/* COOLWORX.C -- Al Williams */

#include <windows.h>
#include <windowsx.h>
#include "coolworx.h"
#include "cwh.h"
#include <ctl3d.h>

/* Get HWND of WM_COMMAND message */
#ifndef GET_WM_COMMAND_HWND
#ifndef WIN32
#define GET_WM_COMMAND_HWND(wp, lp)   (HWND)LOWORD(lp)
#else
#define GET_WM_COMMAND_HWND(wp, lp)   (HWND)(lp)
#endif
#endif


ATOM aCW_RIBBONv;    // atom for Ribbon prop
ATOM aCW_MODELESSv;  // atom for modeless prop
/* Class names */
char cw_RibbonClass[]="RibbonClass";
char cw_EditClass[]="CWEditClass";
char cw_SdiClass[]="CWSDIClass";
HANDLE cw_hInst;
HANDLE dllInst;

/* Avoid warnings */
#define aCW_RIBBON MAKEINTATOM(aCW_RIBBONv)
#define aCW_MODELESS MAKEINTATOM(aCW_MODELESSv)


static void size_ribbon(HWND parent,HWND hDlg,
  LONG style,BOOL f);


/* Process possible modeless dialog. cw_Run() calls this
   so you only need it if you are rolling your own message
   loop */
BOOL WINAPI _export cw_DialogProcess(LPMSG m)
  {
  HWND w=NULL,p=NULL;
  if (!m->hwnd) return FALSE;
/* If window is modeless... */
  if (GetProp(m->hwnd,aCW_MODELESS)) w=m->hwnd;
  else p=GetParent(m->hwnd);
/* ... or parent is modeless... */
  if (p&&GetProp(p,aCW_MODELESS))
    w=GetParent(m->hwnd);
/* ... then process */
  if (w)
    {
/* clean up at end */
    if (m->message==WM_NCDESTROY&&w==m->hwnd)
      RemoveProp(m->hwnd,aCW_MODELESS);
/* Do it */
    return IsDialogMessage(w,m);
    }
  return FALSE;
  }

/* Register modeless dialog -- don't need to this if
   you use cw_CreateDialog... */
BOOL WINAPI _export cw_ModelessRegister(HWND w,BOOL f)
  {
  if (f)
    SetProp(w,aCW_MODELESS,1);
  else
    RemoveProp(w,aCW_MODELESS);
  return TRUE;
  }


/* Ribbon filter -- installed on ribbon's parent window */
long WINAPI _export ribbonfilt(HWND hWnd,UINT message,
                UINT wParam,LONG lParam)
  {
  FARPROC chain;
  HWND ribbon1=(HWND)GetProp(hWnd,aCW_RIBBON);
  chain=(FARPROC)GetWindowLong(ribbon1,CHAIN_LONG);
  switch (message)
    {
    case WM_SIZE:
/* Relocate all ribbons */
      {
      while (ribbon1)
        {
        size_ribbon(hWnd,ribbon1,
        GetWindowLong(ribbon1,STYLE_LONG),TRUE);
        ribbon1=(HWND)GetWindowLong(ribbon1,NEXT_LONG);
        }
      }
    break;

/* Clean up */
    case WM_DESTROY:
      SetWindowLong(hWnd,GWL_WNDPROC,(DWORD)chain);
      RemoveProp(hWnd,aCW_RIBBON);
      while (ribbon1)
        {
        HWND nxt=(HWND)GetWindowLong(ribbon1,NEXT_LONG);
        DestroyWindow(ribbon1);
        ribbon1=nxt;
        }
      break;
      }
   return CallWindowProc((FARPROC)chain,hWnd,message,
     wParam,lParam);
   }

/* Adjust ribbons to get out of each others way */
static void adj_ribbon(LONG style,int *x,int *y,int *len,
   HWND head,HWND rib)
  {
  HWND w=GetParent(rib);
  RECT base,r,bar;
  GetClientRect(w,&base);
  GetClientRect(w,&r);
  GetWindowRect(rib,&bar);
  cw_RibbonInvAdj(w,&r,TRUE,rib);
  switch (style)
    {
    case CWRIBBON_TOP:
      *x=r.left;
      *y=0;
      *len=r.right-r.left;
      break;

    case CWRIBBON_BOTTOM:
      *x=r.left;
      *y=base.bottom-(bar.bottom-bar.top);
      *len=r.right-r.left;
      break;

    case CWRIBBON_RIGHT:
      *x=base.right-(bar.right-bar.left);
      *y=r.top;
      *len=r.bottom-r.top;
      break;

    case CWRIBBON_LEFT:
      *x=0;
      *y=r.top;
      *len=r.bottom-r.top;
      break;
      }
   }

/* Compute correct size for ribbon -- account for existing
   ribbons (even if invisible) */
static void size_ribbon(HWND parent,HWND hDlg,LONG style,
  BOOL f)
  {
  RECT r,pr;
  int x,y,len=0;
  HWND head=GetProp(parent,aCW_RIBBON);
  style&=CWRIBBON_LEFT;  /* includes all position bits */
  GetWindowRect(hDlg,&r);
  GetClientRect(parent,&pr);
  if (style<CWRIBBON_RIGHT)
    {
    x=0;
    len=pr.right;
    if (style==CWRIBBON_TOP)
       y=0;
     else
       y=pr.bottom-(r.bottom-r.top);
     adj_ribbon(style,&x,&y,&len,head,hDlg);
     MoveWindow(hDlg,x,y,len?len:GetSystemMetrics(SM_CXSCREEN),
        r.bottom-r.top,f);
     }
   else
     {
     y=0;
     len=pr.bottom;
     if (style==CWRIBBON_LEFT)
       x=0;
     else
       x=pr.right-(r.right-r.left);
     adj_ribbon(style,&x,&y,&len,head,hDlg);
     MoveWindow(hDlg,x,y,r.right-r.left,
        len?len:GetSystemMetrics(SM_CXSCREEN),f);
     }
   }

/* Ordinary dialog procedure for ribbon */
BOOL WINAPI _export ribbondp(HWND hDlg,UINT message,
    UINT wParam,LONG lParam)
  {
  switch (message)
    {
    case WM_INITDIALOG:
      {
      HWND parent,pdlg;
      parent=GetParent(hDlg);
      SetWindowLong(hDlg,STYLE_LONG,lParam);
      if (!(pdlg=GetProp(parent,aCW_RIBBON)))
        {
        LONG val;
        /* we are #1 ribbon -- start chain */
        val=GetWindowLong(parent,GWL_WNDPROC);
        SetWindowLong(hDlg,CHAIN_LONG,val);
        SetProp(parent,aCW_RIBBON,hDlg);
        SetWindowLong(parent,GWL_WNDPROC,
          (DWORD)ribbonfilt);
        }
      else
        {
        HWND ndlg;
/* Add yourself to existing chain */
        while (ndlg=(HWND)GetWindowLong(pdlg,NEXT_LONG))
          pdlg=ndlg;
        SetWindowLong(pdlg,NEXT_LONG,hDlg);
        }
      SetWindowLong(hDlg,NEXT_LONG,0L);
      size_ribbon(parent,hDlg,lParam,FALSE);
/* Make Dialog 3D */
      Ctl3dSubclassDlgEx(hDlg,CTL3D_ALL);
      SetFocus(parent);
      }
    return FALSE;

    case WM_COMMAND:  // pass commands to parent
      {
      HWND parent;
      LONG style;
      SendMessage(parent=GetParent(hDlg),message,wParam,
        lParam);
      style=GetWindowLong(hDlg,STYLE_LONG);
      if (!(style&CWRIBBON_FOCUSOK))
        {
        HWND fw=GetFocus();
        if (fw==hDlg||
          fw==GET_WM_COMMAND_HWND(wParam,lParam))
        SetFocus(parent);
        }
      }
      return 0;

/* Enable/disable all controls */
    case WM_ENABLE:
      {
      HWND ctl=GetWindow(hDlg,GW_CHILD);
      while (ctl)
        {
        EnableWindow(ctl,wParam);
        ctl=GetWindow(ctl,GW_HWNDNEXT);
        }
      }
    break;
    }
  return 0;
  }

/* Ribbon private dialog class */
long WINAPI _export ribbonproc(HWND hWnd,
        UINT message,UINT wParam, LONG lParam)
  {
  if (message==WM_NCDESTROY)
    {
    RemoveProp(hWnd,aCW_MODELESS);  // clean up
    }
  else if (message==WM_SETFOCUS)  // pass focus to parent
    {
    SetFocus((wParam&&!IsChild(hWnd,wParam))?
      wParam:GetParent(hWnd));
    return 0;
    }
  return DefDlgProc(hWnd,message,wParam,lParam);
  }

/* Start CoolWorks */
BOOL WINAPI _export cw_Begin(HANDLE hInst)
  {
  return cw_BeginIcons(hInst,
    LoadIcon(NULL,IDI_APPLICATION),
    LoadIcon(NULL,IDI_APPLICATION));
  }

/* Register our classes */
static BOOL reg_classes(HANDLE hInst,HICON sdiicon,
  HICON eicon)
  {
  WNDCLASS wc;
/* Ribbon */
  wc.style=0;
  wc.lpfnWndProc=(void FAR *)ribbonproc;
  wc.cbClsExtra=0;
  wc.cbWndExtra=DLGWINDOWEXTRA+12;
  wc.hInstance=hInst;
  wc.hIcon=NULL;
  wc.hCursor=LoadCursor(NULL,IDC_ARROW);
  wc.hbrBackground=COLOR_BTNFACE+1;
  wc.lpszMenuName=NULL;
  wc.lpszClassName=cw_RibbonClass;
  if (!RegisterClass(&wc)) return FALSE;
/* Editor class */
  wc.style=CS_HREDRAW|CS_VREDRAW;
  wc.lpfnWndProc=(void FAR *)cwed_proc;
  wc.cbClsExtra=0;
  wc.cbWndExtra=10;
  wc.hInstance=hInst;
  wc.hIcon=eicon;
  wc.hCursor=LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground=COLOR_WINDOW+1;
  wc.lpszMenuName=NULL;
  wc.lpszClassName=cw_EditClass;
  if (!RegisterClass(&wc)) return FALSE;
/* SDI window */
  wc.style=CS_HREDRAW|CS_VREDRAW;
  wc.lpfnWndProc=(void FAR *)self_subclass;
  wc.cbClsExtra=0;
  wc.cbWndExtra=4;
  wc.hInstance=hInst;
  wc.hIcon=sdiicon;
  wc.hCursor=LoadCursor(NULL,IDC_ARROW);
  wc.hbrBackground=COLOR_WINDOW+1;
  wc.lpszMenuName=NULL;
  wc.lpszClassName=cw_SdiClass;
  if (!RegisterClass(&wc)) return FALSE;
  return TRUE;
  }

/* Start CoolWorx & set icons */
BOOL WINAPI _export cw_BeginIcons(HANDLE hInst,
        HICON sdiicon,HICON eicon)
  {
  WNDCLASS wc;
/* Fire up CTL3DV2 */
  Ctl3dRegister(hInst);
  Ctl3dAutoSubclass(hInst);
/* If ribbons exist -- we are already going */
  if (!GetClassInfo(hInst,cw_RibbonClass,&wc))
    if (!reg_classes(hInst,sdiicon,eicon)) return FALSE;
  cw_hInst=dllInst;
  return TRUE;
  }

/* End CoolWorks */
void WINAPI _export cw_End(HANDLE hInst)
  {
/* Can't unregister classes -- other instances might
   be using them. Let Windows clean it up */
  Ctl3dUnregister(hInst);
  }

/* Create a ribbon */
HWND WINAPI _export cw_Ribbon(LPCSTR id,HWND par,
    LONG param)
  {
#ifdef WIN32
  return cw_CreateDialogParam(
     GetWindowLong(par,GWL_HINSTANCE),
     id,par,ribbondp,param);
#else
  return cw_CreateDialogParam(
     GetWindowWord(par,GWW_HINSTANCE),
     id,par,ribbondp,param);
#endif
  }

/* Silly helper function */
void WINAPI _export cw_SetRibbon(HWND w,UINT id,LPCSTR s)
  {
  SendDlgItemMessage(w,id,WM_SETTEXT,0,(DWORD)s);
  }


/* General purpose message loop */
WORD WINAPI _export cw_Run(HWND w,HWND mdi,int nracc,
  LPHANDLE ary,BOOL idle)
  {
  MSG msg;
  int i;
  while (1)
    {
/* Check for message */
    if (PeekMessage(&msg,NULL,0,0,PM_NOREMOVE))
      {
/* Got one */
      BOOL accproc=FALSE;  // no accel processed (yet)
      if (!GetMessage(&msg,NULL,0,0)) break;
/* Translate MDI accels for MDI apps */
      if (mdi)
        if (TranslateMDISysAccel(mdi,&msg)) continue;
/* Scan accel list */
      for (i=0;i<nracc;i++)
        {
        HANDLE acc=ary[i];
        if (acc&&TranslateAccelerator(w,acc,&msg))
          {
          accproc=TRUE;
          break;
          }
        }
/* If no accel processed, keep going */
      if (!accproc)
        {
/* try modeless dialog */
        if (cw_DialogProcess(&msg))
          continue;
/* Translate & dispatch */
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }
      }  /* No message -- do idle processing */
    else if (w&&idle&&IsWindow(w))
      SendMessage(w,CW_IDLE,0,0);
    }
  return msg.wParam;
  }

/* Create modeless dialog and set property for
         dialog manager */
HWND WINAPI _export cw_CreateDialogIndirectParam
     (HANDLE hInst,const void FAR *tname,
     HWND parent,DLGPROC cb,
     LPARAM lParam)
  {
  HWND rc;
  rc=CreateDialogIndirectParam(hInst,tname,
    parent,cb,lParam);
  if (rc) SetProp(rc,aCW_MODELESS,1);
  return rc;
  }

/* Create modeless dialog and set property for
         dialog manager */
HWND WINAPI _export cw_CreateDialogParam(HANDLE hInst,
  LPCSTR tname,HWND parent,DLGPROC cb,LPARAM lParam)
  {
  HWND rc;
  rc=CreateDialogParam(hInst,tname,parent,cb,lParam);
  if (rc) SetProp(rc,aCW_MODELESS,(HANDLE)1);
  return rc;
  }


/* Adjust rectangle to account for ribbon */
BOOL WINAPI _export cw_RibbonInvAdj(HWND w,LPRECT r,
        BOOL vis,HWND stop)
  {
  BOOL rv=FALSE;
  int adj[4],i;
  LONG style;
  HWND head=(HWND)GetProp(w,aCW_RIBBON);
  RECT bar;
  adj[0]=adj[1]=adj[2]=adj[3]=0;
  while (head&&head!=stop)
    {
    if (vis&&!IsWindowVisible(head)) // skip invisible
      {
      head=(HWND)GetWindowLong(head,NEXT_LONG);
      continue;
      }
    GetWindowRect(head,&bar);
    style=GetWindowLong(head,STYLE_LONG)&3;
    switch (style)
      {
      case CWRIBBON_TOP:
        adj[CWRIBBON_TOP]=max(adj[CWRIBBON_TOP],
          bar.bottom-bar.top);
        break;
      case CWRIBBON_BOTTOM:
        adj[CWRIBBON_BOTTOM]=max(adj[CWRIBBON_BOTTOM],
          bar.bottom-bar.top);
        break;
      case CWRIBBON_RIGHT:
          adj[CWRIBBON_RIGHT]=max(adj[CWRIBBON_RIGHT],
            bar.right-bar.left);
          break;
        case CWRIBBON_LEFT:
          adj[CWRIBBON_LEFT]=max(adj[CWRIBBON_LEFT],
            bar.right-bar.left);
          break;
        }
    head=(HWND)GetWindowLong(head,NEXT_LONG);
    }
  for (i=0;i<4;i++)
    if (adj[i])
      {
      rv=TRUE;
      switch (i)
        {
        case CWRIBBON_TOP:
          r->top+=adj[i];
          break;
        case CWRIBBON_BOTTOM:
          r->bottom-=adj[i];
          break;
        case CWRIBBON_RIGHT:
          r->right-=adj[i];
          break;
        case CWRIBBON_LEFT:
          r->left+=adj[i];
          break;
        }
      }
  return rv;
  }

BOOL WINAPI _export cw_RibbonAdj(HWND w,LPRECT r)
  {
  return cw_RibbonInvAdj(w,r,TRUE,NULL);
  }


/* Get client rectangle taking ribbons into account
   NOTE: r.top and r.left may not be zero when this
   call returns. */
void WINAPI _export cw_GetClientRect(HWND w,LPRECT r)
  {
  GetClientRect(w,r);
  cw_RibbonAdj(w,r);
  }

/* Window proc for self-subclassing windows */
LONG WINAPI _export self_subclass(HWND w,UINT message,
  WPARAM wParam, LPARAM lParam)
  {
  FARPROC p;
  if (message==WM_CREATE)
    {
/* Get createstruct to fetch callback address */
    LPCREATESTRUCT cs=(LPCREATESTRUCT)lParam;
    SetWindowLong(w,0,(LONG)cs->lpCreateParams);
    }
  p=(FARPROC)GetWindowLong(w,0);
  return p?
    CallWindowProc(p,w,message,wParam,lParam):
    DefWindowProc(w,message,wParam,lParam);
  }

/* Get ribbon of specified type */
HWND WINAPI _export cw_GetRibbon(HWND w,LONG type)
  {
  for (w=(HWND)GetProp(w,aCW_RIBBON);w;
    w=(HWND)GetWindowLong(w,NEXT_LONG))
    {
    if (IsWindowVisible(w)&&
      ((GetWindowLong(w,STYLE_LONG)&3)==type))
      return w;
    }
  return NULL;
  }


/* End of the (DLL) world */
#ifdef __BORLANDC
int FAR PASCAL WEP ( int bSystemExit )
#else
int FAR PASCAL _WEP ( int bSystemExit )
#endif
  {
  DeleteAtom(aCW_RIBBONv);
  DeleteAtom(aCW_MODELESSv);
  return 1;
  }

/*  DLL startup */
int FAR PASCAL LibMain( HINSTANCE hModule, WORD wDataSeg,
 WORD cbHeapSize, LPSTR lpszCmdLine )
    {
// Save  module handle to use as instance later
    dllInst = hModule;
    if (cbHeapSize>0) UnlockData(0);
    aCW_RIBBONv=AddAtom("CW_RIBBON");
    aCW_MODELESSv=AddAtom("CW_MODELESS");
    return TRUE;
    }



/* Enable command (menu & toolbar) */
void WINAPI _export cw_EnableCommand(HMENU m,HWND w,
  int cmd,BOOL f,BOOL vis)
  {
  if (m)
    {
    EnableMenuItem(m,cmd,
      (f?MF_ENABLED:(MF_DISABLED|MF_GRAYED))
        |MF_BYCOMMAND);
    }
  if (w)
    {
    HWND ctl,bar;
    bar=(HWND)GetProp(w,aCW_RIBBON);
    while (bar)
      {
      if (!vis||IsWindowVisible(bar))
        {
        ctl=GetDlgItem(bar,cmd);
        if (ctl) EnableWindow(ctl,f);
        }
      bar=(HWND)GetWindowLong(bar,NEXT_LONG);
      }
    }
  }
