//tabs=4
//
//		==========
//		SHUTSRVR.C
//		==========
//
// Utility to shut down the server cleanly. Used prior to doing a
// "stability reboot".
//
// Author:	Robert B. Denny
//			<rdenny@netcom.com>
//			06-Jan-95
//
// History:
//
// Who               When        What
// ----------------- ---------   ---------------------------------------
// Robert B. Denny   06-Jan-95   Created - First release
//
//----------------------------------------------------------------------

#include <windows.h>
#include <stdio.h>

#define VERSION "V1.0/06-Jan-95"

extern HINSTANCE _hInstance;		// BC4 has this in library

HWND hTheWindow;				// Used by WindCatcher() during enumeration

BOOL CALLBACK WindCatcher(HWND hWnd, LPARAM lparam);

// ====
// MAIN
// ====
main()
{
	FARPROC lpfnEnumWinCB;			// Thunk for enum callback

	hTheWindow = NULL;				// Assume failure

	lpfnEnumWinCB = MakeProcInstance((FARPROC)WindCatcher, _hInstance);
	EnumWindows(lpfnEnumWinCB, NULL);
	FreeProcInstance(lpfnEnumWinCB);

	if(hTheWindow == NULL)			// If we didn't find an httpd running
		return(0);

	//
	// Setting wParam = 1 tells the server it is a
	// programmed close. Bypass the "active connections" alert.
	//
	PostMessage(hTheWindow, WM_CLOSE, 1, 0);

	return(0);
}


//------------------------------------------------------------------------
//
// WindCatcher() - Callback function for EnumTaskWindows(). Passes
//                 back a copy of the next window handle.
//
//------------------------------------------------------------------------
#define BUF_LEN 64
#pragma argsused
BOOL CALLBACK _export WindCatcher (HWND hWnd, LPARAM lparam)
{
	char buf[BUF_LEN+1];
	static const char *tgtName = "httpd";
	register int i;

	GetWindowText(hWnd, (LPSTR)buf, BUF_LEN);	// Get name
	for(i=0; i < 5; i++)						// Avoid huge C library
		if(buf[i] != tgtName[i])
			break;
	if(i == 5)
	{											// Found it
		hTheWindow = hWnd;
		return(FALSE);
	}
	return(TRUE);								// Keep going
}


