# %W% %E% %U%
# MICROSOFT WIN32 SDK - Makefile for VersaTrack's DBREAD.DLL
# S.N. Oct 10, 1994

DEBUG = 0
MAINDIR = ..
TARGET  = $(MAINDIR)\dbread.dll
MAKE = nmake
LIBEXE = lib
LINKEXE = link
CC = cl
CPP = cl
RC = rc
CVER =

CFLAGS_D_WEXE    = -W3 -nologo -D_X86_ -D_DEBUG_ -D_WINDOWS -DWIN32 $(CVER)
CFLAGS_R_WEXE    = -W3 -nologo -D_X86_ -DNDEBUG -D_WINDOWS -DWIN32 $(CVER)
LFLAGS_D_WEXE    = -nologo -defaultlib:user32,gdi32,advapi32
LFLAGS_R_WEXE    = -nologo -defaultlib:user32,gdi32,advapi32
MAKEFLAGS        = L E
RCFLAGS          = -D_WINDOWS -DWIN32
D_RCDEFINES      = -D_DEBUG -D_DEBUG_
R_RCDEFINES      = -DNDEBUG
CC_D_OPTIM       =
CC_R_OPTIM       = -Ox

!if "$(DEBUG)" == "1"

CFLAGS         = $(CFLAGS_D_WEXE) $(CC_D_OPTIM)
LFLAGS         = $(LFLAGS_D_WEXE)
RCDEFINES      = $(RCFLAGS) $(D_RCDEFINES)
OBJS_DEBUG     = ..\prf.obj

!else

CFLAGS         = $(CFLAGS_R_WEXE) $(CC_R_OPTIM)
LFLAGS         = $(LFLAGS_R_WEXE)
RCDEFINES      = $(RCFLAGS) $(R_RCDEFINES)
OBJS_DEBUG     =

!endif

OBJS = \
     message.obj \
     registry.obj \
     satdb.obj \
     vstdate1.obj \
     sitedb.obj \
     vstdb.obj \
     vstdib.obj \
     rotcntrl.obj \
     util.obj \
     error.obj \
     $(OBJS_DEBUG)
     

DEPS    =  \
    $(MAINDIR)\vstdefs.h \
    $(MAINDIR)\vsttype.h \
    libxtrns.h

all:	$(TARGET)

dbread.res:    dbread.rc resource.h

$(TARGET):    dbread.res dbread.exp
    link -dll $(OBJS) dbread.res dbread.exp -entry:DBReadInit \
    -out:$(TARGET) $(LFLAGS)

dbread.exp:   dbread.def $(OBJS)
    $(LIBEXE) -nologo -def:dbread.def dbread.res $(OBJS)
    -@del dbread.lib

message.obj:    message.c $(DEPS) resource.h

vstdb.obj:    vstdb.c $(DEPS)

sitedb.obj:    sitedb.c $(DEPS)

vstdate1.obj:   vstdate1.c $(DEPS)

satdb.obj:     satdb.c $(DEPS)

util.obj:   util.c $(DEPS)

error.obj:	error.c

registry.obj:      registry.c $(DEPS) resource.h

vstdib.obj:    vstdib.c $(DEPS) $(MAINDIR)\vstdib.h

rotcntrl.obj:   rotcntrl.c $(DEPS)

..\prf.obj:
    @cd ..
    @$(MAKE) "DEBUG=$(DEBUG)" "INSTALLDIR=$(INSTALLDIR)" prf.obj
    @cd lib
 
.c.obj:
	$(CC) $(CFLAGS) -I$(MAINDIR) -c $*.c

.rc.res:
    $(RC) $(RCDEFINES) -I$(MAINDIR) -r $*.rc

clean:
    -@del *.obj *.lib *.exp *.aps *.sbr *.map *.res *.pch 2>NUL

clobber:    clean
    -@del *.dll 2>NUL

backup:

zip:

