{$R-,S-,D-,L-}
UNIT GroupExceptions;
(**) INTERFACE  (**)
USES SysUtils;
const
  msg_NotGRPFile     = 1;
  msg_CheckSumBad    = 2;
  msg_FirstTagBad    = 3;
  msg_TagBad         = 4;
  msg_IconHeaderBad  = 5;
TYPE

  EGRPError = class(Exception)
  public
    CONSTRUCTOR Create(Error: Integer);
  END;

(**) IMPLEMENTATION (**)
  CONSTRUCTOR EGrpError.Create(Error : Integer);
  BEGIN
    CASE Error OF
      msg_NotGRPFile    :
        Inherited Create('Not a valid GRP file');
      msg_CheckSumBad   :
        Inherited Create('Check sum failed');
      msg_FirstTagBad   :
        Inherited Create('First TAG data structure invalid');
      msg_TagBad        :
        Inherited Create('TAG data structure invalid');
      msg_IconHeaderBad :
        Inherited Create('Wrong size icon header');
    END;
  END;

END.
