/* PROMPT.H
 * prompt handling for COMMAND.COM
 * Tim Norman
 * 1-14-95
*/

void printprompt ()
{
   struct time t;
   struct date d;
   char *pr, direc[128], temp[128];
   static char default_pr[]="$N$G";

   pr = findenv ("PROMPT");     /* get PROMPT environment var. */

   if (!pr)                     /* if PROMPT hasn't been set   */
      pr = default_pr;

   while (*pr)
   {
      if (*pr != '$')
	 putchar (*pr);
      else
      {
	 pr++;

	 switch (toupper (*pr))
	 {
	    case 'Q':
	       putchar ('=');
	       break;
	    case '$':
	       putchar ('$');
	       break;
	    case 'T':
	       gettime (&t);
	       printf ("%2d:%02d:%02d.%02d", t.ti_hour, t.ti_min, t.ti_sec,
					     t.ti_hund);
	       break;
	    case 'D':
	       getdate (&d);
	       printf ("Day %02d-%02d-%04d", d.da_mon, d.da_day, d.da_year);
	       break;
	    case 'P':
	       direc[0] = getdisk () + 'A';
	       direc[1] = ':';

	       getcurdir (0, temp);

	       if (temp[0] == '\\')
		  strcpy (&direc[2], temp);
	       else
	       {
		  direc[2] = '\\';
		  strcpy (&direc[3], temp);
	       }

	       printf ("%s", direc);
	       break;
	    case 'V':
	       printf ("FreeDOS Alpha");
	       break;
	    case 'N':
	       printf ("%c", getdisk () + 'A');
	       break;
	    case 'G':
	       putchar ('>');
	       break;
	    case 'L':
	       putchar ('<');
	       break;
	    case 'B':
	       putchar ('|');
	       break;
	    case '_':
	       putchar ('\n');
	       break;
	    case 'E':
	       putchar (27);
	       break;
	    case 'H':
	       putchar (8);
	       break;
	 }
      }

      pr++;
   }
}
