/* INTERNAL.H
 * internal functions for Free DOS
 * Tim Norman
 * 8-17-94
*/

#include "environ.h"

void SET (char *commandline)
{
   char *command;
   unsigned char count;
   int r;

   command = commandline;

   while (isspace (*command))	/* skip over "set" and whitespace */
      command++;

   while (!isspace (*command))
      command++;

   while (isspace (*command))
      command++;

   strcpy (env_temp, command);

   count = strlen (env_temp) - 1;	/* remove trailing spaces */
   while (env_temp[count] == ' ')
      env_temp[count--] = 0;

   if (strstr (env_temp, "=") == NULL)
   {
      puts ("Syntax error");
      return;
   }

   /* capitalize name of env. var. */
   for (count = 0; env_temp[count] != '=' && env_temp[count] != 0; count++)
      env_temp[count] = toupper (env_temp[count]);

   r = addenv (env_temp);

   if (r == 1)
      puts ("Syntax error");
   else if (r == 2)
      puts ("Out of environment space!");
}

void CD (char *commandline, char *p[128], unsigned char args)
{
   switch (p[0][2])
   {
      case 0:
	 if (args > 2)
	    printf ("Too many parameters - %s\n", p[2]);
	 else
	 {
	    if (p[1][strlen (p[1]) - 1] == '\\') /* take off last \ */
	       p[1][strlen (p[1]) - 1] = 0;      /* this is incompatible */
	    if (chdir (p[1]) != 0)               /* with MS-DOS but makes */
	       puts ("Invalid directory");       /* filename completion */
	 }                                       /* more useful */

	 break;

      case '\\':
	 if (args > 1)
	    printf ("Too many parameters - %s\n", p[1]);
	 else
	    if (chdir (&p[0][2]) != 0)
	       puts ("Invalid directory");

	 break;
      case '.':
	 if (args > 1)
	    printf ("Too many parameters - %s\n", p[1]);
	 else
	    if (chdir (&p[0][2]) != 0)
	       puts ("Invalid directory");

	 break;
   }
}

void DIR (char *p[128], int args)
{
   int count;
   struct ffblk file;
   int done;
   long files = 0, bytes = 0;
   union REGS regs;

   if (args > 1)
   {
      printf ("Too many parameters -");
      for (count = 1; count < args; count++)
	 printf (" %s", p[count]);

      puts ("");

      return;
   }

   /* find all files by default */
   done = findfirst (args == 0 ? "*.*" : p[0], &file, 0xFF);

   do
   {
      printf ("%-12s %15ld\n", file.ff_name, file.ff_fsize);

      files++;
      bytes += file.ff_fsize;

      done = findnext (&file);

      if (files % 20 == 0)
      {
	 puts ("Press any key to continue...");
	 getch ();
      }
   }
   while (!done);

   printf ("    %5ld file%s %15ld byte%s\n", files, files == 1 ? "" : "s",
	   bytes, bytes == 1 ? "" : "s");

   regs.h.ah = 0x36;
   regs.h.dl = 0;
   int86 (0x21, &regs, &regs);

   printf ("              %s %15ld bytes free\n", files == 1 ? "" : " ",
	   (long)regs.x.ax * regs.x.cx * regs.x.bx);
}
