DECLARE SUB OMFPal ()
' OMF Pilot Picture Converter
' By Craig Boston

DEFINT A-Z
DECLARE SUB MakeOMF ()
DECLARE SUB ReplChar ()
DECLARE SUB GetCoords (X%, y%)
							
DECLARE FUNCTION Gbit ()
DECLARE FUNCTION ReadCode (CodeSize)
DECLARE SUB Plot (A)
							
DIM SHARED Image(53, 70)
DIM SHARED linebuffer(70)   ' store the opaque pixels here
DIM ByteBuffer AS STRING * 1
DIM Pwr(8), Prefix(4096), Suffix(4096), Outcode(1024)
DIM SHARED MaxCodes(12), Pwr2(16), Pal(255) AS LONG
DIM SHARED Xstart, Xend, CodeMask(8), ZPA$
DIM SHARED Nothingmuch(3838) AS INTEGER
DIM SHARED Red(255), Green(255), Blue(255)
	   
' a mode 4 (wallpaper) window is used as background.
' several unmovable windows (of the same
' color as background window) with no shadows,
' are created to provide several
' scrollable lists in "one" window.

' the directory and file access routines are used to create
' scrollable lists of files and sub-directories. by clicking
' on a sub-directory, you can change into it, and it's contents
' (files and directories) will then be displayed in the scrollable
' lists.

DECLARE FUNCTION ChgPath% (NewPath$)   ' changes to new path
DECLARE SUB DoFiles ()                 ' menu of files, dirs, drives
DECLARE SUB SortIt (s$())              ' bubble sort
DECLARE SUB Main ()                    ' main window
DECLARE FUNCTION VidType% ()           ' gets type of monitor
DECLARE SUB ProcessFiles (Text$)  ' sample routine to process files

'$DYNAMIC  make all arrays dynamic

DEFINT A-Z

CLEAR , , 5000   ' set stack at 5000 bytes


SCREEN 0, 0, 0
WIDTH 80, 25
CLS
PRINT "OMF Pilot Picture Converter"
PRINT "By Craig M. Boston"
PRINT "Conversion routines inspired by Dave Bollinger"
PRINT "GUI routines courtesy of Allen L. Lang"
PRINT : PRINT "Press any key to continue..."
A$ = ""
DO UNTIL A$ <> "": A$ = INKEY$: LOOP

LOCATE , , 0         ' start with hidden text cursor

'=====================================================================

CALL Main

'=====================================================================


COLOR 7, 0
SCREEN 0, 0, 0
CLS

' GIF file routines follow
' I don't know who originally wrote it, it's been modified heavily

FOR A = 1 TO 8: Pwr(A) = 2 ^ (A - 1): NEXT
						       
FOR A = 0 TO 11: READ MaxCodes(A): NEXT
						       
FOR A = 1 TO 8: READ CodeMask(A): NEXT
						       
FOR A = 0 TO 14: READ Pwr2(A): NEXT
						       
F$ = ZPA$

IF LTRIM$(RTRIM$(F$)) = "" THEN END
						       
IF INSTR(F$, ".") = 0 THEN
    F$ = F$ + ".GIF"
END IF

DEF SEG = &HA000
OPEN F$ FOR BINARY AS #1 LEN = 1
IF LOF(1) = 0 THEN PRINT "Not found!": CLOSE : KILL F$: END
						       
FOR A = 1 TO 6
    GET #1, , ByteBuffer: A$ = A$ + ByteBuffer
NEXT
IF INSTR(A$, "GIF87a") = 0 THEN
PRINT "Warning, the "; A$; " protocol is being used."
LINE INPUT "Proceed anyway(Y/N)?"; A$
IF UCASE$(A$) <> "Y" THEN END
END IF
						       
GET #1, , TotalX
GET #1, , TotalY
						       
GET #1, , ByteBuffer: A = ASC(ByteBuffer)
BitsPixel = (A AND 7) + 1
GET #1, , ByteBuffer: Background = ASC(ByteBuffer)
GET #1, , ByteBuffer
						       
IF ASC(ByteBuffer) <> 0 THEN
    PRINT "Bad file."
    END
END IF
						       
FOR A = 0 TO 2 ^ BitsPixel - 1
    GET #1, , ByteBuffer: Red(A) = ASC(ByteBuffer) \ 4
    GET #1, , ByteBuffer: Green(A) = ASC(ByteBuffer) \ 4
    GET #1, , ByteBuffer: Blue(A) = ASC(ByteBuffer) \ 4
Pal(A) = (Red(A)) + (Green(A)) * 256 + (Blue(A)) * 65536
NEXT
						       
GET #1, , ByteBuffer
IF ByteBuffer <> "," THEN
    PRINT "Bad file."
    END
END IF
						       
GET #1, , Xstart
GET #1, , Ystart
GET #1, , Xlength
GET #1, , Ylength
Xend = Xlength + Xstart - 1: Yend = Ylength + Ystart - 1
						       
GET #1, , ByteBuffer
A = ASC(ByteBuffer)
IF (A AND 128) = 128 THEN
    PRINT "Local colormap encountered."
    END
ELSEIF (A AND 64) = 64 THEN
    PRINT "Image is interlaced!"
    END
END IF
						       
GET #1, , ByteBuffer
CodeSize = ASC(ByteBuffer): ClearCode = Pwr2(CodeSize)
EOFCode = ClearCode + 1: FirstFree = ClearCode + 2
FreeCode = FirstFree: CodeSize = CodeSize + 1
InitCodeSize = CodeSize: Maxcode = MaxCodes(CodeSize - 2)
Bitmask = CodeMask(BitsPixel)
						       
GET #1, , ByteBuffer
BlockLength = ASC(ByteBuffer) + 1: Bitsin = 8
OutCount = 0
X = Xstart: y = Ystart
						       
ON ERROR GOTO NoVGA
SCREEN 13
ON ERROR GOTO 0
						     
LINE (0, 0)-(70, 53), 15, B
GET (0, 0)-(70, 53), Nothingmuch
CLS

LINE (0, 0)-(319, 199), Background, BF
PALETTE USING Pal(0)

DO
    Code = ReadCode(CodeSize)
 IF Code <> EOFCode THEN
  IF Code = ClearCode THEN
     CodeSize = InitCodeSize
     Maxcode = MaxCodes(CodeSize - 2): FreeCode = FirstFree
     Code = ReadCode(CodeSize): CurCode = Code
     OldCode = Code: FinChar = Code AND Bitmask
     Plot FinChar
  ELSE
     CurCode = Code: InCode = Code
	IF Code >= FreeCode THEN
	    CurCode = OldCode
	    Outcode(OutCount) = FinChar
	    OutCount = OutCount + 1
  END IF
	IF CurCode > Bitmask THEN
	  DO
	    Outcode(OutCount) = Suffix(CurCode)
	    OutCount = OutCount + 1
	    CurCode = Prefix(CurCode)
	  LOOP UNTIL CurCode <= Bitmask
	END IF
	    FinChar = CurCode AND Bitmask
	    Outcode(OutCount) = FinChar
	    OutCount = OutCount + 1
	    FOR i = OutCount - 1 TO 0 STEP -1
		Plot Outcode(i)
	    NEXT
       OutCount = 0
     Prefix(FreeCode) = OldCode: Suffix(FreeCode) = FinChar
     OldCode = InCode: FreeCode = FreeCode + 1
      IF FreeCode >= Maxcode THEN
	 IF CodeSize < 12 THEN
	    CodeSize = CodeSize + 1: Maxcode = Maxcode * 2
	  END IF
      END IF
    END IF
    END IF
LOOP UNTIL Code = EOFCode
CLOSE
X = 0: y = 0                    ' reset to upper-left coords
CALL GetCoords(X, y)            ' get part of picute to convert
FOR C = 0 TO 70
FOR R = 0 TO 53
Image(R, C) = POINT(C + X, R + y)       ' put it into an array
NEXT: NEXT
SCREEN 0, 0, 0
WIDTH 80
FOR C = 0 TO 70
FOR R = 0 TO 53
B = Image(R, C)
IF mz = 0 AND B < 207 OR (B > 214 AND B < 224) THEN
  CLS
  INPUT "OMFPIC has detected a color not in the OMF palette.  Do you wish to convert? ", M$
  IF UCASE$(LEFT$(M$, 1)) = "Y" THEN OMFPal
  mz = 1
END IF
NEXT: NEXT
SCREEN 0, 0, 0
WIDTH 80
CLS
PRINT "Converting picture..."
CALL MakeOMF                    ' convert to OMF picture format
CALL ReplChar                   ' put into character file
END

DATA 4,8,16,&h20,&h40,&h80,&h100,&h200,&h400,&h800
DATA &h1000,8192
DATA 1,3,7,15,31,63,127,255
DATA 1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384
						       
NoVGA:
    PRINT "Sorry, this program requires a VGA adapter."
    SLEEP 3
END

2 PRINT "Invalid file name."
SLEEP 3
END

OMFPalData:
DATA 16191,197379,460551,723723,986895,1250067,1513239,1776411,2039583
DATA 2302755,2565927,2829099,3092271,3355443,3618615,3881787,4144959,1511680
DATA 1840898,2235654,2630668,2960146,3354906,3749923,4144942,593427,791321
DATA 1054752,1252647,1516078,1779509,2305592,3095102,3903,6975,10047,13119
DATA 16180,16158,802560,1916672,3096320,4144384,2752512,3932160,1441792
DATA 16128,7680,1326868

REM $STATIC
FUNCTION Gbit STATIC
SHARED ByteBuffer AS STRING * 1, Pwr(), Bitsin
SHARED BlockLength, Num
    Bitsin = Bitsin + 1
    IF Bitsin = 9 THEN
	GET #1, , ByteBuffer
	TChar = ASC(ByteBuffer)
	Bitsin = 1
	Num = Num + 1
	IF Num = BlockLength THEN
	    BlockLength = TChar + 1
	    GET #1, , ByteBuffer
	    TChar = ASC(ByteBuffer)
	    Num = 1
	END IF
    END IF
IF (TChar AND Pwr(Bitsin)) = 0 THEN Gbit = 0 ELSE Gbit = 1
END FUNCTION

SUB GetCoords (X, y)
M = 0
1 PUT (X, y), Nothingmuch
A$ = "": DO UNTIL A$ <> "": A$ = INKEY$: LOOP
PUT (X, y), Nothingmuch
IF A$ = CHR$(13) THEN M = 1
IF A$ = CHR$(0) + "K" THEN X = X - 1
IF A$ = CHR$(0) + "M" THEN X = X + 1
IF A$ = CHR$(0) + "H" THEN y = y - 1
IF A$ = CHR$(0) + "P" THEN y = y + 1
IF X < 0 THEN X = 0
IF y < 0 THEN y = 0
IF X > 249 THEN X = 249
IF y > 146 THEN y = 146
IF M = 0 THEN GOTO 1
END SUB

SUB Main
CLS
INPUT "Enter file to convert: ", A$
ProcessFiles A$
END SUB

SUB MakeOMF
  OPEN "TEMP.OMF" FOR BINARY AS #1      ' open output file binary mode
  k = 2                                 ' key (starts at 0x02)
  OK = 2                                ' copy of key (used for transparent
					' pixels)
  FOR y = 0 TO 53                       ' loop through rows
    offset = 0                          ' set offset to 0
    w = 0                               ' set width to 0
    cwsf = 0                            ' set current width so far to 0
    FOR X = 0 TO 70                     ' loop through columns
      C = Image(y, X)                   ' get pixel color
      IF C <> 0 THEN EXIT FOR           ' if it's opaque then exit loop
      offset = offset + 1               ' increase offset
      cwsf = cwsf + 1                   ' increase current width so far
    NEXT
    IF X >= 70 THEN GOSUB SaveLine: GOTO 10     ' if we're already at the end
						' of the line then save it now
						' and start over again
    FOR M = offset TO 70                 ' loop through columns
      C = Image(y, M)                    ' get pixel color
      IF C = 0 THEN EXIT FOR             ' if it's transparent then exit loop
      linebuffer(w) = C                  ' add to pixel buffer
      w = w + 1                          ' increase width
      cwsf = cwsf + 1                    ' increase current width so far
    NEXT
    IF M >= 70 THEN GOSUB SaveLine: GOTO 10     ' same as previous one
9 FOR X = M TO 70                       ' loop through columns
    C = Image(y, X)                     ' get pixel color
    IF C <> 0 THEN EXIT FOR             ' if it's opaque then exit loop
    cwsf = cwsf + 1                     ' increase current width so far
  NEXT
  IF X >= 70 THEN GOSUB SaveLine: GOTO 10       ' same as previous
  GOSUB SaveLine                                ' save the line now
  w = 0                                 ' reset width to 0
  OP = cwsf * 4                         ' calculate new key value
  FOR M = X TO 70                       ' loop through columns
    C = Image(y, M)                     ' get pixel color
    IF C = 0 THEN EXIT FOR              ' if it's transparent then leave
    linebuffer(w) = C                   ' add to pixel buffer
    w = w + 1                           ' increase width
    cwsf = cwsf + 1                     ' increase current width so far
  NEXT
  IF M >= 70 AND w <> 0 THEN k = OP: offset = 0: GOSUB SaveLine: GOTO 10
  ' if at end of line and found opaque pixel then set new key and save line
  IF w <> 0 THEN k = OP: offset = 0: GOTO 9     ' same as above but without
						' EOL checking, repeat loop
10 NEXT
 
  z = 7
  PUT #1, , z                           ' all I've seen ends with this
  z = 0
  PUT #1, , z                           ' all I've seen ends with this
  CLOSE 1                               ' close the file
EXIT SUB

SaveLine:
    PUT #1, , k                         ' write key value
    IF offset <> 0 THEN h = offset * 4: PUT #1, , h     ' offset times 4 (if
							' it's not zero)
    h = 1 + (4 * w)                     ' width times 4 plus 1 (make it odd)
    PUT #1, , h                         ' write width

    FOR i = 0 TO w - 1                  ' process each opaque pixel
      A$ = CHR$(linebuffer(i))          ' convert to single byte
      PUT #1, , A$                      ' write out pixel data
    NEXT
    IF OK = k THEN
      k = k + 4                         ' next key value
      OK = OK + 4                       ' add to real key, too
    ELSE
      offset = 0                        ' reset offset to 0
      w = 0                             ' reset width to zero
      k = OK                            ' restore key to normal
    END IF
CLOSE 1
OPEN "TEMP.OMF" FOR BINARY AS #1
SEEK 1, LOF(1)
RETURN
END SUB

SUB OMFPal
DIM ByteBuffer AS STRING * 1
DIM OMFRed(255), OMFGreen(255), OMFBlue(255)
DIM OMFPalette(255) AS LONG
CLS

RESTORE OMFPalData
FOR T = 207 TO 255
  READ OMFPalette(T)
  OMFGreen(T) = OMFPalette(T) \ 65536
  OMFBlue(T) = (OMFPalette(T) - OMFGreen(T) * 65536) \ 256
  OMFRed(T) = OMFPalette(T) - OMFGreen(T) * 65536 - OMFBlue(T) * 256
NEXT T

CLS : INPUT "Treat black as transparent or opaque"; BL$

SCREEN 13
PALETTE USING Pal(0)

FOR R = 0 TO 53
FOR C = 0 TO 70
PSET (C, R), Image(R, C)
NEXT: NEXT
FOR R = 0 TO 53
  FOR C = 0 TO 70
    X = POINT(C, R)
    IF UCASE$(LEFT$(BL$, 1)) = "T" AND X = 0 THEN
      HISCO = 0
    ELSE
      HISCO = 0
      Closest = 32767
      FOR M = 207 TO 214
	PALVAL = (ABS(OMFRed(M) - Red(X))) + ABS((OMFBlue(M) - Blue(X))) + ABS((OMFGreen(M) - Green(X))) / 3
	IF PALVAL < Closest THEN HISCO = M: Closest = PALVAL
      NEXT
      FOR M = 224 TO 255
	PALVAL = (ABS(OMFRed(M) - Red(X))) + ABS((OMFBlue(M) - Blue(X))) + ABS((OMFGreen(M) - Green(X))) / 3
	IF PALVAL < Closest THEN HISCO = M: Closest = PALVAL
      NEXT
    END IF
    IF INKEY$ <> "" THEN EXIT FOR
    PSET (C, R), HISCO
  NEXT
NEXT
CLOSE
PALETTE USING OMFPalette(0)
FOR C = 0 TO 70
FOR R = 0 TO 53
Image(R, C) = POINT(C, R)
NEXT: NEXT
END SUB

SUB Plot (A) STATIC
    POKE (y! * 320) + X!, A
    X! = X! + 1
    IF X! > Xend THEN
	X! = Xstart
	y! = y! + 1
    END IF
END SUB

SUB ProcessFiles (Text$)
ZPA$ = Text$
END SUB

FUNCTION ReadCode (CodeSize)
'This subprogram reads one LZW code from the data stream.
    SHARED Pwr2()
    Code = 0
    FOR Aa = 0 TO CodeSize - 1
	Code = Code + Gbit * Pwr2(Aa)
    NEXT
    ReadCode = Code
END FUNCTION

SUB ReplChar
DIM AR AS STRING * 1                    ' used for byte-by-byte file I/O
3 PRINT : INPUT "Enter name of character as it appears in OMF: ", N$
N$ = LEFT$(N$, 8)                       ' get first 8 chars
FOR T = 1 TO LEN(N$)                    ' check for spaces
  IF MID$(N$, T, 1) = " " THEN MID$(N$, T, 1) = "_"
  ' replace them with underscores
NEXT
ON$ = N$                                ' copy of filename withour extention
IF INSTR(N$, ".") <> 0 THEN             ' is there already an extention?
  PRINT "Do not include extention.": GOTO 3
ELSE
  N$ = N$ + ".CHR"                      ' add one
END IF
ON ERROR GOTO 2                         ' error trapping for invalid filenames
OPEN N$ FOR INPUT AS #1                 ' open the file
CLOSE                                   ' close it again (error occoured if
					' filename is invalid or does not
					' exist)
ON ERROR GOTO 0                         ' disable error trapping
PRINT "Backing up " + N$ + "..."
SHELL "COPY " + N$ + " " + LEFT$(N$, LEN(N$) - 4) + ".BAK > NUL"
	'make backup copy
OPEN LEFT$(N$, LEN(N$) - 4) + ".BAK" FOR BINARY AS #1   ' open backup
OPEN N$ FOR BINARY AS #2                                ' open character file
GET #2, 1561, AR                                        ' get first key
IF ASC(AR) <> 2 THEN                                    ' is it there?
  SCREEN 0, 0, 0
  CLS
  PRINT "Pilot must be in North American tournament to change picture."
  END
END IF
PRINT "Replacing pilot picture..."
FOR T = 1 TO 1560                                       ' loop to copy first
GET #1, T, AR                                           ' 1560 bytes of old
PUT #2, , AR                                            ' character file
NEXT
CLOSE                                           ' close all files
OPEN "TEMP.OMF" FOR BINARY AS #1                ' open temporary pic
OPEN N$ FOR BINARY AS #2                        ' open character file
SEEK 2, 1561                                    ' go to byte 1561
FOR T = 1 TO LOF(1)                             ' loop to end of TEMP.OMF
GET #1, T, AR                                   ' read byte from TEMP.OMF
PUT #2, , AR                                    ' write to .CHR file
NEXT
PRINT
PRINT "Done."
SLEEP 3                                         ' 3 second pause
CLOSE                                           ' close all files
KILL "TEMP.OMF"                                 ' delete TEMP.OMF
END SUB

