goto start
:usage
echo off
cls
echo ͻ
echo     testdoz.bat -- Test VENDINFO.DOZ file for integrity,     
echo                    author authentication, a few basic        
echo                    fields, and all special DOZ contents.     
echo                                                              
echo     usage:                                                   
echo            testdoz doz_file out_file [special...]            
echo     where:                                                   
echo            doz_file = pathname of VENDINFO.DOZ file          
echo                                                              
echo            out_file = pathname of output file to which       
echo                       extracted information should be        
echo                       written                                
echo            special  = special code argument needed only      
echo                       when VendEdit is being used to         
echo                       produce and test DOZ file under        
echo                       single-use license provided to the     
echo                       author by a distributor.               
echo                                                              
echo     example:                                                 
echo            testdoz vendinfo.doz sample.prn                   
echo                                                              
echo  Copyright 1993-95 Rams' Island Software All Rights Reserved 
echo     Rams' Island Software, 7644 Lakecliff, Parker CO 80134   
echo ͼ
goto exit

:start
rem ----- test for presence of required arguments -------------------
if %1.==. goto usage
if %2.==. goto usage

rem ----- test for valid, authenticated file ------------------------
vendprcs %1 %3 %4 -zk                      -y " "                  > %2
if errorlevel 12 goto allOK

:test11
if not errorlevel 11 goto test10
echo Ŀ >> %2
echo  Test of validity and authentication of VENDINFO.DOZ file  >> %2
echo  >> %2
echo       This VENDINFO.DOZ file has a missing or invalid      >> %2
echo       author authentication code.  If you are the author   >> %2
echo       and you are testing your VENDINFO.DOZ file, this     >> %2
echo       simply means that you have not yet registered        >> %2
echo       VendEdit and entered the registration numbers so     >> %2
echo       that VendEdit can produce an authenticated record.   >> %2
echo       (It's also possible that you have a special-purpose  >> %2
echo       VendEdit registration, and are attempting to produce >> %2
echo       VENDINFO records for products outside the allowed    >> %2
echo       types.  Try Verify Warnings for more information.)   >> %2
vendprcs    -y " "      >> %2
echo       If you are an author testing your VENDINFO.DOZ file  >> %2
echo       and you have already entered your registration keys, >> %2
echo       make sure that the company name used in this         >> %2
echo       VENDINFO file exactly matches the name in which you  >> %2
echo       registered.  Registration keys are tied to your      >> %2
echo       company name.  (Exception: "single-use" registration >> %2
echo       keys provided to you by a publisher require that you >> %2
echo       place THEIR registration name in your Company Name   >> %2
echo       field.  In any case, try Edit Author Company Name    >> %2
echo       and press F3.                                        >> %2
vendprcs    -y " "      >> %2
echo       Without a valid registration, your license for use   >> %2
echo       does not allow you to send your VENDINFO.DOZ file    >> %2
echo       to anyone else.                                      >> %2
goto continue

:test10
if errorlevel 10 goto badtext
if errorlevel 1 goto error
goto allOK

:error
echo Ŀ >> %2
echo  Test of validity and authentication of VENDINFO.DOZ file  >> %2
echo  >> %2
echo       There has been an error in the reading of this       >> %2
echo       VENDINFO.DOZ file, preventing further processing.    >> %2
echo       The error is probably an incorrect size or CRC       >> %2
echo       for either the text or the data section, and may be  >> %2
echo       caused by a hacked or corrupted file.                >> %2
echo          This error condition can also be created by       >> %2
echo       attempting to use VendPrcs on a VENDINFO.DOZ file    >> %2
echo       created using a special, single-use registration     >> %2
echo       key provided by a distributor, without entering      >> %2
echo       the necessary access key on the VendPrcs command     >> %2
echo       line.                                                >> %2

::@echo off
cls
vendprcs %1 %3 %4 -zk                      -y " "
pause

goto exit

:badtext
echo Ŀ >> %2
echo  Test of validity and authentication of VENDINFO.DOZ file  >> %2
echo  >> %2
echo NOTE: This VENDINFO.DOZ file has an incorrect size or CRC  >> %2
echo       for either the text or the data section, and may be  >> %2
echo       a hacked or corrupted file.                          >> %2
goto exit

:allOK
echo Ŀ >> %2
echo  Test of validity and authentication of VENDINFO.DOZ file  >> %2
echo  >> %2
echo NOTE: This VENDINFO.DOZ file has passed all validity and   >> %2
echo       security tests, including size and CRC tests and     >> %2
echo       basic author source authentication.                  >> %2

:continue
rem ----- extract basic product information from file ---------------
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo      Extraction of information from VENDINFO.DOZ file      >> %2
echo  >> %2
vendprcs VENDDATA %3 %4 -xpp  -zn   -y "Product Information: @" -na >> %2
vendprcs VENDDATA %3 %4 -xpe  -zn   -y " @ v"                  -na >> %2
vendprcs VENDDATA %3 %4 -xpv  -zn   -y "@ "                    -na >> %2
vendprcs VENDDATA %3 %4 -xpt        -y "(@)"                   -na >> %2

vendprcs VENDDATA %3 %4             -y "                     " -na >> %2
vendprcs VENDDATA %3 %4             -y "Header Information   " -na >> %2
vendprcs VENDDATA %3 %4 -xhv        -y "        VI Version: @" -na >> %2
vendprcs VENDDATA %3 %4 -xht        -y "       Header Type: @" -na >> %2
vendprcs VENDDATA %3 %4 -xhd        -y "         Prep Date: @" -na >> %2

rem ----- extract special CD-ROM front-end fields from file ---------
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo        Extraction of CD-ROM front-end information          >> %2
echo  >> %2

::----- author number ---------------------------
vendprcs VENDDATA %3 %4 -ecdfi -na
if errorlevel 51 goto di_done
vendprcs VENDDATA %3 %4 -xcdfi      -y "Author Number:       @" -na >> %2
:di_done

::----- product number --------------------------
vendprcs VENDDATA %3 %4 -ecdfj -na
if errorlevel 51 goto dj_done
vendprcs VENDDATA %3 %4 -xcdfj      -y "Product Number:      @" -na >> %2
:dj_done

::----- volume label ----------------------------
vendprcs VENDDATA %3 %4 -ecdfb -na
if errorlevel 51 goto db_done
vendprcs VENDDATA %3 %4 -xcdfb      -y "Volume label:        @" -na >> %2
:db_done

::----- preferred directory ---------------------
vendprcs VENDDATA %3 %4 -ecdfk -na
if errorlevel 51 goto dk_done
vendprcs VENDDATA %3 %4 -xcdfk      -y "Preferred Directory: @" -na >> %2
:dk_done

::----- executable location ---------------------
vendprcs VENDDATA %3 %4 -ecdfc -na
if errorlevel 51 goto dc_done
vendprcs VENDDATA %3 %4 -xcdfc      -y "Executable:          @" -na >> %2
vendprcs VENDDATA %3 %4 -xcdnc      -y "                     Package @" -na >> %2
:dc_done

::----- demo program ----------------------------
vendprcs VENDDATA %3 %4 -ecdfd -na
if errorlevel 51 goto dd_done
vendprcs VENDDATA %3 %4 -xcdfd      -y "Demo Program:        @" -na >> %2
vendprcs VENDDATA %3 %4 -xcdnd      -y "                     Package @" -na >> %2
:dd_done

::----- install program -------------------------
vendprcs VENDDATA %3 %4 -ecdfe -na
if errorlevel 51 goto de_done
vendprcs VENDDATA %3 %4 -xcdfe      -y "Install Program:     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcdne      -y "                     Package @" -na >> %2
:de_done

::----- config program --------------------------
vendprcs VENDDATA %3 %4 -ecdfl -na
if errorlevel 51 goto dl_done
vendprcs VENDDATA %3 %4 -xcdfl      -y "Config Program:      @" -na >> %2
vendprcs VENDDATA %3 %4 -xcdnl      -y "                     Package @" -na >> %2
:dl_done

::----- user document ---------------------------
vendprcs VENDDATA %3 %4 -ecdff -na
if errorlevel 51 goto df_done
vendprcs VENDDATA %3 %4 -xcdff      -y "User Document:       @" -na >> %2
vendprcs VENDDATA %3 %4 -xcdnf      -y "                     Package @" -na >> %2
:df_done

::----- order form location ---------------------
vendprcs VENDDATA %3 %4 -ecdfg -na
if errorlevel 51 goto dg_done
vendprcs VENDDATA %3 %4 -xcdfg      -y "Order Form:          @" -na >> %2
vendprcs VENDDATA %3 %4 -xcdng      -y "                     Package @" -na >> %2
:dg_done

rem ----- extract any indluced files --------------------------------
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo        Extraction of Included Files                        >> %2
echo  >> %2
echo Following is a list of included files and their descriptions.>> %2
echo You should verify the list, and you should verify that the   >> %2
echo files have all be successfully unzipped in the temporary     >> %2
echo directory.  The files will have the VendEdit-provided        >> %2
echo shown in the list below, rather than your original filenamse.>> %2
vendprcs    -y " "      >> %2

::----- screenshot 1 ----------------------------
vendprcs VENDDATA %3 %4 -ecffa -na
if errorlevel 51 goto fa_done
vendprcs VENDDATA %3 %4 -xcffa      -y "Screenshot 1:        @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfda      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfna      -y "                     Set @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxa -na
if errorlevel 52 goto fa_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fa_done
:fa_ok
vendprcs VENDDATA %3 %4 -xcffa      -y "                     @ extracted successfully" -na >> %2
:fa_done

::----- screenshot 2 ----------------------------
vendprcs VENDDATA %3 %4 -ecffb -na
if errorlevel 51 goto fb_done
vendprcs VENDDATA %3 %4 -xcffb      -y "Screenshot 2:        @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdb      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfnb      -y "                     Set @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxb -na
if errorlevel 52 goto fb_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fb_done
:fb_ok
vendprcs VENDDATA %3 %4 -xcffb      -y "                     @ extracted successfully" -na >> %2
:fb_done

::----- screenshot 3 ----------------------------
vendprcs VENDDATA %3 %4 -ecffc -na
if errorlevel 51 goto fc_done
vendprcs VENDDATA %3 %4 -xcffc      -y "Screenshot 3:        @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdc      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfnc      -y "                     Set @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxc -na
if errorlevel 52 goto fc_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fc_done
:fc_ok
vendprcs VENDDATA %3 %4 -xcffc      -y "                     @ extracted successfully" -na >> %2
:fc_done

::----- icon 1 ----------------------------------
vendprcs VENDDATA %3 %4 -ecffd -na
if errorlevel 51 goto fd_done
vendprcs VENDDATA %3 %4 -xcffd      -y "Icon 1:              @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdd      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfnd      -y "                     Set @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxd -na
if errorlevel 52 goto fd_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fd_done
:fd_ok
vendprcs VENDDATA %3 %4 -xcffd      -y "                     @ extracted successfully" -na >> %2
:fd_done

::----- icon 2 ----------------------------------
vendprcs VENDDATA %3 %4 -ecffe -na
if errorlevel 51 goto fe_done
vendprcs VENDDATA %3 %4 -xcffe      -y "Icon 2:              @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfde      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfne      -y "                     Set @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxe -na
if errorlevel 52 goto fe_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fe_done
:fe_ok
vendprcs VENDDATA %3 %4 -xcffe      -y "                     @ extracted successfully" -na >> %2
:fe_done

::----- icon 3 ----------------------------------
vendprcs VENDDATA %3 %4 -ecfff -na
if errorlevel 51 goto ff_done
vendprcs VENDDATA %3 %4 -xcfff      -y "Icon 3:              @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdf      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfnf      -y "                     Set @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxf -na
if errorlevel 52 goto ff_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto ff_done
:ff_ok
vendprcs VENDDATA %3 %4 -xcfff      -y "                     @ extracted successfully" -na >> %2
:ff_done

::----- sound 1 ---------------------------------
vendprcs VENDDATA %3 %4 -ecffg -na
if errorlevel 51 goto fg_done
vendprcs VENDDATA %3 %4 -xcffg      -y "Sound 1:             @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdg      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfng      -y "                     Set @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxg -na
if errorlevel 52 goto fg_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fg_done
:fg_ok
vendprcs VENDDATA %3 %4 -xcffg      -y "                     @ extracted successfully" -na >> %2
:fg_done

::----- sound 2 ---------------------------------
vendprcs VENDDATA %3 %4 -ecffh -na
if errorlevel 51 goto fh_done
vendprcs VENDDATA %3 %4 -xcffh      -y "Sound 2:             @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdh      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfnh      -y "                     Set @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxh -na
if errorlevel 52 goto fh_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fh_done
:fh_ok
vendprcs VENDDATA %3 %4 -xcffh      -y "                     @ extracted successfully" -na >> %2
:fh_done

::----- sound 3 ---------------------------------
vendprcs VENDDATA %3 %4 -ecffi -na
if errorlevel 51 goto fi_done
vendprcs VENDDATA %3 %4 -xcffi      -y "Sound 3:             @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdi      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfni      -y "                     Set @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxi -na
if errorlevel 52 goto fi_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fi_done
:fi_ok
vendprcs VENDDATA %3 %4 -xcffi      -y "                     @ extracted successfully" -na >> %2
:fi_done

::----- ad or boot screen -----------------------
vendprcs VENDDATA %3 %4 -ecffj -na
if errorlevel 51 goto fj_done
vendprcs VENDDATA %3 %4 -xcffj      -y "Ad or Boot Screen:   @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdj      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxj -na
if errorlevel 52 goto fj_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fj_done
:fj_ok
vendprcs VENDDATA %3 %4 -xcffj      -y "                     @ extracted successfully" -na >> %2
:fj_done

::----- logo ------------------------------------
vendprcs VENDDATA %3 %4 -ecffk -na
if errorlevel 51 goto fk_done
vendprcs VENDDATA %3 %4 -xcffk      -y "Logo:                @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdk      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxk -na
if errorlevel 52 goto fk_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fk_done
:fk_ok
vendprcs VENDDATA %3 %4 -xcffk      -y "                     @ extracted successfully" -na >> %2
:fk_done

::----- press release ---------------------------
vendprcs VENDDATA %3 %4 -ecffl -na
if errorlevel 51 goto fl_done
vendprcs VENDDATA %3 %4 -xcffl      -y "Press Release:       @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdl      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxl -na
if errorlevel 52 goto fl_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fl_done
:fl_ok
vendprcs VENDDATA %3 %4 -xcffl      -y "                     @ extracted successfully" -na >> %2
:fl_done

::----- reviewer guide --------------------------
vendprcs VENDDATA %3 %4 -ecffm -na
if errorlevel 51 goto fm_done
vendprcs VENDDATA %3 %4 -xcffm      -y "Reviewer Guide:      @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdm      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxm -na
if errorlevel 52 goto fm_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fm_done
:fm_ok
vendprcs VENDDATA %3 %4 -xcffm      -y "                     @ extracted successfully" -na >> %2
:fm_done

::----- company backgrounder --------------------
vendprcs VENDDATA %3 %4 -ecffn -na
if errorlevel 51 goto fn_done
vendprcs VENDDATA %3 %4 -xcffn      -y "Company Background:  @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdn      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxn -na
if errorlevel 52 goto fn_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fn_done
:fn_ok
vendprcs VENDDATA %3 %4 -xcffn      -y "                     @ extracted successfully" -na >> %2
:fn_done

::----- author biography ------------------------
vendprcs VENDDATA %3 %4 -ecffo -na
if errorlevel 51 goto fo_done
vendprcs VENDDATA %3 %4 -xcffo      -y "Author Biography:    @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdo      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxo -na
if errorlevel 52 goto fo_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fo_done
:fo_ok
vendprcs VENDDATA %3 %4 -xcffo      -y "                     @ extracted successfully" -na >> %2
:fo_done

::----- product sheet ---------------------------
vendprcs VENDDATA %3 %4 -ecffp -na
if errorlevel 51 goto fp_done
vendprcs VENDDATA %3 %4 -xcffp      -y "Product Sheet:       @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdp      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxp -na
if errorlevel 52 goto fp_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fp_done
:fp_ok
vendprcs VENDDATA %3 %4 -xcffp      -y "                     @ extracted successfully" -na >> %2
:fp_done

::----- question-and-answer sheet ---------------
vendprcs VENDDATA %3 %4 -ecffq -na
if errorlevel 51 goto fq_done
vendprcs VENDDATA %3 %4 -xcffq      -y "Question/Answer:     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdq      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxq -na
if errorlevel 52 goto fq_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fq_done
:fq_ok
vendprcs VENDDATA %3 %4 -xcffq      -y "                     @ extracted successfully" -na >> %2
:fq_done

::----- miscellaneous file 1 --------------------
vendprcs VENDDATA %3 %4 -ecffr -na
if errorlevel 51 goto fr_done
vendprcs VENDDATA %3 %4 -xcffr      -y "Misc File 1:         @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdr      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxr -na
if errorlevel 52 goto fr_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fr_done
:fr_ok
vendprcs VENDDATA %3 %4 -xcffr      -y "                     @ extracted successfully" -na >> %2
:fr_done

::----- miscellaneous file 2 --------------------
vendprcs VENDDATA %3 %4 -ecffs -na
if errorlevel 51 goto fs_done
vendprcs VENDDATA %3 %4 -xcffs      -y "Misc File 2:         @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfds      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxs -na
if errorlevel 52 goto fs_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fs_done
:fs_ok
vendprcs VENDDATA %3 %4 -xcffs      -y "                     @ extracted successfully" -na >> %2
:fs_done

::----- miscellaneous file 3 --------------------
vendprcs VENDDATA %3 %4 -ecfft -na
if errorlevel 51 goto ft_done
vendprcs VENDDATA %3 %4 -xcfft      -y "Misc File 3:         @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdt      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxt -na
if errorlevel 52 goto ft_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto ft_done
:ft_ok
vendprcs VENDDATA %3 %4 -xcfft      -y "                     @ extracted successfully" -na >> %2
:ft_done

::----- miscellaneous file 4 --------------------
vendprcs VENDDATA %3 %4 -ecffu -na
if errorlevel 51 goto fu_done
vendprcs VENDDATA %3 %4 -xcffu      -y "Misc File 4:         @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfdu      -y "                     @" -na >> %2
vendprcs VENDDATA %3 %4 -xcfxu -na
if errorlevel 52 goto fu_ok
echo ##### VendPrcs reports file extraction failure ##### >> %2
goto fu_done
:fu_ok
vendprcs VENDDATA %3 %4 -xcffu      -y "                     @ extracted successfully" -na >> %2
:fu_done

:exit
