goto start
:usage
echo off
cls
echo ͻ 
echo     testdist.bat -- perform distribution policy tests on     
echo                     a VENDINFO file, writing LOGS to         
echo                     specified file                           
echo                                                              
echo     usage:                                                   
echo            testdist diz_file out_file                        
echo     where:                                                   
echo            diz_file = pathname of VENDINFO file              
echo                                                              
echo            out_file = pathname of output file to which       
echo                       log files information should be        
echo                       written                                
echo                                                              
echo     example:                                                 
echo            testdist vendinfo.diz sample.prn                  
echo                                                              
echo  Copyright 1993-94 Rams' Island Software All Rights Reserved 
echo    Rams' Island Software, 7644 Lakecliff, Parker CO 80134    
echo ͼ
goto exit

:start
rem ----- desired VendPrcs test goes here ---------------------------
if %1.==. goto usage
if %2.==. goto usage
del %2

rem ----- test for valid, authenticated file ------------------------
vendprcs %1 -zk                      -y " "                      > %2
if errorlevel 12 goto allOK

:test11
if not errorlevel 11 goto test10
echo Ŀ >> %2
echo  Test of validity and authentication of VENDINFO.DIZ file  >> %2
echo  >> %2
echo       This VENDINFO.DIZ file has a missing or invalid      >> %2
echo       author authentication code.  If you are the author   >> %2
echo       and you are testing your VENDINFO.DIZ file, this     >> %2
echo       simply means that you have not yet registered        >> %2
echo       VendEdit and entered the registration numbers so     >> %2
echo       that VendEdit can produce an authenticated record.   >> %2
echo       (It's also possible that you have a special-purpose  >> %2
echo       VendEdit registration, and are attempting to produce >> %2
echo       VENDINFO records for products outside the allowed    >> %2
echo       types.  Try Verify Warnings for more information.)   >> %2
vendprcs    -y " "      >> %2
echo       If you are an author testing your VENDINFO.DIZ file  >> %2
echo       and you have already entered your registration keys, >> %2
echo       make sure that the company name used in this         >> %2
echo       VENDINFO file exactly matches the name in which you  >> %2
echo       registered.  Registration keys are tied to your      >> %2
echo       company name.  In VendEdit, try Edit Author Company  >> %2
echo       and press F3.                                        >> %2
vendprcs    -y " "      >> %2
echo       If you have found this VENDINFO.DIZ file in a        >> %2
echo       distributed package, however, then that package may  >> %2
echo       be hacked or corrupted.                              >> %2
vendprcs    -y " "      >> %2
echo       Authentication verification will be turned off for   >> %2
echo       the remaining tests, so you can see the results as   >> %2
echo       a distributor would see them after you've registered >> %2
echo       and entered the registration keys for your company.  >> %2
goto continue

:test10
if errorlevel 10 goto badtext
if errorlevel 1 goto error
goto allOK

:error
echo Ŀ >> %2
echo  Test of validity and authentication of VENDINFO.DIZ file  >> %2
echo  >> %2
echo       There has been an error in the reading of this       >> %2
echo       VENDINFO.DIZ file, preventing further processing.    >> %2
echo       The error is probably an incorrect size or CRC       >> %2
echo       for either the text or the data section, and may be  >> %2
echo       caused by a hacked or corrupted file.                >> %2
goto exit

:badtext
echo Ŀ >> %2
echo  Test of validity and authentication of VENDINFO.DIZ file  >> %2
echo  >> %2
echo       This VENDINFO.DIZ file has an incorrect size or CRC  >> %2
echo       for either the text or the data section, and may be  >> %2
echo       a hacked or corrupted file.                          >> %2
goto exit

:allOK
echo Ŀ >> %2
echo  Test of validity and authentication of VENDINFO.DIZ file  >> %2
echo  >> %2
echo       This VENDINFO.DIZ file has passed all validity and   >> %2
echo       security tests, including size and CRC tests and     >> %2
echo       basic author source authentication.                  >> %2

:continue
del VENDDATA

vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  Simple test for BBS distribution, no special conditions   >> %2
echo  >> %2
vendprcs %1 -db     -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  BBS distribution, no charge to customers                  >> %2
echo  >> %2
vendprcs %1 -db -c0 -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  BBS distribution, $50/yr., recompress, add ad,            >> %2
echo  mail disks to some users                                  >> %2
echo  >> %2
vendprcs %1 -db -cy5000 -omac -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  FDN distribution                                          >> %2
echo  >> %2
vendprcs %1 -df     -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  Mail-order disk vendor, no special conditions             >> %2
echo  >> %2
vendprcs %1 -dd     -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  Mail-order disk vendor, $5/360K                           >> %2
echo  >> %2
vendprcs %1 -dd -ck500 -cp0 -cy0 -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  Disk vendor, $5/360K, ASP/informs/non-prof user group     >> %2
echo  >> %2
vendprcs %1 -dd -ck500 -cp0 -cy0 -tan -oipods -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  Disk vendor, $50/360K, ASP/informs/non-prof user group    >> %2
echo  >> %2
vendprcs %1 -dd -ck5000 -cp0 -cy0 -tan -oipods -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  CD-ROM, targetted end users only, $50, ASP distributor    >> %2
echo  >> %2
vendprcs %1 -dc -mcbd -cc5000 -ta -oipods -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  CD-ROM, targetted BBSes and distributors, $50, informs    >> %2
echo  >> %2
vendprcs %1 -dc -mcu -cc5000 -oipods -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  Rack distributor, $9.99/program                           >> %2
echo  >> %2
vendprcs %1 -dr -ck0 -cp999 -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  Installation on user's machine by consultant              >> %2
echo  >> %2
vendprcs %1 -di -tc -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  Distribution by undefined method                          >> %2
echo  >> %2
vendprcs %1 -du     -na >> %2
vendprcs    -y " "      >> %2
vendprcs    -y " "      >> %2
echo Ŀ >> %2
echo  Feel free to add your own tests to this TESTDIST.BAT      >> %2
echo  >> %2

:exit
