  
'  ************************************************************************
'  *                                                                      *
'  * Author:   Paul Lapsansky                                             *
'  * Date:     05/09/95                                                   *
'  *                                                                      *
'  * File:     demo.bas                                                   *
'  *                                                                      *
'  * Descrpt:  Demonstrates functions found in the SYSTEM INFO LIBRARY.   *
'  *                                                                      *
'  * Language: QuickBASIC 4.0+                                            *
'  *                                                                      *
'  * Platform: MS-DOS                                                     *
'  *                                                                      *
'  ************************************************************************

    REM $INCLUDE: 'SYSINFO.BI'

    DEFINT A-Z

    CONST black = 0
    CONST blue = 1
    CONST green = 2
    CONST cyan = 3
    CONST red = 4
    CONST magenta = 5
    CONST brown = 6
    CONST white = 7
    CONST bright = 8
    CONST blink = 16
    CONST yellow = bright + brown

'  ***********************************************************************
'  *                          Initialization...                          *
'  ***********************************************************************

   CLS
   COLOR white + bright, white: PRINT "";
   COLOR black + bright, white: PRINT " ";
   COLOR white + bright, white: PRINT "";
   COLOR black, white: PRINT " Version 1.2         ";
   COLOR black + bright, white: PRINT " ";
   COLOR black, white: PRINT "     SYSTEM INFO LIBRARY DEMO                QB Edition ";
   COLOR black + bright, white: PRINT "";
   COLOR white + bright, white: PRINT "";
   COLOR black, white: PRINT "                  Copyright(c) 1994, 1995 By Paul Lapsansky                   ";
   COLOR black + bright, white: PRINT "";
   PRINT " ";
   COLOR yellow, blue
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   PRINT "                                                                                ";
   COLOR white + bright, white: PRINT "";
   COLOR black, white: PRINT " ";
   COLOR white + bright, white: PRINT "";
   COLOR black, white: PRINT "                        Press any key for next screen...                      ";
   COLOR black + bright, white: PRINT ""
   PRINT " ";
   VIEW PRINT 5 TO 21
  
'   ************************************************************************
'   *                 Display Hardware Information Screen                  *
'   ************************************************************************

    COLOR yellow, blue                   'yellow on blue
    CLS 2
    
    PRINT
    PRINT "                                    Computer                                    ";
    PRINT "                                                                                ";
    PRINT "   BIOS Category     :                                                          ";
    PRINT "   BIOS I.D.         :                                                          ";
    PRINT "   BIOS Date         :                                                          ";
    PRINT "   Bus Type          :                    DMA Channel 3 used            :       ";
    PRINT "                                          2nd 8259 installed            :       ";
    PRINT "   Processor         :                    Real Time Clock installed     :       ";
    PRINT "   Math Co-processor :                    Keyboard Int. (INT 15/AH=4F)  :       ";
    PRINT "   Processor Speed   :                    Wait for External Event       :       ";
    PRINT "   Processor Mode    :                    Extended BIOS allocated       :       ";
    PRINT "                                                                                ";
    PRINT "   Keyboard Type     :                                                          ";

    COLOR white + bright, blue           'bright white on blue

    getID model, submodel, rev           'get model information
    pcdate$ = biosDate$                  'get BIOS date

    LOCATE 8, 24

    SELECT CASE model                    'display model type
      CASE &HFF:
        SELECT CASE submodel
          CASE &H46:
            PRINT "Olivetti M15";
          CASE ELSE:
            IF pcdate$ = "04/24/81" THEN
              PRINT "IBM PC";
            ELSEIF pcdate$ = "10/19/81" THEN
              PRINT "IBM PC";
            ELSEIF pcdate$ = "10/27/82" THEN
              PRINT "IBM PC";
            ELSE
              PRINT "IBM PC compatible";
            END IF
        END SELECT
      CASE &HFE:
        SELECT CASE submodel
          CASE &H43:
            PRINT "Olivetti M240";
          CASE &HA6:
            PRINT "Quadram Quad386";
          CASE ELSE:
            IF pcdate$ = "08/16/82" THEN
              PRINT "IBM PC/XT";
            ELSEIF pcdate$ = "11/08/82" THEN
              PRINT "IBM PC/XT";
            ELSE
              PRINT "IBM PC/XT compatible";
            END IF
        END SELECT
      CASE &HFD:
        PRINT "IBM PCjr";
      CASE &HFC:
        SELECT CASE submodel
          CASE &H1
            SELECT CASE rev
              CASE &H20:
                PRINT "AST";
              CASE &H30:
                PRINT "Tandy 3000NL";
              CASE ELSE:
                IF pcdate$ = "11/15/85" THEN
                  PRINT "IBM AT Model 3x9";
                ELSEIF pcdate$ = "09/17/87" THEN
                  PRINT "Tandy 3000";
                ELSEIF pcdate$ = "01/15&88" THEN
                  PRINT "Toshiba T5200/100";
                ELSEIF pcdate$ = "12/26*89" THEN
                  PRINT "Toshiba T1200/XE";
                ELSEIF pcdate$ = "04/05A92" THEN
                  PRINT "Toshiba T4500SX-C";
                ELSEIF pcdate$ = "07/17o92" THEN
                  PRINT "Toshiba T1800SX";
                ELSEIF pcdate$ = "12/25n92" THEN
                  PRINT "T1850SX";
                ELSEIF pcdate$ = "01/13E93" THEN
                  PRINT "Toshiba T4400C";
                ELSEIF pcdate$ = "04/08/93" THEN
                  PRINT "Compaq";
                ELSEIF pcdate$ = "04/12/93" THEN
                  PRINT "Compaq";
                ELSE
                  PRINT "IBM AT compatible";
                END IF
            END SELECT
          CASE &H2:
            IF pcdate$ = "04/21/86" THEN
              PRINT "IBM XT-286";
            ELSEIF pcdate$ = "08/05/93" THEN
              PRINT "Compaq";
            ELSE
              PRINT "IBM AT compatible";
            END IF
          CASE &H4:
            SELECT CASE rev
              CASE &H0:
                PRINT "PS/2 Model 50";
              CASE &H2:
                PRINT "PS/2 Model 50";
              CASE &H3:
                PRINT "PS/2 Model 50Z";
              CASE &H4:
                PRINT "PS/2 Model 50Z";
              CASE ELSE
                PRINT "IBM AT compatible";
            END SELECT
          CASE &H5:
            PRINT "PS/2 Model 60";
          CASE &H6:
            PRINT "IBM 7552";
          CASE &H8:
            PRINT "PS/2 Model 25";
          CASE &H9:
            PRINT "PS/2 Model 30";
          CASE &HB:
            PRINT "PS/1 Model 2011";
          CASE &H20:
            PRINT "Compaq ProLinea";
          CASE &H30:
            PRINT "Epson";
          CASE &H31:
            PRINT "Epson";
          CASE &H33:
            PRINT "Epson";
          CASE &H42:
            PRINT "Olivetti M280";
          CASE &H45:
            PRINT "Olivetti M380";
          CASE &H48:
            PRINT "Olivetti M290";
          CASE &H4F:
            PRINT "Olivetti M250";
          CASE &H50:
            PRINT "Olivetti M380";
          CASE &H51:
            PRINT "Olivetti PCS286";
          CASE &H52:
            PRINT "Olivetti M300";
          CASE &H94:
            PRINT "Zenith 386";
          CASE ELSE:
            IF pcdate$ = "01/10/84" THEN
              PRINT "IBM AT Model 068/099";
            ELSEIF pcdate$ = "06/10/85" THEN
              PRINT "IBM AT Model 239";
            ELSE
              PRINT "IBM AT compatible";
            END IF
        END SELECT
      CASE &HFB:
        SELECT CASE submodel
          CASE &H4C:
            PRINT "Olivetti M200";
          CASE ELSE:
            IF pcdate$ = "01/10/86" THEN
              PRINT "IBM PC/XT";
            ELSEIF pcdate$ = "05/09/86" THEN
              PRINT "IBM PC/XT";
            ELSE
              PRINT "IBM PC/XT compatible";
            END IF
        END SELECT
      CASE &HFA:
        SELECT CASE submodel
          CASE &H0:
            PRINT "PS/2 Model 30";
          CASE &H1:
            PRINT "PS/2 Model 25";
          CASE &H4E:
            PRINT "Olivetti M111";
          CASE ELSE:
            PRINT "Unknown Model!";
        END SELECT
      CASE &HF9:
        PRINT "PC Convertible";
      CASE &HF8:
        SELECT CASE submodel
          CASE &H0:
            PRINT "PS/2 Model 80";
          CASE &H1:
            PRINT "PS/2 Model 80";
          CASE &H2:
            PRINT "PS/2 Model 55";
          CASE &H4:
            PRINT "PS/2 Model 70";
          CASE &H5:
            PRINT "IBM PC 7568";
          CASE &H6:
            PRINT "PS/2 Model 55";
          CASE &H7:
            SELECT CASE rev
              CASE &H0:
                PRINT "IBM PC 7561/2";
              CASE &H1:
                PRINT "PS/2 Model 55";
              CASE &H2:
                PRINT "IBM PC 7561/2";
              CASE &H3:
                PRINT "PS/2 Model 55";
              CASE ELSE
                PRINT "Unknown Model!";
            END SELECT
          CASE &H9:
            PRINT "PS/2 Model 70";
          CASE &HB:
            PRINT "PS/2 Model 70";
          CASE &HC:
            PRINT "PS/2 Model 55SX";
          CASE &HD:
            PRINT "PS/2 Model 70";
          CASE &HE:
            PRINT "PS/1 486SX";
          CASE &HF:
            PRINT "PS/1 486DX";
          CASE &H10:
            PRINT "PS/2 Model 55";
          CASE &H11:
            PRINT "PS/2 Model 90";
          CASE &H12:
            PRINT "PS/2 Model 95";
          CASE &H13:
            PRINT "PS/2 Model 90";
          CASE &H14:
            PRINT "PS/2 Model 90";
          CASE &H15:
            PRINT "PS/2 Model 90";
          CASE &H16:
            PRINT "PS/2 Model 90";
          CASE &H17:
            PRINT "PS/2 Model 90";
          CASE &H19:
            PRINT "PS/2 Model 35/35LS/40";
          CASE &H1A:
            PRINT "PS/2 Model 95";
          CASE &H1B:
            PRINT "PS/2 Model 70";
          CASE &H1C:
            PRINT "PS/2 Model 65";
          CASE &H1E:
            PRINT "PS/2 Model 55LS";
          CASE &H1F:
            PRINT "PS/ValuePoint";
          CASE &H23:
            PRINT "PS/2 Model L40";
          CASE &H25:
            PRINT "PS/2 Model 57";
          CASE &H26:
            PRINT "PS/2 Model 57";
          CASE &H28:
            PRINT "PS/2 Model 95";
          CASE &H29:
            PRINT "PS/2 Model 90";
          CASE &H2A:
            PRINT "PS/2 Model 95";
          CASE &H2B:
            PRINT "PS/2 Model 90";
          CASE &H2C:
            PRINT "PS/2 Model 95";
          CASE &H2D:
            PRINT "PS/2 Model 90";
          CASE &H2E:
            PRINT "PS/2 Model 95";
          CASE &H2F:
            PRINT "PS/2 Model 90";
          CASE &H30:
            PRINT "PS/1 Model 2121";
          CASE &H33:
            PRINT "PS/2 Model 30";
          CASE &H34:
            PRINT "PS/2 Model 25";
          CASE &H36:
            PRINT "PS/2 Model 95";
          CASE &H37:
            PRINT "PS/2 Model 95";
          CASE &H38:
            PRINT "PS/2 Model 57";
          CASE &H39:
            PRINT "PS/2 Model 95";
          CASE &H3F:
            PRINT "PS/2 Model 90";
          CASE &H40:
            PRINT "PS/2 Model 95";
          CASE &H41:
            PRINT "PS/2 Model 77";
          CASE &H45:
            PRINT "PS/2 Model 90";
          CASE &H46:
            PRINT "PS/2 Model 95";
          CASE &H47:
            PRINT "PS/2 Model 90/95";
          CASE &H48:
            PRINT "PS/2 Model 85";
          CASE &H49:
            PRINT "PS/ValuePoint";
          CASE &H4A:
            PRINT "PS/ValuePoint";
          CASE &H4B:
            PRINT "PS/ValuePoint";
          CASE &H4E:
            PRINT "PS/2 Model 295";
          CASE &H50:
            PRINT "PS/2 Model P70";
          CASE &H52:
            PRINT "PS/2 Model P75";
          CASE &H56:
            PRINT "PS/2 Model CL57";
          CASE &H57:
            PRINT "PS/2 Model 90";
          CASE &H58:
            PRINT "PS/2 Model 95";
          CASE &H59:
            PRINT "PS/2 Model 90";
          CASE &H5A:
            PRINT "PS/2 Model 95";
          CASE &H5B:
            PRINT "PS/2 Model 90";
          CASE &H5C:
            PRINT "PS/2 Model 95";
          CASE &H5D:
            PRINT "PS/2 Model N51";
          CASE &H5E:
            PRINT "IBM ThinkPad 700";
          CASE &H61:
            PRINT "Olivetti P500";
          CASE &H62:
            PRINT "Olivetti P800";
          CASE &H80:
            PRINT "PS/2 Model 80";
          CASE &H81:
            PRINT "PS/2 Model 55";
          CASE &H87:
            PRINT "PS/2 Model N33SX";
          CASE &H88:
            PRINT "PS/2 Model 55";
          CASE &H97:
            PRINT "PS/2 Model 55";
          CASE &H99:
            PRINT "PS/2 Model N51";
          CASE ELSE:
            PRINT "PS/2";
        END SELECT
      CASE &HE1:
        PRINT "PS/2 Model 55";
      CASE &H9A:
        PRINT "Compaq XT/Plus";
      CASE &H30:
        PRINT "Sperry PC";
      CASE &H2D:
        PRINT "Compaq PC/Deskpro";
      CASE ELSE:
        PRINT "Unknown model!";
    END SELECT

    LOCATE 9, 24                         'display model I.D.
    model$ = HEX$(model)
    submodel$ = HEX$(submodel)
    rev$ = HEX$(rev)
    IF LEN(model$) < 2 THEN model$ = "0" + model$
    IF LEN(submodel$) < 2 THEN submodel$ = "0" + submodel$
    IF LEN(rev$) < 2 THEN rev$ = "0" + rev$

    PRINT model$; " "; submodel$; " "; rev$;

    LOCATE 10, 24
    PRINT pcdate$;                       'display BIOS date

    bus = getBusType                     'get bus type
    LOCATE 11, 24

    SELECT CASE bus                      'display bus type     
      CASE 1
        PRINT "ISA";
      CASE 2
        PRINT "MCA";
      CASE 3
        PRINT "EISA";
    END SELECT

    cpu = getCPU                         'get processor type
    npu = getNPU                         'get co-processor type
    LOCATE 13, 24

    SELECT CASE cpu                      'display processor type
      CASE 1:
         IF getPFQ = 2 THEN
          PRINT "NEC V30";
         ELSE
           PRINT "NEC V20";
         END IF
      CASE 2:
         IF getPFQ = 2 THEN
           PRINT "8086";
         ELSE
           PRINT "8088";
         END IF
      CASE 3:
         IF getPFQ = 2 THEN
           PRINT "80186";
         ELSE
           PRINT "80188";
         END IF
      CASE 4:
        PRINT "80286";
      CASE 5:
        PRINT "80386";
      CASE 6:
         IF npu = 0 THEN
           PRINT "80486SX";
         ELSE
           PRINT "80486DX";
         END IF
      CASE 7:
        PRINT "Pentium";
    END SELECT

    LOCATE 14, 24

    SELECT CASE npu                      'display co-processor type
      CASE 1
        PRINT "8087";
      CASE 2
        PRINT "80287";
      CASE 3
        PRINT "80387";
      CASE 4
        PRINT "Internal";
      CASE 5
        PRINT "Internal";
      CASE ELSE
        PRINT "Not Installed";
    END SELECT

    LOCATE 15, 24
    PRINT LTRIM$(STR$(getMhz)) + "Mhz";  'display CPU speed

    LOCATE 18, 24
    IF chkEnhKeyb THEN                   'display keyboard type
      PRINT "Enhanced Keyboard";
    ELSE
      PRINT "Standard Keyboard";
    END IF

    mode = getCPUmode                    'get CPU mode
    LOCATE 16, 24

    SELECT CASE mode                     'display CPU mode     
      CASE 1
        PRINT "Real";
      CASE 2
        PRINT "Protected";
      CASE 3
        PRINT "V86";
      CASE ELSE
        PRINT "Not supported";
    END SELECT

    IF getFeatures(DMA3, s8259, realtime, keyint, event, extbios, mca) = 0 THEN
      COLOR red + bright, blue
      LOCATE 11, 75
      IF DMA3 THEN                       'display if DMA3 is available
        PRINT "yes";
      ELSE
        PRINT "no";
      END IF
      LOCATE 12, 75
      IF s8259 THEN                      'display if a slave 8259 is available
        PRINT "yes";
      ELSE
        PRINT "no";
      END IF
      LOCATE 13, 75
      IF realtime THEN                   'display if a realtime clock is avail
        PRINT "yes";
      ELSE
        PRINT "no";
      END IF
      LOCATE 14, 75
      IF keyint THEN                     'display if keyboard intercept is avail
        PRINT "yes";
      ELSE
        PRINT "no";
      END IF
      LOCATE 15, 75
      IF event THEN                      'display if external event available
        PRINT "yes";
      ELSE
        PRINT "no";
      END IF
      LOCATE 16, 75
      IF extbios THEN                    'display if extended BIOS available
        PRINT "yes";
      ELSE
        PRINT "no";
      END IF
    END IF

    a$ = INPUT$(1)                       'wait for keystroke

'  ************************************************************************
'  *                       Display I/O Ports Screen                       *
'  ************************************************************************

    COLOR yellow, blue                   'yellow on blue
    CLS 2

    PRINT
    PRINT "                                   I/O Ports                                    ";
    PRINT "                                                                                ";
    PRINT "                                                                                ";
    PRINT "                          Label      Address     UART                           ";
    PRINT "                                           ";

    COLOR white + bright, blue           'bright white on blue

    y = 11
    FOR i = 1 TO 4
      addr = getCOMaddr(i)               'check if COM port installed
      IF addr THEN
        LOCATE y, 23
        PRINT "    COM"; LTRIM$(STR$(i)); "         "; HEX$(addr); "h";
        uart = getUART(addr)              'get UART type
        SELECT CASE uart
          CASE 0:
            PRINT "      ----";
          CASE 1:
            PRINT "      8250";
          CASE 2:
            PRINT "     16450";
          CASE 3:
            PRINT "    16C1450";
          CASE 4:
            PRINT "     16550";
          CASE 5:
            PRINT "    16550AF";
          CASE 6:
            PRINT "    16C1550";
          CASE 7:
            PRINT "     16552";
          CASE 8:
            PRINT "     82510";
        END SELECT
        y = y + 1
      END IF
    NEXT i

    FOR i = 1 TO getLPT
      addr = getLPTaddr(i)               'check if LPT port installed
      IF addr THEN
        LOCATE y, 23
        PRINT "    LPT"; LTRIM$(STR$(i)); "         "; HEX$(addr); "h      ----";
        y = y + 1
      END IF
    NEXT i

    a$ = INPUT$(1)                       'wait for keystroke

'   ************************************************************************
'   *                   Display Memory Information Screen                  *
'   ************************************************************************

    COLOR yellow, blue                   'yellow on blue
    CLS 2                                'clear screen

    PRINT
    PRINT "                                     Memory                                     ";
    PRINT "                                                                                ";
    PRINT "   Total Conventional Memory :               Total EMS Memory    :              ";
    PRINT "   Free Conventional Memory  :               Free EMS Memory     :              ";
    PRINT "                                             EMS Version         :              ";
    PRINT "   Total Extended Memory     :               EMS Address Page    :              ";
    PRINT "   Free Extended Memory      :               Handles in Use      :              ";
    PRINT "                                                                                ";
    PRINT "   Available XMS Memory      :               DPMI Installed      :              ";
    PRINT "   Largest XMS Memory Block  :               DPMI Version        :              ";
    PRINT "   XMS Version               :                                                  ";
    PRINT "   XMS Driver Version        :               VCPI Installed      :              ";
    PRINT "   A20 Address Line          :               VCPI Version        :              ";
    PRINT "   High Memory Area          :                                                  ";
    PRINT "                                                                                ";
    PRINT "   '386 Extended Memory Manager :                                               ";

    COLOR white + bright, blue           'bright white on blue

    LOCATE 8, 32
    PRINT LTRIM$(STR$(getRAM)) + "K";    'display total conventional memory

    LOCATE 9, 32
    ram = FRE(-1) / 1024
    PRINT LTRIM$(STR$(ram)) + "K";       'display free conventional memory

    IF cpu > 3 THEN                      'check for '286 or higher
     LOCATE 11, 32
     ext& = getExt                       'get total extended memory
     PRINT LTRIM$(STR$(ext&)) + "K";     'display total extended memory
     LOCATE 12, 32
     exta& = getAvailExt                 'get available extended memory
     PRINT LTRIM$(STR$(exta&)) + "K";    'display available extended memory
     IF chkXMS THEN                      'check for XMS driver
       IF getXMSa(xmsa&, xmsb&) = 0 THEN 'get XMS information
         LOCATE 14, 32
         PRINT LTRIM$(STR$(xmsa&)) + "K"; 'display available XMS memory
         LOCATE 15, 32
         PRINT LTRIM$(STR$(xmsb&)) + "K"; 'display largest XMS block
       END IF
       IF getXMSv(major, minor, drvMaj, drvMin) = 0 THEN  'get XMS version
         LOCATE 16, 32
         PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2)
         LOCATE 17, 32
         PRINT LTRIM$(STR$(drvMaj)) + "." + RIGHT$("0" + LTRIM$(STR$(drvMin)), 2)
       END IF
       IF getXMSi(HMA, A20) = 0 THEN      'get XMS information
         COLOR red + bright, blue         'bright red on blue
         LOCATE 18, 32
         IF A20 THEN                      'display if A20 enabled
           PRINT "Enabled";
         ELSE
           PRINT "Not Enabled";
         END IF
         LOCATE 19, 32
         IF HMA THEN                      'display if HMA available
           PRINT "Available";
         ELSE
           PRINT "Not Available";
         END IF
         COLOR white + bright, blue
       END IF
     END IF
    END IF

    IF chkEMS THEN                        'check for EMS memory
      IF getEMS(ems, emsa) = 0 THEN       'get EMS memory
        LOCATE 8, 68
        ems = ems * 16
        PRINT LTRIM$(STR$(ems)) + "K";    'display total EMS memory
        LOCATE 9, 68
        emsa = emsa * 16
        PRINT LTRIM$(STR$(emsa)) + "K";   'display available EMS memory
      END IF
      IF getEMSv(major, minor) = 0 THEN   'get EMS driver version
        LOCATE 10, 68
        PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2)
      END IF
      IF getEMSi(handles, segment) = 0 THEN 'get EMS information
        LOCATE 11, 68
        PRINT HEX$(segment);              'display EMS page frame address
        LOCATE 12, 67
        PRINT handles;                    'display handles used
      END IF
    ELSE
      LOCATE 8, 68
      PRINT "0K"
      LOCATE 9, 68
      PRINT "0K"
    END IF

    IF cpu > 3 THEN                    'check for '286 or higher
      IF chkDPMI THEN                  'check for DPMI driver
        COLOR bright + red, blue
        LOCATE 14, 68
        PRINT "yes";
        COLOR bright + white, blue
        IF getDPMIv(major, minor) = 0 THEN 'get DPMI version
          LOCATE 15, 68
          PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2)
        END IF
      ELSE
        COLOR bright + red, blue
        LOCATE 14, 68
        PRINT "no";
      END IF
    ELSE
      COLOR bright + red, blue
      LOCATE 14, 68
      PRINT "no";
    END IF

    emm = 0                            'default to EMM not installed
    COLOR bright + white, blue
    IF cpu > 4 AND chkXMS THEN         'check for '386 or higher and XMS
      emm = getEMM                     'get '386 Extended Memory Manager type
      LOCATE 21, 35
      SELECT CASE emm
        CASE 1
          PRINT "Quadtel QMAPS or Hewlett-Packard HPMM.SYS";
        CASE 2
          PRINT "Microsoft EMM386.EXE";
        CASE 3
          PRINT "Microsoft Windows 3.x WIN386.EXE";
        CASE 4
          PRINT "DR-DOS 6.0 EMM386.SYS";
        CASE 5
          PRINT "Qualitas 386MAX";
        CASE 6
          PRINT "V Communication's Memory Commander";
        CASE 7
          PRINT "Quarterdeck QEMM-386";
        CASE 8
          PRINT "Helix Netroom RM386";
        CASE ELSE
          PRINT "Unknown or 386 Memory Manager not installed!";
      END SELECT
    END IF

    IF emm > 0 THEN                    'check for extended memory manager
      IF chkVCPI THEN                  'check for VCPI driver
        COLOR bright + red, blue
        LOCATE 17, 68
        PRINT "yes";
        COLOR bright + white, blue
        getVCPIv major, minor          'get VCPI version
        LOCATE 18, 68
        PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2)
      ELSE
        COLOR bright + red, blue
        LOCATE 17, 68
        PRINT "no";
        COLOR bright + white, blue
      END IF
    ELSE
      COLOR bright + red, blue
      LOCATE 17, 68
      PRINT "no";
      COLOR bright + white, blue
    END IF

    a$ = INPUT$(1)                       'wait for keystroke

'   ************************************************************************
'   *                   Display Video Information Screen                   *
'   ************************************************************************

    COLOR yellow, blue                   'yellow on blue
    CLS 2                                'clear screen

    PRINT
    PRINT "                                      Video                                     ";
    PRINT "                                                                                ";
    PRINT "                                                                                ";
    PRINT "                                                                                ";
    PRINT "                Video Adapter Type     :                                        ";
    PRINT "                Display Type           :                                        ";
    PRINT "                                                                                ";
    PRINT "                                                                                ";
    PRINT "                VESA Support Installed :                                        ";
    PRINT "                VESA Version           :                                        ";
    PRINT "                Video Memory           :                                        ";

    COLOR white + bright, blue           'bright white on blue

    LOCATE 10, 42
    card = getVideo                      'get video card type
    SELECT CASE card
      CASE 1
        PRINT "MDA - Monochrome Display Adapter";
      CASE 2
        PRINT "HGA - Hercules Graphics Adapter";
      CASE 3
        PRINT "CGA - Color Graphics Adapter";
      CASE 4
        PRINT "EGA - Enhanced Graphics Adapter";
      CASE 5
        PRINT "MCGA - Multi-Color Graphics Array";
      CASE 6
        PRINT "VGA - Video Graphics Array";
      CASE 7
        PRINT "XGA - Extended Graphics Adapter";
    END SELECT

    IF card > 4 THEN                     'check for EGA or higher
      LOCATE 11, 42
      IF getCRT THEN
        PRINT "Monochrome";
      ELSE
        PRINT "Color";
      END IF
    END IF

    IF card = 6 THEN                         'check for VGA
      IF getVESA(major, minor, vram) THEN    'check for VESA support
        COLOR bright + red, blue
        LOCATE 14, 42
        PRINT "yes";
        LOCATE 15, 42
        COLOR bright + white, blue
        PRINT LTRIM$(STR$(major)) + "." + LTRIM$(STR$(minor))
        IF major >= 1 AND minor > 0 THEN
          LOCATE 16, 42
          PRINT LTRIM$(STR$(vram)) + "K";
        END IF
      ELSE
        COLOR bright + red, blue
        LOCATE 14, 42
        PRINT "no";
      END IF
    ELSE
      COLOR bright + red, blue
      LOCATE 14, 42
      PRINT "no";
    END IF

    IF chkSB THEN                        'check for SoundBlaster
      LOCATE 18, 31
      PRINT "SoundBlaster installed";
    END IF

    a$ = INPUT$(1)                       'wait for keystroke

'   ************************************************************************
'   *                    Display DOS Information Screen                    *
'   ************************************************************************

    COLOR yellow, blue                   'yellow on blue
    CLS 2                                'clear screen

    PRINT
    PRINT "                                       DOS                                      ";
    PRINT "                                                 ANSI.SYS installed     :       ";
    PRINT "   DOS Version    :                              APPEND.EXE installed   :       ";
    PRINT "   DOS OEM Number :                              ASSIGN.COM installed   :       ";
    PRINT "   DOS Loaded     :                              DISPLAY.SYS installed  :       ";
    PRINT "                                                 DOSKEY.COM installed   :       ";
    PRINT "                                                 DRIVER.SYS installed   :       ";
    PRINT "                                                 EGA.SYS installed      :       ";
    PRINT "                                                 GRAFTABL.COM installed :       ";
    PRINT "                                                 GRAPHICS.COM installed :       ";
    PRINT "                                                 KEYB.COM installed     :       ";
    PRINT "                                                 NLSFUNC.EXE installed  :       ";
    PRINT "                                                 PRINT.COM installed    :       ";
    PRINT "                                                 SHARE.EXE installed    :       ";
    PRINT "                                                 SHELLB.COM installed   :       ";
    PRINT "                                                 XMS2EMS.SYS installed  :       ";

    COLOR white + bright, blue           'bright white on blue

    getDosV major, minor                 'get DOS version
    oem = getDosOem                      'get DOS OEM number
    drdos = getDrDosV                    'get DR-DOS type

    LOCATE 8, 21
    PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2)

    LOCATE 8, 26
    IF major = 6 AND oem = 0 THEN        'check for IBM DOS 6.1
      PRINT "(IBM DOS 6.1)";
    END IF

    IF drdos THEN                        'check for DR-DOS
      SELECT CASE drdos
        CASE 1
          PRINT "(Muliti-User DR-DOS)";
        CASE &H60
          PRINT "(DOS Plus)";
        CASE &H63
          PRINT "(DR-DOS 3.41)";
        CASE &H64
          PRINT "(DR-DOS 3.42)";
        CASE &H65
          PRINT "(DR-DOS 5.0)";
        CASE &H67
          PRINT "(DR-DOS 6.0)";
        CASE &H70
          PRINT "(PalmDOS)";
        CASE &H71
          PRINT "(DR-DOS 6.0)";
        CASE &H72
          PRINT "(Novell DOS 7.0)";
      END SELECT
    END IF

    IF get4DosV(major, minor) THEN       'check for 4DOS
      PRINT "(4DOS ";
      PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2);
      PRINT ")";
    END IF

    LOCATE 9, 21
    oem$ = HEX$(oem)
    IF LEN(oem$) < 2 THEN
      oem$ = "0" + oem$ + "h"
    ELSE
      oem$ = oem$ + "h"
    END IF
    PRINT oem$;                          'display OEM number

    IF drdos = 0 THEN
      LOCATE 9, 26
      SELECT CASE oem
        CASE &H0
          PRINT "(PC-DOS)";
        CASE &H1
          PRINT "(Compaq DOS)";
        CASE &H4
          PRINT "(AT&T DOS)";
        CASE &H5
          PRINT "(Zenith DOS)";
        CASE &H6
          PRINT "(Hewlett-Packard DOS)";
        CASE &H7
          PRINT "(MS-DOS)";
        CASE &HD
          PRINT "(Packard-Bell DOS)";
        CASE &H16
          PRINT "(DEC DOS)";
        CASE &H23
          PRINT "(Olivetti DOS)";
        CASE &H29
          PRINT "(Toshiba DOS)";
        CASE &H4D
          PRINT "(Hewlett-Packard DOS)";
        CASE &HFF
          PRINT "(MS-DOS)";
      END SELECT
    END IF

    COLOR bright + red, blue
    LOCATE 10, 21
    IF major > 4 OR drdos > &H65 THEN    'check for DOS 5.0+ or DR-DOS 6.0+
      IF chkDosHigh THEN                 'see if DOS is loaded in high memory
        PRINT "High";
      ELSE
        PRINT "Low";
      END IF
    ELSE
      PRINT "Low";
    END IF
      LOCATE 7, 75
    IF chkAnsi THEN                      'check for ANSI.SYS
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 8, 75
    IF chkAppend THEN                    'check for APPEND.EXE
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 9, 75
    IF chkAssign THEN                    'check for ASSIGN.COM
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 10, 75
    IF chkDisplay THEN                   'check for DISPLAY.SYS
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 11, 75
    IF chkDoskey THEN                    'check for DOSKEY.COM
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 12, 75
    IF chkDriver THEN                    'check for DRIVER.SYS
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 13, 75
    IF chkEGA THEN                       'check for EGA.SYS
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 14, 75
    IF chkGraftabl THEN                  'check for GRAFTBL.COM
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 15, 75
    IF chkGraphics THEN                  'check for GRAPHICS.COM
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 16, 75
    IF chkKeyb THEN                      'check for KEYB.COM
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 17, 75
    IF chkNlsfunc THEN                   'check for NLSFUNC.EXE
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 18, 75
    IF chkPrint THEN                     'check for PRINT.COM
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 19, 75
    IF chkShare THEN                     'check for SHARE.EXE
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 20, 75
    IF chkShellb THEN                    'check for SHELLB.COM
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
    LOCATE 21, 75
    IF chkXMA2EMS THEN                   'check for XMA2EMS.SYS
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    a$ = INPUT$(1)                       'wait for keystroke

'   ************************************************************************
'   *                   Display Mouse Information Screen                   *
'   ************************************************************************

    COLOR yellow, blue                   'yellow on blue
    CLS 2                                'clear screen

    PRINT
    PRINT "                                      Mouse                                     ";
    PRINT "                                                                                ";
    PRINT "                                                                                ";
    PRINT "                                                                                ";
    PRINT "                        Mouse Installed   :                                     ";
    PRINT "                        Mouse Type        :                                     ";
    PRINT "                        Driver Version    :                                     ";
    PRINT "                        Number of Buttons :                                     ";
    PRINT "                        Mouse IRQ         :                                     ";

    COLOR white + bright, blue           'bright white on blue

    buttons = chkMouse                   'check for mouse and get buttons

    IF buttons THEN
      COLOR bright + red, blue
      LOCATE 10, 45
      PRINT "yes";
      COLOR bright + white, blue
      LOCATE 11, 45
      getMouseI MouseType, irq           'get mouse information
      SELECT CASE MouseType
        CASE 1
          PRINT "Bus Mouse";
        CASE 2
          PRINT "Serial Mouse";
        CASE 3
          PRINT "Inport Mouse";
        CASE 4
          PRINT "PS/2 Mouse";
        CASE 5
          PRINT "Hewlett-Packard Mouse";
      END SELECT
      IF MouseType = 4 THEN              'display mouse IRQ
        LOCATE 14, 45
        PRINT "PS/2 Port";
      ELSE
        LOCATE 14, 44
        PRINT irq;
      END IF
      getMouseV major, minor             'get mouse driver version
      LOCATE 12, 45
      PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2)
      LOCATE 13, 44
      PRINT buttons;
    ELSE
      COLOR bright + red, blue
      LOCATE 10, 45
      PRINT "no";
      COLOR bright + white, blue
    END IF

    a$ = INPUT$(1)                       'wait for keystroke

'   ************************************************************************
'   *                  Display Shell Information Screen                    *
'   ************************************************************************

    COLOR yellow, blue                   'yellow on blue
    CLS 2                                'clear screen

    PRINT
    PRINT "                            TSR's, Drivers and Shells                           ";
    PRINT "                                                                                ";
    PRINT "   Windows Resident   :                        Smartdrv Installed     :         ";
    PRINT "   Windows Version    :                        PC-Cache Installed     :         ";
    PRINT "   Windows Mode       :                        PC-Kwik Installed      :         ";
    PRINT "                                               Ncache Installed       :         ";
    PRINT "   DESQview Resident  :                        HyperDisk Installed    :         ";
    PRINT "   DESQview Version   :                                                         ";
    PRINT "                                               DoubleSpace Installed  :         ";
    PRINT "   DOS Shell Resident :                        Spacemanager Installed :         ";
    PRINT "   CPTask Resident    :                        Stacker Installed      :         ";
    PRINT "   Taskmax Resident   :                                                         ";
    PRINT "                                               MSCDEX Installed       :         ";
    PRINT "                                               MSCDEX Version         :         ";

    COLOR bright + red, blue

    LOCATE 8, 25
    IF getWinV(major, minor, mode) THEN  'check for Windows
      PRINT "yes";
      COLOR bright + white, blue
      LOCATE 9, 25
      PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2)
      LOCATE 10, 25
      IF mode THEN                       'display Windows mode
        PRINT "Enhanced";
      ELSE
        PRINT "Standard";
      END IF
      COLOR bright + red, blue
    ELSE
      PRINT "no";
    END IF

    LOCATE 12, 25
    IF getDESQv(major, minor) THEN       'check for DESQview
      PRINT "yes";
      COLOR bright + white, blue
      LOCATE 13, 25
      PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2)
      COLOR bright + red, blue
    ELSE
      PRINT "no";
    END IF

    LOCATE 15, 25
    IF DosShell THEN                     'check for Microsoft DOS Shell
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    LOCATE 16, 25
    IF CPTask THEN                       'check for PCTools CPTask
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    LOCATE 17, 25
    IF TaskMax THEN                      'check for DR-DOS TaskMax
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    LOCATE 8, 73
    IF SmartDrv THEN                     'check for Microsoft SmartDrv
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    LOCATE 9, 73
    IF PcCache THEN                      'check for PCTools PC-Cache
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    LOCATE 10, 73
    IF PcKwik THEN                       'check for PC-Kwik
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    LOCATE 11, 73
    IF Ncache THEN                       'check for Norton Ncache
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    LOCATE 12, 73
    IF HyperDisk THEN                    'check for HyperDisk
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    dblspc = DblSpace                    'check for MS-DOS 6 DoubleSpace
    LOCATE 14, 73
    IF dblspc THEN
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    LOCATE 15, 73
    IF Spaceman THEN                     'check for Spacemanager
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    stack = Stacker                      'check for Stacker
    LOCATE 16, 73
    IF stack THEN
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    cdext = MSCDEX(major, minor)         'check for CD-ROM extension
    LOCATE 18, 73
    IF cdext THEN
      PRINT "yes";
      COLOR bright + white, blue
      LOCATE 19, 73
      PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2)
    ELSE
      PRINT "no";
    END IF

    a$ = INPUT$(1)                       'wait for keystroke

'   ************************************************************************
'   *                  Display Drives Information Screen                   *
'   ************************************************************************

    COLOR yellow, blue                   'yellow on blue
    CLS 2                                'clear screen

    PRINT
    PRINT "                                      Drives                                    ";
    PRINT "  Drive     Type                                     Free Space    Total Space  ";
    PRINT "               ";

    COLOR bright + white, blue

    x = 5
    y = 9

    IF getFlopType(a, b) = 0 THEN        'get floppy drive type
      LOCATE y, x
      SELECT CASE a
        CASE 1
          PRINT "A:";
          LOCATE y, x + 8
          PRINT "Floppy Drive, 5 360K DD";
          y = y + 1
        CASE 2
          PRINT "A:";
          LOCATE y, x + 8
          PRINT "Floppy Drive, 5 1.2M HD";
          y = y + 1
        CASE 3
          PRINT "A:";
          LOCATE y, x + 8
          PRINT "Floppy Drive, 3 720K DD";
          y = y + 1
        CASE 4
          PRINT "A:"
          LOCATE y, x + 8
          PRINT "Floppy Drive, 3 1.44M HD"
          y = y + 1
        CASE 5
          PRINT "A:"
          LOCATE y, x + 8
          PRINT "Floppy Drive, 3 2.88M ED"
          y = y + 1
        CASE ELSE
      END SELECT
      LOCATE y, x
      SELECT CASE b
        CASE 1
          PRINT "B:";
          LOCATE y, x + 8
          PRINT "Floppy Drive, 5 360K DD";
          y = y + 1
        CASE 2
          PRINT "B:";
          LOCATE y, x + 8
          PRINT "Floppy Drive, 5 1.2M HD";
          y = y + 1
        CASE 3
          PRINT "B:";
          LOCATE y, x + 8
          PRINT "Floppy Drive, 3 720K DD";
          y = y + 1
        CASE 4
          PRINT "B:"
          LOCATE y, x + 8
          PRINT "Floppy Drive, 3 1.44M HD"
          y = y + 1
        CASE 5
          PRINT "B:"
          LOCATE y, x + 8
          PRINT "Floppy Drive, 3 2.88M ED"
          y = y + 1
        CASE ELSE
      END SELECT
    END IF

    num = 3                              'starting drive
    lastdrive = getAvailDrvs             'get lastdrive

drvinfo:

    IF num <= lastdrive AND num <= 26 AND y <= 21 THEN
      code = num + 64                    'convert to ASCII
      drive$ = CHR$(code)
      IF isCDROM(drive$) THEN            'check for CD-ROM drive
        LOCATE y, x
        PRINT drive$ + ":";
        LOCATE y, x + 8
        PRINT "CD-ROM Drive";
        y = y + 1
        num = num + 1
        GOTO drvinfo
      END IF
      IF dblspc THEN                     'check for DblSpace drive
        IF isDblSpace(drive$) THEN
          LOCATE y, x
          PRINT drive$ + ":";
          LOCATE y, x + 8
          PRINT "DblSpace Drive";
          IF getDrvSpace(drive$, SecPerClus&, FreeClus&, BytesPerSec&, TotalClus&) = 0 THEN
            ClusSize& = BytesPerSec& * SecPerClus&          'calc. cluster size
            FreeSpace& = (FreeClus& * ClusSize&) / 1024000  'calc. available space
            TotalSpace& = TotalClus& * ClusSize& / 1024000  'calc. total space
            LOCATE y, x + 51
            PRINT USING "##,###_M"; FreeSpace&
            LOCATE y, x + 66
            PRINT USING "##,###_M"; TotalSpace&
          END IF
          y = y + 1
          num = num + 1
          GOTO drvinfo
        END IF
      END IF
      IF stack THEN                      'check for Stacker drive
        IF isStacker(drive$) THEN
          LOCATE y, x
          PRINT drive$ + ":";
          LOCATE y, x + 8
          PRINT "Stacker Drive";
          IF getDrvSpace(drive$, SecPerClus&, FreeClus&, BytesPerSec&, TotalClus&) = 0 THEN
            ClusSize& = BytesPerSec& * SecPerClus&          'calc. cluster size
            FreeSpace& = (FreeClus& * ClusSize&) / 1024000  'calc. available space
            TotalSpace& = TotalClus& * ClusSize& / 1024000  'calc. total space
            LOCATE y, x + 51
            PRINT USING "##,###_M"; FreeSpace&
            LOCATE y, x + 66
            PRINT USING "##,###_M"; TotalSpace&
          END IF
          y = y + 1
          num = num + 1
          GOTO drvinfo
        END IF
      END IF
      IF chkRemovable(drive$, removable) = 0 THEN  'check for fixed disk
        IF removable THEN
          LOCATE y, x
          PRINT drive$ + ":";
          LOCATE y, x + 8
          PRINT "Fixed Disk";
          IF getDrvSpace(drive$, SecPerClus&, FreeClus&, BytesPerSec&, TotalClus&) = 0 THEN
            ClusSize& = BytesPerSec& * SecPerClus&          'calc. cluster size
            FreeSpace& = (FreeClus& * ClusSize&) / 1024000  'calc. available space
            TotalSpace& = TotalClus& * ClusSize& / 1024000  'calc. total space
            LOCATE y, x + 51
            PRINT USING "##,###_M"; FreeSpace&
            LOCATE y, x + 66
            PRINT USING "##,###_M"; TotalSpace&
          END IF
          IF getDrvInfo(drive$, cyl, heads, sectors) = 0 THEN 'get fixed disk info
            y = y + 1
            LOCATE y, x + 9
            PRINT heads; "Heads,"; cyl; "Cylinders,"; sectors; "Sec/Track";
          END IF
          y = y + 1
          num = num + 1
          GOTO drvinfo
        ELSE
          LOCATE y, x
          PRINT drive$ + ":";
          LOCATE y, x + 8
          PRINT "Removable";
          y = y + 1
          num = num + 1
          GOTO drvinfo
        END IF
      END IF
      IF chkRemote(drive$, remote) = 0 THEN  'check for network drive
        IF remote THEN
          LOCATE y, x
          PRINT drive$ + ":";
          LOCATE y, x + 8
          PRINT "Remote Drive";
          IF getDrvSpace(drive$, SecPerClus&, FreeClus&, BytesPerSec&, TotalClus&) = 0 THEN
            ClusSize& = BytesPerSec& * SecPerClus&          'calc. cluster size
            FreeSpace& = (FreeClus& * ClusSize&) / 1024000  'calc. available space
            TotalSpace& = TotalClus& * ClusSize& / 1024000  'calc. total space
            LOCATE y, x + 51
            PRINT USING "##,###_M"; FreeSpace&
            LOCATE y, x + 66
            PRINT USING "##,###_M"; TotalSpace&
          END IF
          y = y + 1
        END IF
      END IF
      num = num + 1
      GOTO drvinfo
    END IF

    a$ = INPUT$(1)                       'wait for keystroke

    IF num <= lastdrive AND num <= 26 THEN  'see if a second page is needed
      y = 9                                 'reset y-axis
      COLOR yellow, blue                   'yellow on blue
      CLS 2                                'clear screen
      PRINT
      PRINT "                                      Drives                                    ";
      PRINT "  Drive     Type                                     Free Space    Total Space  ";
      PRINT "               ";
      COLOR white + bright, blue            'bright white on blue
      GOTO drvinfo                          'display remaining drive info
    END IF

'   ************************************************************************
'   *                  Display Network Information Screen                  *
'   ************************************************************************/

    COLOR yellow, blue                   'yellow on blue
    CLS 2                                'clear screen

    PRINT
    PRINT "                                     Network                                    ";
    PRINT "                                                                                ";
    PRINT "   IPX Installed      :                 Number of Connections Supported :       ";
    PRINT "                                        Number of Connections in Use    :       ";
    PRINT "   Netbios Installed  :                 Peak Connections Used           :       ";
    PRINT "                                        Maximum Connected Volumes       :       ";
    PRINT "   Shell Installed    :                                                         ";
    PRINT "   Shell Version      :                                                         ";
    PRINT "   Shell Located in   :                                                         ";
    PRINT "                                                                                ";
    PRINT "   Server Name        :                                                         ";
    PRINT "   Netware Version    :                                                         ";
    PRINT "                                                                                ";
    PRINT "   Login Date & Time  :                                                         ";
 
    COLOR bright + red, blue

    LOCATE 8, 25
    IF chkIPX THEN                       'check for IPX
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF

    LOCATE 10, 25
    IF Netbios THEN                      'check for Netbios
      PRINT "yes";
    ELSE
      PRINT "no";
    END IF
  
    LOCATE 12, 25
    IF NetShell(major, minor, rev, mem) THEN 'check for NetShell
      PRINT "yes";
      COLOR white + bright, blue
      LOCATE 13, 25
      PRINT LTRIM$(STR$(major)) + "." + RIGHT$("0" + LTRIM$(STR$(minor)), 2) + "." + RIGHT$("0" + LTRIM$(STR$(rev)), 2);
      LOCATE 14, 25
      SELECT CASE mem                    'display memory type
        CASE 0
          PRINT "Conventional Memory";
        CASE 1
          PRINT "Expanded Memory";
        CASE 2
          PRINT "Extended Memory";
        CASE ELSE
          PRINT "Unknown";
      END SELECT

      server$ = getNetName(version, subver, conn, use, vol, peak) 'get server info
      LOCATE 16, 25
      PRINT server$;                     'display network server name
      LOCATE 17, 25
      PRINT LTRIM$(STR$(version)) + "." + RIGHT$("0" + LTRIM$(STR$(subver)), 2);
      LOCATE 8, 74
      PRINT conn;                        'display number of connections
      LOCATE 9, 74
      PRINT use;                         'display connections in use
      LOCATE 10, 74
      PRINT peak;                        'display peak connections used
      LOCATE 11, 74
      PRINT vol;                         'display number of volumes supported
      IF getLoginTime(year, month, day, hour, min, sec, week) = 0 THEN
        LOCATE 19, 25
        year$ = RIGHT$("0" + MID$(STR$(year), 2), 2)
        month$ = RIGHT$("0" + MID$(STR$(month), 2), 2)
        day$ = RIGHT$("0" + MID$(STR$(day), 2), 2)
        hour$ = RIGHT$("0" + MID$(STR$(hour), 2), 2)
        min$ = RIGHT$("0" + MID$(STR$(min), 2), 2)
        sec$ = RIGHT$("0" + MID$(STR$(sec), 2), 2)
        PRINT month$ + "-" + day$ + "-" + year$ + " at " + hour$ + ":" + min$ + ":" + sec$
      END IF
    ELSE
      PRINT "no";
    END IF

    a$ = INPUT$(1)                       'wait for keystroke
    COLOR white, black                   'white on black
    VIEW PRINT 1 TO 25                   'reset screen size
    CLS                                  'clear screen
    END


