;
;
; Triangle code and Glenz Vector coded by:
;
;
; Written by: John McCarthy (aka Flynn)
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;
; Home phone,(905)831-1944, always willing to talk but don't call at 2 am eh!
;
; Send me a postcard from someplace near where you live.
;
;

         .386p

include  struc.inc

DGROUP   GROUP _TEXT
_TEXT    SEGMENT PARA PUBLIC 'CODE'
         ASSUME CS:_TEXT,DS:DGROUP,ES:DGROUP

         public flat_triangle_
         public flat_polygon_
         public glenz_triangle_

         extrn _virtual_video_tables:dword
         extrn _virtual_video_width:dword

;
; Triangle slopes/lengths (used by all routines)
;

_l0      dd 0
_l1      dd 0
_l2      dd 0
_s0      dd 0
_s1      dd 0
_s2      dd 0
_coarse_position_step dd 0

;
; Flat Shaded Triangle:
;
; In:
;  ESI = pointer to vertex 1 structure
;  EDI = pointer to vertex 2 structure
;  EBX = pointer to vertex 3 structure
;   DL = colour to plot
; Out:
;  EBP = EBP
;  _colour = saved colour
;
; flat_triangle(struct vertex *v1,
;               struct vertex *v2,
;               struct vertex *v3,
;               char colour);
;
;

_colour  dw 0

flat_triangle_:
         push ebp
         mov dh,dl
         mov word ptr _colour,dx

         xor eax,eax
         xor ecx,ecx
         xor ebp,ebp
         mov ax,word ptr [esi].vtx_y2d + 2
         mov bp,word ptr [edi].vtx_y2d + 2
         mov cx,word ptr [ebx].vtx_y2d + 2

         cmp eax,ebp
         jl short ff_test_next_0
         je short ff_test_x1

         xchg esi,edi
         cmp ebp,ecx
         jl short ff_done_test
         je short ff_test_x2

         xchg esi,ebx
         jmp short ff_done_test

ff_test_next_0:
         cmp eax,ecx
         jl short ff_done_test
         je short ff_test_x2

         xchg esi,ebx
         jmp short ff_done_test

ff_test_x1:
         cmp eax,ecx
         jge short ff_flip_y2

         mov ax,word ptr [esi].vtx_x2d + 2
         cmp ax,word ptr [edi].vtx_x2d + 2
         jge short ff_done_test

         xchg esi,edi
         jmp short ff_done_test

ff_test_x2:
         mov ax,word ptr [esi].vtx_x2d + 2
         cmp ax,word ptr [ebx].vtx_x2d + 2
         jge short ff_done_test

ff_flip_y2:
         xchg esi,ebx

ff_done_test:
         mov bp,word ptr [ebx].vtx_y2d + 2  ; find length of long side
         sub bp,word ptr [esi].vtx_y2d + 2  ; _l1, length 0-2
         movsx ebp,bp
         mov _l1,ebp
         jz short ff_dont_calculate_s1

         mov eax,[ebx].vtx_x2d              ; find slope of 0-2
         sub eax,[esi].vtx_x2d
         cdq
         idiv ebp
         mov _s1,eax
ff_dont_calculate_s1:

         mov bp,word ptr [ebx].vtx_y2d + 2
         sub bp,word ptr [edi].vtx_y2d + 2
         movsx ebp,bp
         mov _l2,ebp                        ; result length 1-2
         jz short ff_handle_flatbottom      ; test if flatbottom (avoid divide by 0)

         mov eax,[ebx].vtx_x2d              ; find slope of top 1-2
         sub eax,[edi].vtx_x2d
         cdq
         idiv ebp
         mov _s2,eax
ff_handle_flatbottom:

         mov cx,word ptr [edi].vtx_y2d + 2  ; find length of 0-1 (first short side)
         sub cx,word ptr [esi].vtx_y2d + 2  ; ecx = _l0 from 0-1
         movsx ecx,cx
         mov _l0,ecx
         jz short ff_is_flattop

         mov eax,[edi].vtx_x2d              ; find slope of 0-1
         sub eax,[esi].vtx_x2d
         cdq
         idiv ecx
         mov _s0,eax
         mov edx,eax
ff_is_flattop:
         or ecx,ecx                         ; test if v0-v1 = 0
         jz ff_handle_flattop_0
         cmp _l1,0
         je ff_handle_flattop_1

         mov edi,[esi].vtx_y2d              ; calculate start edi (from vertex 0)
         shr edi,16
         mov eax,_virtual_video_tables
         mov edi,[edi*4+eax]
         mov ebx,[esi].vtx_x2d
         shr ebx,16
         add edi,ebx

         mov ebx,_l1
         mov eax,_s1
         cmp edx,eax
         jle short ff_ok_orientation

         neg _l2
         xchg edx,eax
         xchg ecx,ebx
         or ebp,ebp                         ; test if _l2 > 0
         jg ff_type_b
         mov _s1,eax
         xor ebp,ebp

ff_ok_orientation:
         or ebp,ebp                         ; test if _l2 < 0
         jl ff_type_b

         mov ebx,[esi].vtx_x2d
         shl ebx,16

         mov ebp,edx                        ; get position slope
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s1-s0
         mov esi,eax                        ; eax = slope1 - slope0
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,bx                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx
         mov edx,ebx

         mov ax,_colour
         call [ff_loop_offsets+ecx*4]
         push eax edi edx ebx
         mov eax,_s1
         mov edx,_s2                        ; get next position slope
         mov ebp,edx
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s2-s1
         mov esi,eax                        ; eax = slope2 - slope1
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,cx                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx

         pop ebx edx edi eax
         mov ecx,_l2
         call [ff_loop_offsets+ecx*4]
         pop ebp                            ; shitty C calling can't preserve ebp
         ret

ff_type_b:
         mov _s0,edx
         mov ecx,ebx
         mov ebx,[esi].vtx_x2d
         shl ebx,16
         mov ebp,edx                        ; get position slope
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s1-s0
         mov esi,eax                        ; eax = slope1 - slope0
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,bx                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx
         mov edx,ebx

         mov ax,_colour
         call [ff_loop_offsets+ecx*4]
         push eax edx
         mov eax,_s2
         mov edx,_s0                        ; get next position slope
         sub eax,edx                        ; calculate length slope from s2-s1
         mov esi,eax                        ; eax = slope2 - slope1
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,cx                          ; add bp,0
         shl esi,16                         ; fine length step
         pop edx eax
         mov ecx,_l2
         neg ecx
         call [ff_loop_offsets+ecx*4]
         pop ebp                            ; shitty C calling can't preserve ebp
         ret

ff_handle_flattop_1:
         mov edi,ebx
         mov _s1,eax
         neg ebp

ff_handle_flattop_0:
         mov ecx,ebp
         or ecx,ecx
         jz short ff_flat_line              ; handle flat line.
         mov eax,[edi].vtx_y2d              ; calculate start edi (from vertex 1)
         shr eax,16
         mov ebx,_virtual_video_tables
         mov eax,[eax*4+ebx]
         mov ebx,[edi].vtx_x2d
         shr ebx,16
         add eax,ebx

         mov bx,word ptr [esi].vtx_x2d + 2          ; calculate start length for flattop
         sub bx,word ptr [edi].vtx_x2d + 2
         push bx
         mov edi,eax

         mov ebx,[esi].vtx_x2d
         shl ebx,16
         mov eax,_s1
         mov edx,_s2                        ; get next position slope
         mov ebp,edx
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s2-s1
         mov esi,eax                        ; eax = slope2 - slope1
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,bx                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx

         mov edx,ebx
         pop bx
         mov ax,_colour
         call [ff_loop_offsets+ecx*4]
         pop ebp                            ; shitty C calling can't preserve ebp
         ret

ff_flat_line:
         mov edx,[esi].vtx_x2d              ; handle single flat line
         mov ebp,[edi].vtx_x2d
         mov ecx,[ebx].vtx_x2d
         shr edx,16
         shr ebp,16
         shr ecx,16

         cmp edx,ebp
         jg short ff_flat_t3

         cmp edx,ecx
         jg short ff_flat_t2

         cmp ebp,ecx
         jng short ff_flat_t1
         mov ecx,ebp

ff_flat_t1:
         mov edi,[esi].vtx_y2d              ; calculate start edi (from vertex 0)
         shr edi,16
         mov eax,_virtual_video_tables
         mov edi,[edi*4+eax]
         add edi,edx                        ; esi = start vertex, edx = start x
         sub ecx,edx                        ; ecx = end x
         inc ecx
         mov ax,_colour
         shr ecx,1
         rep stosw
         adc cl,ch
         rep stosb

         pop ebp
         ret

ff_flat_t2:
         mov edx,ecx
         mov ecx,ebp
         mov esi,ebx
         jmp short ff_flat_t1

ff_flat_t3:
         cmp edx,ecx
         jg short ff_flat_t4

         mov edx,ebp
         mov esi,edi
         jmp short ff_flat_t1

ff_flat_t4:
         xchg ecx,edx
         mov esi,ebx
         cmp ebp,edx
         jg short ff_flat_t1
         mov edx,ebp
         mov esi,edi
         jmp short ff_flat_t1

;
;
;Unrolled Flat Fill:
;
; ecx = length
; edi = location
; ah = al = colour
;
; high esi = fine length step,   high edx = fine length count
; high ebp = fine position step, high ebx = fine position count
; low  ebp = coarse length step, low  ebx = length
;
; Aren't unrolled loops great!
;
; Loop is 28 bytes long, so every unrolled section is always aligned!
;
;

         align 4

ff_unrolled_loop:
         rept y_max
         push edi
         mov cx,bx

         shr ecx,1
         rep stosw
         adc cl,ch
         rep stosb

         pop edi
         add edx,esi                        ; high esi = fine length step,   high edx = fine length count
         adc ebx,ebp                        ; high ebp = fine position step, high ebx = fine position count
                                            ; low ebp = coarse length step, low ebx = length
         adc cl,cl
         add edi,_coarse_position_step
         adc edi,ecx
         sub ebx,ecx                        ; ecx = 0 after rep instruction
         endm
ff_unrolled_end:
         xor cl,cl
         ret

ff_loop_offsets label dword
         i = y_max
         rept y_max + 1
         dd offset ff_unrolled_loop + i * (ff_unrolled_end - ff_unrolled_loop)/y_max
         i = i - 1
         endm

;
;
; Glenz Triangle:
;
; In:
;  ESI = pointer to vertex 1 structure
;  EDI = pointer to vertex 2 structure
;  EBX = pointer to vertex 3 structure
;  EDX = cross referancing tables ( must be aligned on 256 byte boundary! )
; Out:
;  EBP = EBP
;  _xreftable = cross referancing tables
;
; glenz_triangle(struct vertex *v1,
;                struct vertex *v2,
;                struct vertex *v3,
;                char *xreftable);
;
;

_xreftables dd 0

glenz_triangle_:
         push ebp
         mov _xreftables,edx

         xor eax,eax
         xor ecx,ecx
         xor ebp,ebp
         mov ax,word ptr [esi].vtx_y2d + 2
         mov bp,word ptr [edi].vtx_y2d + 2
         mov cx,word ptr [ebx].vtx_y2d + 2

         cmp eax,ebp
         jl short gt_test_next_0
         je short gt_test_x1

         xchg esi,edi
         cmp ebp,ecx
         jl short gt_done_test
         je short gt_test_x2

         xchg esi,ebx
         jmp short gt_done_test

gt_test_next_0:
         cmp eax,ecx
         jl short gt_done_test
         je short gt_test_x2

         xchg esi,ebx
         jmp short gt_done_test

gt_test_x1:
         cmp eax,ecx
         jge short gt_flip_y2

         mov ax,word ptr [esi].vtx_x2d + 2
         cmp ax,word ptr [edi].vtx_x2d + 2
         jge short gt_done_test

         xchg esi,edi
         jmp short gt_done_test

gt_test_x2:
         mov ax,word ptr [esi].vtx_x2d + 2
         cmp ax,word ptr [ebx].vtx_x2d + 2
         jge short gt_done_test

gt_flip_y2:
         xchg esi,ebx

gt_done_test:
         mov bp,word ptr [ebx].vtx_y2d + 2  ; find length of long side
         sub bp,word ptr [esi].vtx_y2d + 2  ; _l1, length 0-2
         movsx ebp,bp
         mov _l1,ebp
         jz short gt_dont_calculate_s1

         mov eax,[ebx].vtx_x2d              ; find slope of 0-2
         sub eax,[esi].vtx_x2d
         cdq
         idiv ebp
         mov _s1,eax
gt_dont_calculate_s1:

         mov bp,word ptr [ebx].vtx_y2d + 2
         sub bp,word ptr [edi].vtx_y2d + 2
         movsx ebp,bp
         mov _l2,ebp                        ; result length 1-2
         jz short gt_handle_flatbottom      ; test if flatbottom (avoid divide by 0)

         mov eax,[ebx].vtx_x2d              ; find slope of top 1-2
         sub eax,[edi].vtx_x2d
         cdq
         idiv ebp
         mov _s2,eax
gt_handle_flatbottom:

         mov cx,word ptr [edi].vtx_y2d + 2  ; find length of 0-1 (first short side)
         sub cx,word ptr [esi].vtx_y2d + 2  ; ecx = _l0 from 0-1
         movsx ecx,cx
         mov _l0,ecx
         jz short gt_is_flattop

         mov eax,[edi].vtx_x2d              ; find slope of 0-1
         sub eax,[esi].vtx_x2d
         cdq
         idiv ecx
         mov _s0,eax
         mov edx,eax
gt_is_flattop:
         or ecx,ecx                         ; test if 0-1 = 0
         jz gt_handle_flattop_0
         cmp _l1,0
         je gt_handle_flattop_1

         mov edi,[esi].vtx_y2d              ; calculate start edi (from vertex 0)
         shr edi,16
         mov eax,_virtual_video_tables
         mov edi,[edi*4+eax]
         mov ebx,[esi].vtx_x2d
         shr ebx,16
         add edi,ebx

         mov ebx,_l1
         mov eax,_s1
         cmp edx,eax
         jle short gt_ok_orientation

         neg _l2
         xchg edx,eax
         xchg ecx,ebx
         or ebp,ebp                         ; test if _l2 > 0
         jg gt_type_b
         mov _s1,eax
         xor ebp,ebp

gt_ok_orientation:
         or ebp,ebp                         ; test if _l2 < 0
         jl gt_type_b

         mov ebx,[esi].vtx_x2d
         shl ebx,16

         mov ebp,edx                        ; get position slope
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s1-s0
         mov esi,eax                        ; eax = slope1 - slope0
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,bx                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx
         mov edx,ebx

         mov eax,_xreftables
         call [gt_loop_offsets+ecx*4]
         push edi edx ebx
         mov eax,_s1
         mov edx,_s2                        ; get next position slope
         mov ebp,edx
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s2-s1
         mov esi,eax                        ; eax = slope2 - slope1
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,cx                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx

         pop ebx edx edi
         mov ecx,_l2
         mov eax,_xreftables
         call [gt_loop_offsets+ecx*4]
         pop ebp                            ; shitty C calling can't preserve ebp
         ret

gt_type_b:
         mov _s0,edx
         mov ecx,ebx
         mov ebx,[esi].vtx_x2d
         shl ebx,16
         mov ebp,edx                        ; get position slope
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s1-s0
         mov esi,eax                        ; eax = slope1 - slope0
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,bx                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx
         mov edx,ebx

         mov eax,_xreftables
         call [gt_loop_offsets+ecx*4]
         push edx
         mov eax,_s2
         mov edx,_s0                        ; get next position slope
         sub eax,edx                        ; calculate length slope from s2-s1
         mov esi,eax                        ; eax = slope2 - slope1
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,cx                          ; add bp,0
         shl esi,16                         ; fine length step
         pop edx
         mov ecx,_l2
         neg ecx
         mov eax,_xreftables
         call [gt_loop_offsets+ecx*4]
         pop ebp                            ; shitty C calling can't preserve ebp
         ret

gt_handle_flattop_1:
         mov edi,ebx
         mov _s1,eax
         neg ebp

gt_handle_flattop_0:
         mov ecx,ebp
         or ecx,ecx
         jz short gt_flat_line              ; handle flat line.
         mov eax,[edi].vtx_y2d              ; calculate start edi (from vertex 1)
         shr eax,16
         mov ebx,_virtual_video_tables
         mov eax,[eax*4+ebx]
         mov ebx,[edi].vtx_x2d
         shr ebx,16
         add eax,ebx

         mov bx,word ptr [esi].vtx_x2d + 2          ; calculate start length for flattop
         sub bx,word ptr [edi].vtx_x2d + 2
         push bx
         mov edi,eax

         mov ebx,[esi].vtx_x2d
         shl ebx,16
         mov eax,_s1
         mov edx,_s2                        ; get next position slope
         mov ebp,edx
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s2-s1
         mov esi,eax                        ; eax = slope2 - slope1
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,bx                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx

         mov edx,ebx
         pop bx
         mov eax,_xreftables
         call [gt_loop_offsets+ecx*4]
         pop ebp                            ; shitty C calling can't preserve ebp
         ret

gt_flat_line:
         mov edx,[esi].vtx_x2d              ; handle single flat line
         mov ebp,[edi].vtx_x2d
         mov ecx,[ebx].vtx_x2d
         shr edx,16
         shr ebp,16
         shr ecx,16

         cmp edx,ebp
         jg short gt_flat_t3

         cmp edx,ecx
         jg short gt_flat_t2

         cmp ebp,ecx
         jng short gt_flat_t1
         mov ecx,ebp

gt_flat_t1:
         mov edi,[esi].vtx_y2d              ; calculate start edi (from vertex 0)
         shr edi,16
         mov eax,_virtual_video_tables
         mov edi,[edi*4+eax]
         add edi,edx                        ; esi = start vertex, edx = start x
         sub ecx,edx                        ; ecx = end x
         inc ecx

         mov eax,_xreftables
         call [gt_glenz_offsets + ecx * 4]  ; edi = position, eax = xref tables, ecx = length

         pop ebp
         ret

gt_flat_t2:
         mov edx,ecx
         mov ecx,ebp
         mov esi,ebx
         jmp short gt_flat_t1

gt_flat_t3:
         cmp edx,ecx
         jg short gt_flat_t4

         mov edx,ebp
         mov esi,edi
         jmp short gt_flat_t1

gt_flat_t4:
         xchg ecx,edx
         mov esi,ebx
         cmp ebp,edx
         jg short gt_flat_t1
         mov edx,ebp
         mov esi,edi
         jmp short gt_flat_t1

;
;
; Unrolled Glenz Fill:
;
; ecx = length
; edi = location
; eax = cross referancing tables (must be 256 byte aligned)
;
; high esi = fine length step,   high edx = fine length count
; high ebp = fine position step, high ebx = fine position count
; low  ebp = coarse length step, low  ebx = length
;
;    mov al,[edi]  ; get pixel
;    mov al,[eax]  ; xref it
;    stosb         ; store it
;
; Scan converter is unrolled by y width (semi-important)
; Glenz pixel is unrolled by x width (really important)
;
;

gt_unrolled_loop:
         rept y_max
         push edi
         mov cx,bx

         call [gt_glenz_offsets + ecx * 4]  ; edi = position, eax = xref tables, ecx = length

         xor ecx,ecx
         pop edi
         add edx,esi
         adc ebx,ebp
         adc cl,cl
         add edi,_coarse_position_step
         adc edi,ecx
         sub ebx,ecx
         endm
gt_unrolled_end:
         xor cl,cl
         ret

gt_loop_offsets label dword
         i = y_max
         rept y_max + 1
         dd offset gt_unrolled_loop + i * (gt_unrolled_end - gt_unrolled_loop)/y_max
         i = i - 1
         endm

gt_unrolled_glenz:
         rept x_max
         mov al,[edi]                       ; hmmm I guess this can't get much faster...
         mov al,[eax]                       ; eax => glenz table
         stosb
         endm
gt_unrolled_glenz_end:
         ret

         align 4

gt_glenz_offsets label dword
         i = x_max
         rept x_max + 1
         dd offset gt_unrolled_glenz + i * (gt_unrolled_glenz_end - gt_unrolled_glenz)/x_max
         i = i - 1
         endm

;
; Flat_Polygon:
; In:
;  ESI => pointer to polygon struture
;   DL =  colour
;

flat_polygon_:
         push ebp
         mov ebp,[esi].pg_vertex_count
         sub ebp,2
         mov ecx,[esi].pg_poly_list
         mov esi,[ecx].pc_this_vertex
         mov eax,[ecx].pc_next_link
         mov edi,[eax].pc_this_vertex
fp_polyloop:
         mov eax,[eax].pc_next_link
         mov ebx,[eax].pc_this_vertex
         push eax ecx ebx esi
         call flat_triangle_
         pop edi ebx ecx eax
         dec ebp
         jz short fp_outahere
         mov dl,byte ptr _colour
         mov ecx,[ecx].pc_previous_link
         mov esi,[ecx].pc_this_vertex
         push eax ecx ebx esi
         call flat_triangle_
         pop esi edi ecx eax
         mov dl,byte ptr _colour
         dec ebp
         jnz short fp_polyloop

fp_outahere:
         pop ebp
         ret

;
; Glenz_Polygon:
; In:
;  ESI => pointer to polygon struture
;  EDX =  cross referancing tables
;

glenz_polygon_:
         push ebp
         mov ebp,[esi].pg_vertex_count
         sub ebp,2
         mov ecx,[esi].pg_poly_list
         mov esi,[ecx].pc_this_vertex
         mov eax,[ecx].pc_next_link
         mov edi,[eax].pc_this_vertex
gp_polyloop:
         mov eax,[eax].pc_next_link
         mov ebx,[eax].pc_this_vertex
         push eax ecx ebx esi
         call glenz_triangle_
         pop edi ebx ecx eax
         dec ebp
         jz short gp_outahere
         mov edx,_xreftables
         mov ecx,[ecx].pc_previous_link
         mov esi,[ecx].pc_this_vertex
         push eax ecx ebx esi
         call glenz_triangle_
         pop esi edi ecx eax
         mov edx,_xreftables
         dec ebp
         jnz short gp_polyloop

gp_outahere:
         pop ebp
         ret

_TEXT    ends
         end
