DECLARE SUB purge ()
'$DYNAMIC

DEFINT A-Z

CONST BATCH = 200
CONST BENCHTIME = 15

TYPE rd
  pname AS STRING * 20
  amount AS DOUBLE
  code AS INTEGER
END TYPE

TYPE dbrec
  pname AS STRING * 20
  amount AS DOUBLE
END TYPE

DECLARE SUB dump ()
DECLARE SUB xupdate (datastream() AS rd)

DIM SHARED database(0) as dbrec
'backup array needed because REDIM wipes out your data
DIM SHARED database2(0) as dbrec

CONST INPUTSIZE = 30

REM update commands
CONST NEW = 1      ' add a new account
CONST UPDATE = 2   ' add/substract from their account
CONST DELETE = 3   ' delete someone's account

DIM SHARED rawdata(INPUTSIZE) AS rd
DATA "George Bush", 1000, 1
DATA "Bill Clinton", 2000, 1
DATA "Brian Mulroney", 500, 1
DATA "Ross Perot", 10000, 1
DATA "Ross Perot", 0, 3
DATA "George Bush", -30.55, 2
DATA "Madonna", 2500, 1
DATA "Boris Yeltsin", 100, 1
DATA "Michael Jackson", 50, 1
DATA "Peter Mansbridge", 1200, 1
DATA "Bill Clinton", +500, 2
DATA "Rod Stewart", 3000, 1
DATA "Boris Yeltsin", 0, 3
DATA "Sharon Stone", 1500, 1
DATA "Clint Eastwood", 1900, 1
DATA "Madonna", 0, 3
DATA "Sally Jessy Raphael", 750, 1
DATA "Brian Mulroney", -400, 3
DATA "Richard Gere", 299, 1
DATA "Rod Stewart", 0, 3
DATA "Demi Moore", 350, 1
DATA "Bruce Willis", 480, 1
DATA "Sharon Stone", +900.50, 2
DATA "Arsenio Hall", 300, 1
DATA "David Letterman", 450, 1
DATA "Whoopi Goldberg", 1050, 1
DATA "Clint Eastwood", +2500, 2
DATA "Michael Jackson", -50, 2
DATA "Clint Eastwood", 0, 3
DATA "Jack Nicholson", 3000, 1

DIM SHARED size
size = 0  'current database size

FOR i = 0 TO INPUTSIZE - 1
    READ rawdata(i).pname
    READ rawdata(i).amount
    READ rawdata(i).code
NEXT i

PRINT "database benchmark ..."
cycles& = 0
t# = TIMER
WHILE TIMER < t# + BENCHTIME
    FOR b = 1 TO BATCH
        purge
        CALL xupdate(rawdata())
    NEXT b
    cycles& = cycles& + BATCH * INPUTSIZE
WEND
t# = TIMER - t#
PRINT USING "##### transactions per second"; cycles& / t#
dump

SYSTEM

SUB dump
REM used to verify that program works correctly
REM not part of timing loop
    FOR i = 0 TO size - 1
	PRINT database(i).pname, database(i).amount
    NEXT i
END SUB

SUB purge
REM empty the database - free all storage
    size = 0
    REDIM database(0)
    REDIM database2(0)
END SUB

SUB xupdate (datastream() AS rd)
    FOR i = 0 TO INPUTSIZE - 1
	transactioncode = datastream(i).code
	
	IF transactioncode = NEW THEN
	    FOR j = 0 TO size - 1 
	        database2(j) = database(j)
	    NEXT j
	    size = size + 1
	    REDIM database(size)
	    FOR j = 0 TO size - 2
		database(j) = database2(j)
	    NEXT j
	    database(size - 1).pname = datastream(i).pname
	    database(size - 1).amount = datastream(i).amount
	    REDIM database2(size)

	ELSE
	    REM look up name
	    pname$ = datastream(i).pname
	    FOR accountno = 0 TO size - 1
		IF pname$ = database(accountno).pname THEN
		    EXIT FOR
		END IF
	    NEXT accountno

	    IF transactioncode = UPDATE THEN
	        database(accountno).amount = database(accountno).amount + datastream(i).amount

	    ELSE  'DELETE
	    	FOR j = 0 TO size - 1 
	            database2(j) = database(j)
	        NEXT j
	        size = size - 1
	        REDIM database(size)
	        j = 0
	        FOR k = 0 TO accountno - 1
		    database(j) = database2(k)
		    j = j + 1
	        NEXT k
	        FOR k = accountno + 1 TO size
		    database(j) = database2(k)
		    j = j + 1
	        NEXT k
	        REDIM database2(size)
	    END IF
	END IF
    NEXT i
END SUB

