/* Sample CoolWorx Editor */
#include <windows.h>
#include "xeditor.h"
#include "coolworx.h"

HANDLE hInst;
HWND mainw;
HWND editor;

/* Forward reference */
long WINAPI _export win_proc(HWND hWnd, UINT message,
         UINT wParam, LONG lParam);
int init(HANDLE,HANDLE,int);

int PASCAL WinMain(HANDLE hInstance, HANDLE prev,
  LPSTR cmdline, int show)
  {
  HANDLE acc;
  hInst=hInstance;
  cw_BeginIcons(hInst,LoadIcon(hInst,  // start
    MAKEINTRESOURCE(APPICON)),NULL);
  if (!init(hInst,prev,show)) return FALSE;
  acc=LoadAccelerators(hInst,MAKEINTRESOURCE(EMENU));
  cw_Run(mainw,NULL,1,&acc,TRUE);  // event loop
  cw_End(hInst);    // done!
  return FALSE;
  }

/* Create window here */
int init(HANDLE hInstance, HANDLE prev,int nCmdShow)
  {
  HWND hWnd;
  /* Create a main window */
  mainw=hWnd=cw_SDICreate("SDICoolEdit",
    MAKEINTRESOURCE(EMENU),
    hInst,(FARPROC)win_proc,MAKEINTRESOURCE(EMENUBAR),
    NULL,NULL,MAKEINTRESOURCE(STATUS_BAR),0);
  if (!hWnd)
    return FALSE;
/* Make the window visible, update its client area,
   and return "success" */
  if (nCmdShow==SW_SHOWNORMAL)
    ShowWindow(hWnd,nCmdShow);
  UpdateWindow(hWnd);
  return TRUE;
  }



/* Window procedure -- this is ordinary except it
   calls cw_DefWindowProc() */
long WINAPI _export win_proc(HWND hWnd, UINT message,
         UINT wParam, LONG lParam)
  {
  switch (message)
    {
    case WM_SETFOCUS:  // pass focus
     if (editor) SetFocus(editor);
     break;

   case WM_SIZE:   // resize editor
     {
     RECT r;
     /* Don't use passed in size since
     other code calls WM_SIZE with
     no parameters */
     cw_GetClientRect(hWnd,&r);
     MoveWindow(editor,r.left,r.top,r.right-r.left,
       r.bottom-r.top,TRUE);
     break;
     }

   case CW_SDICREATE:  // make edit component
     {
     RECT r;
     cw_GetClientRect(hWnd,&r);
     editor=CreateWindow("CWEDITCLASS",
       "Untitled - 1",WS_CHILD|WS_VISIBLE|
       CE_HSCROLL|CE_VSCROLL,r.left,r.top,
       r.right-r.left,r.bottom-r.top,
       hWnd,1,hInst,0);
     SetFocus(editor);
     cw_EditNew(editor);
     SendMessage(hWnd,WM_SETTEXT,0,(DWORD)
       "CoolEdit SDI - Untitled");
     break;
     }

     case WM_INITMENU:  // delegate to editor
       SendMessage(editor,WM_INITMENU,wParam,lParam);
       break;

/* Do menu help on status bar */
     case WM_MENUSELECT:
       cw_StatusHelp(hInst,
       cw_GetRibbon(hWnd,CWRIBBON_BOTTOM),STATUS_PANE,
          lParam&MF_POPUP?0:wParam);
       break;

/* Update tool/status bars */
     case CW_IDLE:
       {
       static unsigned divide=0;
/* Only do time every 600 idle's to avoid undue flicker */
       if (divide++%600==0)
         cw_StatusTime(hWnd,CWRIBBON_BOTTOM,TIME_PANE);
       cw_StatusKeys(hWnd,CWRIBBON_BOTTOM,
           CAP_STATIC,NUM_STATIC,NULL,NULL);
       if (editor)  // get editor status
         {
         SendMessage(editor,CW_INITTOOL,0,(DWORD)hWnd);
         cw_EditStatus(hWnd,CWRIBBON_BOTTOM,editor,
           EDSTAT_PANE,FALSE);
         }
       else
         {  // no editor (!) so blank status
         SendMessage(GetDlgItem(cw_GetRibbon(hWnd,
             CWRIBBON_BOTTOM),EDSTAT_PANE),
             WM_SETTEXT,0,(DWORD)"");
         }
       break;
       }

    case WM_COMMAND:
// delegate to editor 1st
       if (!SendMessage(editor,CW_STDMENU,wParam,0))
         switch (wParam)  // editor didn't know
           {
           case VIEW_FONT:
             if (editor)
               cw_EditSetFont(editor,NULL);
             break;

           case VIEW_TB:
             {
             HMENU m=GetMenu(hWnd);
             BOOL ck=GetMenuState(m,VIEW_TB,MF_BYCOMMAND)
               &MF_CHECKED;
             static HWND tb; // get toolbar handle once
             if (!tb) tb=cw_GetRibbon(hWnd,CWRIBBON_TOP);
             ShowWindow(tb,ck?SW_HIDE:SW_SHOW);
             CheckMenuItem(m,VIEW_TB,MF_BYCOMMAND
                |(ck?MF_UNCHECKED:MF_CHECKED));
/* Force editor to size the right way */
             SendMessage(hWnd,WM_SIZE,0,0);
             break;
             }

           case VIEW_SB:
             {
             HMENU m=GetMenu(hWnd);
             BOOL ck=GetMenuState(m,VIEW_SB,MF_BYCOMMAND)
               &MF_CHECKED;
             static HWND sb;  // get sb handle once
             if (!sb)
               sb=cw_GetRibbon(hWnd,CWRIBBON_BOTTOM);
             ShowWindow(sb,ck?SW_HIDE:SW_SHOW);
             CheckMenuItem(m,VIEW_SB,MF_BYCOMMAND
                 |(ck?MF_UNCHECKED:MF_CHECKED));
/* Force editor to size the right way */
             SendMessage(hWnd,WM_SIZE,0,0);
             break;
             }

           case CM_FILENEW:
             cw_EditNew(editor);
             SendMessage(hWnd,WM_SETTEXT,0,
               (DWORD)"CoolEdit SDI - Untitled");
             break;

           case CM_FILEOPEN:
             {
             char fn[66];
             if (cw_EditOpenFile(editor,
                fn,sizeof(fn)))
                {
                char title[256];
                wsprintf(title,"CoolEdit SDI - %s",
                  (LPSTR)fn);
                SendMessage(hWnd,WM_SETTEXT,0,
                  (DWORD)title);
                }
              }
             break;

           case NUM_BUTTON:
             cw_ToggleKeyState(VK_NUMLOCK);
             break;

           case CAP_BUTTON:
             cw_ToggleKeyState(VK_CAPITAL);
             break;

           case CM_HELPABOUT:
             MessageBox(mainw,
               "DDJ CoolWorx Editor by Al Williams",
               "About XEDITOR",MB_OK|MB_ICONINFORMATION);
             break;

           }
        break;

      case WM_QUERYENDSESSION:  // delegate
        return SendMessage(editor,WM_QUERYENDSESSION,0,0);

      case WM_DESTROY:   // end program
        PostQuitMessage(0);
        break;

      }

    return (cw_DefWindowProc(hWnd,message,wParam,lParam));
    }

