// Various tables used for JPEG like image compression/expansion

#include "tables.hpp"

// The tables below are for quantization. The tables are in zigzag
// order. Values are for a quality factor of 50.
BYTE LumaQuantTable[64] = {
  16, 11, 12, 14, 12, 10, 16, 14,
  13, 14, 18, 17, 16, 19, 24, 40,
  26, 24, 22, 22, 24, 49, 35, 37,
  29, 40, 58, 51, 61, 60, 57, 51,
  56, 55, 64, 72, 92, 78, 64, 68,
  87, 69, 55, 56, 80,109, 81, 87,
  95, 98,103,104,103, 62, 77,113,
 121,112,100,120, 92,101,103, 99
};

BYTE ChromaQuantTable[64] = {
  17,18,18,24,21,24,47,26,
  26,47,99,66,56,66,99,99,
  99,99,99,99,99,99,99,99,
  99,99,99,99,99,99,99,99,
  99,99,99,99,99,99,99,99,
  99,99,99,99,99,99,99,99,
  99,99,99,99,99,99,99,99,
  99,99,99,99,99,99,99,99
};

// The table below is used for zig-zag reordering
BYTE ZigZagTable[64] = {
   0, 1, 8,16, 9, 2, 3,10,
  17,24,32,25,18,11, 4, 5,
  12,19,26,33,40,48,41,34,
  27,20,13, 6, 7,14,21,28,
  35,42,49,56,57,50,43,36,
  29,22,15,23,30,37,44,51,
  58,59,52,45,38,31,39,46,
  53,60,61,54,47,62,55,63
};


// The tables below are used during encoding of the huffman bit stream

BYTE EncDCLumaCodeLength[12] = {   // Code length indexed by category
  2,3,3,3,3,3,4,5,6,7,8,9
};


WORD EncDCLumaCode[12] = {        // Huffman code indexed by category

  0x0000,0x0002,0x0003,0x0004,0x0005,0x0006,0x000E,0x001E,
  0x003E,0x007E,0x00FE,0x01FE
};


BYTE EncDCChromaCodeLength[12] = {// Code length indexed by category
  2,2,2,3,4,5,6,7,8,9,10,11
};


WORD EncDCChromaCode[12] = {      // Huffman code indexed by category

  0x0000,0x0001,0x0002,0x0006,0x000E,0x001E,0x003E,0x007E,
  0x00FE,0x01FE,0x03FE,0x07FE
};


BYTE EncACLumaCodeLength[256] = { // Huffman code length indexed by category

   4, 2, 2, 3, 4, 5, 7, 8,10,16,16, 0, 0, 0, 0, 0,
   0, 4, 5, 7, 9,11,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 5, 8,10,12,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 6, 9,12,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 6,10,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 7,11,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 7,12,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 8,12,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 9,15,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 9,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 9,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0,10,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0,10,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0,11,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0,16,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
  11,16,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0
};


WORD EncACLumaCode[256] = {

  0x000A,0x0000,0x0001,0x0004,0x000B,0x001A,0x0078,0x00F8,
  0x03F6,0xFF82,0xFF83,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x000C,0x001B,0x0079,0x01F6,0x07F6,0xFF84,0xFF85,
  0xFF86,0xFF87,0xFF88,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x001C,0x00F9,0x03F7,0x0FF4,0xFF89,0xFF8A,0xFF8B,
  0xFF8C,0xFF8D,0xFF8E,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x003A,0x01F7,0x0FF5,0xFF8F,0xFF90,0xFF91,0xFF92,
  0xFF93,0xFF94,0xFF95,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x003B,0x03F8,0xFF96,0xFF97,0xFF98,0xFF99,0xFF9A,
  0xFF9B,0xFF9C,0xFF9D,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x007A,0x07F7,0xFF9E,0xFF9F,0xFFA0,0xFFA1,0xFFA2,
  0xFFA3,0xFFA4,0xFFA5,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x007B,0x0FF6,0xFFA6,0xFFA7,0xFFA8,0xFFA9,0xFFAA,
  0xFFAB,0xFFAC,0xFFAD,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x00FA,0x0FF7,0xFFAE,0xFFAF,0xFFB0,0xFFB1,0xFFB2,
  0xFFB3,0xFFB4,0xFFB5,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x01F8,0x7FC0,0xFFB6,0xFFB7,0xFFB8,0xFFB9,0xFFBA,
  0xFFBB,0xFFBC,0xFFBD,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x01F9,0xFFBE,0xFFBF,0xFFC0,0xFFC1,0xFFC2,0xFFC3,
  0xFFC4,0xFFC5,0xFFC6,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x01FA,0xFFC7,0xFFC8,0xFFC9,0xFFCA,0xFFCB,0xFFCC,
  0xFFCD,0xFFCE,0xFFCF,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x03F9,0xFFD0,0xFFD1,0xFFD2,0xFFD3,0xFFD4,0xFFD5,
  0xFFD6,0xFFD7,0xFFD8,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x03FA,0xFFD9,0xFFDA,0xFFDB,0xFFDC,0xFFDD,0xFFDE,
  0xFFDF,0xFFE0,0xFFE1,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x07F8,0xFFE2,0xFFE3,0xFFE4,0xFFE5,0xFFE6,0xFFE7,
  0xFFE8,0xFFE9,0xFFEA,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0xFFEB,0xFFEC,0xFFED,0xFFEE,0xFFEF,0xFFF0,0xFFF1,
  0xFFF2,0xFFF3,0xFFF4,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x07F9,0xFFF5,0xFFF6,0xFFF7,0xFFF8,0xFFF9,0xFFFA,0xFFFB,
  0xFFFC,0xFFFD,0xFFFE,0x0000,0x0000,0x0000,0x0000,0x0000
};


BYTE EncACChromaCodeLength[256] = {

   2, 2, 3, 4, 5, 5, 6, 7, 9,10,12, 0, 0, 0, 0, 0,
   0, 4, 6, 8, 9,11,12,16,16,16,16, 0, 0, 0, 0, 0,
   0, 5, 8,10,12,15,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 5, 8,10,12,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 6, 9,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 6,10,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 7,11,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 7,11,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 8,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 9,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 9,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 9,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0, 9,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0,11,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
   0,14,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0,
  10,15,16,16,16,16,16,16,16,16,16, 0, 0, 0, 0, 0
};


WORD EncACChromaCode[256] = {

  0x0000,0x0001,0x0004,0x000A,0x0018,0x0019,0x0038,0x0078,
  0x01F4,0x03F6,0x0FF4,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x000B,0x0039,0x00F6,0x01F5,0x07F6,0x0FF5,0xFF88,
  0xFF89,0xFF8A,0xFF8B,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x001A,0x00F7,0x03F7,0x0FF6,0x7FC2,0xFF8C,0xFF8D,
  0xFF8E,0xFF8F,0xFF90,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x001B,0x00F8,0x03F8,0x0FF7,0xFF91,0xFF92,0xFF93,
  0xFF94,0xFF95,0xFF96,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x003A,0x01F6,0xFF97,0xFF98,0xFF99,0xFF9A,0xFF9B,
  0xFF9C,0xFF9D,0xFF9E,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x003B,0x03F9,0xFF9F,0xFFA0,0xFFA1,0xFFA2,0xFFA3,
  0xFFA4,0xFFA5,0xFFA6,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0079,0x07F7,0xFFA7,0xFFA8,0xFFA9,0xFFAA,0xFFAB,
  0xFFAC,0xFFAD,0xFFAE,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x007A,0x07F8,0xFFAF,0xFFB0,0xFFB1,0xFFB2,0xFFB3,
  0xFFB4,0xFFB5,0xFFB6,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x00F9,0xFFB7,0xFFB8,0xFFB9,0xFFBA,0xFFBB,0xFFBC,
  0xFFBD,0xFFBE,0xFFBF,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x01F7,0xFFC0,0xFFC1,0xFFC2,0xFFC3,0xFFC4,0xFFC5,
  0xFFC6,0xFFC7,0xFFC8,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x01F8,0xFFC9,0xFFCA,0xFFCB,0xFFCC,0xFFCD,0xFFCE,
  0xFFCF,0xFFD0,0xFFD1,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x01F9,0xFFD2,0xFFD3,0xFFD4,0xFFD5,0xFFD6,0xFFD7,
  0xFFD8,0xFFD9,0xFFDA,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x01FA,0xFFDB,0xFFDC,0xFFDD,0xFFDE,0xFFDF,0xFFE0,
  0xFFE1,0xFFE2,0xFFE3,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x07F9,0xFFE4,0xFFE5,0xFFE6,0xFFE7,0xFFE8,0xFFE9,
  0xFFEA,0xFFEB,0xFFEC,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x3FE0,0xFFED,0xFFEE,0xFFEF,0xFFF0,0xFFF1,0xFFF2,
  0xFFF3,0xFFF4,0xFFF5,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x03FA,0x7FC3,0xFFF6,0xFFF7,0xFFF8,0xFFF9,0xFFFA,0xFFFB,
  0xFFFC,0xFFFD,0xFFFE,0x0000,0x0000,0x0000,0x0000,0x0000
};


// The structures and tables below are used during decoding
// of the huffman bit stream


MINCODEENTRY DecDCLumaMinCodeIndex[10] = {

  {-1,-1},
  {-1,-1},
  { 0,0},
  { 1,2},
  { 6,0x0E},
  { 7,0x1E},
  { 8,0x3E},
  { 9,0x7E},
  {10,0xFE},
  {11,0x1FE}
};


long DecDCLumaMaxCodeIndex[10] = {

  -1,-1,0,6,0x0E,0x1E,0x3E,0x7E,0xFE,0x1FE
};


BYTE DecDCLumaCodeCategory[12] = {

  0,1,2,3,4,5,6,7,8,9,10,11
};

WORD DecDCLumaCode[12] = {

  0x0000,0x0002,0x0003,0x0004,0x0005,0x0006,0x000E,0x001E,
  0x003E,0x007E,0x00FE,0x01FE
};



MINCODEENTRY DecDCChromaMinCodeIndex[12] = {

  {-1,-1},
  {-1,-1},
  { 0, 0},
  { 3, 6},
  { 4,0x0E},
  { 5,0x1E},
  { 6,0x3E},
  { 7,0x7E},
  { 8,0xFE},
  { 9,0x1FE},
  {10,0x3FE},
  {11,0x7FE}
};

long DecDCChromaMaxCodeIndex[12] = {

  -1,-1,2,6,0x0E,0x1E,0x3E,0x7E,0xFE,0x1FE,0x3FE,0x7FE
};

BYTE DecDCChromaCodeCategory[12] = {

  0,1,2,3,4,5,6,7,8,9,10,11
};

WORD DecDCChromaCode[12] = {

  0x0000,0x0001,0x0002,0x0006,0x000E,0x001E,0x003E,0x007E,
  0x00FE,0x01FE,0x03FE,0x07FE
};



MINCODEENTRY DecACLumaMinCodeIndex[17] = {

  {-1,-1},
  {-1,-1},
  { 0,0},
  { 2,4},
  { 3,0x0A},
  { 6,0x1A},
  { 9,0x3A},
  {11,0x78},
  {15,0xF8},
  {18,0x1F6},
  {23,0x3F6},
  {28,0x7F6},
  {32,0xFF4},
  {-1,-1},
  {-1,-1},
  {36,0x7FC0},
  {37,0xFF82}
};

long DecACLumaMaxCodeIndex[17] = {

  -1,-1,1,4,0x0C,0x1C,0x3B,0x7B,
  0xFA,0x1FA,0x3FA,0x7F9,0xFF7,-1,-1,0x7FC0,0xFFFE
};

BYTE DecACLumaCodeCategory[162] = {

  0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
  0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,
  0x22,0x71,0x14,0x32,0x81,0x91,0xA1,0x08,
  0x23,0x42,0xB1,0xC1,0x15,0x52,0xD1,0xF0,
  0x24,0x33,0x62,0x72,0x82,0x09,0x0A,0x16,
  0x17,0x18,0x19,0x1A,0x25,0x26,0x27,0x28,
  0x29,0x2A,0x34,0x35,0x36,0x37,0x38,0x39,
  0x3A,0x43,0x44,0x45,0x46,0x47,0x48,0x49,
  0x4A,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
  0x5A,0x63,0x64,0x65,0x66,0x67,0x68,0x69,
  0x6A,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
  0x7A,0x83,0x84,0x85,0x86,0x87,0x88,0x89,
  0x8A,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
  0x99,0x9A,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,
  0xA8,0xA9,0xAA,0xB2,0xB3,0xB4,0xB5,0xB6,
  0xB7,0xB8,0xB9,0xBA,0xC2,0xC3,0xC4,0xC5,
  0xC6,0xC7,0xC8,0xC9,0xCA,0xD2,0xD3,0xD4,
  0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xE1,0xE2,
  0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,
  0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,
  0xF9,0xFA
};

WORD DecACLumaCode[162] = {

  0x0000,0x0001,0x0004,0x000A,0x000B,0x000C,0x001A,0x001B,
  0x001C,0x003A,0x003B,0x0078,0x0079,0x007A,0x007B,0x00F8,
  0x00F9,0x00FA,0x01F6,0x01F7,0x01F8,0x01F9,0x01FA,0x03F6,
  0x03F7,0x03F8,0x03F9,0x03FA,0x07F6,0x07F7,0x07F8,0x07F9,
  0x0FF4,0x0FF5,0x0FF6,0x0FF7,0x7FC0,0xFF82,0xFF83,0xFF84,
  0xFF85,0xFF86,0xFF87,0xFF88,0xFF89,0xFF8A,0xFF8B,0xFF8C,
  0xFF8D,0xFF8E,0xFF8F,0xFF90,0xFF91,0xFF92,0xFF93,0xFF94,
  0xFF95,0xFF96,0xFF97,0xFF98,0xFF99,0xFF9A,0xFF9B,0xFF9C,
  0xFF9D,0xFF9E,0xFF9F,0xFFA0,0xFFA1,0xFFA2,0xFFA3,0xFFA4,
  0xFFA5,0xFFA6,0xFFA7,0xFFA8,0xFFA9,0xFFAA,0xFFAB,0xFFAC,
  0xFFAD,0xFFAE,0xFFAF,0xFFB0,0xFFB1,0xFFB2,0xFFB3,0xFFB4,
  0xFFB5,0xFFB6,0xFFB7,0xFFB8,0xFFB9,0xFFBA,0xFFBB,0xFFBC,
  0xFFBD,0xFFBE,0xFFBF,0xFFC0,0xFFC1,0xFFC2,0xFFC3,0xFFC4,
  0xFFC5,0xFFC6,0xFFC7,0xFFC8,0xFFC9,0xFFCA,0xFFCB,0xFFCC,
  0xFFCD,0xFFCE,0xFFCF,0xFFD0,0xFFD1,0xFFD2,0xFFD3,0xFFD4,
  0xFFD5,0xFFD6,0xFFD7,0xFFD8,0xFFD9,0xFFDA,0xFFDB,0xFFDC,
  0xFFDD,0xFFDE,0xFFDF,0xFFE0,0xFFE1,0xFFE2,0xFFE3,0xFFE4,
  0xFFE5,0xFFE6,0xFFE7,0xFFE8,0xFFE9,0xFFEA,0xFFEB,0xFFEC,
  0xFFED,0xFFEE,0xFFEF,0xFFF0,0xFFF1,0xFFF2,0xFFF3,0xFFF4,
  0xFFF5,0xFFF6,0xFFF7,0xFFF8,0xFFF9,0xFFFA,0xFFFB,0xFFFC,
  0xFFFD,0xFFFE
};



MINCODEENTRY DecACChromaMinCodeIndex[17] = {

  {-1,-1},
  {-1,-1},
  { 0, 0},
  { 2, 4},
  { 3,0x0A},
  { 5,0x18},
  { 9,0x38},
  {13,0x78},
  {16,0xF6},
  {20,0x1F4},
  {27,0x3F6},
  {32,0x7F6},
  {36,0xFF4},
  {-1,-1},
  {40,0x3FE0},
  {41,0x7FC2},
  {43,0xFF88}
};

long DecACChromaMaxCodeIndex[17] = {

  -1,-1,1,4,0x0B,0x1B,0x3B,0x7A,
  0xF9,0x1FA,0x3FA,0x7F9,0xFF7,-1,0x3FE0,0x7FC3,0xFFFE
};

BYTE DecACChromaCodeCategory[162] = {

  0x00,0x01,0x02,0x03,0x11,0x04,0x05,0x21,
  0x31,0x06,0x12,0x41,0x51,0x07,0x61,0x71,
  0x13,0x22,0x32,0x81,0x08,0x14,0x42,0x91,
  0xA1,0xB1,0xC1,0x09,0x23,0x33,0x52,0xF0,
  0x15,0x62,0x72,0xD1,0x0A,0x16,0x24,0x34,
  0xE1,0x25,0xF1,0x17,0x18,0x19,0x1A,0x26,
  0x27,0x28,0x29,0x2A,0x35,0x36,0x37,0x38,
  0x39,0x3A,0x43,0x44,0x45,0x46,0x47,0x48,
  0x49,0x4A,0x53,0x54,0x55,0x56,0x57,0x58,
  0x59,0x5A,0x63,0x64,0x65,0x66,0x67,0x68,
  0x69,0x6A,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7A,0x82,0x83,0x84,0x85,0x86,0x87,
  0x88,0x89,0x8A,0x92,0x93,0x94,0x95,0x96,
  0x97,0x98,0x99,0x9A,0xA2,0xA3,0xA4,0xA5,
  0xA6,0xA7,0xA8,0xA9,0xAA,0xB2,0xB3,0xB4,
  0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xC2,0xC3,
  0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xD2,
  0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,
  0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,
  0xEA,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,
  0xF9,0xFA
};

WORD DecACChromaCode[162] = {

  0x0000,0x0001,0x0004,0x000A,0x000B,0x0018,0x0019,0x001A,
  0x001B,0x0038,0x0039,0x003A,0x003B,0x0078,0x0079,0x007A,
  0x00F6,0x00F7,0x00F8,0x00F9,0x01F4,0x01F5,0x01F6,0x01F7,
  0x01F8,0x01F9,0x01FA,0x03F6,0x03F7,0x03F8,0x03F9,0x03FA,
  0x07F6,0x07F7,0x07F8,0x07F9,0x0FF4,0x0FF5,0x0FF6,0x0FF7,
  0x3FE0,0x7FC2,0x7FC3,0xFF88,0xFF89,0xFF8A,0xFF8B,0xFF8C,
  0xFF8D,0xFF8E,0xFF8F,0xFF90,0xFF91,0xFF92,0xFF93,0xFF94,
  0xFF95,0xFF96,0xFF97,0xFF98,0xFF99,0xFF9A,0xFF9B,0xFF9C,
  0xFF9D,0xFF9E,0xFF9F,0xFFA0,0xFFA1,0xFFA2,0xFFA3,0xFFA4,
  0xFFA5,0xFFA6,0xFFA7,0xFFA8,0xFFA9,0xFFAA,0xFFAB,0xFFAC,
  0xFFAD,0xFFAE,0xFFAF,0xFFB0,0xFFB1,0xFFB2,0xFFB3,0xFFB4,
  0xFFB5,0xFFB6,0xFFB7,0xFFB8,0xFFB9,0xFFBA,0xFFBB,0xFFBC,
  0xFFBD,0xFFBE,0xFFBF,0xFFC0,0xFFC1,0xFFC2,0xFFC3,0xFFC4,
  0xFFC5,0xFFC6,0xFFC7,0xFFC8,0xFFC9,0xFFCA,0xFFCB,0xFFCC,
  0xFFCD,0xFFCE,0xFFCF,0xFFD0,0xFFD1,0xFFD2,0xFFD3,0xFFD4,
  0xFFD5,0xFFD6,0xFFD7,0xFFD8,0xFFD9,0xFFDA,0xFFDB,0xFFDC,
  0xFFDD,0xFFDE,0xFFDF,0xFFE0,0xFFE1,0xFFE2,0xFFE3,0xFFE4,
  0xFFE5,0xFFE6,0xFFE7,0xFFE8,0xFFE9,0xFFEA,0xFFEB,0xFFEC,
  0xFFED,0xFFEE,0xFFEF,0xFFF0,0xFFF1,0xFFF2,0xFFF3,0xFFF4,
  0xFFF5,0xFFF6,0xFFF7,0xFFF8,0xFFF9,0xFFFA,0xFFFB,0xFFFC,
  0xFFFD,0xFFFE
};

