// Miscellaneous Includes and Defintions

#ifndef MISC_HPP
#define MISC_HPP

#ifndef BYTE
typedef unsigned char BYTE;
#endif

#ifndef WORD
typedef unsigned short WORD;
#endif

#ifndef DWORD
typedef unsigned long DWORD;
#endif

#ifndef BOOL
typedef int BOOL;
#endif

#ifndef LPSTR
typedef char far * LPSTR;
#endif

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

#define ALIGN_DWORD(x) (((x)+3)/4 * 4) // Double word alignment macro

enum IMAGETYPE {NOIMAGETYPE, GRAYSCALETYPE, PALETTECOLORTYPE, TRUECOLORTYPE};


#define BLOCKCOLUMNS  8           // Blocks are 8x8
#define BLOCKROWS     8
#define MAXSAMPLES    8           // 8 samples/row of data
#define MAXRESULTS    8           // results in 8x8 or 64 freq components

// BYTEBLOCKS are 8x8 bytes
typedef BYTE BYTEBLOCK[BLOCKCOLUMNS][BLOCKROWS];
typedef BYTEBLOCK * BYTEBLOCKPTR;

// INTBLOCKS are 8x8 integers
typedef int INTBLOCK[BLOCKCOLUMNS][BLOCKROWS];
typedef INTBLOCK * INTBLOCKPTR;

// Shared function prototypes
void far * MyAlloc(DWORD Size);
void MyFree(void far * pMem);

#endif
