// Huffman Encoding/Decoding Interface Definition

#ifndef HUFFMAN_HPP
#define HUFFMAN_HPP

#include "fileio.hpp"
#include "dct.hpp"
#include "tables.hpp"

// Various substitutions for boolean values
#define USELUMATABLE     1
#define USECHROMATABLE   0
#define HUFFMANENCODE    1
#define HUFFMANDECODE    0

typedef struct {
  BYTE *pCodeLengthTable;
  WORD *pCodeTable;
} ENCODEHUFFMANTABLE;

typedef struct {
  MINCODEENTRY *pMinCodeTable;
  long *pMaxCodeTable;
  BYTE *pCodeCategoryTable;
  WORD *pCodeTable;
} DECODEHUFFMANTABLE;


// Huffman Class Defintion
class Huffman {
  private:
    BOOL AccessType;

    // Huffman bit accumulation/extraction buffers
    long PutBuffer;               // Bit accumulation buffer
    int  PutBufferBitCount;       // Number of bits accumulated

    long GetBuffer;               // Bit extraction buffer
    int GetBufferBitCount;        // Number of unused bits in GetBuffer

    ENCODEHUFFMANTABLE EncodeDCLumaTable;
    ENCODEHUFFMANTABLE EncodeDCChromaTable;
    ENCODEHUFFMANTABLE EncodeACLumaTable;
    ENCODEHUFFMANTABLE EncodeACChromaTable;

    DECODEHUFFMANTABLE DecodeDCLumaTable;
    DECODEHUFFMANTABLE DecodeDCChromaTable;
    DECODEHUFFMANTABLE DecodeACLumaTable;
    DECODEHUFFMANTABLE DecodeACChromaTable;

    // Private member functions
    void PutNBits(WORD code, int size);
    void EncodeABlock(int *Block, ENCODEHUFFMANTABLE *DCTable,
                      ENCODEHUFFMANTABLE *ACTable);
    int GetNBits(int nbits);
    int GetCodeFromStream(DECODEHUFFMANTABLE *lpTable);
    void DecodeABlock(int *Block, DECODEHUFFMANTABLE *DCTable,
                      DECODEHUFFMANTABLE *ACTable);
    int DecodeCode(int Code, int Category);

  public:
    AFile FileObject;

    Huffman(LPSTR FileName, BOOL Type);
   ~Huffman(void);

    void EncodeBlock(int *InBlock,  BOOL Type);
    void DecodeBlock(int *OutBlock, BOOL Type);

    void FlushInputStream(void);
    void FlushOutputStream(void);
};

#endif
