// File I/O Class Interface Definition

#ifndef FILEIO_HPP
#define FILEIO_HPP

#include <windows.h>

enum TypeFileAccess {NOTOPEN, OPENFORREAD, OPENFORWRITE};

class AFile {
  private:
    TypeFileAccess Access;        // Access type for this object
    HFILE hFile;                  // Handle to file
    char  FileName[128];
    int ErrorCode;

    BYTE FileBuf[2560];           // 10 sector file buffer for read/write
    int  nIndex;                  // Used in ReadByte/WriteByte
    int  iDataBytes;              // functions

  public:
    AFile();
    virtual ~AFile();

    BOOL OpenReadFile(LPSTR TheFileName);
    BOOL OpenWriteFile(LPSTR TheFileName);
    BOOL CloseFile(void);

    int  ReadByte(void);
    BOOL ReadMBytes(BYTE huge *Buffer, DWORD Number);

    BOOL WriteByte(BYTE TheByte);
    BOOL WriteMBytes(BYTE huge *Buffer, DWORD Number);
    BOOL FlushWriteFile(void);

    int  GetError(void);
};

#endif

