// Color Conversion Class Interface Definition


#ifndef COLOR_HPP
#define COLOR_HPP

#include "misc.hpp"

// The ColorConvert Class Definition
class ColorConvert {
  private:
    IMAGETYPE ImageType;
    WORD WidthInPixels;
    WORD HeightInPixels;
	BYTE huge *lpImage;
	BYTE far *lpY1Buffer;
	BYTE far *lpY2Buffer;
	BYTE far *lpCrBuffer;
    BYTE far *lpCbBuffer;
    long ChromaRangeOffset;

    WORD YBufferBytesPerLine;
    WORD CBufferBytesPerLine;
    WORD SizeOfCBuffers;
    WORD DIBBytesPerLine;

    long *pEncodeYRed;
    long *pEncodeYGreen;
    long *pEncodeYBlue;
    long *pEncodeCbRed;
    long *pEncodeCbGreen;
    long *pEncodeCbBlue;
    long *pEncodeCrRed;
    long *pEncodeCrGreen;
    long *pEncodeCrBlue;
    long *pDecodeRCr;
    long *pDecodeGCb;
    long *pDecodeGCr;
    long *pDecodeBCb;

  public:
    ColorConvert(IMAGETYPE Type, WORD Width, WORD Height,
                 BYTE huge *lpImageData,
				 BYTE far *lpY1BufferData, BYTE far *lpY2BufferData,
				 BYTE far *lpCbBufferData,
                 BYTE far *lpCrBufferData);


   ~ColorConvert(void);

   void GetDIBData(WORD FromRowNumber);
   void PutDIBData(WORD ToRowNumber);
};

#endif

