// Huffman Test Code

#include <windows.h>
#include "compand.hpp"
#include "cal.hpp"

// Start of the main program
int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int) {

  // Open the test image
  Compand Ex;
  Ex.InitExpander("f:\\images\\motor.bmp");
  Ex.DoExpansion();

  Compand *C1;
  CompressCALImage *C;
  ExpandCALImage *E;

  MessageBox(NULL, "Compress/Expand QF = 100", "Alert", MB_OK);

  // Attempt to compress a CAL image
  C = new CompressCALImage(
                      "c:\\miscimgs\\cal100.cal", TRUECOLORTYPE,
					  Ex.GetDataPtr(), Ex.GetPalettePtr(),
					  Ex.GetWidth(), Ex.GetHeight(),
					  Ex.GetBitsPerPixel(), Ex.GetColors(),
					  100);

  C->CompressImage();

  // Attempt to expand the CAL image
  E = new ExpandCALImage("c:\\miscimgs\\cal100.cal");
  E->ExpandImage();

  MessageBox(NULL, "Compress/Expand QF = 100 Done", "Alert", MB_OK);

  // Save the expanded image as a BMP image
  C1 = new Compand;
  C1->InitCompressor(BMPTYPE, "c:\\miscimgs\\cal100.bmp",
					E->GetWidth(), E->GetHeight(),
                    E->GetBitsPerPixel(), E->GetColors(),
                    E->GetDataPtr(), E->GetPalettePtr());
  C1->DoCompression();

  delete C;
  delete E;
  delete C1;


  MessageBox(NULL, "Compress/Expand QF = 50", "Alert", MB_OK);

  // Attempt to compress a CAL image
  C = new CompressCALImage(
                      "c:\\miscimgs\\cal50.cal", TRUECOLORTYPE,
					  Ex.GetDataPtr(), Ex.GetPalettePtr(),
					  Ex.GetWidth(), Ex.GetHeight(),
					  Ex.GetBitsPerPixel(), Ex.GetColors(),
					  50);

  C->CompressImage();

  // Attempt to expand the CAL image
  E = new ExpandCALImage("c:\\miscimgs\\cal50.cal");
  E->ExpandImage();

  MessageBox(NULL, "Compress/Expand QF = 50 Done", "Alert", MB_OK);

  // Save the expanded image as a BMP image
  C1 = new Compand;
  C1->InitCompressor(BMPTYPE, "c:\\miscimgs\\cal50.bmp",
					E->GetWidth(), E->GetHeight(),
                    E->GetBitsPerPixel(), E->GetColors(),
                    E->GetDataPtr(), E->GetPalettePtr());
  C1->DoCompression();

  delete C;
  delete E;
  delete C1;

  MessageBox(NULL, "Compress/Expand QF = 25", "Alert", MB_OK);

  // Attempt to compress a CAL image
  C = new CompressCALImage(
                      "c:\\miscimgs\\cal25.cal", TRUECOLORTYPE,
					  Ex.GetDataPtr(), Ex.GetPalettePtr(),
					  Ex.GetWidth(), Ex.GetHeight(),
					  Ex.GetBitsPerPixel(), Ex.GetColors(),
					  25);

  C->CompressImage();

  // Attempt to expand the CAL image
  E = new ExpandCALImage("c:\\miscimgs\\cal25.cal");
  E->ExpandImage();

  MessageBox(NULL, "Compress/Expand QF = 25 Done", "Alert", MB_OK);

  // Save the expanded image as a BMP image
  C1 = new Compand;
  C1->InitCompressor(BMPTYPE, "c:\\miscimgs\\cal25.bmp",
					E->GetWidth(), E->GetHeight(),
                    E->GetBitsPerPixel(), E->GetColors(),
                    E->GetDataPtr(), E->GetPalettePtr());
  C1->DoCompression();

  delete C;
  delete E;
  delete C1;

  MessageBox(NULL, "Compress/Expand QF = 12", "Alert", MB_OK);

  // Attempt to compress a CAL image
  C = new CompressCALImage(
                      "c:\\miscimgs\\cal12.cal", TRUECOLORTYPE,
					  Ex.GetDataPtr(), Ex.GetPalettePtr(),
					  Ex.GetWidth(), Ex.GetHeight(),
					  Ex.GetBitsPerPixel(), Ex.GetColors(),
					  12);

  C->CompressImage();

  // Attempt to expand the CAL image
  E = new ExpandCALImage("c:\\miscimgs\\cal12.cal");
  E->ExpandImage();

  MessageBox(NULL, "Compress/Expand QF = 12 Done", "Alert", MB_OK);

  // Save the expanded image as a BMP image
  C1 = new Compand;
  C1->InitCompressor(BMPTYPE, "c:\\miscimgs\\cal12.bmp",
					E->GetWidth(), E->GetHeight(),
                    E->GetBitsPerPixel(), E->GetColors(),
                    E->GetDataPtr(), E->GetPalettePtr());
  C1->DoCompression();

  delete C;
  delete E;
  delete C1;





  return 0;
}
