// Compress and Expand CAL Files Class Interface Definition

#ifndef CAL_HPP
#define CAL_HPP

#include "dct1.hpp"
#include "quant.hpp"
#include "huffman.hpp"
#include "bufman.hpp"

#ifndef __RGBCOLOR
#define __RGBCOLOR
typedef struct  {
  BYTE Red;
  BYTE Green;
  BYTE Blue;
} RGBCOLOR;
#endif

// Define the CAL file header
typedef struct {
    WORD   StructureSize;         // Size of structure for version control
    WORD   CALFileTag;            // Tag should be CL
    IMAGETYPE ImageType;          // Type of image
	WORD   ImageWidth;            // Image width in pixels
    WORD   ImageHeight;           // Image height in pixels
    DWORD  RasterSize;            // DIB Raster size including padding
    WORD   BitsPerPixel;          // Number of bits per pixel
    WORD   NumberOfColors;        // Number of important colors in image
    WORD   QualityFactor;         // Quality factor image compressed with
    WORD   NumberOfMCUs;          // Total number of MCUs in image
    WORD   BlocksPerMCU;          // Number of blocks in a single MCU
    RGBCOLOR Palette[256];        // Palette for image display
    DWORD  Unused1;               // TBD
} CALFILEHEADER;


// The Expand Class Definition
class ExpandCALImage {
  private:
    int ErrorCode;
    CALFILEHEADER Header;
    BYTE huge *lpImageData;

    BufferManager *BM;
    DCT InvTransform;
    Quantize InvQuant;
    Huffman *Decoder;

    int PreviousYBlockDCValue;    // DC values of previously decoded blocks
    int PreviousCbBlockDCValue;
    int PreviousCrBlockDCValue;

  public:
    ExpandCALImage(LPSTR FileName);
    virtual ~ExpandCALImage(void);

    BOOL ExpandImage(void);

	WORD GetWidth(void)                { return Header.ImageWidth; }
    WORD GetHeight(void)               { return Header.ImageHeight; }
    WORD GetColors(void)               { return Header.NumberOfColors; }
    WORD GetBitsPerPixel(void)         { return Header.BitsPerPixel; }
    DWORD GetRasterSize(void)          { return Header.RasterSize; }

    BYTE huge * GetDataPtr(void)       { return lpImageData; }
    RGBCOLOR * GetPalettePtr(void)     { return Header.Palette; }

    int GetError(void);
};

// The Compress Class Definition
class CompressCALImage {
  private:
    int ErrorCode;
	CALFILEHEADER Header;
    BYTE huge *lpImageData;

    WORD BlocksPerMCU;
    WORD NumberOfMCUs;
    int PreviousYBlockDCValue;    // DC values of previously encoded blocks
    int PreviousCbBlockDCValue;
    int PreviousCrBlockDCValue;

    BufferManager *BM;
    DCT FwdTransform;
    Quantize FwdQuant;
    Huffman *Encoder;

  public:
	  CompressCALImage(LPSTR FileName, IMAGETYPE Type,
	             BYTE huge *lpImage, RGBCOLOR *lpPalette,
               WORD Width, WORD Height,
               WORD BitsPerPixel, WORD NumOfColors,
               WORD QualityFactor);
    virtual ~CompressCALImage(void);

	  BOOL CompressImage(void);
    int GetError(void);
};


#endif

