unit Models;

interface
uses
	Global,
	Property,
	Event,
	Resource,
	WinSys,
	WinTypes,
	WinProcs,
	VBApi_,
	Strings;

function CircleCtlProc(Control: HCtl; Wnd: HWnd;
			Msg, wp: Word; lp: LongInt):LongInt; export;

{//---------------------------------------------------------------------------
// Model struct
//---------------------------------------------------------------------------
// Define the control model (using the event and property structures).
//---------------------------------------------------------------------------}
const
	ModelDefCtlName: 	array[0..8] of Char = 'Circle'#0; 		{ default control name prefix}
	ModelClassName:		array[0..14] of Char = 'Circle2'#0;{ Visual Basic class name}
	ModelParentClassName:	array[0..8] of Char = #0;	{ Parent window class if subclassed}
	modelCircle: TMODEL = (
		usVersion:		VB_VERSION;							{ VB version used by control}
		fl:				0;								 	{ Bitfield structure}
		ctlproc:		TFarProc(@CircleCtlProc);			{ The control proc.}
		fsClassStyle:	cs_VRedraw or cs_HRedraw;			{ window class style}
		flWndStyle:		0;			 						{ default window style}
		cbCtlExtra:		sizeof(TCirc2);						{ # bytes alloc'd for HCTL structure}
		idBmpPalette:	IDBMP_Circle;							{ BITMAP id for tool palette}
		DefCtlName: 	tOffset(@ModelDefCtlName); 				{ default control name prefix}
		ClassName:		tOffset(@ModelClassName);			{ Visual Basic class name}
		ParentClassName:	0;								{ Parent window class if subclassed}
		proplist:		ofs(Circle_Properties);				{ Property list}
		eventlist:		ofs(Circle_Events); 				{ Event list}
		nDefProp: 		ord(IPROP_Circle_BackColor);				{ index of default property}
		nDefEvent:		ord(Event_Circle_ClickIn);				{ index of default event}
		nValueProp:		ord(IProp_Circle_Shape));			{ default value }

implementation

procedure PaintCircle(Control: hCtl; Wnd: HWnd; hDcIn: hDc);
var
	lpCirc:	pCirc2;
	lpRect: tRect;
	hBr,
	hBrOld:	HBrush;			{ defined in windows}
begin
	hBrOld := 0;
	lpCirc := VBDerefControl(Control);
	lpRect := lpCirc^.RectDrawInto;
	GetClientRect(Wnd, lpRect);
	hBr := SendMessage(GetParent(Wnd), WM_CTLCOLOR, hDcIn, MAKELong(Wnd, 0));
	if (hBr <> 0) then
		hbrOld := SelectObject(hDcIn, hBr);
	Ellipse(hdcin, lpRect.left, lpRect.top, lpRect.right, lpRect.bottom);
	if hBrOld <> 0 then
		SelectObject(hDcIn, hBrOld);
end;

{---------------------------------------------------------------------------
 Paint the circle in the FlashColor.
---------------------------------------------------------------------------}
procedure FlashCircle(Control: hctl; hDcIn: hDc);
var
	hbr,
	hbrOld:	hBrush;
	lpCirc: pCirc2;
	lpRect:	tRect;
begin
	hbrOld := 0;
	lpcirc := VBDerefControl(Control);
	lpRect := lpCirc^.rectDrawInto;
	hbr := CreateSolidBrush(lpcirc^.FlashColor);
	if (hbr <> 0 ) then
		hbrOld := SelectObject(hDcIn, hbr);
	Ellipse(hDcIn, lpRect.left, lpRect.top, lpRect.right, lpRect.bottom);
	if (hbr <> 0) then begin
		SelectObject(hDcIn, hbrOld);
		DeleteObject(hbr);
	end;
end;


{---------------------------------------------------------------------------
 Use the hwnd's client size to determine the bounding rectangle for the
 circle.  If CircleShape is TRUE, then we need to calculate a square
 centered in lpRect.
---------------------------------------------------------------------------}
procedure RecalcArea(Control: hctl; Wnd: hwnd);
var
	lpCirc: pCirc2;
	lpRect:	tRect;
begin
	lpcirc := VBDerefControl(Control);
	lpRect := lpCirc^.rectDrawInto;

	GetClientRect(Wnd, lpRect);
	if (lpCirc^.CircleShape = 0) then exit;
	if (lpRect.right > lpRect.bottom) then begin
		lpRect.left  := (lpRect.right - lpRect.bottom) div 2;
		lpRect.right := lpRect.left + lpRect.bottom;
	end else if (lpRect.bottom > lpRect.right) then begin
		lpRect.top    := (lpRect.bottom - lpRect.right) div 2;
		lpRect.bottom := lpRect.top + lpRect.right;
	end;
end;


{--------------------------------------------------------------------------
 Return TRUE if the given coordinates are inside of the circle.
---------------------------------------------------------------------------}
function InCircle(Control: hctl; xcoord, ycoord: integer): boolean;
var
	lpCirc: pCirc2;
	lpRect:	tRect;
	a, b:	longInt;
	x, y:	longInt;
	c, d:	longInt;
begin
	lpcirc := VBDerefControl(Control);
	lpRect := lpCirc^.rectDrawInto;
	a := (lpRect.right	- lpRect.left) div 2;
	b := (lpRect.bottom - lpRect.top) div 2;
	x := xcoord - (lpRect.left + lpRect.right)  div 2;
	y := ycoord - (lpRect.top  + lpRect.bottom) div 2;
	c := (a * a);
	if c <> 0 then
		c := ((x * x) div c)
	else
		c := (x * x);
	d := (b * b);
	if d <> 0 then
		d := (y * y) div d
	else
		d := (y * y);
	InCircle := (c + d <= 1);
end;


{---------------------------------------------------------------------------
 TYPEDEF for parameters to the ClickIn event.
---------------------------------------------------------------------------}
Type
	tagCLICKINPARMS = record
{	float far *Y;} Y:   pointer;
{	float far *X;} X:	pointer;
{	LPVOID     Index;}Index:	LPVoid;
	end;


{--------------------------------------------------------------------------
 Fire the ClickIn event, passing the x,y coords of the click.
---------------------------------------------------------------------------}
procedure FireClickIn(Control: hctl; x, y: integer);
var
	params:	tagClickInParms;
	xTwips,
	yTwips:	LongInt;
begin
	xTwips := VBXPixelsToTwips(x);
	yTwips := VBYPixelsToTwips(y);
	params.X := @xTwips;
	params.Y := @yTwips;
	VBFireEvent(Control, ord(EVENT_CIRCLE_CLICKIN), @params);
end;


{---------------------------------------------------------------------------
 Fire the ClickOut event.
---------------------------------------------------------------------------}
procedure FireClickOut(Control: hctl);
begin
	VBFireEvent(Control, ord(EVENT_CIRCLE_CLICKOUT), NIL);
end;

function CircleCtlProc(Control: HCtl; Wnd: HWnd;
			Msg, wp: Word; lp: LongInt):LongInt;
var
	ps:		tPaintStruct;
	LpCirc:	pCirc2;
	hDcHold:	hDc;
begin

	case Msg of
		WM_NCCREATE:	begin
			LpCirc := VBDerefControl(Control);
			LpCirc^.CircleShape := 0;
			lpCirc^.FlashColor := 128;
			VBSetControlProperty(Control, ord(IPROP_Circle_BACKCOLOR), 255);
		end;
		WM_LBUTTONDOWN,
		WM_LBUTTONDBLCLK:
			if (InCircle(Control, lp, HiWord(lp))) then begin
				hDcHold := GetDC(Wnd);
				FlashCircle(Control, hDcHold);
				ReleaseDC(Wnd, hDcHold);
				FireClickIn(Control, lp, HiWord(lp));
			end else
				FireClickOut(Control);
		WM_LBUTTONUP:
			if (InCircle(Control, lp, HIWORD(lp))) then begin
				hDcHold := GetDC(Wnd);
				PaintCircle(Control, Wnd, hDcHold);
				ReleaseDC(Wnd, hDcHold);
			end;

		WM_PAINT:
			if (wP <> 0) then
				PaintCircle(Control, Wnd, wP)
			else begin
				BeginPaint(Wnd, ps);
				paintCircle(Control, Wnd, ps.hdc);
				EndPaint(Wnd, ps);
			end;
		WM_SIZE:	RecalcArea(Control, Wnd);
		VBM_SETPROPERTY:
			case wP of
				ord(IPROP_Circle_Shape): begin
					lpCirc := VBDerefControl(Control);
					lpCirc^.CircleShape := lp;
					RecalcArea(Control, Wnd);
					InvalidateRect(Wnd, nil, true);
					CircleCtlProc := 0;
					exit;
				end;
			end;
	end;

	{// Default processing:}
	CircleCtlProc := VBDefControlProc(Control, Wnd, Msg, wP, lP);

end;

end.
