Unit Debug;

interface

uses
	wsstring,
	WinDos,
	WinCrt;

procedure initDebug;

procedure WriteDebug(msg: pChar);

procedure WriteDebugValue(p: string; m1: pchar);

procedure WriteDebugValues(p: string; m1, m2, m3: pchar);

procedure WriteDebugNumber(p: string; m1: longInt);

procedure WriteDebugChar(p: string; m1: char);

procedure WriteDebugMessages(p: string; m1, m2, m3: longInt);

var
	D:	text;

implementation

procedure initDebug;
begin
	assign(D, 'Debug.TxT');
	reWrite(D);
	writeln('VBDOS DEBUG');
	close(D);
end;

procedure reopenDebug;
begin
	append(D);
end;

procedure closeDebug;
begin
	close(D);
end;

function interpret(msg: longInt): string;
var
	hexrep: array[0..12] of char;
	hexstr:	string;
begin
	HexL(hexrep, msg);
	hexstr[0] := #4;
	hexstr[1] := hexrep[4];
	hexstr[2] := hexrep[5];
	hexstr[3] := hexrep[6];
	hexstr[4] := hexrep[7];
	case msg of
		1:		interpret := '0x0001 WM_Create           ';
		$5:		interpret := '0x0005 WM_Size             ';
		$F:		interpret := '0x000F WM_Paint            ';
		$14:	interpret := '0x0014 WM_EraseBkGnd       ';
		$18:	interpret := '0x0018 WM_ShowWindow       ';
		$21:	interpret := '0x0021 WM_MouseActivate    ';
		$22:	interpret := '0x0022 WM_ChildActivate    ';
		$24:	interpret := '0x0024 WM_GetMinMaxInfo    ';
		$31:	interpret := '0x0031 WM_GetFont          ';
		$46:	interpret := '0x0046 WM_WindowPosChanging';
		$47:	interpret := '0x0047 WM_WindowPosChanged ';
		$71:	interpret := '0x0071 WM_WindowPosChanged ';
		$81:	interpret := '0x0081 WM_NCCreate         ';
		$83:	interpret := '0x0083 WM_NCCalcSize       ';
		$1002:	interpret := '0x1002 VBM_Initialize      ';
		$100A:	interpret := '0x100A VBM_QPASTEOK        ';
		$1017:	interpret := '0x1017 VBM_PaintOutline    ';
		$2210:	interpret := '0x2210 VBM_ParentNotify    ';
		else	interpret := '0x' + hexstr + '     Unknown             ';
	end;
end;

procedure WriteDebug(msg: pChar);
begin
	reopenDebug;
	writeln(D, Msg);
	closeDebug;
end;

procedure WriteDebugValue(p: string; m1: pchar);
begin
	reopenDebug;
	writeLn(D, p, ' ', m1);
	closeDebug;
end;

procedure WriteDebugValues(p: string; m1, m2, m3: pchar);
begin
	reopenDebug;
	writeLn(D, p, ' ', m1, ' ', m2, ' ',m3);
	closeDebug;
end;

procedure WriteDebugNumber(p: string; m1: longInt);
begin
	reopenDebug;
	writeLn(D, p, ' ', m1);
	closeDebug;
end;

procedure WriteDebugChar(p: string; m1: char);
begin
	reopenDebug;
	writeLn(D, p, ' ', m1);
	closeDebug;
end;

procedure WriteDebugMessages(p: string; m1, m2, m3: longInt);
begin
	reopenDebug;
	writeLn(D, p, ' ', interpret(m1), ' ', m2, ' ',m3);
	closeDebug;
end;


end.