VERSION 2.00
Begin Form frmOpen 
   Caption         =   "Open Bitmap File"
   Height          =   2415
   Left            =   5205
   LinkTopic       =   "Form1"
   ScaleHeight     =   134
   ScaleMode       =   3  'sNZ
   ScaleWidth      =   217
   Top             =   705
   Width           =   3375
   Begin PictureBox PicBitmaps 
      AutoRedraw      =   -1  'True
      BorderStyle     =   0  'Ȃ
      Height          =   615
      Left            =   360
      ScaleHeight     =   615
      ScaleWidth      =   375
      TabIndex        =   6
      Top             =   120
      Visible         =   0   'False
      Width           =   375
   End
   Begin PictureBox picTemp 
      AutoRedraw      =   -1  'True
      BorderStyle     =   0  'Ȃ
      Height          =   615
      Index           =   0
      Left            =   120
      ScaleHeight     =   615
      ScaleWidth      =   135
      TabIndex        =   5
      Top             =   120
      Visible         =   0   'False
      Width           =   135
   End
   Begin CommandButton cmdRedraw 
      Caption         =   "&Redraw"
      Default         =   -1  'True
      Height          =   495
      Left            =   120
      TabIndex        =   4
      Top             =   1440
      Width           =   855
   End
   Begin CommandButton cmdCancel 
      Caption         =   "&Cancel"
      Height          =   495
      Left            =   2160
      TabIndex        =   3
      Top             =   1440
      Width           =   855
   End
   Begin CommandButton cmdOK 
      Caption         =   "&OK"
      Height          =   495
      Left            =   1200
      TabIndex        =   2
      Top             =   1440
      Width           =   855
   End
   Begin TextBox txtBitcnt 
      Height          =   285
      Left            =   2280
      TabIndex        =   1
      Text            =   "1"
      Top             =   840
      Width           =   375
   End
   Begin Image ImgBitmaps 
      Height          =   615
      Left            =   120
      Stretch         =   -1  'True
      Top             =   120
      Width           =   2535
   End
   Begin Label Label1 
      Caption         =   "Enter number of bitmap images in this file:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   840
      Width           =   2055
   End
End
Sub cmdCancel_Click ()
'cancel file open operation

 frmOpen.Tag = ""     'no file was selected
 frmOpen.Hide         'hide this Open dialog box

End Sub

Sub cmdOK_Click ()
'return name of selected file in tag property of the form

If txtBitcnt.Text = "" Then         'check if a file was selected
 Beep                                    'if not, beep and display error message
 MsgBox ("Please enter how many bitmap images are contained in this picture.")
Else
 frmOpen.Tag = txtBitcnt.Text        'set file name to form's tag
 procCutBit                          'divide image to each corresponding images
 frmOpen.Hide                        'hide Open dialog
End If

End Sub

Sub cmdRedraw_Click ()
 
 Form_resize        'readjust Open dialog form size and redraw selected bitmap image

End Sub

Sub Form_Activate ()
 ImgBitmaps.Picture = LoadPicture(frmGetFile.Tag)     'display content of selected BMP file
 ImgBitmaps.Refresh
End Sub

Sub Form_Load ()
 
 ImgBitmaps.Width = Val(frmMain.Tag)      'Set width of object to value entered in Item Height of main form
 ImgBitmaps.Height = Val(frmMain.Tag)     'set height = width of object

End Sub

Sub Form_resize ()
'check if all bitmap images are displayed on screen.
'if not, enlarge form size so they will be displayed

 ImgBitmaps.Width = Val(frmMain.Tag) * Val(txtBitcnt.Text)
 
'check horizontally
 If (ImgBitmaps.Left + ImgBitmaps.Width) * screen.TwipsPerPixelX > frmOpen.Width Then
   frmOpen.Width = (ImgBitmaps.Width) * screen.TwipsPerPixelX + (ImgBitmaps.Left * screen.TwipsPerPixelX) * 3
 End If

'check vertically
 If frmOpen.Height < (ImgBitmaps.Height * screen.TwipsPerPixelY * 5) Then
   frmOpen.Height = ImgBitmaps.Height * screen.TwipsPerPixelY * 5
 End If

 ImgBitmaps.Refresh   'redraw image

End Sub

Sub procCutBit ()
'separate bitmap image to number of bitmap images to picTemp array objects
'these separated bitmap images are later copied to the images in status bar

picBitmaps.Top = ImgBitmaps.Top          'Move picBitmaps over to ImgBitmaps
picBitmaps.Left = ImgBitmaps.Left
picBitmaps.Width = ImgBitmaps.Width
picBitmaps.Height = ImgBitmaps.Height
picBitmaps.Picture = ImgBitmaps.Picture

picTemp(0).Top = ImgBitmaps.Top

For cnt = 0 To txtBitcnt - 1             'Separate bitmap images
 If cnt > 0 Then                           'Create new bitmap object
  Load picTemp(cnt)
 End If
 picTemp(cnt).Left = ImgBitmaps.Left + Val(frmMain.Tag) * cnt    'set position of object to go underneath corresponding bitmap image
 picTemp(cnt).Width = Val(frmMain.Tag)      'set width of object
 picTemp(cnt).Height = ImgBitmaps.Height    'set height = width of object
                                            'copy bitmap image to picTemp() array
 rtncode = BitBlt(picTemp(cnt).hDC, 0, 0, picTemp(0).Width, picTemp(0).Height, picBitmaps.hDC, picBitmaps.Width / Val(txtBitcnt.Text) * cnt, 0, SRCCOPY)
Next

End Sub

Sub txtBitcnt_KeyPress (KeyAscii As Integer)
'when number of bitmaps in a file is changed, change image width and redisplay it

If KeyAscii = 13 Then         'check if Enter key was pressed
 txtBitcnt_LostFocus              'redraw image to new size
End If

End Sub

Sub txtBitcnt_LostFocus ()
 
Form_resize          'resize the form and redisplay it

End Sub

