/******************************************************************/
/* INSTALL.CMD Workplace Security installation utility            */
/*                                                                */
/* Workplace Security Copyright (C) 1995 by Maple Valley Software */
/******************************************************************/
  
'@Echo Off'

/* Set the installation variables */

Title = 'Workplace Security'

file.1  = 'README.DOC'         /* Readme instructions       */
file.2  = 'INSTALL.CMD'        /* installation cmd            */
file.3  = 'INSTALL.DOC'        /* installation doc             */
file.4  = 'ORDER.DOC'          /* order form                  */
file.5  = 'REGISTER.EXE'       /* registration program        */
file.6  = 'ACTIVATE.EXE'       /* activation program          */
file.7  = 'DEINSTAL.CMD'       /* deinstallation utility       */
file.8  = 'REMOVE.EXE'       /* removal program             */
file.9  = 'WPSECURE.DOC'       /* WPSecure documentation */
file.10 = 'WPSECUG.INF'          /* WPSecure User Guide    */
file.11 = 'WPSECURE.HLP'       /* WPSecure Help file     */
file.12 = 'WPSECURE.DLL'       /* WPSecure Class library */
 
files = 12                         /* total files to install */

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initialize */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

/* get current directory */

Result = SysFileTree('WPSECURE.DLL', 'Dirs', 'O' )
If Dirs.0 = 0 Then Do
  Say 'Change to the directory or diskette drive containing'
  Say 'the Workplace Security files to be installed.' 
  exit
  End

current_directory = directory()


Call SysCls
say ' '
say ' '
say ' '
Say 'Installing 'Title '...'
Say ' '

/* Verify that all files are present */

n = 1
do files
Result = SysFileTree( file.n, 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR:' file.n 'not found!'
  Signal DONE
  End
n = n + 1
End


/* Find the drive for the d:\OS2\DLL directory */

Drives = SysDriveMap(C,'LOCAL')
   do words(drives)
      parse var drives drive drives
      directory = drive||'\OS2\DLL'
      Result = SysFileTree(Directory,'Dirs','D')
      If Dirs.0 > 0 Then signal ASKDRIVE
      end

Directory = 'C:\OS2\DLL'

/* Ask for the boot drive */
ASKDRIVE:
Say 'Please enter the drive letter of your'
Say 'OS/2 boot drive. (default' drive ')'
Say ' '
Parse upper pull bootdrive ':' .

if bootdrive = "Q" Then signal DONE
If bootdrive > "" Then drive  = bootdrive||':'


/* Verify the d:\OS2\DLL directory exists. */
Result = SysFileTree( drive||"\OS2\DLL", 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Say ' '
  Say 'OS/2 could not be found on drive' drive||':'
  Say ' '
  Signal ASKDRIVE
  End


/* Create the target directory for the other WPSECURE files */

Directory = drive||'\WPSECURE'

/* Ask for the WPSECURE directory name. */
Say ' '
Say 'Please enter the full name of the directory where you'
Say 'want Workplace Security installed (default' Directory '):'
Say 'Press Enter for default or type Q to Quit'
Say ' '
Parse upper pull Direct

if Direct = "Q" Then signal DONE
If Direct > "" Then Directory = Direct

/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory.'
    Signal DONE
    End
  End

Say ''
/* Perform the installation. */

n = 1
do files
If Directory = current_directory Then nop
Else
  Do
  Say 'Copying' file.n ' to ' Directory '...'
  Copy file.n Directory                   '1>NUL'
  n = n + 1
  End
End

/* change to installed directory */

install_drive = filespec("drive",directory)

call directory(directory)

Result = SysFileTree(install_drive||'\OS2\DLL\WPSECURE.DLL', 'Dirs', 'O' )
If Dirs.0 = 0 Then Do 
   /* doing first time install */
   Say  "Copying WPSECURE.HLP to  "drive||"\OS2\HELP"
   Copy "WPSECURE.HLP" drive||"\OS2\HELP" '1>NUL'
   Say  "Copying WPSECURE.DLL to  "drive||"\OS2\DLL" 
   Copy "WPSECURE.DLL" drive||"\OS2\DLL"  '1>NUL'
   End
Else Do /* Perform upgrade */
   fStartupExists = 0
   SAY 'Upgrading Workplace Security'
   call directory(install_drive||'\')
   startup_cmd = drive||'STARTUP.CMD'
   wpsecure_cmd = directory||"\WPSECURE.CMD"
   callcmd = "call "wpsecure_cmd
   Result = SysFileTree(drive||'\STARTUP.CMD', 'Dirs', 'O' )
   If Dirs.0 <> 0 Then Do
         fStartupExists = 1
         copy "STARTUP.CMD STARTUP.WPS 1>NULL"  /* save current startup.cmd */
         "DEL STARTUP.CMD"   
         startup_cmd = drive||'STARTUP.CMD'
         End
   rc = lineout(startup_cmd,callcmd)
   rc = lineout(startup_cmd) /* close the file */
   Result = SysFileTree(wpsecure_cmd, 'Dirs', 'O' )
   If Dirs.0 <> 0 Then Do
        'DEL' wpsecure_cmd
         End
   rc = lineout(wpsecure_cmd,'@echo off')
   rc = lineout(wpsecure_cmd,'echo Upgrading Workplace Security')
   rc = lineout(wpsecure_cmd,'COPY' directory||'\WPSECURE.DLL' drive||'\OS2\DLL 1>NULL')
   rc = lineout(wpsecure_cmd,'COPY' directory||'\WPSECURE.HLP' drive||'\OS2\HELP 1>NULL')
   if fStartupExists = 1 then do   
          rc = lineout(wpsecure_cmd,'COPY STARTUP.WPS STARTUP.CMD 1>NULL')
          rc = lineout(wpsecure_cmd,'DEL STARTUP.WPS')
          rc = lineout(wpsecure_cmd,'CALL' drive||"\STARTUP.CMD")  
          End
   Else Do 
          rc = lineout(wpsecure_cmd,'DEL STARTUP.CMD')  
          rc = lineout(wpsecure_cmd,'Exit')
          End
   rc = lineout(wpsecure_cmd)   /* close the file */
   End

call directory(directory)

Say ''
Say 'Creating 'Title 'Folder on desktop' 
Result = SysCreateObject( "WPFolder", "Workplace Security", "<WP_DESKTOP>", "OBJECTID=<WP_SECURE>","REPLACE")
if Result = 0  then do
   say 'Error creating 'Title 'Folder'
   exit(1)
   end

Say 'Adding WPS Security program objects to folder...'
Type = 'WPProgram'
Folder = '<WP_SECURE>'
Title = 'Workplace Security Registration'
Parms = "PROGTYPE=PM;EXENAME="Directory"\REGISTER.EXE;STARTUPDIR="Directory";OBJECTID=<Register>;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 0 Then
  Say 'ERROR:' Title ' program object not created.'

Title = 'Workplace Security User Guide'
Parms = "PROGTYPE=PM;EXENAME="Drive"\OS2\VIEW.EXE;STARTUPDIR="Directory";PARAMETERS="Directory||"\WPSECUG.INF;OBJECTID=<UserGuide>"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 0 Then
  Say 'ERROR:' Title ' program object not created.'

Type = 'WPProgram'
Folder = '<WP_SECURE>'
Title =  'Workplace Security order form'
Parms = "EXENAME="drive||"\OS2\APPS\EPM.EXE;PARAMETERS="directory||"\ORDER.DOC;OBJECTID=<Orderform>;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 0 Then
  Say 'ERROR:' Title ' program object not created.'

Say 'Program objects created successfully'

Say 'Activating Workplace Security'
'ACTIVATE'
if rc > 1 then do
  say 'Activate Failed, rc='rc 'See INSTALL.DOC for help'
  exit
  end  /* Do */
say ' '
Say ' '
Say 'Shutdown and Re-boot to enable Workplace Security'
Say ' '
Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
