/* An example of a multiple windows. It creates a Main Window with a Push button
    Group in it.  Whenever one of the buttons are pushed, this causes RXDLG to
    return (ie, the Group has its END flag set).  I then open a window appropriate
    to that button (ie, the window title becomes the string "Window XXX" where
    XXX is the selected button number.	Of course, if that window is already
    open, then I don't open it again. In that case, I close the window.
    Note that my message loop has to take into account all of those possibly
    open windows by checking RXWIND for that. Oh yeah, the Groups that we put
    into the Child Dialogs is really trivial. Each window just gets 1 RESULT
    Button Group with an OK in it.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* ================ Create "Main Window" dialog =============== */
/* First Group is PUSH */
RXTYPE.1 = 'PUSH'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END'

/* Labels for each button, and Groupbox */
RXLABEL.1 = 'One|Two|Three|Four|Windows'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '4 2 0'

/* Default choice for PushButton is nothing */
RXVAL.1 = ''

/* Position */
RXX.1 = 16
RXY.1 = 10

RXWIN.0 = ' '

/* NOCLOSE since we'll close the window ourselves */
RXDLG 1 '"Main Window"' 'RXWIN.0' 'NOCLOSE'

/* Initialize the Dimensions strings for the 4 child windows. Rexx Dailog
 automatically updates these whenever the dialog is closed */
RXWIN.1 = '110 60 60 60'
RXWIN.2 = '110 60 70 70'
RXWIN.3 = '110 60 90 90'
RXWIN.4 = '110 60 110 110'

/* ============= Message loop on the dialog windows ============ */
more:
   /* Do user interaction. We go to sleep until RXDLG returns */
   RXDLG

   /* Did user press ESC or click on the CLOSE ICON? */
   IF RXID < 0 THEN DO

      /* If the Main Window, then close down our app. All windows and devices
	 that we opened are automatically closed down */
      IF RXWIND = 'Main Window' THEN EXIT

   END

   /* User didn't abort */

   ELSE SELECT
       /* ================ Main Window ================= */
       WHEN RXWIND = "Main Window" THEN DO
	   /* Make the Child Dialog window title */
	   title = 'Window '||RXVAL.1

	   /* Check if this window is already open */
	   RXQUERY '"'title'"'

	   /* If the window is open, close it */
	   IF RC = 1 THEN RXDLG '"'title'"' 4

	   /* Otherwise, open it */
	   ELSE DO
	       /* First Group is RESULT */
	       RXTYPE.1 = 'RESULT'

	       /* Default */
	       RXFLAGS.1 = ' '

	       /* No Groupbox */
	       RXLABEL.1 = ' '

	       /* OK button */
	       RXINFO.1 = '2'

	       /* Position */
	       RXX.1 = 7
	       RXY.1 = 6

		/* Use a stem variable for the Dimensions string, where
		   the stem is the window #. That way, each window has its own
		   dimensions string */
		name = 'RXWIN.'||RXVAL.1

		/* Present child */
		RXDLG 1 '"'title'"' name 'NOCLOSE|RESULT'
	   END
       END

       /* =============== "Window 1" Dialog ================ */
       WHEN RXWIND = "Window 1" THEN DO
	   RXSAY RXWIND
       END

       /* =============== "Window 2" Dialog ================ */
       WHEN RXWIND = "Window 2" THEN DO
	   RXSAY RXWIND
       END

       /* =============== "Window 3" Dialog ================ */
       WHEN RXWIND = "Window 3" THEN DO
	   RXSAY RXWIND
       END

       /* =============== "Window 4" Dialog ================ */
       WHEN RXWIND = "Window 4" THEN DO
	   RXSAY RXWIND
       END

   END

   /* Close the Window if it's not the Main Window. Note that we
       wouldn't need this if we omitted the NOCLOSE Flag on our
       Child Dialogs */
   IF RXWIND \= "Main Window" THEN RXDLG '"'RXWIND'"' 4

/* Do another message loop */
SIGNAL more

/* =================================================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
