/* */
CALL ON FAILURE
CALL ON ERROR

/* Cause an error with Rexx Dialog's RXDLG command. (We're trying to perform
    an END operation upon a dialog that doesn't exist. We should get the
    "Can't find Rexx Dialog' error message returned). We get an error string
    back, and also Rexx Dialog automatically displays a message box, because
    those are the defaults */
RXDLG 'my window'
RXSAY 'RC = 'RC

/* Do the same error, but this time ask to be returned an error number. We
    haven't changed the default severity level, so Rexx Dialog is still going
    to display that message box */
RXERR 'NUM'
RXDLG 'my window'
RXSAY 'RC = 'RC

/* Do the same error, but this time change the severity level to 0. We're
    going to get the error message returned, but Rexx Dialog isn't going
    to display that message box */
RXERR '0'
RXDLG 'my window'
RXSAY 'RC = 'RC

/* Do the same error, but this time change the severity level to 0 and ask
    for an error number return. Again, Rexx Dialog isn't going to display
    that message box */
RXERR '0|NUM'
RXDLG 'my window'
RXSAY 'RC = 'RC

/* Let's ask for FULL error messages. When the error occurs on this call to
    RXDLG, Rexx Dialog will post a REXX INTERPRETER ERROR message box
    (actually two; one containing the line # where the error occurred, and
    your REXX statement, which is "RXDLG 'my window'" for this example, and
    then a second message box containing the error message returned by Rexx
    Dialog which will be 'Can't find Rexx Dialog' for this example. Note: We
    CALL ON FAILURE when we have 'FULL' on. The preceding errors with
    RXDLG caused the CALL ON ERROR. The RC we get back is the "Can't
    find Rexx Dialog" error message, because we didn't ask for NUM. */
RXERR 'FULL'
RXDLG 'my window'
RXSAY 'RC = 'RC

/* Same thing as above, but this time give me an error number back */
RXERR 'FULL|NUM'
RXDLG 'my window'
RXSAY 'RC = 'RC

/* Send a command to OS/2. In this case, we're asking it to execute the
    'hello' program. It probably won't find any such executable, and so REXX
    will force a FAILURE and Rexx Dialog will post that 2 part message box,
    but with a return string or number that OS/2 returned. You really have no
    control over the error display and return type that is generated by other
    than calls to Rexx Dialog commands. For this, you're always going to
    see the REXX INTERPRETER ERROR message box regardless of how
    you set RXERR. RXERR only controls the error return/display behavior
    of Rexx Dialog functions */
ADDRESS CMD 'hello'

/* Example of a syntax error. Uncomment and run script. Rexx Dialog will post
    a REXX INTERPRETER ERROR message box containing some error message
    provided by the interpreter (which also provides the value of RC). Then the
    interpreter will halt the script due to a fatal error. Actually, the script will
    never even execute the preceding instructions, because REXX checks the
    syntax before running the script */
/* RXSAY 'Hello" */
EXIT

/* These simply return so that we can see all of the errors happening
     without the script coming to an end after the first error */
FAILURE:
   RETURN
ERROR:
   RETURN
