/**********************************************************/
/*                                                        */
/*  PopCliD.cmd - popclient Daemon                        */
/*  (C) Copyright Claudio Fahey, 1994                     */
/*  e-mail: claudio@uclink.berkeley.edu                   */
/*                                                        */
/*  Procedures GetArg, ArgCheck, and Help and minor       */
/*  other changes:                                        */
/*  Clark K. Gaylord (cgaylord@vt.edu)                    */
/*  Version 2.21a: 18 January 1995                        */
/*          2.21b: 25 March 1995                          */
/*          2.21c:  8 April 1995                          */
/*                                                        */
/**********************************************************/
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

/**********************************************************/
/*  New argument processing.  I moved Claudios' original  */
/*  to the bottom with label 'Changed:'.             CKG  */
/**********************************************************/
PARSE ARG Args
IF (Pos( '-?', Args )>0) THEN SIGNAL HELP
CALL GetArg Args

/*  Can we use PMPOPUP? */
popupexe = SysSearchPath( 'PATH', 'pmpopup.exe')
IF (popupexe='') THEN
   PopUp = 0
ELSE
   PopUp = 1

/*  Is it POPCLIEN.EXE or POPCLIENT.EXE?  */
PopClient = SysSearchPath( 'PATH', 'popclient.exe')
IF (PopClient = '') THEN
   PopClient = SysSearchPath( 'PATH', 'popclien.exe')
IF (PopClient = '') THEN DO
    IF (PopUp) THEN
        "@start pmpopup Could not find POPCLIENT executable."
    ELSE
        SAY 'Could not find POPCLIENT executable.'
    EXIT
END

IF ((Mailer='U') | (Mailer='u')) THEN DO
    mda_path = 'UMAILER.EXE'
    mda_args = '-dest' inbasket '-to $u'
END
ELSE DO
    mda_path = value('COMSPEC',,'OS2ENVIRONMENT')
    mda_args = '/C e:\tcpip\pop\LAMAILER.CMD -dest' inbasket '-to $u'
END

signal on halt  /* don't display REXX error message when user breaks out */

/**********************************************************************
   When mail arrives, popclient runs the mail delivery agent
   specified by MDA_PATH with arguments MDA_ARGS.  This
   sets the environment to the correct MDA
**********************************************************************/
rc = value('MDA_PATH',mda_path,'OS2ENVIRONMENT')
rc = value('MDA_ARGS',mda_args,'OS2ENVIRONMENT')

counter = 0
do until (delay=0 | counter>10)
    say time()
    '@e:\tcpip\pop\popclient -u' loginname '-p' password host

    /* If there's an error, just beep and continue */
    if rc > 1 then do
       IF (PopUp) THEN
          "@start pmpopup POPCLID.CMD: POPCLIENT.EXE returned error ("rc")"
       ELSE
           say 'POPCLID.CMD: POPCLIENT.EXE returned error ('rc')'
       call beep 400, 500
       counter = counter + 1
       end
    else
       counter = 0

    /* wait for a specified number of seconds */
    call syssleep delay
    end

IF (counter>0) THEN DO
    IF (PopUp) THEN
       "@start pmpopup POPCLID.CMD aborted with too many errors."
    ELSE
        say 'POPCLID.CMD aborted with too many errors.'
END

halt:
   exit

GetArg:
PARSE ARG 1 '-h' host .  1 '-l' loginname .  1 '-p' password . ,
          1 '-d' delay . 1 '-b' inbasket .   1 '-m' mailer . ,
          1 '-u' user .

host      = ArgCheck( host, 'POPHOST', '' )
loginname = ArgCheck( loginname, 'POPUSER', '' )
password  = ArgCheck( password, 'POPPASS', '' )
delay     = ArgCheck( delay, 'POPDELAY', '0' )
inbasket  = ArgCheck( inbasket, 'INBASKET', '.' )
mailer    = left( ArgCheck( mailer, 'MDA_PROG', 'LAMAIL' ), 1 )
user      = ArgCheck( user, 'USER', 'root' )

IF ((host='') | (loginname='') | (password='')) THEN SIGNAL HELP
RETURN

ArgCheck:
PARSE ARG RexxVar, OS2Var, Default
IF (RexxVar = '') THEN DO
   RexxVar = value(OS2Var,,'OS2ENVIRONMENT')
   IF (RexxVar = '') THEN
      RexxVar = Default
END
RETURN RexxVar

Help:
SAY 'POPCLID: OS/2 frontend for Carl Harris'' popclient'
SAY '   by Claudio Fahey and Clark Gaylord'
SAY ' '
SAY 'Usage:'
SAY 'popclid -h pophost -l loginname -p password [-d delay] [-b inbasket] [-m L|U]'
SAY '           [-u user]'
SAY ' '
SAY ' '
SAY 'The following environment variables can be used:'
SAY '   POPHOST  for pophost'
SAY '   POPUSER  for loginname'
SAY '   POPPASS  for password'
SAY '   POPDELAY for delay, defaults to 0, i.e., retrieve mail once only'
SAY '   INBASKET for inbasket, defaults to current directory,'
SAY '                should be SERVER''s inbox for UltiMail Lite.'
SAY '   MDA_PROG for mailer, LaMail or Ultimail, only first letter significant,'
SAY '                defaults to LaMail'
SAY '   USER     for Ultimail inbasket, defaults to root.'
SAY ' '
EXIT

Changed:
/**********************************************************************
   These lines are only for reference; the program never gets here.   
   CKG
**********************************************************************/
/*********************************************************/
/* Edit the following lines to configure this program:   */
/*********************************************************/
host = 'pop.server'                 /* POP host name                */
loginname = 'loginnameonpop'        /* Login name on the host       */
password = 'password'               /* Password on the host         */
delay = 600                         /* Seconds between mail checks  */
