/***********************************************************************\
 *                                PC2.c                                *
 *           Copyright (C) by Stangl Roman, 1993, 1994, 1995           *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * PC2.h        Program Commander/2 header file.                       *
 *                                                                     *
\***********************************************************************/

#ifndef IPFC                            /* Don't include if we compile HLP files */
#define         INCL_WIN                /* Environment include files */
#define         INCL_GPI
#define         INCL_DOS
#define         INCL_DOSERRORS
#define         INCL_DOSPROCESS
#include        <os2.h>

#include        <stdio.h>               /* C Set++ include files */
#include        <stdlib.h>
#include        <string.h>
#include        <ctype.h>
#include        <memory.h>
#endif /* IPFC */

/*                                                                     *\
 * Because the dialog editor takes the first macro definition of mul-  *
 * tiple definitions of the same value, we have to put the dialog      *
 + controls definition first.                                          *
\*                                                                     */

#define PIID_PROGRAMDIALOG      400     /* Program installation notebook dialog */
#define PINB_NOTEBOOK           401

#define PIID_PAGE1              402     /* First notebook page */
#define PIGRP_PROGRAM           403     /* Program data group */
#define PIEF_PROGRAMTITLE       404
#define PIEF_PATHFILENAME       405
#define PIEF_DIRECTORY          406
#define PIEF_PARAMETERS         407
#define PIMLE_DOSSETTINGS       408
#define PIPB_WINFILEDLG         409
#define PIPB_SETTINGSDLG        410

#define PIID_PAGE2              420     /* Second notebook page */
#define PIGRP_TYPE              421     /* Program type group */
#define PIRB_SHELL              422
#define PIRB_OS2FULLSCREEN      423
#define PIRB_OS2WINDOW          424
#define PIRB_PM                 425
#define PIRB_DOSFULLSCREEN      426
#define PIRB_DOSWINDOW          427
#define PIRB_WPSOBJECT          428
#define PIRB_WINOS2             429

#define PIGRP_WINOS2            440     /* Seamless WIN-OS2 settings */
#define PIRB_WINREAL            441
#define PIRB_WINSTANDARD        442
#define PIRB_WIN386ENHANCED     443
#define PICB_WINSEPARATE        444

#define PIID_PAGE3              460     /* Third notebook page */
#define PIGRP_STYLE             461     /* Program style group */
#define PIRB_DEFAULTSTYLE       462
#define PIRB_MAXIMIZED          463
#define PIRB_MINIMIZED          464
#define PICB_INVISIBLE          465
#define PICB_NOAUTOCLOSE        466
#define PICB_BACKGROUND         467
#define PICB_AUTOSTART          468
#define PIGRP_SIZEPOSITION      469     /* User defined size & position */
#define PICB_SIZEPOSITION       460
#define PIEF_X                  471
#define PIEF_Y                  472
#define PIEF_XSIZE              473
#define PIEF_YSIZE              474

#define PIID_PAGE4              480     /* Forth notebook page */
#define PIGRP_HOTKEY            481     /* Hotkey settings group */
#define PIEF_SESSIONTITLE       482
#define PICB_HOTKEYENABLED      483
#define PIRB_WSMAXIMIZED        484
#define PIRB_WSRESTORE          485
#define PIRB_NONE               486
#define PIRB_CTRL               487
#define PIRB_ALT                488
#define PICBX_HOTKEY            489
#define PIGRP_DESKTOP           490
#define PICB_DONTMOVE           491
#define PIGRP_WINDOWLIST        492
#define PILB_WINDOWLIST         493

#define PIID_PAGE5              500     /* Fifth notebook page */
#define PIGRP_PROCESSPRIORITY   501     /* Process priority */
#define PIRB_IDLETIME           502
#define PIRB_REGULAR            503
#define PIRB_NOCHANGE           504
#define PIRB_TIMECRITICAL       505
#define PIRB_FOREGROUNDSERVER   506
#define PIEF_PRIORITYDELTA      507
#define PIHSB_PRIORITYDELTA     508

#define PIID_PAGE6              510     /* Sixth notebook page */
#define PIGRP_ENVIRONMENT       511     /* Process environment */
#define PIMLE_ENVIRONMENT       512     /* Additions/Replacement of PC/2's environment for
                                           the started session */

#define PIID_EXAMPLE1           540
#define PIID_EXAMPLE2           541
#define PIID_EXAMPLE3           542
#define PIID_EXAMPLE4           543
#define PIID_EXAMPLE5           544

#define ADID_ABOUTDIALOG        550     /* About program dialog */

#define DDID_DESKTOPDIALOG      600     /* Desktop configuration dialog */
#define DDNB_NOTEBOOK           601

#define DDID_PAGE1              620     /* First notebook page */
#define DDGRP_VIRTUALDESKTOP    621
#define DDCB_VIRTUALDESKTOP     622
#define DDCB_MOVEDESKTOP        623
#define DDCB_EXPANDWPS          624
#define DDCB_CLICK2MOVE         625
#define DDCB_OVERVIEW           626
#define DDSB_HORIZONTALDESKTOPS 627
#define DDSB_VERTICALDESKTOPS   628
#define DDEF_SCROLLPERCENTAGE   629
#define DDHSB_SCROLLPERCENTAGE  630
#define DDGRP_POPUP             631
#define DDRB_BUTTON1CLICK       632
#define DDRB_BUTTON1DBLCLK      633
#define DDCB_SELECTFIRSTITEM    634
#define DDGRP_SLIDINGFOCUS      635
#define DDCB_SLIDINGFOCUS       636
#define DDCB_PRESERVEZORDER     637
#define DDGRP_OVERVIEWWINDOW    638
#define DDCB_HIDETITLEBAR       639
#define DDCB_HIDESMARTICONBAR   640

#define DDID_PAGE2              650     /* Second notebook page */
#define DDGRP_PHYSICALDESKTOP   651
#define DDCB_BUTTON2ZORDER      652
#define DDCB_KEEPONTOP          653
#define DDCB_USESPOOLER         654
#define DDEF_DESKTOPNAME        655
#define DDEF_WINDOWLISTNAME     656
#define DDGRP_BACKGROUNDBITMAP  657
#define DDCB_BACKGROUNDBITMAP   658
#define DDEF_BACKGROUNDBITMAP   659
#define DDPB_WINFILEDLG         660
#define DDRB_BITMAPNORMAL       661
#define DDRB_BITMAPSCALED       662
#define DDRB_BITMAPTILED        663
#define DDSB_BITMAPTILEDCOUNT   664

#define DDID_PAGE3              680
#define DDGRP_GENERAL           681
#define DDCB_NORMALSHUTDOWN     682
#define DDCB_IGNOREAUTOSTART    683
#define DDCB_HOTKEY4PC2ONLY     684

#define CDID_CONFIGDIALOG       700     /* Configuration menu dialog */
#define CDGRP_PROGRAM           701     /* Submenu/Program installation group */
#define CDLB_MENUPROGRAM        702
#define CDID_LEVELUP            703
#define CDID_LEVELDOWN          704
#define CDID_ADDMENU            705
#define CDID_ADDPROGRAM         706
#define CDID_CHANGEENTRY        707
#define CDID_REMOVEENTRY        708
#define CDID_RESORT             709
#define CDID_ADDCONTROL         710

#define CDID_HELP_1             711     /* Help pages */
#define CDID_HELP_2             712

#define RDID_RESORTDIALOG       750     /* Resort menuentries dialog */
#define RDPB_MOVE               751     /* Move pushbutton */
#define RDGRP_SOURCEMENU        755     /* Move from menu */
#define RDLB_SOURCEMENU         756
#define RDGRP_DESTINATIONMENU   760     /* Move into menu */
#define RDLB_DESTINATIONMENU    761

#define MIID_MENUDIALOG         800     /* Menu installation dialog */
#define MIGRP_PROGRAM           801     /* Menu data group */
#define MIEF_MENUTITLE          802

#define MIID_HELP_1             810     /* Help page */

#define MDID_CONTROLDIALOG      850     /* PC/2 Menu-Control dialog */
#define MDGRP_CTRL              851
#define MDRB_CTRL_CONFIGMENU    852
#define MDRB_CTRL_CONFIGDESKTOP 853
#define MDRB_CTRL_ABOUT         854
#define MDRB_CTRL_SHUTDOWN      855
#define MDRB_CTRL_HELP          856
#define MDRB_CTRL_EXIT          857
#define MDRB_CTRL_SPOOLER       858
#define MDRB_CTRL_BRKSEPARATOR  859
#define MDRB_CTRL_SEPARATOR     860

#define SDID_SHUTDOWNDIALOG     900     /* OS/2 ShutDown dialog */
#define SDID_SHUTDOWNMESSAGE    901     /* Message diaplayed a ShutDown */

#define SUID_STARTUPDIALOG      950     /* Request parameters from user before launching
                                           an application */
#define SUTF_STARTUPPROGRAM     951     /* Application to be started */
#define SUTF_STARTUPINFO        952     /* Info to the user what to do */
#define SUTF_STARTUPPARAMETERS  953     /* Info to the user of current parameters */
#define SUEF_STARTUPPARAMETERS  954     /* Entryfield for user data */

#define WPID_WPS2PC2DIALOG      1000    /* WPS 2 PC2 dialog */
#define WPTF_EXTRACTEDOBJECTS   1001    /* Text for listbox */
#define WPLB_EXTRACTEDOBJECTS   1002    /* Listbox of WPS objects extracted */
#define WPTF_STATUSBITMAP       1003    /* Text for status bitmap */
#define WPBM_STATUSBITMAP       1004    /* Status bitmap */
#define WPBM_EMPTY              1005    /* First status bitmap (empty listbox) */
#define WPBM_FULL               1006    /* Second status bitmap (filled listbox) */
#define WPPB_CLEAR              1007    /* Clear all WPS objects extracted up to now */
#define WPPB_HELP               1008    /* Help */

/*                                                                     *\
 * Now we can safely define more macros with values already occuring   *
 * in the dialog controls definition, because the dialog editor only   *
 * takes the first definition.                                         *
\*                                                                     */

                                        /* Draw the reduced Virtual Desktop layout into the
                                           in memory presentation space to avoid flickering.
                                           For debugging purposes it may be useful to draw
                                           the same things directly into the client area's
                                           presentation space, to be able the see what the
                                           drawing does. So you may want to replace pHP->hpsMemory
                                           by hpsClient then. */
#ifdef  SLOWVIDEO
#define         HPSDRAW         hpsClient
#else
#define         HPSDRAW         pHP->hpsMemory
#endif /* SLOWVIDEO */

                                        /* PC/2 semaphore to avoid loading PC/2 twice */
#define         PC2_SEM "\\SEM32\\PC2_SEM.SEM"
#define         DESKTOP_CLASS   "#37"   /* Class name of the "Desktop" window handle (which
                                           is reserved in the Toolkit) but it's a container */

                                        /* Oveview window frame creation flags */
#define         FCF_OVERVIEWWINDOW          FCF_ICON | FCF_SIZEBORDER | FCF_TASKLIST | FCF_MENU | \
                                            FCF_TITLEBAR | FCF_HIDEBUTTON | FCF_ACCELTABLE |      \
                                            FCF_NOBYTEALIGN | FCF_AUTOICON
                                        /* Spooler window frame creation flags */
#define         FCF_SPOOLERWINDOW           FCF_ICON | FCF_SIZEBORDER | FCF_TITLEBAR |            \
                                            FCF_HIDEBUTTON | FCF_NOBYTEALIGN | FCF_AUTOICON
                                        /* WPS 2 PC/2 window frame creation flags */
#define         FCF_WPS2PC2WINDOW           FCF_BORDER | FCF_TITLEBAR | FCF_SYSMENU

                                        /* Define an additional session type of WPS object
                                           representing any object */
#define         PROG_WPSOBJECT              21
                                        /* Defined SSF_CONTROL_AUTOSTART additional to SSF_CONTROL_* */
#define         SSF_CONTROL_AUTOSTART       0x4000
#define         FAPPTYP_WINDOWSPROT31       0x1000
                                        /* Number of KEYDATA hotkeys defined for PC/2 */
#define         KEYDATACOUNT                72

#define         CLASSNAMESIZE               7
#define         SWP_MOVEWINDOWVISIBLE       0x20000000
#define         SWP_NOMOVE                  0x40000000
#define         SWP_MOVEWINDOW              0x80000000

                                        /* All notebook dialog pages that are loaden into any of
                                           PC/2's notebooks are 200 * 150 dialog units in size.
                                           This dialog units are used to size the notebook so that
                                           a notebook dialog page fits into the notebook area where
                                           dialogs are loaded into. The dialog window is somewhat
                                           larger as required on 8514/A and VGA displays to have
                                           some spare place to size the notebook within */
#define         NOTEBOOKPAGE_CX             200
#define         NOTEBOOKPAGE_CY             150

                                        /* Used for font selection */
#define         LCID_FONT                   1

#define         DRT_WPS2PC2                 "DRT_OBJECT"
#define         DRM_WPS2PC2                 "DRM_WPS2PC2"
#define         DRF_WPS2PC2                 "DRF_WPS2PC2"
#define         RMF_WPS2PC2                 "<"DRM_WPS2PC2","DRF_WPS2PC2">"

                                        /* Debug details flags */
#define         DEBUG_NO                    0
#define         DEBUG_LOW                   1
#define         DEBUG_ENTRY                 2
#define         DEBUG_FULL                  3

/*--------------------------------------------------------------------------------------*\
 *                                                                                      *
 * +-----+-----+-----+                                                                  *
 * | www |    www========== Some windows, only two seen by the user on the display.     *
 * | www |     |     |                                                                  *
 * +-----+-----www---+===== Virtual Desktop (9fold-size of physical Desktop).           *
 * |     | www wwww  |                                                                  *
 * |  +----www | ww  |                                                                  *
 * +--|ww  www-+-----+                                                                  *
 * |  |ww   |============== Physical Desktop somewhere within virtual Desktop. The      *
 * |  +-----+  |     |      physical Desktop is the part of the virtual Desktop which   *
 * +-----+-----+-----+      the user visually can see, therefor large parts of the      *
 *                          virtual Desktop can't be ssen by the user. He must use      *
 * his pointing device, the slide the physical Desktop around the virtual Desktop, by   *
 * moving the pointer over the surrounding rows and columns of the physical screen.     *
 *                                                                                      *
\*------------------------------------------------------------------------------------- */
                                        /* Status bits defined for bitmapped ulMoveFlag */
                                        /* Set if we move all windows right (our physical
                                           Desktop will move left on the virtual Desktop) */
#define         MOVEXR              0x0001
                                        /* Set if we move all windows left */
#define         MOVEXL              0x0002
                                        /* Set if we move all windows up (our physical
                                           Desktop will move down on the virtual Desktop */
#define         MOVEYU              0x0004
                                        /* Set if we move all windows down */
#define         MOVEYD              0x0008
                                        /* Set if we are to move all windows, but the
                                           CLICK2MOVE flag is set, and therefor we require
                                           a click before we really move */
#define         MOVED4CLICK         0x0010

                                        /* Status bits defined for bitmapped ulStatusFlag */
                                        /* Before writing ulStatusFlag to PC2.INI it is anded
                                           with WRITEMASK to write only permanent flags */
#define         WRITEMASK           0x00FFFFFF
                                        /* Permanent flags */
                                        /* Set if the user requested a sliding focus */
#define         SLIDINGFOCUS        0x00000001
                                        /* Set if the user requested a virtual Desktop */
#define         VIRTUALDESKTOP      0x00000002
                                        /* Set if the user also wants the WPS to move */
#define         MOVEDESKTOP         0x00000004
                                        /* Set if the user wants to click before Desktop
                                           moves */
#define         CLICK2MOVE          0x00000008
                                        /* Set if the user wants an overview window */
#define         OVERVIEW            0x00000010
                                        /* Set if sliding focus should preserve the Z-order of
                                           the windows */
#define         PRESERVEZORDER      0x00000020
                                        /* Set if mouse button 2 click downs on titlebars should
                                           set the window to the bottom of all windows */
#define         BUTTON2ZORDER       0x00000040
                                        /* Set if overview window should be the topmost window,
                                           even when another window has the focus */
#define         KEEPONTOP           0x00000080
                                        /* Set if the WPS should be expanded to the whole Virtual Desktop */
#define         EXPANDWPS           0x00000100
                                        /* Set if a bitmap is set for PM Background */
#define         BACKGROUNDBITMAP    0x00000200
                                        /* Set if the first item of the Popup-Menu should be selected */
#define         SELECTFIRSTITEM     0x00000400
                                        /* Set if the user wants to hide PC/2's titlebar */
#define         HIDETITLEBAR        0x00000800
                                        /* Set if the user wants to hide PC/2's smarticon bar */
#define         HIDESMARTICONBAR    0x00001000
                                        /* Set if the user wants PC/2's Spooler Window even when
                                           PC/2 is running on top of the WPS */
#define         SHOWSPOOLERWINDOW   0x00002000
                                        /* Set if the user wants normal OS/2 shutdown, that is
                                           the user gets asked as you would select shutdown from
                                           the WPS's conext menu */
#define         NORMALSHUTDOWN      0x00004000
                                        /* Set if Autostart should be ignored when invoking PC/2
                                           (e.g. for debugging purposes) */
#define         IGNOREAUTOSTART     0x00008000
                                        /* Set if Hotkeys should be detected only when either PC/2,
                                           the Window List or the WPS has the focus */
#define         HOTKEY4PC2ONLY      0x00010000

                                        /* Flags only used during PC/2 running */
                                        /* Set if /INSTALL commandline parameter was given */
#define         INSTALLATIONHELP    0x01000000
                                        /* Set when configuration dialog should be displayed,
                                           because Popup-Menu is empty */
#define         DISPLAYCONFIGDIALOG 0x02000000
                                        /* Set when used closed PC/2 via Window List, in this case
                                           ignore current WM_QUIT to shutdown PC/2 which than posts
                                           WM_QUIT to itself again */
#define         QUITFROMWINDOWLIST  0x04000000
                                        /* Set when PC/2 is the WPS process running */
#define         PC2RUNNINGASWPS     0x08000000
                                        /* Set when a internal error forces us to close PC/2 */
#define         PC2EMERGENCYEXIT    0x10000000
                                        /* Set when the Spooler or PMSPL.DLL can't be accessed */
#define         PC2SPOOLERERROR     0x20000000

                                        /* Background bitmap style flag (lower USHORT contains tile count */
                                        /* Normal style */
#define         BITMAPNORMAL        0x00010000
                                        /* Scaled */
#define         BITMAPSCALED        0x00020000
                                        /* Tiled */
#define         BITMAPTILED         0x00040000

                                        /* Bitmapped flag for ulThreadReady flag, that is used by
                                           the client window procedure to serialize access to the
                                           working thread, to avoid queueing of work */
                                        /* Working thread is just doing his work of enumerating
                                           windows for new, moved, sized or destroyed windows  */
#define         THREADWINDOWBUSY    0x00000001
                                        /* Working thread is just doing his work of moving from
                                           one Virtual Desktop to another */
#define         THREADMOVEBUSY      0x00000002
                                        /* Working thread was busy when more window enumeration
                                           requests were available, save fact and do the work
                                           when not busy */
#define         THREADWINDOWQUEUED  0x00000004

/*--------------------------------------------------------------------------------------*\
 *                                                                                      *
 * Style definitions for DrawWindow() functions.                                        *
 *                                                                                      *
\*------------------------------------------------------------------------------------- */

#define         BACKGROUND_WND  0x0001  /* Set for 3D effect of a deeper than surface window */
#define         FOREGROUND_WND  0x0002  /* Set for 3D effect of a higher than surface window */
#define         BORDERONLY_WND  0x0001  /* Set if only the border of a window should be drawn */

#define         VISIBLE         0x01    /* Set if window visible on overview window */
#define         FRAMECLASS      0X02    /* Set if window has a known frame class */

#define         EF_SIZE255      255
#define         LENDOSSETTINGS  8192    /* Length of all DOS settings of a session */
#define         LENENVSETTINGS  8192    /* Lenght of user added/replaced environment */
#define         LENENVENTRY     1024    /* Length of a single EnvironmentVariable=Value entry */

typedef struct  _SESSIONDATA            SESSIONDATA;
typedef struct  _MENUDATA               MENUDATA;
typedef struct  _COMMANDLINEPARAMS      COMMANDLINEPARAMS;
typedef struct  _HOOKPARAMETERS         HOOKPARAMETERS;
typedef struct  _NBPAGE                 NBPAGE;
typedef struct  _KEYDATA                KEYDATA;
typedef struct  _WINDOWDATA             WINDOWDATA;
typedef struct  _WINDOWS                WINDOWS;
typedef struct  _SPOOLERRECORD          SPOOLERRECORD;
typedef struct  _SPOOLEROBJECT          SPOOLEROBJECT;
typedef struct  _WPSOBJECTLIST          WPSOBJECTLIST;

                                        /* OS/2 3.00 WAPR+ supports the new APIs DosSetExtLIBPATH
                                           (DOSCALL1.998) and DosQueryExtLIBPATH (DOSCALL1.999)
                                           to dynamically modify the search sequence for locating
                                           dynamic link libraries (DLLs). PC/2 tries dynamic linking
                                           of these APIs, instead of statically linking, for
                                           compatibility with OS/2 2.x.
                                           To my surprise, these APIs seem to be in a 16:16 segment,
                                           APIENTRY does not work (at the time I write this I have
                                           no documentation that emphasis or denys this)  */
#define         BEGINLIBPATH    1
#define         ENDLIBPATH      2
typedef APIRET  (APIENTRY16 DOSSETEXTLIBPATH)     (PSZ pszExtLIBPATH, ULONG ulFlags);
typedef APIRET  (APIENTRY16 DOSQUERYEXTLIBPATH)   (PSZ pszExtLIBPATH, ULONG ulFlags);

typedef void    (EXPENTRY PFFUNCPTR1)   (void);
typedef BOOL    (EXPENTRY PFFUNCPTR2)   (HAB hab, PQMSG pqmsg, ULONG option);
typedef void    (EXPENTRY PFFUNCPTR3)   (HAB hab, PSMHSTRUCT pSmh, BOOL bInterTask);
typedef PCH     (EXPENTRY PFFUNCPTR4)   (HWND hwndClient, HWND hwnd, PSZ pcIn, USHORT usIn,\
                                         USHORT *pusOut, USHORT *pusWinMode);
typedef ULONG   (EXPENTRY PFFUNCPTR5)   (HMODULE hDLLPc2Hook);

#define         ENTRYSUBMENU    0       /* Popup-Menu entry is a (sub)menu */
#define         ENTRYMENUITEM   1       /* Popup-Menu entry is a program */
#define         ENTRYCONTROL    2       /* Popup-Menu entry is a PC/2 configuration control */
#define         ENTRYEMPTY      3       /* Popup-Menu entry is empty */

#define         WPSOBJECTPROGRAM 0      /* WPSOBJECTLIST entry for WPProgram Objects */
#define         WPSOBJECTFOLDER 1       /* WPSOBJECTLIST entry for WPFolder Objects */
#define         WPSOBJECTOBJECT 2       /* WPSOBJECTLIST entry for any other WPS Objects */

#define         CTRL_CONFIGMENU         "Config ~Menu"
#define         CTRL_CONFIGDESKTOP      "Config ~Desktop"
#define         CTRL_ABOUT              "~About PC/2"
#define         CTRL_SHUTDOWN           "~ShutDown OS/2"
#define         CTRL_HELP               "~Help\tF1"
#define         CTRL_EXIT               "E~xit\tF3"
#define         CTRL_SPOOLER            "PC/2 Spoo~ler"
#define         CTRL_BREAKSEPARATOR     "-- Vert. Break --"
#define         CTRL_SEPARATOR          "--- Separator ---"

#define         PAGE_1          0       /* Index of 1st notebook page */
#define         PAGE_2          1
#define         PAGE_3          2
#define         PAGE_4          3
#define         PAGE_5          4
#define         PAGE_6          5

struct  _KEYDATA                        /* Structure that defined 1 hotkey */
{
USHORT          usFlags;                /* Keyboard control codes: KC_CTRL, KC_ALT,... */
USHORT          usCh;                   /* Keyboard character value: 0, 1,... */
UCHAR           ucScanCode;             /* Keyboard character scan code */
BOOL            bUsed;                  /* True if this hotkey is defined */
MENUDATA        *pMenuData;             /* Pointer to MenuData structure where is Hotkey
                                           is defined */
};

struct _SESSIONDATA                     /* Control structure to start a new session */
{
ULONG           id;                     /* Session ID for menu ressources */
UCHAR           PgmTitle[MAXNAMEL+1];   /* Session title */
                                        /* Session (sub)title on window's titlebar */
UCHAR           WindowTitle[MAXNAMEL+1];
UCHAR           PgmName[EF_SIZE255+1];  /* Session path and filename */
                                        /* Session working directory */
UCHAR           PgmDirectory[EF_SIZE255+1];
                                        /* Session parameter */
UCHAR           PgmInputs[EF_SIZE255+1];
PSZ             PgmDosSettings;         /* DOS Settings for OS/2 DOS and WIN-OS2 sessions */
PSZ             PgmEnvironment;         /* Optional environment addition/replacement of environment
                                           inherited from PC/2 to the started application */
USHORT          SessionType;            /* Session type */
USHORT          PgmControl;             /* Session control */
USHORT          FgBg;                   /* Start session in foreground/background */
SHORT           InitXPos;               /* X position */
SHORT           InitYPos;               /* Y position */
SHORT           InitXSize;              /* X size */
SHORT           InitYSize;              /* Y size */
KEYDATA         KeyData;                /* Hotkey data, if none defined, usCh=0, bUsed=0, pMenuData=NULL */
ULONG           SwpFlag;                /* Activation on hotkey SWP flag: SWP_RESTORE or SWP_MAXIMIZE,
                                           SWP_NOMOVE */
USHORT          PriorityClass;          /* Priority Class */
SHORT           PriorityDelta;          /* Priority Delta */
};

struct _MENUDATA                        /* Control structure to build popup menu */
{
USHORT          Item;                   /* MENUITEM or SUBMENU */
HWND            hwndItem;               /* Window handle within Popup-Menu */
ULONG           id;                     /* Session ID for menu ressources */
PSZ             PgmTitle;               /* Session title */
PSZ             WindowTitle;            /* Session (sub)title on window's titlebar */
PSZ             PgmName;                /* Session path and filename */
PSZ             PgmDirectory;           /* Session working directory */
PSZ             PgmInputs;              /* Session parameter */
PSZ             PgmDosSettings;         /* Session settings for DOS applications */
PSZ             PgmEnvironment;         /* Session environment settings */
USHORT          SessionType;            /* Session type */
USHORT          PgmControl;             /* Session control */
USHORT          FgBg;                   /* Start session in foreground/background */
SHORT           InitXPos;               /* X position */
SHORT           InitYPos;               /* Y position */
SHORT           InitXSize;              /* X size */
SHORT           InitYSize;              /* Y size */
KEYDATA         KeyData;                /* Hotkey data, if none defined, usCh=0, bUsed=0, pMenuData=NULL */
ULONG           SwpFlag;                /* Activation on hotkey SWP flag: SWP_RESTORE or SWP_MAXIMIZE,
                                           SWP_NOMOVE */
USHORT          PriorityClass;          /* Priority Class */
SHORT           PriorityDelta;          /* Priority Delta */
MENUDATA        *Back;                  /* Pointer to previous menu */
MENUDATA        *Submenu;               /* Pointer to a submenu */
MENUDATA        *Next;                  /* Pointer to next menu */
};

struct  _COMMANDLINEPARAMS
{
UCHAR           ucPgmTitle[MAXNAMEL+1]; /* Session title */
UCHAR           ucPBefore[MAXNAMEL+1];  /* Parameters before user requested parameter */
UCHAR           ucPUser[128];           /* User requested parameter */
UCHAR           ucPAfter[MAXNAMEL+1];   /* Parameters after user requested parameter */
};

struct  _NBPAGE                         /* Notebook pages setup data */
{
PFNWP           pDialogWndProc;         /* Window procedure of a  notebook page */
HWND            hwndNBPage;             /* Window handle of a notebook page */
ULONG           ulIDPage;               /* ID of notebook page */
PSZ             pszStatusLine;          /* Status line text */
PSZ             pszTab;                 /* Tab text */
ULONG           ulIDDialogPage;         /* ID of a dialog resource */
ULONG           ulIDFocus;              /* ID of control to receive focus */
};

struct  _WINDOWDATA                     /* All we need to know about a certain window */
{
UCHAR           ucPgmTitle[MAXNAMEL+1]; /* Session title on titlebar */
                                        /* Session title in Window List */
UCHAR           ucWindowTitle[MAXNAMEL+1];
                                        /* Session's class name */
UCHAR           ucClassName[CLASSNAMESIZE];
SWP             swpWindow;              /* Window's SWP structure */
KEYDATA         KeyData;                /* Hotkey data */
ULONG           SwpFlag;                /* Activation on hotkey SWP flag: SWP_RESTORE or SWP_MAXIMIZE,
                                           SWP_NOMOVE */
HSWITCH         hswitchWindow;          /* Switch handle of the window */
ULONG           ulStatus;               /* Status on overview window */
};

struct  _WINDOWS                        /* All windows on PM are traced here */
{
ULONG           ulDesktop;              /* Index of Desktop in WINDOWDATA[] */
ULONG           ulWindowList;           /* Index of Window List in WINDOWDATA[] */
ULONG           ulWindowLast;           /* Index of last window in WINDOWDATA[] */
WINDOWDATA      wdWindow[128];          /* Assume 128 windows maximum */
};

struct  _HOOKPARAMETERS
{
TIB             *pTib;                  /* TIB of PC/2 */
PIB             *pPib;                  /* PIB of PC/2 */
KEYDATA         *pKeyData;              /* Hotkeys allowed for PC/2 */
HAB             habPc2;                 /* Anchor block handle of PC/2 */
HMQ             hmqPc2;                 /* Message queue handle of PC/2 */
HPS             hpsMemory;              /* Presentation space in a memory DC to draw
                                           Overview window into and clip it into the
                                           Overview window's client area afterwards, to
                                           avoid the flickering of drawing in the client
                                           area directly */
HBITMAP         hbmMemory;              /* Bitmap handle of in memory presentation space */
HWND            hwndFrame;              /* PC/2's overview window frame */
HWND            hwndClient;             /* PC/2's overview window client to send/post
                                           messages to */
HWND            hwndThread;             /* PC/2's working thread window handle to
                                           send/post messages to */
HWND            hwndSpooler;            /* PC/2's spooler window handle to send/post
                                           messages to when PC/2 runs as a WPS replacement */
HWND            hwndSpoolerContainer;   /* Handle of the container which is the client of PC/2's
                                           spooler window */
HWND            hwndPopupMenu;          /* Handle of popup menu window */
HWND            hwndMenu;               /* Handle of overview window menu */
HWND            hwndHelp;               /* Help window handle */
HWND            hwndWPS;                /* WPS window handle where mouse clicks on WPS
                                           can be found */
HWND            hwndDesktop;            /* PM window handle where mouse clicks on Desktop
                                           can be found */
HWND            hwndWindowList;         /* Window List window handle to avoid changing its
                                           Z-order in the WinSendMsgHook() */
HWND            hwndActiveWindow;       /* Top level window that was active, before PC/2
                                           detected an event that results in a change of
                                           the active window and input focus */
MENUDATA        *pPopupMenu;            /* First entry of linked list of menus */
MENUDATA        *pMenuData;             /* This pointer points to the current level of
                                           Submenus and Menuitems within the configuration
                                           dialog procedure */
SPOOLEROBJECT   *pSpoolerObjectRoot;    /* This pointer points the the first SPOOLEROBJECT filled
                                           by enumerating the printer queue or NULL */
SPOOLEROBJECT   *pSpoolerObject;        /* This pointer points the the current SPOOLEROBJECTs list,
                                           which contains all selected container records or NULL */
WINDOWS         Windows;                /* Trace all windows here */
USHORT          MenuDataId;             /* Create linked list by starting with ID ID_POPUPMENU */
USHORT          PriorityClass;          /* PC/2's standard Priority Class */
SHORT           PriorityDelta;          /* PC/2's stantard Priority Delta */
                                        /* Path of PC2.INI */
UCHAR           ucFilenameINI[CCHMAXPATH];
UCHAR           ucPathDLL[CCHMAXPATH];  /* Path to PC/2 DLLs */
                                        /* Name of Desktop, f.e. OS/2 2.0 Desktop */
UCHAR           ucDesktopName[MAXNAMEL+1];
                                        /* Name of Task List, f.e. Window List */
UCHAR           ucWindowListName[MAXNAMEL+1];
                                        /* Name of PM background bitmap */
UCHAR           ucBackgroundBitmap[MAXNAMEL+1];
                                        /* Font used for Popup-Menu (set by dropping font onto
                                           smart icons) */
UCHAR           ucPopupMenuFont[MAXNAMEL+1];
                                        /* Font for overview window */
UCHAR           ucPC2WindowFont[MAXNAMEL+1];
                                        /* Font for spooler window */
UCHAR           ucPC2SpoolerFont[MAXNAMEL+1];
ULONG           ulBackgroundBitmapFlag; /* Upper USHORT contains PM background bitmap style flag,
                                           lower USHORT contains tile count */
ULONG           ProcessId;              /* PC/2's process ID */
ULONG           ulScrollPercentage;     /* Percentage of physical Desktop used to scroll
                                           through virtual Desktop (25, 50, 75, 100 %) */
ULONG           ulHorizontalDesktops;   /* Number of horizontal Desktops */
ULONG           ulVerticalDesktops;     /* Number of vertical Desktops */
ULONG           ulStatusFlag;           /* Bitmapped status flag */
ULONG           ulClickFlag;            /* WM_BUTTON1CLICK for a single click, and
                                           WM_BUTTON1DBLCLK for a double click */
ULONG           ulLogicalDriveMap;      /* Bitmapped flag for all drives available locally */
ULONG           ulOverviewFCF;          /* FCF_OVEVIEWWINDOW or user modification */
ULONG           ulSpoolerFCF;           /* FCF_SPOOLERWINDOW or user modification (currently not used) */
ULONG           ulDebug;                /* Debug status flag */
LONG            lSplitbarPosition;      /* Splitbar position in pixel of spooler container splitbar */
LONG            SlidingXFactor;         /* Sliding offset in pixel for horizontal movements */
LONG            SlidingYFactor;         /* Sliding offset in pixel for vertical movements */
float           fScaleX, fScaleY;       /* Reduce factor to reduce horizontal size of virtual
                                           Desktop to horizonal client window size */
SWP             swpScreen;              /* The screen dimensions */
SWP             swpPC2;                 /* Overview window size and position */
SWP             swpPC2Client;           /* Overview window client's size and position */
SWP             swpPC2Spooler;          /* Spooler window size and position */
POINTL          ptlOrigin;              /* Coordinates (0|0) within client area */
POINTL          LLHotBorder;            /* Lower left coordinates that force sliding in x & y direction */
POINTL          URHotBorder;            /* Upper right coordinates that force sliding in -x & -y direction */
POINTL          DesktopSize;            /* Size of the physical Desktop screen */
POINTL          VirtualDesktopPos;      /* Position of the physical Desktop within the virtual */
POINTL          VirtualDesktopMin;      /* Lower left position of whole virtual Desktop */
POINTL          VirtualDesktopMax;      /* Upper right position of whole virtual Desktop */
HMODULE         hDLLPc2Hook;            /* PC2HOOK.DLL handle */
HMODULE         hDLLPc2Spooler;         /* PC2SPOOL.DLL handle */
FILE            *Pc2Profile;            /* Open the profile, where the user entered menu
                                           data is stored, with this handle */
                                        /* DOSCALL1.998 DOSSETEXTLIBPATH API introduced
                                           with OS/2 WARP+ */
DOSSETEXTLIBPATH    *DosSetExtLIBPATH;
                                        /* DOSCALL1.999 DOSQUERYTEXTLIBPATH API introduced
                                           with OS/2 WARP+ */
DOSQUERYEXTLIBPATH  *DosQueryExtLIBPATH;
};

struct  _SPOOLERRECORD                  /* Within the spooler window container spooler objects
                                           are stored as SPOOLERRECORD objects */
{
MINIRECORDCORE  MiniRec;                /* A (MINI)RECORDCORE must be the first element of any
                                           type of container window structure */
SPOOLEROBJECT   *pSpoolerObject;        /* Pointer to the linked list of SPOOLEROBJECTs that
                                           controls the SPOOLERRECORD list used by the container internally */
PSZ             pszQueue;               /* Pointer to the queue name column of a spooler container record */
PSZ             pszQueueStatus;         /* Pointer to the queue status column */
PSZ             pszQueueComment;        /* Pointer to the queue comment column */
PSZ             pszQueueDriver;         /* Pointer to the queue status column */
PSZ             pszJob;                 /* Pointer to the job name column */
PSZ             pszJobNumber;           /* Pointer to the job identification number in ASCII */
PSZ             pszJobStatus;           /* Pointer to the job status column */
PSZ             pszJobComment;          /* Pointer to the job document comment */
ULONG           ulJob;                  /* Job identification number */
};

struct  _SPOOLEROBJECT                  /* PC/2 internal structure that is a copy of the list used
                                           within the container to control the container objects to
                                           avoid message exchange with the container, when updating
                                           the spooler data */
{
SPOOLEROBJECT   *pSpoolerObjectNext;    /* Pointer to the next SPOOLEROBJECT (next row in container) */
SPOOLEROBJECT   *pSpoolerObjectBack;    /* Pointer to the previous SPOOLEROBJECT */
BOOL            bInQueue;               /* TRUE if current job found during queue enumeration */
SPOOLERRECORD   *pSpoolerRecord;        /* Pointer to a SPOOLERRECORD that is used within the container
                                           to represent a row in the spooler container details view */
};

struct  _WPSOBJECTLIST                  /* LIST structure of WPS objects extracted by WPS2PC2.DLL
                                           into shared memory, which is used in PC2.EXE to create
                                           menuitems from */
{
ULONG           ulType;                 /* WPSOBJECT* type value of list element */
WPSOBJECTLIST   *pNext;                 /* Pointer to next LIST element */
WPSOBJECTLIST   *pFolder;               /* Pointer to LIST of elements within the current folder */
VOID            *pData;                 /* Pointer to data item of LIST, e. g. variable length
                                           PROGDETAILS or UCHAR[] structures */
};


#define ID_PC2MAINWINDOW        256
#define ID_PC2THREADWINDOW      257
#define ID_PC2SPOOLERWINDOW     258
#define ID_PC2POPUPMENU         259
#define ID_PC2SPOOLERCONTAINER  260
#define ID_WPS2PC2MAINWINDOW    261

#define PC2_CLASSNAME           "PC2 - Main"
#define PC2_CLASSNAME_THREAD    "PC2 - Thread"
#define PC2_CLASSNAME_SPOOLER   "PC2 - Spooler"
#define PC2_CLASSNAME_WPS2PC2   "PC2 - WPS 2 PC/2"

#define PC2_OVERVIEW_WINDOW     "PC/2 Overview"
#define PC2_SPOOLER_WINDOW      "PC/2 Spooler"
#define PC2_WPS2PC2_WINDOW      "WPS 2 PC/2"

#define PC2_WPS2PC2_HELP        "WPS2PC2.HLP"

#define ID_SPOOLERPOPUPMENU     270     /* Popup Menu for PC/2 spooler window container */
#define ID_SPOOLERREFRESH       271     /* Refresh spooler window */
#define ID_SPOOLERHOLDJOB       272     /* Pause a print job */
#define ID_SPOOLERRELEASEJOB    273     /* Release a print job */
#define ID_SPOOLERDELETEJOB     274     /* Delete a print job */
#define ID_SPOOLERHOLDQUEUE     275     /* Pause a printer queue */
#define ID_SPOOLERRELEASEQUEUE  276     /* Release a printer queue */
#define ID_SPOOLERHELP          277     /* Help for PC/2 spooler window */

#define ID_PC2SETUP             300     /* Defines for PopUp Menu, that is popped up after
                                           the user presses mouse button 1 on DESKTOP */
#define ID_CONFIGDIALOG         301     /* User pressed Configure Menu */
#define ID_ABOUTDIALOG          302     /* User pressed About PC/2 */
#define ID_EXIT                 303     /* User pressed F3 to exit PC/2 */
#define ID_SHUTDOWN             304     /* User pressed ShutDown OS/2 */
#define ID_DESKTOPDIALOG        305     /* User pressed Configure Desktop */
#define ID_HELP                 306     /* ID used for HELP panels */
#define ID_SPOOLER              307     /* User pressed PC/2 Spooler */
#define ID_DEBUG                308     /* User pressed Debug toggle key */
#define ID_EMERGENCYEXIT        309     /* User pressed ALT+CTRL+F3 to exit PC/2 in
                                           an undocumented way. This is for testing
                                           or debugging only, useful when running as WPS */

#define ID_ICONEXIT             310     /* Exit PC/2 smarticon */
#define ID_ICONMOVE             311     /* Move smarticon */
#define ID_ICONHIDE             312     /* Hide window smarticon */
#define ID_ICONZORDERTOP        313     /* Set window behind HWND_TOP smarticon */
#define ID_ICONZORDERBOTTOM     314     /* Set window behind HWND_BOTTOM smarticon */
#define ID_ICONCLOSE            315     /* Close window smarticon */
#define ID_ICONMAXIMIZE         316     /* Maximize window smarticon */
#define ID_ICONMINIMIZE         317     /* Minimize window smarticon */
#define ID_ICONRESTORE          318     /* Restore window smarticon */
#define ID_ICONSHUTDOWN         319     /* Shutdown OS/2 smarticon */
#define ID_ICONHELP             320     /* Help PC/2 window smarticon */

#define ID_MOVEPOINTER          330     /* Pointer active while moving windows on
                                           overview window is enabled */
#define ID_ACTIONPOINTER        331     /* Pointer active while performing actions (except
                                           moving) on windows */

#define ID_POPUPMENU            1500    /* ID used by first user entered entry in the
                                           popup menu. It is incremented by 1 by tracing
                                           through the linked list for each entry (submenu
                                           or menuitem). */
#define USERITEMFIRST           ID_POPUPMENU
#define USERITEMLAST            ID_POPUPMENU+1499

                                        /* IDs used for HELP panels */
#define MAIN_HELP_TABLE         3001
#define MAIN_HELP_SUBTABLE      3002
#define ID_FAQ                  3003
#define ID_GENERALHELP          3004
#define ID_CONCEPTSHELP         3005
#define ID_USINGHELP            3006
#define ID_ERRORHELP            3007
#define ID_INSTALLATIONHELP     3008
#define ID_OVERVIEWHELP         3009
#define ID_COMPATIBILITY        3010


                                        /* PC/2 error messages help panel IDs */
#define HELP_CREATEWINDOW       3100    /* PM environment creation failed */
#define HELP_PC2LOADED          3101    /* PC/2 already loaded */
#define HELP_DLLLOADED          3102    /* Can't load from PC2HOOK.DLL */
#define HELP_PC2INI             3103    /* Can't load from PC2.INI */
#define HELP_PC2SPOOLDLL        3104    /* Can't load from PC2SPOOL.DLL */
#define HELP_PC2THREAD          3105    /* Can't start second thread */
#define HELP_PC2CFG             3106    /* Can't load from PC2.CFG */
#define HELP_PC2HOOK            3107    /* Can't load/unload hooks */
#define HELP_CREATEDIALOG       3108    /* WinDlgBox failed */
#define HELP_SETPATH            3109    /* Can't change current directory */
#define HELP_PRIORITY           3110    /* Can't change our priority */
#define HELP_LAUNCH             3111    /* Error when starting a session */
#define HELP_MEDIA              3112    /* Error during DosDevIOCtl */
#define HELP_PC2RUNNINGASWPS    3113    /* Can't close PC/2 when running as WPS */

#define HELP_HMERROR            3150    /* HM_ERROR detected */
#define HELP_PC2HELP            3151    /* Can't load from PC2.HLP */

#define HELP_PC2LOADED_SUBTABLE         3201
#define HELP_DLLLOADED_SUBTABLE         3202
#define HELP_PC2INI_SUBTABLE            3203
#define HELP_PC2SPOOLDLL_SUBTABLE       3204
#define HELP_PC2THREAD_SUBTABLE         3205
#define HELP_PC2CFG_SUBTABLE            3206
#define HELP_PC2HOOK_SUBTABLE           3207
#define HELP_CREATEDIALOG_SUBTABLE      3208
#define HELP_SETPATH_SUBTABLE           3209
#define HELP_PRIORITY_SUBTABLE          3210
#define HELP_LAUNCH_SUBTABLE            3211
#define HELP_MEDIA_SUBTABLE             3212
#define HELP_PC2RUNNINGASWPS_SUBTABLE   3213

                                        /* New messages for the configuration menu dialog */
                                        /* Load the current level into configuration listbox */
#define WM_LOADPOPUPMENU        WM_USER+1
                                        /* Initialize the input queue hook */
#define WM_LOADHOOK             WM_USER+2
                                        /* Save Popup-Menu to Profile */
#define WM_SAVEPOPUPMENU        WM_USER+3
                                        /* Load Popup-Menu from Profile */
#define WM_SETPOPUPMENU         WM_USER+4
                                        /* Display Popup-Menu on Desktop */
#define WM_POPUPMENU            WM_USER+5

                                        /* Insert an item to the linked list */
#define MM_INSERTITEMMENUITEM   WM_USER+6
                                        /* Change the first item of a Submenu to an item */
#define MM_INSERTITEMSUBMENU    WM_USER+7
                                        /* Move an item of a Submenu to another position */
#define MM_MOVEMENUITEM         WM_USER+8
                                        /* ShutDown message to ShutDown dialog */
#define WM_SHUTDOWN             WM_USER+9
                                        /* Program Type configuration of Program Installation
                                           dialog */
#define WM_SETUPPROGRAMTYPE     WM_USER+10
                                        /* Program Priority configuration of Program Installation
                                           dialog */
#define WM_SETUPPROGRAMPRIORITY WM_USER+11
                                        /* Program Size & Position configuration of Program
                                           Installation dialog */
#define WM_SETUPSIZEPOSITION    WM_USER+12
                                        /* Hotkey settings to be initialized by Program
                                           Installation dialot */
#define WM_SETUPHOTKEY          WM_USER+13
                                        /* Query and set desktop window handle */
#define WM_SETDESKTOPHANDLE     WM_USER+14
                                        /* Sent by PC2HOOK.DLL if windows need to be moved */
#define WM_DESKTOPMOVE          WM_USER+15
                                        /* Sent by Program Installation dialog to dialog window
                                           procedure to initialize notebook pages with user data */
#define WM_SETUPNOTEBOOKPAGES   WM_USER+16
                                        /* Sent by PC2Hook.DLL when a WM_CHAR message was detected
                                           that is used by the Hotkey function */
#define WM_HOTKEY               WM_USER+17
                                        /* Sent by PC2Hook.DLL when mouse clicks are detected on
                                           PM that would display the window list on the WPS */
#define WM_WINDOWLIST           WM_USER+18
                                        /* Sent by PC2Hook.DLL when the pointer is positioned on
                                           a surrounding row and/or column and the Desktop should
                                           be moved */
#define WM_MOVEREQUEST          WM_USER+19
                                        /* Sent to working thread window to resize WPS */
#define WM_EXPANDWPS            WM_USER+20
                                        /* Sent to main window and passed to working thread
                                           from PC2HOOK.DLL when a frame window's z order should
                                           be adjusted because of a button 2 click on titlebar */
#define WM_ZORDER               WM_USER+21
                                        /* Sent to working thread to start applications that have
                                           the autostart flag */
#define WM_AUTOSTART            WM_USER+22
                                        /* Sent to working thread to change the PM background bitmap */
#define WM_BACKGROUNDBITMAP     WM_USER+23
                                        /* Sent by working thread to indicate he finished his work */
#define WM_THREADREADY          WM_USER+24
                                        /* Sent by working thread to client window when startup finished */
#define WM_THREADSTARTUPREADY   WM_USER+25
                                        /* Sent to working thread to reinitialize to root of all drives */
#define WM_SETDRIVEROOT         WM_USER+26
                                        /* Sent to spooler window to bring to top of Z-order */
#define WM_SHOWSPOOLER          WM_USER+27
                                        /* Sent to spooler window to refresh the container holding
                                           the real-time status of the printer queues */
#define WM_REFRESHSPOOLER       WM_USER+28
                                        /* Sent to Overview Window to change FCF_* flags */
#define WM_OVERVIEWFCF          WM_USER+29
                                        /* Initialize PC/2 main window */
#define WM_PC2STARTUP           WM_USER+30
#define WM_PC2STARTUPSCREEN     WM_USER+31
#define WM_PC2STARTUPMEMORYDC   WM_USER+32
#define WM_PC2STARTUPTHREAD     WM_USER+33

                                        /* Procedures */
extern BOOL             WinStartUp(HAB *pHab, HMQ *pHmq);
extern BOOL             WinStartHelp(HAB hab, UCHAR *pHelpfile, HWND *pHwndHelp, HWND HwndFrame);
extern BOOL             WinCloseDown(HWND *pHwndHelp, HAB *pHab, HMQ *pHmq);
extern void             StartSession(SESSIONDATA *SessionData);
extern BOOL             LoadMenuData2SessionData(MENUDATA *pMenuData, SESSIONDATA *pSessionData);
extern BOOL             LoadSessionData2MenuData(MENUDATA *pMenuData, SESSIONDATA *pSessionData);
extern MENUDATA         *AllocateMenuData(void);
extern void             LoadMenu(MENUDATA *pMenuData);
extern void             SaveMenu(MENUDATA *pMenuData);
extern MRESULT          SetPopupMenu(ULONG msg, MPARAM mp1, MPARAM mp2);
extern MENUDATA         *SearchItem(MENUDATA *pMD, ULONG *id);
extern MENUDATA         *SearchTitle(MENUDATA *pMD, WINDOWDATA *pWD, BOOL *pbFlag);
extern void             SearchAutoStartItem(MENUDATA *pMD);
extern void             InstallFilename2Dialog(HWND hwndDlg, UCHAR *pucFullFileName, BOOL bObject);
extern void             DisableDialogItem(HWND hwndDlg, USHORT usDialogIDs[], USHORT usItemCount, ULONG ulStyle);
extern ULONG            INIAccess(UCHAR *pucFilenameINI, BOOL bRead);
extern void             DrawWindow(HPS hpsClient, SWP *pswpWindow, ULONG ulWindowColor, ULONG ulTextColor, ULONG ulStyle, PSZ pszWindowName);
extern UCHAR            *ImportDosSettings(UCHAR *pucSettings, ULONG *pulLength, BOOL bImport);
extern ULONG            LoadProgDetails2MenuData(MENUDATA *pMenuData, PROGDETAILS *pProgDetails);
extern ULONG            SetDriveRoot(void);
extern ULONG            ConvertWPSObjectList2MenuData(MENUDATA *pMenuData, WPSOBJECTLIST *pListRoot);

                                        /* Pc2Spool.c */
extern ULONG            RefreshSpooler(void);
extern SPOOLERRECORD    *QuerySelectedRecords(SPOOLERRECORD *pSelectedSpoolerRecord);
extern void             NotifySelectedRecords(ULONG ulActionCode);

                                        /* Dynamic linked functions */
extern PFFUNCPTR1       *pSetParameters;
extern PFFUNCPTR2       *pInputHook;
extern PFFUNCPTR3       *pWinSendMsgHook;

                                        /* PC/2's working thread */
extern void _Optlink    PC2_Thread(void *ThreadArg);

                                        /* Window procedures */
extern MRESULT  EXPENTRY PC2_MainWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY PI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY PI_SubclassedDialogProcedure(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY PI_NotebookProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY AD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY MI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY CD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SU_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY RD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY DD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY DD_NotebookProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY MD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SubclassedMenuWindowProc(HWND hwndMenu, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SubclassedListboxWindowProc(HWND hwndLB, ULONG msg, MPARAM mp1, MPARAM mp2);

                                        /* Application hooks */
BOOL                     HelpHook(HAB hab, ULONG ulMode, ULONG ulTopic, ULONG ulSubTopic, PRECTL prectlPosition);

                                        /* Working thread (object) window procedures */
extern MRESULT  EXPENTRY PC2_ThreadWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

                                        /* Spooler window procedures */
extern MRESULT  EXPENTRY PC2_SpoolerWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SubclassedContainerWindowProc(HWND hwndMenu, ULONG msg, MPARAM mp1, MPARAM mp2);

                                        /* Pointer to PC/2 control structure loaded from PC2HOOK.DLL */
extern HOOKPARAMETERS   *pHP;

                                        /* Pointer to OS/2 APIs dynamically linked */
extern DOSSETEXTLIBPATH *DosSetExtLIBPATH;
extern DOSQUERYEXTLIBPATH
                        *DosQueryExtLIBPATH;

