/***********************************************************************\
 *                                PC2.c                                *
 *           Copyright (C) by Stangl Roman, 1993, 1994, 1995           *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * Dialog.c     Dialog window procedures.                              *
 *                                                                     *
\***********************************************************************/

static char RCSID[]="@(#) $Header: Dialog.c Version 1.80 01,1995 $ (LBL)";

#define         _FILE_  "PC/2 - Dialog.c V1.80"

#include        "PC2.h"                 /* User include files */
#include        "Error.h"

                                        /* Program Installation dialog notebook pages */
NBPAGE          nbPINotebookPage[]=
{
    {PI_NotebookProcedure,  0,  0,  "Application Settings",      "~Application", PIID_PAGE1, PIEF_PROGRAMTITLE},
    {PI_NotebookProcedure,  0,  0,  "Session Settings",          "~Session",     PIID_PAGE2, PIRB_SHELL},
    {PI_NotebookProcedure,  0,  0,  "Style Settings",            "S~tyle",       PIID_PAGE3, PIRB_DEFAULTSTYLE},
    {PI_NotebookProcedure,  0,  0,  "Hotkey Settings",           "~Hotkey",      PIID_PAGE4, PIEF_SESSIONTITLE},
    {PI_NotebookProcedure,  0,  0,  "Priority Settings",         "~Priority",    PIID_PAGE5, PIRB_NOCHANGE},
    {NULL,                  0,  0,  "",                          "",             0,          0}
};

                                        /* Desktop Settings dialog notebook pages */
NBPAGE          nbDDNotebookPage[]=
{
    {DD_NotebookProcedure,  0,  0,  "Virtual Desktop Settings",  "~Desktop",     DDID_PAGE1, DDCB_VIRTUALDESKTOP},
    {DD_NotebookProcedure,  0,  0,  "Physical Desktop Settings", "~Screen",      DDID_PAGE2, DDCB_BUTTON2ZORDER},
    {NULL,                  0,  0,  "",                     "",                  0,          0}
};

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - About dialog.                               *
 * Req: none                                                                            *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY AD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    swp.fl=SWP_MOVE;                    /* Center dialog window */
    swp.x=(pHP->swpScreen.cx-swp.cx)>>1;
    swp.y=(pHP->swpScreen.cy-swp.cy)>>1;
    swp.cx=swp.cy=0;
    swp.hwndInsertBehind=NULLHANDLE;
    WinSetMultWindowPos(pHP->habPc2, &swp, 1);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(pHP->hwndHelp!=NULLHANDLE)
        WinSendMsg(pHP->hwndHelp, HM_DISPLAY_HELP,
            MPFROMSHORT(ID_ABOUTDIALOG), HM_RESOURCEID);
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
                                        /* Dialog terminated with DID_OK */
        WinDismissDlg(hwndDlg, DID_OK);
        break;

    case DID_CANCEL:                    /* Cancel key pressed */
                                        /* Dialog terminated with DID_CANCEL */
        WinDismissDlg(hwndDlg, DID_CANCEL);
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Desktop configuration dialog.               *
 * Req: none                                                                            *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY DD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static HWND          hwndNB;            /* Program Installation dialog notebook window handle */

switch(msg)
{
case WM_INITDLG:
    {
    HPS         hps;                    /* Used to query font metrics for tab size */
    FONTMETRICS fmFontMetrics;
    POINTL      aptlTabText[TXTBOX_COUNT];
    USHORT      usTabTextLength=50;
    SWP         swp;
    ULONG       ulPage, ulPageID;
    RECTL       rectlNB;                /* Notebook rectangle to load notebook dialog page into */
    POINTL      ptlNB;                  /* Notebook page conversion from dialog units to pixels */


    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
                                        /* Get window handle of notebook */
    hwndNB=WinWindowFromID(hwndDlg, DDNB_NOTEBOOK);
                                        /* Set spiralbind style */
    WinSetWindowULong(hwndNB, QWL_STYLE, WinQueryWindowULong(hwndNB, QWL_STYLE) | BKS_SPIRALBIND);
    hps=WinGetPS(hwndNB);               /* Get presentation space to query fontmetrics */
    memset(&fmFontMetrics, 0, sizeof(FONTMETRICS));
    if(GpiQueryFontMetrics(hps, sizeof(FONTMETRICS), &fmFontMetrics))
        fmFontMetrics.lMaxBaselineExt<<=1;
    else
        fmFontMetrics.lMaxBaselineExt=30;
                                        /* Load and associate all dialogs of the Program
                                           Installation dialog to notebook pages */
    for(ulPage=0; nbDDNotebookPage[ulPage].pDialogWndProc!=NULL; ulPage++)
        {
                                        /* Load a dialog into a page */
        if(!(nbDDNotebookPage[ulPage].hwndNBPage=WinLoadDlg(
            hwndDlg,                    /* Parent window */
            hwndDlg,                    /* Owner window */
                                        /* Window procedure */
            nbDDNotebookPage[ulPage].pDialogWndProc,
            NULLHANDLE,                 /* Resource idendity */
                                        /* Dialog idendity */
            nbDDNotebookPage[ulPage].ulIDDialogPage,
            NULL)))                     /* Application defined data area */
                                        /* On error suggest exiting */
        USR_ERR("Can't load dialog resources - suggest exiting...",
            pHP->hwndFrame, pHP->hwndFrame);
                                        /* Query length of largest tab text */
        if(GpiQueryTextBox(hps, strlen(nbDDNotebookPage[ulPage].pszTab),
            nbDDNotebookPage[ulPage].pszTab, TXTBOX_COUNT, aptlTabText))
            if(usTabTextLength<aptlTabText[TXTBOX_CONCAT].x)
                usTabTextLength=aptlTabText[TXTBOX_CONCAT].x;
        ulPageID=(ULONG)WinSendMsg(     /* Insert a page into the notebook */
            hwndNB,
            BKM_INSERTPAGE,
            (MPARAM)NULL,               /* Page ID, ignored if BKA_FIRST or BKA_LAST
                                           specified */
                                        /* Style and order attribute */
            MPFROM2SHORT(BKA_MAJOR | BKA_STATUSTEXTON | BKA_AUTOPAGESIZE, BKA_LAST));
        nbDDNotebookPage[ulPage].ulIDPage=ulPageID;
                                        /* Set text into the status line */
        WinSendMsg(hwndNB,
            BKM_SETSTATUSLINETEXT,
            MPFROMP(ulPageID),
            MPFROMP(nbDDNotebookPage[ulPage].pszStatusLine));
                                        /* Set text into tab */
        WinSendMsg(hwndNB,
            BKM_SETTABTEXT,
            MPFROMP(ulPageID),
            MPFROMP(nbDDNotebookPage[ulPage].pszTab));
                                        /* Associate page with dialog */
        WinSendMsg(hwndNB,
            BKM_SETPAGEWINDOWHWND,
            MPFROMP(ulPageID),
            MPFROMLONG(nbDDNotebookPage[ulPage].hwndNBPage));
        }
    WinReleasePS(hps);
    WinSendMsg(hwndNB,                  /* Set background to dialog box background */
        BKM_SETNOTEBOOKCOLORS,
        MPFROMLONG(SYSCLR_FIELDBACKGROUND),
        MPFROMSHORT(BKA_BACKGROUNDPAGECOLORINDEX));
    WinSendMsg(hwndNB,                  /* Set tab dimension */
        BKM_SETDIMENSIONS,
        MPFROM2SHORT(usTabTextLength+5, (SHORT)((float)fmFontMetrics.lMaxBaselineExt*0.8)),
        MPFROMSHORT(BKA_MAJORTAB));
                                        /* Notebook page dialog panel size in dialog units */
    ptlNB.x=NOTEBOOKPAGE_CX;
    ptlNB.y=NOTEBOOKPAGE_CY;
                                        /* Map dialog units to screen pixels */
    WinMapDlgPoints(hwndDlg, &ptlNB, 1, TRUE);
                                        /* Query notebook size and position in pixels */
    WinQueryWindowPos(hwndNB, &swp);
    rectlNB.yBottom=rectlNB.xLeft=0;
    rectlNB.xRight=swp.cx;
    rectlNB.yTop=swp.cy;
                                        /* Return size of notebook page in pixel for given
                                           notebook window size (with tab text size set) */
    WinSendMsg(hwndNB, BKM_CALCPAGERECT, MPFROMP(&rectlNB), MPFROMSHORT(TRUE));
                                        /* Calculate notebook size so that notebook dialog page fits
                                           into the notebook page */
    swp.cx-=(rectlNB.xRight-rectlNB.xLeft)-ptlNB.x;
    swp.cy-=(rectlNB.yTop-rectlNB.yBottom)-ptlNB.y;
                                        /* Size notebook accordingly */
    swp.fl=SWP_SIZE;
    swp.x=swp.y=0;
    swp.hwndInsertBehind=NULLHANDLE;
    swp.hwnd=hwndNB;
    WinSetMultWindowPos(pHP->habPc2, &swp, 1);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    swp.fl=SWP_MOVE;                    /* Center dialog window */
    swp.x=(pHP->swpScreen.cx-swp.cx)>>1;
    swp.y=(pHP->swpScreen.cy-swp.cy)>>1;
    swp.cx=swp.cy=0;
    swp.hwndInsertBehind=NULLHANDLE;
    WinSetMultWindowPos(pHP->habPc2, &swp, 1);
                                        /* Now initialize all notebook page dialogs
                                           by posting to 1st page */
    WinPostMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, WM_SETUPNOTEBOOKPAGES, (MPARAM)NULL, (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    {
    ULONG   ulPageId, ulPage;
    ULONG   ulHelp[]={DDID_PAGE1, DDID_PAGE2};

    ulPageId=(ULONG)WinSendMsg(hwndNB,  /* Query the currently active page */
        BKM_QUERYPAGEID,
        MPFROMLONG(0),                  /* Location page ID, ignored if */
                                        /* Page ID is BKA_TOP */
        MPFROM2SHORT(BKA_TOP, BKA_MAJOR));
    for(ulPage=0; nbDDNotebookPage[ulPage].pDialogWndProc!=NULL; ulPage++)
        if(nbDDNotebookPage[ulPage].ulIDPage==ulPageId)
            if(pHP->hwndHelp!=NULLHANDLE)
                WinSendMsg(pHP->hwndHelp, HM_DISPLAY_HELP,
                    MPFROMSHORT(ulHelp[ulPage]), HM_RESOURCEID);
    }
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
        {
        UCHAR       ucBuffer[4];
        POINTL      DesktopCountMin, DesktopCountMax;
        ULONG       ulOldStatusFlag=pHP->ulStatusFlag;
/*                                                                                      *\
 * First notebook page.                                                                 *
\*                                                                                      */
                                        /* Query checkboxes' state and set according flag */
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_VIRTUALDESKTOP))
            pHP->ulStatusFlag|=VIRTUALDESKTOP;
        else pHP->ulStatusFlag&=~VIRTUALDESKTOP;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_MOVEDESKTOP))
            pHP->ulStatusFlag|=MOVEDESKTOP;
        else pHP->ulStatusFlag&=~MOVEDESKTOP;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_EXPANDWPS))
            pHP->ulStatusFlag|=EXPANDWPS;
        else pHP->ulStatusFlag&=~EXPANDWPS;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_CLICK2MOVE))
            pHP->ulStatusFlag|=CLICK2MOVE;
        else pHP->ulStatusFlag&=~CLICK2MOVE;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_OVERVIEW))
            pHP->ulStatusFlag|=OVERVIEW;
        else pHP->ulStatusFlag&=~OVERVIEW;
                                        /* Query scroll percentage entryfield (0-based !!!) */
        WinQueryWindowText(WinWindowFromID(nbDDNotebookPage[PAGE_1].hwndNBPage, DDEF_SCROLLPERCENTAGE),
            sizeof(ucBuffer), ucBuffer);
        pHP->ulScrollPercentage=(ULONG)atol(ucBuffer);;
                                        /* Reinitialize scroll percentage */
        pHP->SlidingXFactor=(pHP->ulScrollPercentage*
            pHP->DesktopSize.x)/100;
        pHP->SlidingYFactor=(pHP->ulScrollPercentage*
            pHP->DesktopSize.y)/100;
/*                                                                                      *\
 * Get the count of Virtual Desktops, and adjust HookParameters control structure       *
 * accordingly. This will allow dynamic change on the overview window and allowed user  *
 * operation borders.                                                                   *
\*                                                                                      */
                                        /* Get number of horizontal and vertical Virtual Desktops */
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDSB_HORIZONTALDESKTOPS,
            SPBM_QUERYVALUE, MPFROMP(&pHP->ulHorizontalDesktops), MPFROM2SHORT(0, SPBQ_UPDATEIFVALID));
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDSB_VERTICALDESKTOPS,
            SPBM_QUERYVALUE, MPFROMP(&pHP->ulVerticalDesktops), MPFROM2SHORT(0, SPBQ_UPDATEIFVALID));
        DesktopCountMin.x=(pHP->ulHorizontalDesktops-1)>>1;
        DesktopCountMin.y=(pHP->ulVerticalDesktops-1)>>1;
        DesktopCountMax.x=pHP->ulHorizontalDesktops-DesktopCountMin.x;
        DesktopCountMax.y=pHP->ulVerticalDesktops-DesktopCountMin.y;
        pHP->VirtualDesktopMin.x=(-pHP->DesktopSize.x)*DesktopCountMin.x;
        pHP->VirtualDesktopMin.y=(-pHP->DesktopSize.y)*DesktopCountMin.y;
        pHP->VirtualDesktopMax.x=pHP->DesktopSize.x*DesktopCountMax.x;
        pHP->VirtualDesktopMax.y=pHP->DesktopSize.y*DesktopCountMax.y;
                                        /* Query click flag */
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDRB_BUTTON1CLICK))
            pHP->ulClickFlag=WM_BUTTON1CLICK;
        else pHP->ulClickFlag=WM_BUTTON1DBLCLK;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_SELECTFIRSTITEM))
            pHP->ulStatusFlag|=SELECTFIRSTITEM;
        else pHP->ulStatusFlag&=~SELECTFIRSTITEM;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_SLIDINGFOCUS))
            pHP->ulStatusFlag|=SLIDINGFOCUS;
        else pHP->ulStatusFlag&=~SLIDINGFOCUS;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_PRESERVEZORDER))
            pHP->ulStatusFlag|=PRESERVEZORDER;
        else pHP->ulStatusFlag&=~PRESERVEZORDER;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_HIDETITLEBAR))
            pHP->ulStatusFlag|=HIDETITLEBAR;
        else pHP->ulStatusFlag&=~HIDETITLEBAR;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_HIDESMARTICONBAR))
            pHP->ulStatusFlag|=HIDESMARTICONBAR;
        else pHP->ulStatusFlag&=~HIDESMARTICONBAR;
        {                               /* Show or hide overview window according to
                                           the user selected flag */
        SWP     swp;

        swp.x=swp.y=swp.cx=swp.cy=0;
        swp.hwnd=pHP->hwndFrame;
        if(pHP->ulStatusFlag & OVERVIEW)
            {
            swp.fl=SWP_SHOW|SWP_DEACTIVATE;
            swp.hwndInsertBehind=HWND_BOTTOM;
            WinSetMultWindowPos(pHP->habPc2, &swp, 1);
            }
        else
            {
            swp.fl=SWP_HIDE|SWP_DEACTIVATE;
            swp.hwndInsertBehind=HWND_BOTTOM;
            WinSetMultWindowPos(pHP->habPc2, &swp, 1);
            }
        }
/*                                                                                      *\
 * Add or remove Titlebar + Hide Button or Smart icon bar according to user request.    *
\*                                                                                      */
        {
        ULONG   ulChangedFCF;

        ulChangedFCF=0;
                                        /* If titlebar is set but should be hidden, update
                                           its window, which is a child of the frame */
        if( (!!(pHP->ulOverviewFCF & (FCF_TITLEBAR|FCF_HIDEBUTTON)))==
            (!!(pHP->ulStatusFlag & HIDETITLEBAR)) )
            ulChangedFCF|=FCF_TITLEBAR|FCF_HIDEBUTTON;
                                        /* If menubar is set but should be hidden, update
                                           its window */
        if( (!!(pHP->ulOverviewFCF & FCF_MENU))==
            (!!(pHP->ulStatusFlag & HIDESMARTICONBAR)) )
            ulChangedFCF|=FCF_MENU;
                                        /* Set new FCF_* flags for titlebar + hide button */
        if(pHP->ulStatusFlag & HIDETITLEBAR)
            pHP->ulOverviewFCF&=~(FCF_TITLEBAR|FCF_HIDEBUTTON);
        else
            pHP->ulOverviewFCF|=(FCF_TITLEBAR|FCF_HIDEBUTTON);
                                        /* Set new FCF_* flags for smarticon bar */
        if(pHP->ulStatusFlag & HIDESMARTICONBAR)
            pHP->ulOverviewFCF&=~(FCF_MENU);
        else
            pHP->ulOverviewFCF|=(FCF_MENU);
                                        /* Now update Overview window */
        if(ulChangedFCF)
            WinPostMsg(pHP->hwndClient, WM_OVERVIEWFCF, MPFROMLONG(ulChangedFCF), NULL);
        }
/*                                                                                      *\
 * Second notebook page.                                                                *
\*                                                                                      */
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_2].hwndNBPage, DDCB_BUTTON2ZORDER))
            pHP->ulStatusFlag|=BUTTON2ZORDER;
        else pHP->ulStatusFlag&=~BUTTON2ZORDER;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_2].hwndNBPage, DDCB_KEEPONTOP))
            pHP->ulStatusFlag|=KEEPONTOP;
        else pHP->ulStatusFlag&=~KEEPONTOP;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_2].hwndNBPage, DDCB_USESPOOLER))
            pHP->ulStatusFlag|=SHOWSPOOLERWINDOW;
        else pHP->ulStatusFlag&=~SHOWSPOOLERWINDOW;
                                        /* Query Desktop and Window List name */
        WinQueryWindowText(WinWindowFromID(nbDDNotebookPage[PAGE_2].hwndNBPage, DDEF_DESKTOPNAME),
            sizeof(pHP->ucDesktopName), pHP->ucDesktopName);
        WinQueryWindowText(WinWindowFromID(nbDDNotebookPage[PAGE_2].hwndNBPage, DDEF_WINDOWLISTNAME),
            sizeof(pHP->ucWindowListName), pHP->ucWindowListName);
/*                                                                                      *\
 * Get PM background bitmap settings.                                                   *
\*                                                                                      */
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_2].hwndNBPage, DDCB_BACKGROUNDBITMAP))
            pHP->ulStatusFlag|=BACKGROUNDBITMAP;
        else pHP->ulStatusFlag&=~BACKGROUNDBITMAP;
        WinQueryWindowText(WinWindowFromID(nbDDNotebookPage[PAGE_2].hwndNBPage, DDEF_BACKGROUNDBITMAP),
            sizeof(pHP->ucBackgroundBitmap), pHP->ucBackgroundBitmap);
                                        /* Get number of tiled bitmaps */
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDSB_BITMAPTILEDCOUNT,
            SPBM_QUERYVALUE, MPFROMP(&pHP->ulBackgroundBitmapFlag), MPFROM2SHORT(0, SPBQ_UPDATEIFVALID));
                                        /* Query background bitmap style into upper USHORT */
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_2].hwndNBPage, DDRB_BITMAPNORMAL))
            pHP->ulBackgroundBitmapFlag|=BITMAPNORMAL;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_2].hwndNBPage, DDRB_BITMAPSCALED))
            pHP->ulBackgroundBitmapFlag|=BITMAPSCALED;
        if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_2].hwndNBPage, DDRB_BITMAPTILED))
            pHP->ulBackgroundBitmapFlag|=BITMAPTILED;
/*                                                                                      *\
 * Update INI file and resize WPS when necessary.                                       *
\*                                                                                      */
                                        /* Write changes to PC2.INI */
        if(!INIAccess(pHP->ucFilenameINI, FALSE))
            USR_ERR("Error writing to PC2.INI - continuing...",
                pHP->hwndFrame, pHP->hwndFrame);
                                        /* Size WPS according to expand WPS flag */
        if(pHP->ulStatusFlag & EXPANDWPS)
            WinPostMsg(pHP->hwndThread, WM_EXPANDWPS, (MPARAM)TRUE, NULL);
                                        /* If WPS was expanded before we must reduce it,
                                           if WPS is not the same as before */
        if((ulOldStatusFlag & EXPANDWPS) && !(pHP->ulStatusFlag & EXPANDWPS))
            WinPostMsg(pHP->hwndThread, WM_EXPANDWPS, (MPARAM)FALSE, NULL);
                                        /* Inform working thread to change PM background bitmap */
        WinPostMsg(pHP->hwndThread, WM_BACKGROUNDBITMAP, NULL, NULL);
                                        /* Dialog terminated with DID_OK */
        WinDismissDlg(hwndDlg, DID_OK);
        }
        break;

    case DID_CANCEL:                    /* Cancel key pressed */
                                        /* Dialog terminated with DID_CANCEL */
        WinDismissDlg(hwndDlg, DID_CANCEL);
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Desktop Settings dialog notebook pages.     *
 * Req:                                                                                 *
 *      nbDDNotebookPage[] ...  Structure of the Desktop Settings notebook pages        *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY DD_NotebookProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
                                        /* Child windows that change with the
                                           DDCD_SLIDINGFOCUS checkbox */
static USHORT   usChild2SlidingFocusCB[]={DDCB_PRESERVEZORDER};
                                        /* Child windows that change with the
                                           DDCB_VIRTUALDESKTOP checkbox */
static USHORT   usChild2VirtualDesktopCB[]={DDCB_MOVEDESKTOP, DDCB_CLICK2MOVE,
                                            DDCB_OVERVIEW, DDCB_EXPANDWPS, DDEF_SCROLLPERCENTAGE,
                                            DDSB_HORIZONTALDESKTOPS, DDSB_VERTICALDESKTOPS};
                                        /* Child window that change with DDCB_MOVEDESKTOP checkbox */
static USHORT   usChild2MoveDesktopCB[]={DDCB_EXPANDWPS};
                                        /* Child windows that change with DDCB_BACKGROUNDBITMAP */
static USHORT   usChild2BackgroundBitmapCB[]={DDEF_BACKGROUNDBITMAP, DDPB_WINFILEDLG, DDRB_BITMAPNORMAL,
                                              DDRB_BITMAPSCALED, DDRB_BITMAPTILED, DDSB_BITMAPTILEDCOUNT};
                                        /* Child windows that change with DDCB_BITMAPTILED */
static USHORT   usChild2BitmapTiledCB[]={DDSB_BITMAPTILEDCOUNT};

switch(msg)
{
/*                                                                                      *\
 * Syntax: WM_SETUPNOTEBOOKPAGES, NULL, NULL                                            *                                           *
\*                                                                                      */
case WM_SETUPNOTEBOOKPAGES:
    {
    UCHAR       ucBuffer[4];
/*                                                                                      *\
 * Check the checkboxes that should be set according to the bitmap currently used in    *
 * PC2.INI. If the virtual Desktop is disabled, then its child checkboxes can't be set, *
 * because unchecking the virtual Desktop automatically unchecks its child checkboxes.  *
\*                                                                                      */
/*                                                                                      *\
 * First notebook page.                                                                 *
\*                                                                                      */
                                        /* Check checkbox if Virtual Desktop flag is set */
    if(pHP->ulStatusFlag & VIRTUALDESKTOP)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_VIRTUALDESKTOP, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if move Desktop flag is set. If set
                                           disable expand WPS checkbox, else it may be set */
    if(pHP->ulStatusFlag & MOVEDESKTOP)
        {
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_MOVEDESKTOP, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
        DisableDialogItem(nbDDNotebookPage[PAGE_1].hwndNBPage, usChild2MoveDesktopCB,
            sizeof(usChild2MoveDesktopCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
        }
                                        /* Check checkbox if expand WPS flag is set */
    if(pHP->ulStatusFlag & EXPANDWPS)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_EXPANDWPS, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if click to move flag is set */
    if(pHP->ulStatusFlag & CLICK2MOVE)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_CLICK2MOVE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if overview window flag is set */
    if(pHP->ulStatusFlag & OVERVIEW)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_OVERVIEW, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
/*                                                                                      *\
 * Set scrolling percentage entryfield and horizontal scrollbar in 5 % increments.      *
\*                                                                                      */
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDHSB_SCROLLPERCENTAGE,
        SBM_SETTHUMBSIZE, MPFROM2SHORT(1, 20), (MPARAM)NULL);
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDHSB_SCROLLPERCENTAGE,
        SBM_SETSCROLLBAR, MPFROMSHORT(pHP->ulScrollPercentage/5),
        MPFROM2SHORT(0, 20));
                                        /* Insert the string */
    WinSetDlgItemText(nbDDNotebookPage[PAGE_1].hwndNBPage, DDEF_SCROLLPERCENTAGE,
        (CHAR *)_itoa(pHP->ulScrollPercentage, ucBuffer, 10));
/*                                                                                      *\
 * Set horizontal and vertical count of Virtual Desktops into spinbuttons after         *
 * initialising them into the range of 1 to 9.                                          *
\*                                                                                      */
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDSB_HORIZONTALDESKTOPS,
        SPBM_SETLIMITS, MPFROMLONG(9), MPFROMLONG(1));
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDSB_HORIZONTALDESKTOPS,
        SPBM_SETCURRENTVALUE, MPFROMLONG(pHP->ulHorizontalDesktops), (MPARAM)0);
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDSB_VERTICALDESKTOPS,
        SPBM_SETLIMITS, MPFROMLONG(9), MPFROMLONG(1));
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDSB_VERTICALDESKTOPS,
        SPBM_SETCURRENTVALUE, MPFROMLONG(pHP->ulVerticalDesktops), (MPARAM)0);
/*                                                                                      *\
 * Disable the child windows of the virtual Desktop, if this checkbox isn't checked.    *
\*                                                                                      */
    if(!(pHP->ulStatusFlag & VIRTUALDESKTOP))
        DisableDialogItem(nbDDNotebookPage[PAGE_1].hwndNBPage, usChild2VirtualDesktopCB,
            sizeof(usChild2VirtualDesktopCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
/*                                                                                      *\
 * Set click flag.                                                                      *
\*                                                                                      */
    if(pHP->ulClickFlag==WM_BUTTON1CLICK)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDRB_BUTTON1CLICK, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    else
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDRB_BUTTON1DBLCLK, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if select first menuitem flag is set */
    if(pHP->ulStatusFlag & SELECTFIRSTITEM)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_SELECTFIRSTITEM, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
/*                                                                                      *\
 * Disable the child windows of the sliding Focus, if this checkbox isn't checked.      *
\*                                                                                      */
    if(!(pHP->ulStatusFlag & SLIDINGFOCUS))
        DisableDialogItem(nbDDNotebookPage[PAGE_1].hwndNBPage, usChild2SlidingFocusCB,
            sizeof(usChild2SlidingFocusCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Check ckeckbox if sliding focus flag is set */
    if(pHP->ulStatusFlag & SLIDINGFOCUS)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_SLIDINGFOCUS, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check ckeckbox if preserve z-order flag is set */
    if(pHP->ulStatusFlag & PRESERVEZORDER)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_PRESERVEZORDER, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
/*                                                                                      *\
 * Set overview window flags.                                                           *
\*                                                                                      */
                                        /* Check ckeckbox if hide titlebar flag is set */
    if(pHP->ulStatusFlag & HIDETITLEBAR)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_HIDETITLEBAR, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check ckeckbox if hide smarticonbar flag is set */
    if(pHP->ulStatusFlag & HIDESMARTICONBAR)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_HIDESMARTICONBAR, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
/*                                                                                      *\
 * Second notebook page.                                                                *
\*                                                                                      */
/*                                                                                      *\
 * Write the Desktop and Window List currently available or the default ones from       *
 * PC2.INI into the entryfields. The maximum length of both we assume MAXNAMEL.         *
\*                                                                                      */
                                        /* First set the limits to MAXNAMEL */
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDEF_DESKTOPNAME, EM_SETTEXTLIMIT,
        MPFROMSHORT(MAXNAMEL), (MPARAM)NULL);
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDEF_WINDOWLISTNAME, EM_SETTEXTLIMIT,
        MPFROMSHORT(MAXNAMEL), (MPARAM)NULL);
                                        /* Insert the strings */
    WinSetDlgItemText(nbDDNotebookPage[PAGE_2].hwndNBPage, DDEF_DESKTOPNAME, pHP->ucDesktopName);
    WinSetDlgItemText(nbDDNotebookPage[PAGE_2].hwndNBPage, DDEF_WINDOWLISTNAME, pHP->ucWindowListName);
                                        /* Check ckeckbox if button 2 z-order flag is set */
    if(pHP->ulStatusFlag & BUTTON2ZORDER)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDCB_BUTTON2ZORDER, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if keep on top flag is set */
    if(pHP->ulStatusFlag & KEEPONTOP)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDCB_KEEPONTOP, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if use Spooler Window flag is set */
    if(pHP->ulStatusFlag & SHOWSPOOLERWINDOW)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDCB_USESPOOLER, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
/*                                                                                      *\
 * Disable the child windows of the background bitmap, if this checkbox isn't checked.  *
\*                                                                                      */
    if(!(pHP->ulStatusFlag & BACKGROUNDBITMAP))
        DisableDialogItem(nbDDNotebookPage[PAGE_2].hwndNBPage, usChild2BackgroundBitmapCB,
            sizeof(usChild2BackgroundBitmapCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
    else
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDCB_BACKGROUNDBITMAP, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Setup bitmap name entryfield */
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDEF_BACKGROUNDBITMAP, EM_SETTEXTLIMIT,
        MPFROMSHORT(MAXNAMEL), (MPARAM)NULL);
    WinSetDlgItemText(nbDDNotebookPage[PAGE_2].hwndNBPage, DDEF_BACKGROUNDBITMAP,
        pHP->ucBackgroundBitmap);
                                        /* Setup bitmap radiobuttons */
    if(pHP->ulBackgroundBitmapFlag & BITMAPNORMAL)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDRB_BITMAPNORMAL, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    if(pHP->ulBackgroundBitmapFlag & BITMAPSCALED)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDRB_BITMAPSCALED, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    if(pHP->ulBackgroundBitmapFlag & BITMAPTILED)
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDRB_BITMAPTILED, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    else
        DisableDialogItem(nbDDNotebookPage[PAGE_2].hwndNBPage, usChild2BitmapTiledCB,
            sizeof(usChild2BitmapTiledCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
/*                                                                                      *\
 * Set tiled count of background bitmap into spinbuttons after initialising it into the *
 * range of 1 to 99 (taken from lower USHORT of ulBackgroundBitmapFlag).                *
\*                                                                                      */
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDSB_BITMAPTILEDCOUNT,
        SPBM_SETLIMITS, MPFROMLONG(99), MPFROMLONG(1));
    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDSB_BITMAPTILEDCOUNT,
        SPBM_SETCURRENTVALUE, MPFROMLONG(pHP->ulBackgroundBitmapFlag & 0xFFFF), (MPARAM)0);
    break;
    }

case WM_HSCROLL:                        /* Messages generated by horizontal scrollbars */
/*                                                                                      *\
 * This message is generated when a horizontal scrollbar is manipulated. See if it is   *
 * our scrollbar DDHSB_SCROLLPERCENTAGE and process.                                    *
\*                                                                                      */
    if(SHORT1FROMMP(mp1)==DDHSB_SCROLLPERCENTAGE)
        {
        UCHAR       ucBuffer[4];
        SHORT       sSliderPosition=SHORT1FROMMP(mp2);;

        switch(SHORT2FROMMP(mp2))
        {                               /* All messages contain the new slider position,
                                           so just use this value to change the priority
                                           delta entryfield value */
        case SB_LINELEFT:
            pHP->ulScrollPercentage-=5;
            break;

        case SB_PAGELEFT:
            pHP->ulScrollPercentage-=25;
            break;

        case SB_LINERIGHT:
            pHP->ulScrollPercentage+=5;
            break;

        case SB_PAGERIGHT:
            pHP->ulScrollPercentage+=25;
            break;

        case SB_SLIDERTRACK:
        case SB_SLIDERPOSITION:
            pHP->ulScrollPercentage=sSliderPosition*5;
            break;
        }
        if(((LONG)pHP->ulScrollPercentage)<0) pHP->ulScrollPercentage=0;
        if(pHP->ulScrollPercentage>100) pHP->ulScrollPercentage=100;
        WinSetDlgItemText(nbDDNotebookPage[PAGE_1].hwndNBPage, DDEF_SCROLLPERCENTAGE,
            (CHAR *)_itoa(pHP->ulScrollPercentage, ucBuffer, 10));
        WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDHSB_SCROLLPERCENTAGE,
            SBM_SETPOS, MPFROMSHORT(pHP->ulScrollPercentage/5), (MPARAM)NULL);
        }
    break;

case WM_CONTROL:                        /* Test for checkbuttons buttons pressed */
/*                                                                                      *\
 * Only if the DDCB_VIRTUALDESKTOP checkbox is pressed, its child windows are to be     *
 * enabled. Otherwise the are disabled, but allways visible.                            *
\*                                                                                      */
    {
    if(SHORT2FROMMP(mp1)==BN_CLICKED)   /* Was autoradio button clicked ? */
        switch(SHORT1FROMMP(mp1))
        {
        case DDCB_VIRTUALDESKTOP:       /* Virtal Desktop enable/disable checkbox */
            if((BOOL)WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_VIRTUALDESKTOP, BM_QUERYCHECK,
                (MPARAM)NULL, (MPARAM)NULL)==TRUE)
                                        /* Enable and show VirtualDesktopCB child windows */
                DisableDialogItem(nbDDNotebookPage[PAGE_1].hwndNBPage, usChild2VirtualDesktopCB,
                    sizeof(usChild2VirtualDesktopCB)/sizeof(USHORT), WS_VISIBLE);
            else
                {
                                        /* If move Desktop checkbox is checked, uncheck it */
                if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_MOVEDESKTOP))
                    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_MOVEDESKTOP, BM_SETCHECK,
                    MPFROMSHORT(FALSE), (MPARAM)NULL);
                                        /* If click to move checkbox is checked, uncheck it */
                if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_CLICK2MOVE))
                    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_CLICK2MOVE, BM_SETCHECK,
                    MPFROMSHORT(FALSE), (MPARAM)NULL);
                                        /* If overview checkbox is checked, uncheck it */
                if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_OVERVIEW))
                    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_OVERVIEW, BM_SETCHECK,
                    MPFROMSHORT(FALSE), (MPARAM)NULL);
                DisableDialogItem(nbDDNotebookPage[PAGE_1].hwndNBPage, usChild2VirtualDesktopCB,
                    sizeof(usChild2VirtualDesktopCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            break;

        case DDCB_MOVEDESKTOP:          /* Move WPS selected */
            if((BOOL)WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_MOVEDESKTOP, BM_QUERYCHECK,
                (MPARAM)NULL, (MPARAM)NULL)==TRUE)
                {                       /* If expand WPS is checked, uncheck it and disable */
                if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_EXPANDWPS))
                    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_EXPANDWPS, BM_SETCHECK,
                    MPFROMSHORT(FALSE), (MPARAM)NULL);
                DisableDialogItem(nbDDNotebookPage[PAGE_1].hwndNBPage, usChild2MoveDesktopCB,
                    sizeof(usChild2MoveDesktopCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            else
                DisableDialogItem(nbDDNotebookPage[PAGE_1].hwndNBPage, usChild2MoveDesktopCB,
                    sizeof(usChild2MoveDesktopCB)/sizeof(USHORT), WS_VISIBLE);
            break;

        case DDCB_SLIDINGFOCUS:         /* Sliding Focus enable/disable checkbox */
            if((BOOL)WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_SLIDINGFOCUS, BM_QUERYCHECK,
                (MPARAM)NULL, (MPARAM)NULL)==TRUE)
                                        /* Enable and show SlidingFocusCB child windows */
                DisableDialogItem(nbDDNotebookPage[PAGE_1].hwndNBPage, usChild2SlidingFocusCB,
                    sizeof(usChild2SlidingFocusCB)/sizeof(USHORT), WS_VISIBLE);
            else
                {                       /* If preserve Z-order is checked, uncheck it */
                if(WinQueryButtonCheckstate(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_PRESERVEZORDER))
                    WinSendDlgItemMsg(nbDDNotebookPage[PAGE_1].hwndNBPage, DDCB_PRESERVEZORDER, BM_SETCHECK,
                    MPFROMSHORT(FALSE), (MPARAM)NULL);
                                        /* Disable and show SlidingFocusCB child windows */
                DisableDialogItem(nbDDNotebookPage[PAGE_1].hwndNBPage, usChild2SlidingFocusCB,
                    sizeof(usChild2SlidingFocusCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            break;

        case DDCB_BACKGROUNDBITMAP:     /* Background bitmap enable/disable checkbox */
            if((BOOL)WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDCB_BACKGROUNDBITMAP, BM_QUERYCHECK,
                (MPARAM)NULL, (MPARAM)NULL)==TRUE)
                {
                                        /* Enable and show BackgroundBitmapCB child windows */
                DisableDialogItem(nbDDNotebookPage[PAGE_2].hwndNBPage, usChild2BackgroundBitmapCB,
                    sizeof(usChild2BackgroundBitmapCB)/sizeof(USHORT), WS_VISIBLE);
                                        /* If bitmap should be not tiled, ensure that spinbutton is disabled */
                if((BOOL)WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDRB_BITMAPTILED, BM_QUERYCHECK,
                    (MPARAM)NULL, (MPARAM)NULL)==FALSE)
                    DisableDialogItem(nbDDNotebookPage[PAGE_2].hwndNBPage, usChild2BitmapTiledCB,
                        sizeof(usChild2BitmapTiledCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            else
                                        /* Disable and show BackgroundBitmapCB child windows */
                DisableDialogItem(nbDDNotebookPage[PAGE_2].hwndNBPage, usChild2BackgroundBitmapCB,
                    sizeof(usChild2BackgroundBitmapCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            break;

        case DDRB_BITMAPNORMAL:         /* Enable tile count spinbutton on DDRB_BITMAPTILED otherwise disable it */
        case DDRB_BITMAPSCALED:
        case DDRB_BITMAPTILED:
            if((BOOL)WinSendDlgItemMsg(nbDDNotebookPage[PAGE_2].hwndNBPage, DDRB_BITMAPTILED, BM_QUERYCHECK,
                (MPARAM)NULL, (MPARAM)NULL)==TRUE)
                                        /* Enable and show BitmapTiledCB child windows */
                DisableDialogItem(nbDDNotebookPage[PAGE_2].hwndNBPage, usChild2BitmapTiledCB,
                    sizeof(usChild2BitmapTiledCB)/sizeof(USHORT), WS_VISIBLE);
            else
                                        /* Disable and show BitmapTiledCB child windows */
                DisableDialogItem(nbDDNotebookPage[PAGE_2].hwndNBPage, usChild2BitmapTiledCB,
                    sizeof(usChild2BitmapTiledCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            break;
        }
    }
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_CANCEL:                    /* Cancel key pressed on a dialog within a notebook page,
                                           ignore it within dialog but post it to parent dialog */
        {
        HWND    hwndNotebook;

                                        /* Query parent of current notebook page window,
                                           Query parent of this, which is the notebook */
        hwndNotebook=WinQueryWindow(WinQueryWindow(hwndDlg, QW_PARENT), QW_PARENT);
                                        /* Post CANCEL to parent of notebook which is the dialog */
        WinPostMsg(WinQueryWindow(hwndNotebook, QW_PARENT), WM_COMMAND,
            MPFROMSHORT(DID_CANCEL), MPFROM2SHORT(CMDSRC_ACCELERATOR, FALSE));
                                        /* We have handled the message */
        return((MRESULT)TRUE);
        }

    case DDPB_WINFILEDLG:               /* Locate file by standard file dialog */
/*                                                                                      *\
 * The user selected the File Find pushbutton to get the standard file dialog to find   *
 * a background bitmap.                                                                 *
\*                                                                                      */
        {
        FILEDLG fdFileDlg;              /* Standard file dialog control */
        HWND    hwndFileDlg;            /* Handle of standard file dialog */

                                        /* Clear out structure */
        memset(&fdFileDlg, 0, sizeof(FILEDLG));
                                        /* Structure size */
        fdFileDlg.cbSize=sizeof(FILEDLG);
                                        /* FDS_* flags */
        fdFileDlg.fl=FDS_CENTER | FDS_OPEN_DIALOG | FDS_PRELOAD_VOLINFO;
                                        /* Dialog title string */
        fdFileDlg.pszTitle="PC/2 File Search";
                                        /* Initial path, filename or file filter */
        strcpy(fdFileDlg.szFullFile, "*.BMP");
                                        /* Open the standard file dialog ...*/
        hwndFileDlg=WinFileDlg(HWND_DESKTOP, hwndDlg, &fdFileDlg);
        if(hwndFileDlg && (fdFileDlg.lReturn==DID_OK))
                                        /* Load the values of the standard file dialog to
                                           the corresponding entryfield in the Desktop
                                           settings dialog */
            WinSetDlgItemText(nbDDNotebookPage[PAGE_2].hwndNBPage, DDEF_BACKGROUNDBITMAP,
                fdFileDlg.szFullFile);
        }
        break;
    }
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Program Installation dialog.                *
 * Req:                                                                                 *
 *      StartSession .. a structure of type SESSIONDATA where the information entered   *
 *                      in the dialog is entered. If DID_OK is pressed this structure   *
 *                      is used to start the session and set its priority.              *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY PI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static HWND         hwndNB;             /* Program Installation dialog notebook window handle */
static SESSIONDATA  *pSessionData;      /* Pointer to SESSIONDATA structure for current instance */

switch(msg)
{
case WM_INITDLG:
    {
    HPS         hps;                    /* Used to query font metrics for tab size */
    FONTMETRICS fmFontMetrics;
    POINTL      aptlTabText[TXTBOX_COUNT];
    USHORT      usTabTextLength=50;
    SWP         swp;
    ULONG       ulPage, ulPageID;
    RECTL       rectlNB;                /* Notebook rectangle to load notebook dialog page into */
    POINTL      ptlNB;                  /* Notebook page conversion from dialog units to pixels */

                                        /* Access parameters passed */
    pSessionData=(SESSIONDATA *)PVOIDFROMMP(mp2);
    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
                                        /* Get window handle of notebook */
    hwndNB=WinWindowFromID(hwndDlg, PINB_NOTEBOOK);
                                        /* Set spiral binding */
    WinSetWindowULong(hwndNB, QWL_STYLE, WinQueryWindowULong(hwndNB, QWL_STYLE) | BKS_SPIRALBIND);
    hps=WinGetPS(hwndNB);               /* Get presentation space to query fontmetrics */
    memset(&fmFontMetrics, 0, sizeof(FONTMETRICS));
    if(GpiQueryFontMetrics(hps, sizeof(FONTMETRICS), &fmFontMetrics))
        fmFontMetrics.lMaxBaselineExt<<=1;
    else
        fmFontMetrics.lMaxBaselineExt=30;
                                        /* Load and associate all dialogs of the Program
                                           Installation dialog to notebook pages */
    for(ulPage=0; nbPINotebookPage[ulPage].pDialogWndProc!=NULL; ulPage++)
        {
                                        /* Load a dialog into a page */
        if(!(nbPINotebookPage[ulPage].hwndNBPage=WinLoadDlg(
            hwndDlg,                    /* Parent window */
            hwndDlg,                    /* Owner window */
                                        /* Window procedure */
            nbPINotebookPage[ulPage].pDialogWndProc,
            NULLHANDLE,                 /* Resource idendity */
                                        /* Dialog idendity */
            nbPINotebookPage[ulPage].ulIDDialogPage,
            NULL)))                     /* Application defined data area */
                                        /* On error suggest exiting */
        USR_ERR("Can't load dialog resources - suggest exiting...",
            pHP->hwndFrame, pHP->hwndFrame);
                                        /* Query length of largest tab text */
        if(GpiQueryTextBox(hps, strlen(nbPINotebookPage[ulPage].pszTab),
            nbPINotebookPage[ulPage].pszTab, TXTBOX_COUNT, aptlTabText))
            if(usTabTextLength<aptlTabText[TXTBOX_CONCAT].x)
                usTabTextLength=aptlTabText[TXTBOX_CONCAT].x;
        ulPageID=(ULONG)WinSendMsg(     /* Insert a page into the notebook */
            hwndNB,
            BKM_INSERTPAGE,
            (MPARAM)NULL,               /* Page ID, ignored if BKA_FIRST or BKA_LAST
                                           specified */
                                        /* Style and order attribute */
            MPFROM2SHORT(BKA_MAJOR | BKA_STATUSTEXTON | BKA_AUTOPAGESIZE, BKA_LAST));
        nbPINotebookPage[ulPage].ulIDPage=ulPageID;
                                        /* Set text into the status line */
        WinSendMsg(hwndNB,
            BKM_SETSTATUSLINETEXT,
            MPFROMP(ulPageID),
            MPFROMP(nbPINotebookPage[ulPage].pszStatusLine));
                                        /* Set text into tab */
        WinSendMsg(hwndNB,
            BKM_SETTABTEXT,
            MPFROMP(ulPageID),
            MPFROMP(nbPINotebookPage[ulPage].pszTab));
                                        /* Associate page with dialog */
        WinSendMsg(hwndNB,
            BKM_SETPAGEWINDOWHWND,
            MPFROMP(ulPageID),
            MPFROMLONG(nbPINotebookPage[ulPage].hwndNBPage));
        }
    WinReleasePS(hps);
    WinSendMsg(hwndNB,                  /* Set background to dialog box background */
        BKM_SETNOTEBOOKCOLORS,
        MPFROMLONG(SYSCLR_FIELDBACKGROUND),
        MPFROMSHORT(BKA_BACKGROUNDPAGECOLORINDEX));
    WinSendMsg(hwndNB,                  /* Set tab dimension */
        BKM_SETDIMENSIONS,
        MPFROM2SHORT(usTabTextLength+5, (SHORT)((float)fmFontMetrics.lMaxBaselineExt*0.8)),
        MPFROMSHORT(BKA_MAJORTAB));
                                        /* Notebook page dialog panel size in dialog units */
    ptlNB.x=NOTEBOOKPAGE_CX;
    ptlNB.y=NOTEBOOKPAGE_CY;
                                        /* Map dialog units to screen pixels */
    WinMapDlgPoints(hwndDlg, &ptlNB, 1, TRUE);
                                        /* Query notebook size and position in pixels */
    WinQueryWindowPos(hwndNB, &swp);
    rectlNB.yBottom=rectlNB.xLeft=0;
    rectlNB.xRight=swp.cx;
    rectlNB.yTop=swp.cy;
                                        /* Return size of notebook page in pixel for given
                                           notebook window size (with tab text size set) */
    WinSendMsg(hwndNB, BKM_CALCPAGERECT, MPFROMP(&rectlNB), MPFROMSHORT(TRUE));
                                        /* Calculate notebook size so that notebook dialog page fits
                                           into the notebook page */
    swp.cx-=(rectlNB.xRight-rectlNB.xLeft)-ptlNB.x;
    swp.cy-=(rectlNB.yTop-rectlNB.yBottom)-ptlNB.y;
                                        /* Size notebook accordingly */
    swp.fl=SWP_SIZE;
    swp.x=swp.y=0;
    swp.hwndInsertBehind=NULLHANDLE;
    swp.hwnd=hwndNB;
    WinSetMultWindowPos(pHP->habPc2, &swp, 1);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    swp.fl=SWP_MOVE;                    /* Center dialog window */
    swp.x=(pHP->swpScreen.cx-swp.cx)>>1;
    swp.y=(pHP->swpScreen.cy-swp.cy)>>1;
    swp.cx=swp.cy=0;
    swp.hwndInsertBehind=NULLHANDLE;
    WinSetMultWindowPos(pHP->habPc2, &swp, 1);
                                        /* Now initialize all notebook page dialogs
                                           by posting to 1st page */
    WinPostMsg(nbPINotebookPage[PAGE_1].hwndNBPage, WM_SETUPNOTEBOOKPAGES, MPFROMP(pSessionData), (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    {
    ULONG   ulPageId, ulPage;
    ULONG   ulHelp[]={PIID_PAGE1, PIID_PAGE2, PIID_PAGE3, PIID_PAGE4, PIID_PAGE5};

    ulPageId=(ULONG)WinSendMsg(hwndNB,  /* Query the currently active page */
        BKM_QUERYPAGEID,
        MPFROMLONG(0),                  /* Location page ID, ignored if */
                                        /* Page ID is BKA_TOP */
        MPFROM2SHORT(BKA_TOP, BKA_MAJOR));
    for(ulPage=0; nbPINotebookPage[ulPage].pDialogWndProc!=NULL; ulPage++)
        if(nbPINotebookPage[ulPage].ulIDPage==ulPageId)
            if(pHP->hwndHelp!=NULLHANDLE)
                WinSendMsg(pHP->hwndHelp, HM_DISPLAY_HELP,
                    MPFROMSHORT(ulHelp[ulPage]), HM_RESOURCEID);
    }
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Query the Program Title, Filename, Parameters and DOS Settings and copy them to the  *
 * corresponding entries in the StartSession structure.                                 *
\*                                                                                      */
        {
        UCHAR   PgmDosSettings[LENDOSSETTINGS];
        UCHAR   *pucChar;

        WinQueryWindowText(             /* Query data entered in Program title entry */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndNBPage, PIEF_PROGRAMTITLE),
                                        /* into SessionData structure */
            sizeof(pSessionData->PgmTitle),
            pSessionData->PgmTitle);
        WinQueryWindowText(             /* Query data entered in Path and Filename entry */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndNBPage, PIEF_PATHFILENAME),
                                        /* into SessionData structure */
            sizeof(pSessionData->PgmName),
            pSessionData->PgmName);
        WinQueryWindowText(             /* Query data entered in working Directory entry */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndNBPage, PIEF_DIRECTORY),
                                        /* into SessionData structure */
            sizeof(pSessionData->PgmDirectory),
            pSessionData->PgmDirectory);
        WinQueryWindowText(         /* Query data entered in Parameters entry */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndNBPage, PIEF_PARAMETERS),
                                        /* into SessionData structure */
            sizeof(pSessionData->PgmInputs),
            pSessionData->PgmInputs);
        WinQueryWindowText(             /* Query data entered in DOS Settings MLE */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndNBPage, PIMLE_DOSSETTINGS),
                                        /* into SessionData structure */
            sizeof(PgmDosSettings),
            PgmDosSettings);
                                        /* Deallocate old and allocate new DOS settings */
        free(pSessionData->PgmDosSettings);
                                        /* Remove all trailing \r and \n to add just 1 \r\n */
        for(pucChar=strchr(PgmDosSettings, '\0'); pucChar!=PgmDosSettings; )
            if((*--pucChar=='\r') || (*pucChar=='\n')) *pucChar='\0';
            else break;
                                        /* If not empty string ("\0") add 1 \r\n */
        if(pucChar!=PgmDosSettings) strcat(PgmDosSettings, "\r\n");
        pSessionData->PgmDosSettings=strdup(PgmDosSettings);
        }
/*                                                                                      *\
 * Query the Program Type radiobuttons and set the corresponding bit into the           *
 * StartSession structure. No change or the default selection are preselected during    *
 * WM_INITDLG. It must be one of them set, so we don't need else parts for if-else.     *
\*                                                                                      */
                                        /* Program type: WPS default */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_SHELL))
            pSessionData->SessionType=PROG_DEFAULT;
                                        /* Program type: OS/2 Fullscreen */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_OS2FULLSCREEN))
            pSessionData->SessionType=PROG_FULLSCREEN;
                                        /* Program type: OS/2 Window */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_OS2WINDOW))
            pSessionData->SessionType=PROG_WINDOWABLEVIO;
                                        /* Program type: PM */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_PM))
            pSessionData->SessionType=PROG_PM;
                                        /* Program type: DOS Fullscreen */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_DOSFULLSCREEN))
            pSessionData->SessionType=PROG_VDM;
                                        /* Program type: DOS Window */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_DOSWINDOW))
            pSessionData->SessionType=PROG_WINDOWEDVDM;
                                        /* Program type: WPS Object */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_WPSOBJECT))
            pSessionData->SessionType=PROG_WPSOBJECT;
                                        /* Program type: WIN-OS2 session. Type can then be
                                           queried from WIN-OS2 session radiobuttons */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_WINOS2))
            {
            BOOL    bCommonVDM=TRUE;

            if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PICB_WINSEPARATE))
                bCommonVDM=FALSE;
            else
                {                       /* If we start into a common WIN-OS2 seamless VDM, ensure
                                           that the program name contains no path information */
                UCHAR   ucBuffer[EF_SIZE255+1];
                UCHAR   *pucPgmName;

                strcpy(ucBuffer, pSessionData->PgmName);
                if(pucPgmName=strrchr(ucBuffer, '\\'))
                    strcpy(pSessionData->PgmName, ++pucPgmName);
                }
            if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_WINREAL))
                pSessionData->SessionType=PROG_WINDOW_REAL;
            if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_WINSTANDARD))
                pSessionData->SessionType=
                    (bCommonVDM==TRUE ? PROG_31_STDSEAMLESSCOMMON : PROG_WINDOW_PROT);
            if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_WIN386ENHANCED))
                pSessionData->SessionType=
                    (bCommonVDM==TRUE ? PROG_31_ENHSEAMLESSCOMMON : PROG_31_ENH);
            }
/*                                                                                      *\
 * Query Program Style radiobuttons and set the corresponding bits in the StartSession  *
 * structure. No change or the default selection are preselected during WM_INITDLG.     *
\*                                                                                      */
                                        /* Program style: Maximized */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndNBPage, PIRB_MAXIMIZED))
            pSessionData->PgmControl|=SSF_CONTROL_MAXIMIZE;
        else
            pSessionData->PgmControl&=(~SSF_CONTROL_MAXIMIZE);
                                        /* Program style: Minimized */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndNBPage, PIRB_MINIMIZED))
            pSessionData->PgmControl|=SSF_CONTROL_MINIMIZE;
        else
            pSessionData->PgmControl&=(~SSF_CONTROL_MINIMIZE);
                                        /* Program style: Invisible */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndNBPage, PICB_INVISIBLE))
            pSessionData->PgmControl|=SSF_CONTROL_INVISIBLE;
        else
            pSessionData->PgmControl&=(~SSF_CONTROL_INVISIBLE);
                                        /* Program style: No autoclose */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndNBPage, PICB_NOAUTOCLOSE))
            pSessionData->PgmControl|=SSF_CONTROL_NOAUTOCLOSE;
        else
            pSessionData->PgmControl&=(~SSF_CONTROL_NOAUTOCLOSE);
                                        /* Program style: Autostart */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndNBPage, PICB_AUTOSTART))
            pSessionData->PgmControl|=SSF_CONTROL_AUTOSTART;
        else
            pSessionData->PgmControl&=(~SSF_CONTROL_AUTOSTART);
                                        /* Program style: Background */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndNBPage, PICB_BACKGROUND))
            pSessionData->FgBg|=SSF_FGBG_BACK;
        else
            pSessionData->FgBg&=(~SSF_FGBG_BACK);
/*                                                                                      *\
 * Query Size & Position radiobutton, set the corresponding bit, and load the values    *
 * from the corresponding entryfields for the StartSession structure.                   *
\*                                                                                      */
        {
        UCHAR   Buffer[6];              /* Prefix, 4 numbers, \0 */

        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndNBPage, PICB_SIZEPOSITION))
            pSessionData->PgmControl|=SSF_CONTROL_SETPOS;
        else
            pSessionData->PgmControl&=(~SSF_CONTROL_SETPOS);
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_3].hwndNBPage, PIEF_X), sizeof(Buffer), Buffer);
        pSessionData->InitXPos=(SHORT)atol(Buffer);
        if(pSessionData->InitXPos<pHP->VirtualDesktopMin.x)
            pSessionData->InitXPos=pHP->VirtualDesktopMin.x;
        if(pSessionData->InitXPos>2*pHP->VirtualDesktopMax.x)
            pSessionData->InitXPos=pHP->VirtualDesktopMax.x;
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_3].hwndNBPage, PIEF_Y), sizeof(Buffer), Buffer);
        pSessionData->InitYPos=(SHORT)atol(Buffer);
        if(pSessionData->InitYPos<pHP->VirtualDesktopMin.y)
            pSessionData->InitYPos=pHP->VirtualDesktopMin.y;
        if(pSessionData->InitYPos>2*pHP->VirtualDesktopMax.y)
            pSessionData->InitYPos=pHP->VirtualDesktopMax.y;
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_3].hwndNBPage, PIEF_XSIZE), sizeof(Buffer), Buffer);
        pSessionData->InitXSize=(USHORT)atol(Buffer);
        if(pSessionData->InitXSize<0) pSessionData->InitXSize*=-1;
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_3].hwndNBPage, PIEF_YSIZE), sizeof(Buffer), Buffer);
        pSessionData->InitYSize=(USHORT)atol(Buffer);
        if(pSessionData->InitYSize<0) pSessionData->InitYSize*=-1;
/*                                                                                      *\
 * Query Hotkey settings notebook page                                                  *
\*                                                                                      */
        {
        UCHAR   ucBuffer[]=" ";

        pSessionData->SwpFlag=0;        /* Assume no flags, which will now be corrected */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndNBPage, PIRB_WSMAXIMIZED))
            pSessionData->SwpFlag=SWP_MAXIMIZE;
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndNBPage, PIRB_WSRESTORE))
            pSessionData->SwpFlag=SWP_RESTORE;
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndNBPage, PICB_DONTMOVE))
            pSessionData->SwpFlag|=SWP_NOMOVE;
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndNBPage, PIRB_CTRL))
            pSessionData->KeyData.usFlags=KC_CTRL;
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndNBPage, PIRB_ALT))
            pSessionData->KeyData.usFlags=KC_ALT;
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_4].hwndNBPage, PICBX_HOTKEY),
            sizeof(ucBuffer), ucBuffer);
                                        /* If no hotkey is contained in the hotkey combobox
                                           none is available or it is disabled ignore hotkey feature */
        if(!strcmp(ucBuffer, "") ||
            !WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndNBPage, PICB_HOTKEYENABLED))
            {
            pSessionData->KeyData.usFlags=0;
            pSessionData->KeyData.usCh=0;
            }
        else                            /* Mark the selected key as used */
            {
            KEYDATA     *pKeyDataIndex;
            ULONG       ulTemp1;

            pSessionData->KeyData.usCh=(USHORT)ucBuffer[0];
                                        /* Point to Hotkey control structure */
            pKeyDataIndex=pHP->pKeyData;
                                        /* Loop for all keys and set used one */
            for(ulTemp1=0; ulTemp1<=KEYDATACOUNT; pKeyDataIndex++, ulTemp1++)
                {
                                        /* Set current key to used */
                if((pKeyDataIndex->usCh==pSessionData->KeyData.usCh)  &&
                    (pKeyDataIndex->usFlags==pSessionData->KeyData.usFlags))
                    {
                    pKeyDataIndex->bUsed=TRUE;
                    pKeyDataIndex->pMenuData=pSessionData->KeyData.pMenuData;
                    }
                }
            }
                                        /* Query the name of the session to search in Window List
                                           or in titlebars. If nothing is entered take the Program
                                           Title entryfield text, but ensure that tildes (~) are
                                           removed, because the session is launched with tiles
                                           removed. The tildes are only used to define mnemonics
                                           within PC/2's Popup-Menu. */
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_4].hwndNBPage, PIEF_SESSIONTITLE),
            sizeof(pSessionData->WindowTitle), pSessionData->WindowTitle);
        if(!strcmp(pSessionData->WindowTitle, ""))
            {
            UCHAR   *pucTo, *pucFrom;

            for(pucFrom=pSessionData->PgmTitle, pucTo=pSessionData->WindowTitle; *pucFrom; pucFrom++)
                if(*pucFrom!='~') *pucTo++=*pucFrom;
            *pucTo='\0';                /* Zero termination */
            }
        }
/*                                                                                      *\
 * Query Program Priority radiobuttons and set the corresponding bits in the            *
 * StartSession structure. The default priority is No-Change. The listbox is also       *
 * queried and the Delta Priority is also set in the StartSession structure. It must be *
 * one of the radiobuttons, so else part of if-else is not required.                    *
\*                                                                                      */
                                        /* Program Priority: No-Change */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_5].hwndNBPage, PIRB_NOCHANGE))
            pSessionData->PriorityClass=PRTYC_NOCHANGE;
                                        /* Program Priority: Idle-time */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_5].hwndNBPage, PIRB_IDLETIME))
            pSessionData->PriorityClass=PRTYC_IDLETIME;
                                        /* Program Priority: Regular */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_5].hwndNBPage, PIRB_REGULAR))
            pSessionData->PriorityClass=PRTYC_REGULAR;
                                        /* Program Priority: Time-critical */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_5].hwndNBPage, PIRB_TIMECRITICAL))
            pSessionData->PriorityClass=PRTYC_TIMECRITICAL;
                                        /* Program Priority: Server */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_5].hwndNBPage, PIRB_FOREGROUNDSERVER))
            pSessionData->PriorityClass=PRTYC_FOREGROUNDSERVER;
                                        /* Query index of selected item on correct it */
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_5].hwndNBPage, PIEF_PRIORITYDELTA),
            sizeof(Buffer), Buffer);
        pSessionData->PriorityDelta=(SHORT)atol(Buffer);
        }
                                        /* Dialog terminated with DID_OK */
        WinDismissDlg(hwndDlg, DID_OK);
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
                                        /* Dialog terminated with DID_CANCEL */
        WinDismissDlg(hwndDlg, DID_CANCEL);
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Program Installation dialog notebook pages. *
 * Req:                                                                                 *
 *      nbPINotebookPage[] ...  Structure of the Program Installtion notebook pages     *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY PI_NotebookProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static SESSIONDATA  *pSessionData;      /* Pointer to SESSIONDATA structure for current instance */

static SHORT        sPriorityDelta=PRTYC_NOCHANGE;

switch(msg)
{
/*                                                                                      *\
 * Syntax: WM_SETUPNOTEBOOKPAGES, (SESSIONDATA *pSessionData), NULL                     *                                           *
\*                                                                                      */
case WM_SETUPNOTEBOOKPAGES:
    {
/*                                                                                      *\
 * Set the maximum number of chars accepted from the entryfield (thus overwriting the   *
 * default number of 63 and load the data from the SESSIONDATA structure SessionData    *
 * into the entryfields.                                                                *
\*                                                                                      */
                                        /* Access parameters passed */
    pSessionData=(SESSIONDATA *)PVOIDFROMMP(mp1);
    WinSendDlgItemMsg(                  /* Send message to dialog window */
                                        /* Handle of page 1 */
        nbPINotebookPage[PAGE_1].hwndNBPage,
        PIEF_PROGRAMTITLE,              /* Program title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 60 */
        MPFROMSHORT(MAXNAMEL),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Load the default text of the entryfield */
        nbPINotebookPage[PAGE_1].hwndNBPage, PIEF_PROGRAMTITLE, pSessionData->PgmTitle);
    WinSendDlgItemMsg(
        nbPINotebookPage[PAGE_1].hwndNBPage,
        PIEF_PATHFILENAME,              /* Path and Filename title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(nbPINotebookPage[PAGE_1].hwndNBPage, PIEF_PATHFILENAME, pSessionData->PgmName);
    WinSendDlgItemMsg(
        nbPINotebookPage[PAGE_1].hwndNBPage,
        PIEF_DIRECTORY,                 /* Working directory entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(nbPINotebookPage[PAGE_1].hwndNBPage, PIEF_DIRECTORY, pSessionData->PgmDirectory);
    WinSendDlgItemMsg(
        nbPINotebookPage[PAGE_1].hwndNBPage,
        PIEF_PARAMETERS,                /* Program Parameters entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(nbPINotebookPage[PAGE_1].hwndNBPage, PIEF_PARAMETERS, pSessionData->PgmInputs);
                                        /* Insert DOS Settings. If none exist add the
                                           IDLE_* default settings */
    if(strlen(pSessionData->PgmDosSettings)!=0)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_1].hwndNBPage,
            PIMLE_DOSSETTINGS,          /* Program DOS Settings entryfield */
            MLM_INSERT,                 /* Insert text */
            MPFROMP(pSessionData->PgmDosSettings),
            (MPARAM)NULL);
    else
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_1].hwndNBPage,
            PIMLE_DOSSETTINGS,          /* Program DOS Settings entryfield */
            MLM_INSERT,                 /* Insert text */
            MPFROMP("IDLE_SECONDS=5\nIDLE_SENSITIVITY=100\n"),
            (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program type group to the state indicated by *
 * the SessionData structure.                                                           *
\*                                                                                      */
    WinSendMsg(hwndDlg, WM_SETUPPROGRAMTYPE,
        MPFROMSHORT(pSessionData->SessionType), (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program style group to the state indicated   *
 * by the SessionData structure.                                                        *
\*                                                                                      */
    if(!(pSessionData->PgmControl & (SSF_CONTROL_MAXIMIZE | SSF_CONTROL_MINIMIZE)))
        WinSendDlgItemMsg(              /* Send message to Default radiobutton */
                                        /* Handle of dialog window */
            nbPINotebookPage[PAGE_3].hwndNBPage,
            PIRB_DEFAULTSTYLE,          /* Program style: Default radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(pSessionData->PgmControl & SSF_CONTROL_MAXIMIZE)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndNBPage,
            PIRB_MAXIMIZED,             /* Program style: Maximized radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(pSessionData->PgmControl & SSF_CONTROL_MINIMIZE)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndNBPage,
            PIRB_MINIMIZED,             /* Program style: Minimized radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(pSessionData->PgmControl & SSF_CONTROL_INVISIBLE)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndNBPage,
            PICB_INVISIBLE,             /* Program style: Invisible checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(pSessionData->PgmControl & SSF_CONTROL_NOAUTOCLOSE)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndNBPage,
            PICB_NOAUTOCLOSE,           /* Program style: NoAutoClose checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(pSessionData->PgmControl & SSF_CONTROL_AUTOSTART)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndNBPage,
            PICB_AUTOSTART,             /* Program style: Autostart checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(pSessionData->FgBg & SSF_FGBG_BACK)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndNBPage,
            PICB_BACKGROUND,            /* Program style: Background checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program Size & Position group to the state   *
 * indicated by the SessionData structure.                                              *
\*                                                                                      */
    if(pSessionData->PgmControl & SSF_CONTROL_SETPOS)
        {                               /* If requested select it for the first time */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_3].hwndNBPage, PICB_SIZEPOSITION, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
        WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
            MPFROMSHORT(TRUE), MPFROMSHORT(TRUE));
        }
    else
        WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
            MPFROMSHORT(FALSE), MPFROMSHORT(TRUE));
    }
                                        /* Simulate the click to update the dialog's child windows */
    WinSendMsg(nbPINotebookPage[PAGE_3].hwndNBPage, WM_CONTROL,
        MPFROM2SHORT(PICB_SIZEPOSITION, BN_CLICKED), (MPARAM)NULL);
/*                                                                                      *\
 * Now we initialize the priority settings notebook page.                               *
\*                                                                                      */
     WinSendMsg(hwndDlg, WM_SETUPPROGRAMPRIORITY,
        MPFROMSHORT(pSessionData->PriorityClass), MPFROMSHORT(pSessionData->PriorityDelta));
/*                                                                                      *\
 * Now we initialize the hotkey settings notebook page.                                 *
\*                                                                                      */
     WinSendMsg(hwndDlg, WM_SETUPHOTKEY, (MPARAM)NULL, (MPARAM)NULL);
    break;

/*                                                                                      *\
 * Syntax: WM_SETUPPROGRAMTYPE, USHORT SessionType, NULL                                *
\*                                                                                      */
case WM_SETUPPROGRAMTYPE:
/*                                                                                      *\
 * Adjust the Program Type radiobuttons by selecting only the button corresponding to   *
 * the SessionType.                                                                     *
\*                                                                                      */
    {                                   /* Radiobutton IDs sorted */
    USHORT      usSessionTypeRBs[]={PIRB_SHELL, PIRB_OS2FULLSCREEN, PIRB_OS2WINDOW,
                                    PIRB_PM, PIRB_DOSFULLSCREEN, PIRB_DOSWINDOW,
                                    PIRB_WPSOBJECT};
                                        /* Corresponding session type IDs sorted */
    USHORT      usSessionTypeIDs[]={PROG_DEFAULT    , PROG_FULLSCREEN   , PROG_WINDOWABLEVIO,
                                    PROG_PM         , PROG_VDM          , PROG_WINDOWEDVDM,
                                    PROG_WPSOBJECT};
                                        /* Radiobutton IDs sorted */
    USHORT      usWINOS2TypeRBs[]={PIRB_WINREAL, PIRB_WINSTANDARD, PIRB_WIN386ENHANCED,
                                   PIRB_WINSTANDARD, PIRB_WIN386ENHANCED};
                                        /* Corresponding session type IDs sorted */
    USHORT      usWINOS2TypeIDs[]={PROG_WINDOW_REAL, PROG_WINDOW_PROT, PROG_31_ENH,
                                   PROG_31_STDSEAMLESSCOMMON, PROG_31_ENHSEAMLESSCOMMON};
    USHORT      usSessionType=SHORT1FROMMP(mp1);
    USHORT      usTemp;
                                        /* Loop for all buttons and deselect all but the
                                           one specified in usSessionType */
    for(usTemp=0; usTemp<=(sizeof(usSessionTypeRBs)/sizeof(USHORT)); usTemp++)
        if(usSessionTypeIDs[usTemp]==usSessionType)
            {
            WinSendDlgItemMsg(          /* Send message to one Program Type radiobutton,
                                           this only updates the radiobutton but doesn't
                                           create a WM_CONTROL message */
                                        /* Handle of dialog window */
                nbPINotebookPage[PAGE_2].hwndNBPage,
                                        /* Program type radiobutton */
                usSessionTypeRBs[usTemp],
                BM_SETCHECK,            /* Set it to pressed */
                MPFROMSHORT(TRUE),
                (MPARAM)NULL);
                                        /* Simulate the click to update the dialog's child windows */
            WinSendMsg(nbPINotebookPage[PAGE_2].hwndNBPage, WM_CONTROL,
                MPFROM2SHORT(usSessionTypeRBs[usTemp], BN_CLICKED), (MPARAM)NULL);
            }
    switch(usSessionType)
    {                                   /* WIN-OS2 sessions must be treated similar */
    case PROG_WINDOW_REAL:
    case PROG_WINDOW_PROT:
    case PROG_31_ENH:
                                        /* For seamless separate WIN-OS2 session check PICB_WINSEPARATE */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_2].hwndNBPage, PICB_WINSEPARATE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    case PROG_31_STDSEAMLESSCOMMON:
    case PROG_31_ENHSEAMLESSCOMMON:
                                        /* Loop for all WIN-OS2 buttons and deselect all but the
                                           one specified in usSessionType */
        for(usTemp=0; usTemp<=(sizeof(usWINOS2TypeRBs)/sizeof(USHORT)); usTemp++)
            if(usWINOS2TypeIDs[usTemp]==usSessionType)
                WinSendDlgItemMsg(nbPINotebookPage[PAGE_2].hwndNBPage, usWINOS2TypeRBs[usTemp],
                    BM_SETCHECK, MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check WIN-OS2 session type radiobutton */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_WINOS2, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
        WinSendMsg(nbPINotebookPage[PAGE_2].hwndNBPage, WM_CONTROL,
            MPFROM2SHORT(PIRB_WINOS2, BN_CLICKED), (MPARAM)NULL);
        break;

    default:
                                        /* Check WIN standard session radiobutton, because at
                                           least one should be checked, if no WIN-OS2 session
                                           type is selected */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_2].hwndNBPage, PICB_WINSEPARATE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_2].hwndNBPage, PIRB_WINSTANDARD, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
        break;
    }
                                        /* Hide DOS Settings window until the application
                                           type is DOS Window or DOS Fullscreen */
    if(usSessionType==PROG_WPSOBJECT)
                                        /* Only default Style is allowed */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_3].hwndNBPage, PIRB_DEFAULTSTYLE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETUPSIZEPOSITION, (BOOL bWriteable), (BOOL bInsert)                      *
\*                                                                                      */
case WM_SETUPSIZEPOSITION:
/*                                                                                      *\
 * The 4 entryfields for the Size&Position are a bit more complicated to handle.        *
 * First we set the entryfields to a size of 4 and the default values are read from the *
 * SessionData structure. Only if Size&Position is selected, this 4 entryfields are not *
 * readonly. Flag bWriteable is true if Size&Position is selected, Flag bInsert is true *
 * if we write the values the first time.                                               *
\*                                                                                      */
    {
    USHORT      usSizePositionEFs[]={PIEF_X, PIEF_Y, PIEF_XSIZE, PIEF_YSIZE};
    BOOL        bWriteable=SHORT1FROMMP(mp1);
    BOOL        bInsert=SHORT1FROMMP(mp2);
    USHORT      usTemp;
    SHORT       *psSizePosition;
    UCHAR       ucBuffer[6];            /* Prefix, 4 numbers, \0 */

                                        /* Get first Size & Position value */
    psSizePosition=&pSessionData->InitXPos;
                                        /* Loop for all entryfields and enable and insert
                                           values into them */
    for(usTemp=0; usTemp<=(sizeof(usSizePositionEFs)/sizeof(USHORT));
        usTemp++, psSizePosition++)
        {
        if(bWriteable==TRUE)            /* If writeable, enable them */
            WinSendDlgItemMsg(          /* Send message to entryfield */
                nbPINotebookPage[PAGE_3].hwndNBPage,
                                        /* Program size & position entryfield */
                usSizePositionEFs[usTemp],
                EM_SETREADONLY,         /* Set to enable read/write */
                MPFROMSHORT(FALSE),
                (MPARAM)NULL);
        else
            WinSendDlgItemMsg(          /* Send message to entryfield */
                nbPINotebookPage[PAGE_3].hwndNBPage,
                                        /* Program size & position entryfield */
                usSizePositionEFs[usTemp],
                EM_SETREADONLY,         /* Set to enable readonly */
                MPFROMSHORT(TRUE),
                (MPARAM)NULL);
        if(bInsert==TRUE)               /* If initializing, insert them */
            {
            WinSendDlgItemMsg(          /* Send message to dialog window */
                                        /* Handle of dialog window */
                nbPINotebookPage[PAGE_3].hwndNBPage,
                                        /* Program size: X entryfield */
                usSizePositionEFs[usTemp],
                EM_SETTEXTLIMIT,        /* Set text limit to 5 */
                MPFROMSHORT(5),
                (MPARAM)NULL);
            WinSetDlgItemText(          /* Set a text string in a dialog item */
                nbPINotebookPage[PAGE_3].hwndNBPage,
                usSizePositionEFs[usTemp],
                (CHAR *)_itoa(*psSizePosition, ucBuffer, 10));
            }
        }
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETUPHOTKEY, NULL, NULL                                                   *
\*                                                                                      */
case WM_SETUPHOTKEY:
/*                                                                                      *\
 * Load Program Title into entryfield, fill the combobox and fill the MLE containing    *
 * the current window list.                                                             *
\*                                                                                      */
    {
    ULONG       ulTemp1, ulTemp2;
    PSWBLOCK    pSwBlock;               /* Pointer to window list */
                                        /* Used to add \n to switchlist entries */
    UCHAR       ucSwName[MAXNAMEL+1];

                                        /* Set Window Title entryfield */
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PIEF_SESSIONTITLE,
        EM_SETTEXTLIMIT, MPFROMSHORT(MAXNAMEL), (MPARAM)NULL);
    WinSetDlgItemText(nbPINotebookPage[PAGE_4].hwndNBPage, PIEF_SESSIONTITLE, pSessionData->WindowTitle);
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PICBX_HOTKEY,
        EM_SETTEXTLIMIT, MPFROMSHORT(sizeof(" ")), (MPARAM)NULL);
                                        /* Set SWP control radiobuttons */
    if(pSessionData->SwpFlag & SWP_MAXIMIZE)
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PIRB_WSMAXIMIZED, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    else if(pSessionData->SwpFlag & SWP_RESTORE)
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PIRB_WSRESTORE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    else
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PIRB_NONE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    if(pSessionData->SwpFlag & SWP_NOMOVE)
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PICB_DONTMOVE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    if(pSessionData->KeyData.usCh!=0)   /* Check if a hotkey is defined */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PICB_HOTKEYENABLED, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Simulate the click to update the dialog's child windows */
    WinSendMsg(nbPINotebookPage[PAGE_2].hwndNBPage, WM_CONTROL,
        MPFROM2SHORT(PICB_HOTKEYENABLED, BN_CLICKED), (MPARAM)NULL);
                                        /* Simulate the click to update the PIRB_CTRL or
                                           PIRB_ALT radiobutton */
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, (pSessionData->KeyData.usFlags==KC_CTRL) ? PIRB_CTRL : PIRB_ALT,
        BM_SETCHECK, MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* This message invalidates pSessionData->KeyData !!! */
    WinSendMsg(nbPINotebookPage[PAGE_4].hwndNBPage, WM_CONTROL,
        MPFROM2SHORT((pSessionData->KeyData.usFlags==KC_CTRL) ? PIRB_CTRL : PIRB_ALT, BN_CLICKED), (MPARAM)NULL);
                                        /* Query the number of entries in window list */
    ulTemp1=WinQuerySwitchList(pHP->habPc2, NULL, 0);
                                        /* Allocate space for window list */
    pSwBlock=(PSWBLOCK)malloc(ulTemp1=(ulTemp1*sizeof(SWENTRY)+sizeof(HSWITCH)));
                                        /* Load window list into LB */
    ulTemp1=WinQuerySwitchList(pHP->habPc2, pSwBlock, ulTemp1);
    for(ulTemp2=0; ulTemp2<=ulTemp1; ulTemp2++)
        {
        if(pSwBlock->aswentry[ulTemp2].swctl.fbJump==SWL_JUMPABLE)
            {
            strcpy(ucSwName, pSwBlock->aswentry[ulTemp2].swctl.szSwtitle);
            WinSendDlgItemMsg(
                nbPINotebookPage[PAGE_4].hwndNBPage, PILB_WINDOWLIST,
                LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(ucSwName));
            }
        }
    free(pSwBlock);                     /* Free allocated space for window list */
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETUPPROGRAMPRIORITY, (USHORT PriorityClass), (SHORT PriorityDelta)       *                                           *
\*                                                                                      */
case WM_SETUPPROGRAMPRIORITY:
/*                                                                                      *\
 * To enable all Priorities to be selected, the checkbox PICB_CHILDPROCESS must be      *
 * checked and is either checked by the user or by the Priority not equal to the        *
 * default selection of PRTYC_NOCHANGE and 0.                                           *
\*                                                                                      */
    {
    USHORT      usPriorityClassRBs[]={PIRB_NOCHANGE, PIRB_IDLETIME, PIRB_REGULAR,
                                      PIRB_TIMECRITICAL, PIRB_FOREGROUNDSERVER};
    USHORT      usPriorityClass=SHORT1FROMMP(mp1);
    UCHAR       ucBuffer[4];

    sPriorityDelta=SHORT1FROMMP(mp2);
                                        /* Check priority class radiobutton by simulation a
                                           radiobutton click */
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndNBPage, usPriorityClassRBs[usPriorityClass],
        BM_SETCHECK, MPFROMSHORT(TRUE), (MPARAM)NULL);
    WinSendMsg(nbPINotebookPage[PAGE_5].hwndNBPage, WM_CONTROL,
        MPFROM2SHORT(usPriorityClass, BN_CLICKED), (MPARAM)NULL);
                                        /* Set priority delta entryfield and scrollbar */
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndNBPage, PIEF_PRIORITYDELTA,
        EM_SETTEXTLIMIT, MPFROMSHORT(3), (MPARAM)NULL);
    WinSetDlgItemText(nbPINotebookPage[PAGE_5].hwndNBPage, PIEF_PRIORITYDELTA,
        (CHAR *)_itoa(sPriorityDelta, ucBuffer, 10));
                                        /* Set scollbar size and position. Caution
                                           a scrollbar is 0 based */
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndNBPage, PIHSB_PRIORITYDELTA,
        SBM_SETTHUMBSIZE, MPFROM2SHORT(1, PRTYD_MAXIMUM), (MPARAM)NULL);
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndNBPage, PIHSB_PRIORITYDELTA,
        SBM_SETSCROLLBAR, MPFROMSHORT(sPriorityDelta),
        MPFROM2SHORT(0, PRTYD_MAXIMUM));
    }
    break;

case WM_HSCROLL:                        /* Messages generated by horizontal scrollbars */
/*                                                                                      *\
 * This message is generated when a horizontal scrollbar is manipulated. See if it is   *
 * our scrollbar PIHSB_PRIORITYDELTA and process.                                       *
\*                                                                                      */
    if(SHORT1FROMMP(mp1)==PIHSB_PRIORITYDELTA)
        {
        UCHAR       ucBuffer[4];
        SHORT       sSliderPosition=SHORT1FROMMP(mp2);;

        switch(SHORT2FROMMP(mp2))
        {                               /* All messages contain the new slider position,
                                           so just use this value to change the priority
                                           delta entryfield value */
        case SB_LINELEFT:
            sPriorityDelta--;
            break;

        case SB_PAGELEFT:
            sPriorityDelta-=10;
            break;

        case SB_LINERIGHT:
            sPriorityDelta++;
            break;

        case SB_PAGERIGHT:
            sPriorityDelta+=10;
            break;

        case SB_SLIDERTRACK:
        case SB_SLIDERPOSITION:
            sPriorityDelta=sSliderPosition;
            break;
        }
        if(sPriorityDelta<PRTYC_NOCHANGE) sPriorityDelta=PRTYC_NOCHANGE;
        if(sPriorityDelta>PRTYD_MAXIMUM) sPriorityDelta=PRTYD_MAXIMUM;
        WinSetDlgItemText(nbPINotebookPage[PAGE_5].hwndNBPage, PIEF_PRIORITYDELTA,
            (CHAR *)_itoa(sPriorityDelta, ucBuffer, 10));
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndNBPage, PIHSB_PRIORITYDELTA,
            SBM_SETPOS, MPFROMSHORT(sPriorityDelta), (MPARAM)NULL);
        }
    break;

case WM_CONTROL:                        /* Test for autoradio buttons pressed */
/*                                                                                      *\
 * The Size & Position radiobutton must be checked every time it is selected, because   *
 * only if it is selected, the user may have write access to X, Y, Size X and Size Y    *
 * entryfields, otherwise they are read only. The DOS Setting MLE is only visible if a  *
 * DOS window or fullscreen application type is selected.                               *
\*                                                                                      */
    {                                   /* Child windows that change with the
                                           PIRB_WPSOBJECT radiobutton */
    USHORT      usChild2WPSObject[]={PIRB_MAXIMIZED, PIRB_MINIMIZED, PICB_SIZEPOSITION,
                                     PICB_INVISIBLE, PICB_NOAUTOCLOSE, PICB_BACKGROUND,
                                     PIEF_X, PIEF_Y, PIEF_XSIZE, PIEF_YSIZE};
                                        /* Disable the following if Size & Position is disabled */
    USHORT      usChild2SizeEnable[]={PIEF_X, PIEF_Y, PIEF_XSIZE, PIEF_YSIZE};
                                        /* Hide the following for WPS Objects */
    USHORT      usChild2WPSObjectHide[]={PIEF_DIRECTORY, PIEF_PARAMETERS};
                                        /* Child window that changes with a DOS radiobutton */
    USHORT      usChild2DOS[]={PIMLE_DOSSETTINGS, PIPB_SETTINGSDLG};
    USHORT      usChild2DOSP5[]={PIRB_IDLETIME, PIRB_REGULAR, PIRB_TIMECRITICAL, PIRB_FOREGROUNDSERVER,
                                 PIEF_PRIORITYDELTA, PIHSB_PRIORITYDELTA};
                                        /* Child windows that change with a WIN-OS2 radiobutton */
    USHORT      usChild2WINOS2[]={PIRB_WINREAL, PIRB_WINSTANDARD, PIRB_WIN386ENHANCED, PICB_WINSEPARATE};
                                        /* Child windows that change witch Hotkey enable checkbox */
    USHORT      usChild2HotKey[]={PIRB_NONE, PIRB_WSMAXIMIZED, PIRB_WSRESTORE, PIRB_CTRL,
                                  PIRB_ALT, PICBX_HOTKEY};

    if(SHORT2FROMMP(mp1)==BN_CLICKED)   /* Was autoradio button clicked ? */
        switch(SHORT1FROMMP(mp1))
        {
        case PICB_SIZEPOSITION:         /* Program type: User defined size & position */
            if((BOOL)WinSendDlgItemMsg( /* Send message to Size & Position radiobutton */
                                        /* Handle of dialog window */
                nbPINotebookPage[PAGE_3].hwndNBPage,
                PICB_SIZEPOSITION,      /* Program size: Size & Position radiobutton */
                BM_QUERYCHECK,          /* Query the state */
                (MPARAM)NULL,
                (MPARAM)NULL)==TRUE)
                {
                WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
                    MPFROMSHORT(TRUE), MPFROMSHORT(FALSE));
                DisableDialogItem(nbPINotebookPage[PAGE_3].hwndNBPage, usChild2SizeEnable,
                    sizeof(usChild2SizeEnable)/sizeof(USHORT), WS_VISIBLE);
                }
            else
                {
                WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
                    MPFROMSHORT(FALSE), MPFROMSHORT(FALSE));
                                        /* Enable and show Size & Position child windows */
                                        /* Disable and show Size & Position child windows */
                DisableDialogItem(nbPINotebookPage[PAGE_3].hwndNBPage, usChild2SizeEnable,
                    sizeof(usChild2SizeEnable)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            break;

        case PICB_HOTKEYENABLED:        /* Enable or disable and show Hotkey controls depending
                                           on Hotkey Enable checkbox */
            if((BOOL)WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage,
                PICB_HOTKEYENABLED, BM_QUERYCHECK, (MPARAM)NULL, (MPARAM)NULL)==TRUE)
                {
                DisableDialogItem(nbPINotebookPage[PAGE_4].hwndNBPage, usChild2HotKey,
                    sizeof(usChild2HotKey)/sizeof(USHORT), WS_VISIBLE);
                }
            else
                {
                DisableDialogItem(nbPINotebookPage[PAGE_4].hwndNBPage, usChild2HotKey,
                    sizeof(usChild2HotKey)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            break;

        case PIRB_CTRL:
        case PIRB_ALT:                  /* Set hotkey MLE corresponding to radiobuttons */
            {
            KEYDATA     *pKeyDataIndex;
            UCHAR       ucBuffer[]="0"; /* String to be inserted into combobox */
            ULONG       ulTemp1;
            BOOL        bFirst=TRUE;    /* False if first key was inserted */

                                        /* Point to Hotkey control structure */
            pKeyDataIndex=pHP->pKeyData;
                                        /* If a key is defined set it into entryfield of
                                           combobox. Clear it afterwards that user selections
                                           to the PIRB_CTRL or PIRB_ALT insert the first free
                                           available key */
            if(pSessionData->KeyData.usCh!=0)
                {
                ucBuffer[0]=(UCHAR)pSessionData->KeyData.usCh;
                WinSetDlgItemText(nbPINotebookPage[PAGE_4].hwndNBPage, PICBX_HOTKEY, ucBuffer);
                bFirst=FALSE;
                }
            else bFirst=TRUE;
                                        /* Delete current entries in hotkey combobox */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PICBX_HOTKEY,
                LM_DELETEALL, (MPARAM)NULL, (MPARAM)NULL);
                                        /* Loop for all keys and set unused into combobox */
            for(ulTemp1=0; ulTemp1<=KEYDATACOUNT; pKeyDataIndex++, ulTemp1++)
                {
                ucBuffer[0]=(UCHAR)pKeyDataIndex->usCh;
                                        /* Clear current key because it may not selected again */
                if((pKeyDataIndex->usCh==pSessionData->KeyData.usCh) &&
                    ((SHORT1FROMMP(mp1)==PIRB_CTRL ? KC_CTRL : KC_ALT)==pKeyDataIndex->usFlags))
                    {
                    pSessionData->KeyData.usCh=0;
                    pKeyDataIndex->bUsed=FALSE;
                    pKeyDataIndex->pMenuData=NULL;
                    }
                                        /* Load unused key of current type into combobox */
                if((pKeyDataIndex->bUsed==FALSE) &&
                    ((SHORT1FROMMP(mp1)==PIRB_CTRL ? KC_CTRL : KC_ALT)==pKeyDataIndex->usFlags))
                    {
                    if(bFirst==TRUE)
                        {               /* The first valid hotkey is loaded into entryfield part
                                           of combobox */
                        WinSetDlgItemText(nbPINotebookPage[PAGE_4].hwndNBPage, PICBX_HOTKEY, ucBuffer);
                        bFirst=FALSE;
                        }
                    WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PICBX_HOTKEY,
                        LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(ucBuffer));
                    }
                }
            }
            break;

        case PIRB_DOSFULLSCREEN:
        case PIRB_DOSWINDOW:
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndNBPage, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show DOS child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndNBPage, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), WS_VISIBLE);
                                        /* Set default priority class radiobutton by simulation a
                                           radiobutton click */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndNBPage, PIRB_NOCHANGE,
                BM_SETCHECK, MPFROMSHORT(TRUE), (MPARAM)NULL);
            WinSendMsg(nbPINotebookPage[PAGE_5].hwndNBPage, WM_CONTROL,
                MPFROM2SHORT(PIRB_NOCHANGE, BN_CLICKED), (MPARAM)NULL);
                                        /* Set default priority delta entryfield and scrollbar */
            WinSetDlgItemText(nbPINotebookPage[PAGE_5].hwndNBPage, PIEF_PRIORITYDELTA, "0");
                                        /* Set default scollbar position */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndNBPage, PIHSB_PRIORITYDELTA,
                SBM_SETPOS, MPFROMSHORT(0), (MPARAM)NULL);
                                        /* Now disable non-default priority settings */
            DisableDialogItem(nbPINotebookPage[PAGE_5].hwndNBPage, usChild2DOSP5,
                sizeof(usChild2DOSP5)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_3].hwndNBPage, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE);
                                        /* Disable and show WIN-OS2 child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_2].hwndNBPage, usChild2WINOS2,
                sizeof(usChild2WINOS2)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            break;

        case PIRB_SHELL:
        case PIRB_OS2FULLSCREEN:
        case PIRB_OS2WINDOW:
        case PIRB_PM:
                                        /* Enable and hide DOS child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndNBPage, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), 0);
                                        /* Now enable priority settings */
            DisableDialogItem(nbPINotebookPage[PAGE_5].hwndNBPage, usChild2DOSP5,
                sizeof(usChild2DOSP5)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_3].hwndNBPage, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndNBPage, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), WS_VISIBLE);
                                        /* Disable and show WIN-OS2 child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_2].hwndNBPage, usChild2WINOS2,
                sizeof(usChild2WINOS2)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            break;

        case PIRB_WPSOBJECT:
                                        /* Disable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_3].hwndNBPage, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Enable and hide DOS child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndNBPage, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), 0);
                                        /* Now enable priority settings */
            DisableDialogItem(nbPINotebookPage[PAGE_5].hwndNBPage, usChild2DOSP5,
                sizeof(usChild2DOSP5)/sizeof(USHORT), WS_VISIBLE);
                                        /* Hide but enable WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndNBPage, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), 0);
                                        /* Disable and show WIN-OS2 child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_2].hwndNBPage, usChild2WINOS2,
                sizeof(usChild2WINOS2)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Only default Style is allowed */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_3].hwndNBPage, PIRB_DEFAULTSTYLE, BM_SETCHECK,
                MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Size and Position is not allowed */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_3].hwndNBPage, PICB_SIZEPOSITION, BM_SETCHECK,
                MPFROMSHORT(FALSE), (MPARAM)NULL);
                                        /* Load empty text in not required fields */
            WinSetDlgItemText(nbPINotebookPage[PAGE_1].hwndNBPage, PIEF_DIRECTORY, "");
            WinSetDlgItemText(nbPINotebookPage[PAGE_1].hwndNBPage, PIEF_PARAMETERS, "");
            break;

        case PIRB_WINOS2:
                                        /* Enable and show WPSObject child windows, because
                                           a WIN-OS2 session is a specail DOS session */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndNBPage, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show DOS child windows, hide priority */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndNBPage, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), WS_VISIBLE);
                                        /* Set default priority class radiobutton by simulation a
                                           radiobutton click */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndNBPage, PIRB_NOCHANGE,
                BM_SETCHECK, MPFROMSHORT(TRUE), (MPARAM)NULL);
            WinSendMsg(nbPINotebookPage[PAGE_5].hwndNBPage, WM_CONTROL,
                MPFROM2SHORT(PIRB_NOCHANGE, BN_CLICKED), (MPARAM)NULL);
                                        /* Set default priority delta entryfield and scrollbar */
            WinSetDlgItemText(nbPINotebookPage[PAGE_5].hwndNBPage, PIEF_PRIORITYDELTA, "0");
                                        /* Set default scollbar position */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndNBPage, PIHSB_PRIORITYDELTA,
                SBM_SETPOS, MPFROMSHORT(0), (MPARAM)NULL);
                                        /* Now disable non-default priority settings */
            DisableDialogItem(nbPINotebookPage[PAGE_5].hwndNBPage, usChild2DOSP5,
                sizeof(usChild2DOSP5)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_3].hwndNBPage, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show WIN-OS2 child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_2].hwndNBPage, usChild2WINOS2,
                sizeof(usChild2WINOS2)/sizeof(USHORT), WS_VISIBLE);
            break;
        }
    if(SHORT1FROMMP(mp1)==PILB_WINDOWLIST)
        switch(SHORT2FROMMP(mp1))       /* Events of Window List listbox */
        {
        case LN_ENTER:                  /* When selected, copy selected item into session title entryfield */
            {
            UCHAR   ucTemp[MAXNAMEL];
            USHORT  usSelection;

            usSelection=(USHORT)WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PILB_WINDOWLIST,
                LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), (MPARAM)NULL);
                                        /* Copy selected item */
            if(usSelection!=(USHORT)LIT_NONE)
                {
                WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndNBPage, PILB_WINDOWLIST,
                    LM_QUERYITEMTEXT, MPFROM2SHORT(usSelection, MAXNAMEL), MPFROMP(ucTemp));
                WinSetDlgItemText(nbPINotebookPage[PAGE_4].hwndNBPage, PIEF_SESSIONTITLE, ucTemp);
                }
            break;
            }
        }
    }
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_CANCEL:                    /* Cancel key pressed on a dialog within a notebook page,
                                           ignore it within dialog but post it to parent dialog */
        {
        HWND    hwndNotebook;

                                        /* Query parent of current notebook page window,
                                           Query parent of this, which is the notebook */
        hwndNotebook=WinQueryWindow(WinQueryWindow(hwndDlg, QW_PARENT), QW_PARENT);
                                        /* Post CANCEL to parent of notebook which is the dialog */
        WinPostMsg(WinQueryWindow(hwndNotebook, QW_PARENT), WM_COMMAND,
            MPFROMSHORT(DID_CANCEL), MPFROM2SHORT(CMDSRC_ACCELERATOR, FALSE));
                                        /* We have handled the message */
        return((MRESULT)TRUE);
        }

    case PIPB_WINFILEDLG:               /* Locate file by standard file dialog */
/*                                                                                      *\
 * The user selected the File Find pushbutton to get the standard file dialog to find   *
 * the program he wants to install.                                                     *
\*                                                                                      */
        {
        FILEDLG fdFileDlg;              /* Standard file dialog control */
        HWND    hwndFileDlg;            /* Handle of standard file dialog */

                                        /* Clear out structure */
        memset(&fdFileDlg, 0, sizeof(FILEDLG));
                                        /* Structure size */
        fdFileDlg.cbSize=sizeof(FILEDLG);
                                        /* FDS_* flags */
        fdFileDlg.fl=FDS_CENTER | FDS_OPEN_DIALOG | FDS_PRELOAD_VOLINFO;
                                        /* Dialog title string */
        fdFileDlg.pszTitle="PC/2 File Search";
                                        /* Initial path, filename or file filter */
        strcpy(fdFileDlg.szFullFile, "C:\\*");
                                        /* Open the standard file dialog ...*/
        hwndFileDlg=WinFileDlg(HWND_DESKTOP, hwndDlg, &fdFileDlg);
        if(hwndFileDlg && (fdFileDlg.lReturn==DID_OK))
                                        /* Load the values of the standard file dialog to
                                           the corresponding entryfield in the Program
                                           installation dialog. It is a file not an object. */
            InstallFilename2Dialog(hwndDlg, fdFileDlg.szFullFile, FALSE);
        }
        break;

    case PIPB_SETTINGSDLG:              /* Locate file by standard file dialog */
/*                                                                                      *\
 * The user selected the Settings pushbutton to get the standard OS/2 DOS settings      *
 * dialog. Special thanks to Monte Copeland for giving me a sample source code on how   *
 * using this built-in but undocumented OS/2 feature.                                   *
\*                                                                                      */
        {
                                        /* PMVDMP.DLL export @11 WINDOWS32PROPERTYDIALOG */
        PFFUNCPTR4  *pWindows32PropertyDialog;
        HMODULE     hDllPMVDMP;         /* PMVDMP.DLL module handle */
        UCHAR       ucBuffer[80];       /* Buffer for possible return codes from DLL loading */
        UCHAR       ucSettingsIn[LENDOSSETTINGS];
        UCHAR       *pucSettingsIn;
        UCHAR       *pucSettingsOut;
        USHORT      usLength, usWinMode=0;
        ULONG       ulLength;

                                        /* Get ordinal 11 function pointer of PMVDMP.DLL which
                                           contains the DOS settings dialog */
        if((DosLoadModule(ucBuffer, sizeof(ucBuffer)-1, "PMVDMP", &hDllPMVDMP)!=NO_ERROR) ||
            (DosQueryProcAddr(hDllPMVDMP, 11, NULL, (PFN *)(&pWindows32PropertyDialog))
            !=NO_ERROR))
            {                           /* An error occured */
            pWindows32PropertyDialog=NULL;
            DosFreeModule(hDllPMVDMP);  /* Free DLL reference */
            USR_ERR("Can't load VDM support from PMVDMP.DLL. You have either not installed the "\
                "DOS support of OS/2, or your DOS support is not setup correctly. The DOS settings "\
                "dialog of PC/2 will not be available until you correct this problem - continuing...",
                HWND_DESKTOP, HWND_DESKTOP);
            }
                                        /* Without VDM support installed DOS support is not available */
        if(pWindows32PropertyDialog==NULL) break;
        WinQueryWindowText(             /* Query data entered in DOS Settings MLE */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndNBPage, PIMLE_DOSSETTINGS),
            sizeof(ucSettingsIn), ucSettingsIn);
        ulLength=strlen(ucSettingsIn)+1;
                                        /* Convert to format used by WINDOWS32PROPERTYDIALOG */
        pucSettingsIn=ImportDosSettings(ucSettingsIn, &ulLength, FALSE);
        pucSettingsOut=pWindows32PropertyDialog(
            hwndDlg,                    /* Parent window handle ? */
            hwndDlg,                    /* Owner window handle ? */
            pucSettingsIn,              /* In-buffer containing DOS settings */
            (USHORT)ulLength,           /* Length of in-buffer containing DOS settings */
            &usLength,                  /* Length of out-buffer containing modified DOS settings,
                                           allocated by DosAllocateMem() */
            &usWinMode);                /* 0 if no WIN-OS2 settings are included
                                           ? if WIN-OS2 settings are included */
        if(pucSettingsIn) free(pucSettingsIn);
        if(pucSettingsOut!=NULL)        /* NULL returned when Cancel was pressed */
            {
            ulLength=(ULONG)usLength;
                                        /* Convert to format used PC/2 configuration file and
                                           Program Installation dialog */
            pucSettingsIn=ImportDosSettings(pucSettingsOut, &ulLength, TRUE);
            DosFreeMem(pucSettingsOut);
                                        /* Insert data in DOS Settings MLE */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_1].hwndNBPage, PIMLE_DOSSETTINGS,
                MLM_DELETE, MPFROMLONG(0), MPFROMLONG(LENDOSSETTINGS));
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_1].hwndNBPage, PIMLE_DOSSETTINGS,
                MLM_INSERT, MPFROMP(pucSettingsIn), (MPARAM)NULL);
            free(pucSettingsIn);
            }
        DosFreeModule(hDllPMVDMP);      /* Free DLL reference */
        }
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    break;

                                        /* Call function instead of subclassing notebook page 1
                                           notebook dialogs */
case DM_DRAGOVER:
case DM_DROP:
                                        /* Only on first page allow Drag'n Drop */
    if(hwndDlg==nbPINotebookPage[PAGE_1].hwndNBPage)
        return(PI_SubclassedDialogProcedure(hwndDlg, msg, mp1, mp2));
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the Drag'n Drop support - Program Installation dialog. *
 * Req:                                                                                 *
 *      SessionData ... a structure of type SESSIONDATA where the information entered   *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY PI_SubclassedDialogProcedure(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PDRAGINFO       pDraginfo;              /* Pointer to DRAGINFO structure */
PDRAGITEM       pDragitem;              /* Pointer to DRAGITEM structure */

switch(msg)
{
/*                                                                                      *\
 * Allow objects to be dropped on dialog box to add first dragitem as an application.   *
\*                                                                                      */
case DM_DRAGOVER:
    pDraginfo = (PDRAGINFO)mp1;         /* Get the pointer to the DRAGINFO structure */
                                        /* Access the structure */
    if(DrgAccessDraginfo(pDraginfo)==FALSE) break;
                                        /* Get the first itemp of the item(s) dragged
                                           onto dialog window */
    pDragitem = DrgQueryDragitemPtr(pDraginfo, 0);
    if((pDraginfo->cditem==1) &&
        ((DrgVerifyRMF(pDragitem, "DRM_OS2FILE", "DRF_UNKNOWN")) ||
        (DrgVerifyRMF(pDragitem, "DRM_OS2FILE", "DRF_TEXT"))))
                                        /* Allow drop of undefined operation onto dialog window */
        return(MPFROM2SHORT(DOR_DROP, DO_UNKNOWN));
                                        /* Don't allow dropping of more than one or unknown item */
    return(MPFROM2SHORT(DOR_NODROP, DO_UNKNOWN));

case DM_DROP:
    {
    UCHAR       ucBuffer[256];
    UCHAR       ucFileName[256];
    UCHAR       ucObjectType[256];
    UCHAR       *pucBuffer;

    pDraginfo = (PDRAGINFO)mp1;         /* Get the pointer to the DRAGINFO structure */
                                        /* Access the structure */
    if(DrgAccessDraginfo(pDraginfo)==FALSE) break;
                                        /* Get the first itemp of the item(s) dragged
                                           onto dialog window */
    pDragitem = DrgQueryDragitemPtr(pDraginfo, 0);
                                        /* Query the rendering format */
    DrgQueryStrName(pDragitem->hstrRMF, sizeof(ucObjectType), ucObjectType);
                                        /* Scan for an file object */
    if((DrgVerifyRMF(pDragitem, "DRM_OS2FILE", "DRF_UNKNOWN")) ||
        (DrgVerifyRMF(pDragitem, "DRM_OS2FILE", "DRF_TEXT")))
        {                               /* It is an application to get path and filename */
                                        /* Query path (container) */
        DrgQueryStrName(pDragitem->hstrContainerName, sizeof(ucBuffer), ucBuffer);
                                        /* Position to \0 of path */
        pucBuffer=ucBuffer+strlen(ucBuffer);
                                        /* Query filename and append it to path */
        DrgQueryStrName(pDragitem->hstrSourceName, sizeof(ucBuffer)-strlen(pucBuffer), pucBuffer);
                                        /* Copy filename of file object dropped and uppercase it */
        strcpy(ucFileName, ucBuffer);
        strupr(ucFileName);
                                        /* If it is an executable or batch file PC/2 can start it
                                           otherwise it must be an WPS object like a filder */
        if(strstr(ucFileName, "EXE") || strstr(ucFileName, "COM") ||
            strstr(ucFileName, "CMD") || strstr(ucFileName, "BAT"))
                                        /* Now change the entryfields to the dropped object
                                           which is not a WPS object */
            InstallFilename2Dialog(hwnd, ucBuffer, FALSE);
        else
                                        /* Now change the entryfields to the dropped object
                                           which is a WPS object */
            InstallFilename2Dialog(hwnd, ucBuffer, TRUE);
        break;
        }
    }
    break;
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Menu Installation dialog.                   *
 * Req:                                                                                 *
 *      SessionData ... a structure of type SESSIONDATA where the information entered   *
 *                      in the dialog is entered. If DID_OK is pressed this structure   *
 *                      is used to start the session.                                   *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY MI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static SESSIONDATA   *pSessionData;     /* Pointer to SESSIONDATA structure for current instance */

switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
                                        /* Access parameters passed */
    pSessionData=(SESSIONDATA *)PVOIDFROMMP(mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    swp.fl=SWP_MOVE;                    /* Center dialog window */
    swp.x=(pHP->swpScreen.cx-swp.cx)>>1;
    swp.y=(pHP->swpScreen.cy-swp.cy)>>1;
    swp.cx=swp.cy=0;
    swp.hwndInsertBehind=NULLHANDLE;
    WinSetMultWindowPos(pHP->habPc2, &swp, 1);
/*                                                                                      *\
 * Set the maximum number of chars accepted from the entryfield (thus overwriting the   *
 * default number of 63.                                                                *
\*                                                                                      */
    WinSendDlgItemMsg(                  /* Send message to dialog window */
        hwndDlg,                        /* Handle of dialog window */
        MIEF_MENUTITLE,                 /* Program submenu title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 60 */
        MPFROMSHORT(MAXNAMEL),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Set text of title entryfield */
        hwndDlg, MIEF_MENUTITLE, pSessionData->PgmTitle);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(pHP->hwndHelp!=NULLHANDLE)
        WinSendMsg(pHP->hwndHelp, HM_DISPLAY_HELP,
            MPFROMSHORT(MIID_MENUDIALOG), HM_RESOURCEID);
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Query the Submenu Title and copy it to the corresponding entry in the StartSession   *
 * structure.                                                                           *
\*                                                                                      */
        WinQueryWindowText(             /* Query data entered in Submenu title entry */
            WinWindowFromID(hwndDlg, MIEF_MENUTITLE),
                                        /* into SessionData structure */
            sizeof(pSessionData->PgmTitle),
            pSessionData->PgmTitle);
                                        /* Dialog terminated with DID_OK */
        WinDismissDlg(hwndDlg, DID_OK);
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
                                        /* Dialog terminated with DID_CANCEL */
        WinDismissDlg(hwndDlg, DID_CANCEL);
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Control Addition dialog.                    *
 * Req:                                                                                 *
 *      SessionData ... a structure of type SESSIONDATA where the control style         *
 *                      selected in the dialog is entered. If DID_OK is pressed this    *
 *                      structure is used to add the control entries to the Popup-menu. *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY MD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static SESSIONDATA   *pSessionData;     /* Pointer to SESSIONDATA structure for current instance */

switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;
    ULONG       ulid;
    ULONG       ulidCopy;
                                        /* Sort radiobuttons as the Menuentry IDs are
                                           sorted in PC2.h as ID_* */
    USHORT      usChild2Control[]={MDRB_CTRL_CONFIGMENU, MDRB_CTRL_ABOUT, MDRB_CTRL_EXIT,
                                   MDRB_CTRL_SHUTDOWN, MDRB_CTRL_CONFIGDESKTOP,
                                   MDRB_CTRL_HELP, MDRB_CTRL_SPOOLER};

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
                                        /* Access parameters passed */
    pSessionData=(SESSIONDATA *)PVOIDFROMMP(mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    swp.fl=SWP_MOVE;                    /* Center dialog window */
    swp.x=(pHP->swpScreen.cx-swp.cx)>>1;
    swp.y=(pHP->swpScreen.cy-swp.cy)>>1;
    swp.cx=swp.cy=0;
    swp.hwndInsertBehind=NULLHANDLE;
    WinSetMultWindowPos(pHP->habPc2, &swp, 1);
    for(ulid=0; ulid<=(sizeof(usChild2Control)/sizeof(usChild2Control[0])); ulid++)
        {
        ulidCopy=ulid+ID_CONFIGDIALOG;  /* Copy because SearchItem() changes passed ID */
                                        /* Search in the linked list for entry ulid */
        if((SearchItem(pHP->pPopupMenu, &ulidCopy))!=NULL)
                                        /* Disable and show 1 Control child windows
                                           according to its id if id was found */
            DisableDialogItem(hwndDlg, &usChild2Control[ulid],
                1, WS_VISIBLE | WS_DISABLED);
        }
                                        /* Select Separator RB because this is the only
                                           one selectable all times */
    WinSendDlgItemMsg(hwndDlg, MDRB_CTRL_SEPARATOR, BM_SETCHECK,
        MPFROMSHORT(TRUE), (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(pHP->hwndHelp!=NULLHANDLE)
        WinSendMsg(pHP->hwndHelp, HM_DISPLAY_HELP,
            MPFROMSHORT(MDID_CONTROLDIALOG), HM_RESOURCEID);
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Query through all radiabuttons for the control style the user has selected. Write    *
 * the corresponding string name into the  pSessionData->PgmTitle field.                *
\*                                                                                      */
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_CONFIGMENU))
            strcpy(pSessionData->PgmTitle, CTRL_CONFIGMENU);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_CONFIGDESKTOP))
            strcpy(pSessionData->PgmTitle, CTRL_CONFIGDESKTOP);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_ABOUT))
            strcpy(pSessionData->PgmTitle, CTRL_ABOUT);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_SHUTDOWN))
            strcpy(pSessionData->PgmTitle, CTRL_SHUTDOWN);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_HELP))
            strcpy(pSessionData->PgmTitle, CTRL_HELP);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_EXIT))
            strcpy(pSessionData->PgmTitle, CTRL_EXIT);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_SPOOLER))
            strcpy(pSessionData->PgmTitle, CTRL_SPOOLER);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_SEPARATOR))
            strcpy(pSessionData->PgmTitle, CTRL_SEPARATOR);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_BRKSEPARATOR))
            strcpy(pSessionData->PgmTitle, CTRL_BREAKSEPARATOR);
                                        /* Dialog terminated with DID_OK */
        WinDismissDlg(hwndDlg, DID_OK);
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
                                        /* Dialog terminated with DID_CANCEL */
        WinDismissDlg(hwndDlg, DID_CANCEL);
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - ShutDown OS/2 dialog.                       *
 * Req: none                                                                            *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY SD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
                                        /* Load before ShutDown info */
    WinSetDlgItemText(hwndDlg, SDID_SHUTDOWNMESSAGE,
        "All disk activity will be suspended. After all disk activity has been stopped, "\
        "it is safe to power off or reset your system.");
    swp.fl=SWP_MOVE;                    /* Center dialog window */
    swp.x=(pHP->swpScreen.cx-swp.cx)>>1;
    swp.y=(pHP->swpScreen.cy-swp.cy)>>1;
    swp.cx=swp.cy=0;
    swp.hwndInsertBehind=NULLHANDLE;
    WinSetMultWindowPos(pHP->habPc2, &swp, 1);
    WinPostMsg(hwndDlg, WM_SHUTDOWN, NULL, NULL);
    break;
    }

/*                                                                                      *\
 * Syntax: WM_SHUTDOWN, NULL, NULL                                                      *
\*                                                                                      */
case WM_SHUTDOWN:
/*                                                                                      *\
 * Wait for 1 seconds and then shut down OS/2.                                          *
\*                                                                                      */
    DosSleep(01000);
    DosShutdown(0);
                                        /* Load after ShutDown info */
    WinSetDlgItemText(hwndDlg, SDID_SHUTDOWNMESSAGE,
        "All disk activity has been stopped. It is now safe to power off or reset "\
        "your system. ");
    break;

case WM_COMMAND:                        /* Eat up keys to avoid dismission of dialog with
                                           ESC key */
    return((MRESULT)TRUE);

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Startup Parameters dialog.                  *
 * Req: *PgmInputs .....A pointer to a string of commandline params of an application   *
 *                      via mp2                                                         *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY SU_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static COMMANDLINEPARAMS        *pCLPParams;

switch(msg)
{
case WM_INITDLG:
    {
    UCHAR       ucBuffer[EF_SIZE255+1];

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    pCLPParams=PVOIDFROMMP(mp2);
/*                                                                                      *\
 * Load text from CLPParams into the dialog box text fields, and set the text limit of  *
 * the entryfield to 127.                                                               *
\*                                                                                      */
                                        /* Program to be started information text field */
    WinSetDlgItemText(hwndDlg, SUTF_STARTUPPROGRAM, pCLPParams->ucPgmTitle);
    sprintf(ucBuffer, "%s[...] %s", pCLPParams->ucPBefore, pCLPParams->ucPAfter);
                                        /* User information text field */
    WinSetDlgItemText(hwndDlg, SUTF_STARTUPINFO, pCLPParams->ucPUser);
                                        /* Current parameters text field */
    WinSetDlgItemText(hwndDlg, SUTF_STARTUPPARAMETERS, ucBuffer);
    WinSendDlgItemMsg(hwndDlg, SUEF_STARTUPPARAMETERS, EM_SETTEXTLIMIT,
        MPFROMSHORT(MAXNAMEL), (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(pHP->hwndHelp!=NULLHANDLE)
        WinSendMsg(pHP->hwndHelp, HM_DISPLAY_HELP,
            MPFROMSHORT(SUID_STARTUPDIALOG), HM_RESOURCEID);
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
        WinQueryWindowText(WinWindowFromID(hwndDlg, SUEF_STARTUPPARAMETERS),
            sizeof(pCLPParams->ucPUser), pCLPParams->ucPUser);
                                        /* Dialog terminated with DID_OK */
        WinDismissDlg(hwndDlg, DID_OK);
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
                                        /* Dialog terminated with DID_CANCEL */
        WinDismissDlg(hwndDlg, DID_CANCEL);
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Resort dialog.                              *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY RD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static MENUDATA *pSortedMenuData;       /* Pointer to the first element of the resorted
                                           linked list */
static MENUDATA *pParentMenuData;       /* Menuitem, which current level is a child of */
static USHORT   usChild2InitPBs[]={DID_OK};
static USHORT   usChild2MovePBs[]={DID_CANCEL};
static USHORT   usChild2OKPBs[]={RDPB_MOVE};
static BOOL     bFirstMove;
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;
    MENUDATA    *pMDSource;             /* Pointer withing the current linked list */

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    swp.fl=SWP_MOVE;                    /* Center dialog window */
    swp.x=(pHP->swpScreen.cx-swp.cx)>>1;
    swp.y=(pHP->swpScreen.cy-swp.cy)>>1;
    swp.cx=swp.cy=0;
    swp.hwndInsertBehind=NULLHANDLE;
    WinSetMultWindowPos(pHP->habPc2, &swp, 1);
/*                                                                                      *\
 * Disable OK pushbutton, until all items have been moved. Get the first element of the *
 * current level of the linked list which will be resorted. Add all Menuitems of the    *
 * current level of the linked list to the source listbox. Save the parent Menuitem,    *
 * from where the current level is a child of.                                          *
\*                                                                                      */
    bFirstMove=FALSE;                   /* We didn't make any sort before */
    pSortedMenuData=NULL;               /* Pointer of resorted linked list points to a non
                                           available Menuitem */
                                        /* Disable and show OK pushbutton */
    DisableDialogItem(hwndDlg, usChild2InitPBs,
        sizeof(usChild2InitPBs)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Is current level is the root of all levels ? */
    if(pHP->pMenuData==pHP->pPopupMenu)
        pParentMenuData=NULL;           /* Yes, then parent Menuitem is NULL */
    else                                /* No, then get parent Menuitem */
        pParentMenuData=pHP->pMenuData->Back;
                                        /* Get first element of linked list */
    pMDSource=pHP->pMenuData;
    do                                  /* Add current level of Menuitems to the source listbox */
    {
        if(pMDSource->Item==ENTRYSUBMENU) /* It is a Submenu */
            {
            UCHAR       ucBuffer[MAXNAMEL+4];
                                        /* Add >> for a Submenu */
            sprintf(ucBuffer, "%s >>", pMDSource->PgmTitle);
                                        /* Insert Menuitem at the end of the listbox */
            WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_INSERTITEM,
                MPFROMSHORT(LIT_END), MPFROMP(ucBuffer));
            }
                                        /* It's a Menuitem or Control */
        if((pMDSource->Item==ENTRYMENUITEM) || (pMDSource->Item==ENTRYCONTROL))
            WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_INSERTITEM,
                MPFROMSHORT(LIT_END), MPFROMP(pMDSource->PgmTitle));
                                        /* It may also be an empty entry, but then we
                                           ignore it, because it must be filled with
                                           Menuitem or Submenu data first */
        if(pMDSource->Next!=NULL)       /* Get through linked list without diving into
                                           Submenus */
                pMDSource=pMDSource->Next;
        else break;                     /* We're at the end of the linked list */
    }while(TRUE);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(pHP->hwndHelp!=NULLHANDLE)
        WinSendMsg(pHP->hwndHelp, HM_DISPLAY_HELP,
            MPFROMSHORT(RDID_RESORTDIALOG), HM_RESOURCEID);
    break;

case WM_CONTROL:
    switch(SHORT1FROMMP(mp1))
    {
    case RDLB_SOURCEMENU:
        if(SHORT2FROMMP(mp1)==LN_ENTER)
                                        /* Simulate clicking the Resort pushbutton */
            WinPostMsg(hwndDlg, WM_COMMAND,
                MPFROM2SHORT(RDPB_MOVE, CMDSRC_PUSHBUTTON), MPFROMSHORT(TRUE));
        break;
    }
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case RDPB_MOVE:                     /* Move pushbutton */
        {
        MENUDATA        *pMDSource;     /* Walk through current linked list */
        MENUDATA        *pMDSourceNext; /* Next menuentry after pMDSource */
                                        /* Walk through destination linked list */
        MENUDATA        *pMDDestination;
        SHORT           sCount;
        SHORT           sCountSave;

/*                                                                                      *\
 * For the first resort operation, disable the Cancel pushbutton.                       *
\*                                                                                      */
        if(bFirstMove==FALSE)           /* After the first move operation, disable the
                                           Cancel pushbutton */
            {
            bFirstMove=TRUE;            /* We make now the first move */
            DisableDialogItem(hwndDlg, usChild2MovePBs,
                sizeof(usChild2MovePBs)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            }
/*                                                                                      *\
 * Now get the selected Menuitem of the source listbox, delete it from the listbox. If  *
 * the source listbox is now empty, reenable the OK pushbutton again.                   *
\*                                                                                      */
                                        /* Query the selected Menuitem from the source listbox */
        sCountSave=sCount=(SHORT)WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYSELECTION,
            MPFROMSHORT(LIT_FIRST), (MPARAM)NULL);
        if(sCount==LIT_NONE)            /* If no item selected ignore this button */
            return((MRESULT)FALSE);
                                        /* Point to the first element of the linked list */
        pMDSource=pHP->pMenuData;
        for( ; sCount>0; sCount--)      /* Walk through the linked list to the selected
                                           item */
            pMDSource=pMDSource->Next;
        pMDDestination=pSortedMenuData; /* Point to the first element of the resorted linked list */
        if(pMDDestination!=NULL)        /* Walk through the resorted linked list to the
                                           last Menuitem, if there's at least one element */
            for( ; pMDDestination->Next!=NULL; pMDDestination=pMDDestination->Next);
                                        /* If the current menuitem is followed by a break
                                           separator, also resort the break separator because
                                           is is just a style of the current menuitem */
                                        /* A break separator can't be resorted, because
                                           it is only a style flag of the previous menu entry
                                           and is therefor moved only together with the
                                           menu entry */
        if(!strcmp(pMDSource->PgmTitle, CTRL_BREAKSEPARATOR))
            return((MRESULT)FALSE);
        {
        UCHAR   ucBuffer[MAXNAMEL+4];
        SHORT   usItems;
                                        /* Query the text of the selected Menuitem from the
                                           source listbox */
        WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYITEMTEXT,
            MPFROM2SHORT(sCountSave, sizeof(ucBuffer)), MPFROMP(ucBuffer));
                                        /* Delete the selected Menuitem from the source listbox */
        WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_DELETEITEM,
            MPFROMSHORT(sCountSave), (MPARAM)NULL);
                                        /* Insert the text of the selected Menuitem into the
                                           destination listbox */
        WinSendDlgItemMsg(hwndDlg, RDLB_DESTINATIONMENU, LM_INSERTITEM,
            MPFROMSHORT(LIT_END), MPFROMP(ucBuffer));
                                        /* Query the number of Menuitems from the source
                                           listbox */
        usItems=(USHORT)WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYITEMCOUNT,
            (MPARAM)NULL, (MPARAM)NULL);
        if(usItems==0)                  /* If now more items left, reenable OK pushbutton
                                           and disable Resort pushbutton */
            {
            DisableDialogItem(hwndDlg, usChild2InitPBs,
                sizeof(usChild2InitPBs)/sizeof(USHORT), WS_VISIBLE);
            DisableDialogItem(hwndDlg, usChild2OKPBs,
                sizeof(usChild2OKPBs)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            }
        }
/*                                                                                      *\
 * Now remove the selected Menuitem from the current linked list, by updating the       *
 * pointers according to previous or following Menuitems.                               *
\*                                                                                      */
                                        /* Get menu entry that follows pMDSource */
        if(((pMDSourceNext=pMDSource->Next)!=NULL) &&
            (!strcmp(pMDSource->Next->PgmTitle, CTRL_BREAKSEPARATOR)))
            {                           /* Same as above */
            UCHAR   ucBuffer[MAXNAMEL+4];
            SHORT   usItems;

                                        /* Get menu entry that follows (pMDSource->Break Separator) */
            pMDSourceNext=pMDSource->Next->Next;
            WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYITEMTEXT,
                MPFROM2SHORT(sCountSave, sizeof(ucBuffer)), MPFROMP(ucBuffer));
            WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_DELETEITEM,
                MPFROMSHORT(sCountSave), (MPARAM)NULL);
            WinSendDlgItemMsg(hwndDlg, RDLB_DESTINATIONMENU, LM_INSERTITEM,
                MPFROMSHORT(LIT_END), MPFROMP(ucBuffer));
            usItems=(USHORT)WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYITEMCOUNT,
                (MPARAM)NULL, (MPARAM)NULL);
            if(usItems==0)
                {
                DisableDialogItem(hwndDlg, usChild2InitPBs,
                    sizeof(usChild2InitPBs)/sizeof(USHORT), WS_VISIBLE);
                DisableDialogItem(hwndDlg, usChild2OKPBs,
                    sizeof(usChild2OKPBs)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            }
        else
                                        /* Point to menu entry following current selection */
            pMDSourceNext=pMDSource->Next;
/*                                                                                      *\
 * Now update the Popup-Menu, by moving the selected Menuitem. Break separators are     *
 * moved automatically by moving 2 menu entries, because they are only style flags of   *
 * a functional menu entry.                                                             *
\*                                                                                      */
        if((pMDDestination==NULL) && (pParentMenuData==NULL))
            SetPopupMenu(MM_MOVEMENUITEM, MPFROMP(pMDSource), MPFROMP(pHP->pPopupMenu));
        if((pMDDestination==NULL) && (pParentMenuData!=NULL))
            SetPopupMenu(MM_MOVEMENUITEM, MPFROMP(pMDSource), MPFROMP(pParentMenuData));
        if(pMDDestination!=NULL)
            SetPopupMenu(MM_MOVEMENUITEM, MPFROMP(pMDSource), MPFROMP(pMDDestination));
        if((pMDSource->Back!=NULL) && (pMDSourceNext!=NULL))
            {                           /* Current element follows another and is followed
                                           by another element, so simple remove it by
                                           updating the pointers. Be carefull if the
                                           parent element is a Submenu where the current
                                           level is a leaf of. */
            if((pMDSource->Back)->Submenu==pMDSource)
                {
                (pMDSource->Back)->Submenu=pMDSourceNext;
                pHP->pMenuData=pMDSourceNext;
                }
            else
                (pMDSource->Back)->Next=pMDSourceNext;
            (pMDSourceNext)->Back=pMDSource->Back;
            }
        if((pMDSource->Back!=NULL) && (pMDSourceNext==NULL))
            {                           /* Current element follows another but is the last
                                           one of the current linked list.  Be carefull if
                                           the parent element is a Submenu where the current
                                           level is a leaf of. */
                                        /* Next element of course is NULL */
            if((pMDSource->Back)->Submenu==pMDSource)
                {
                (pMDSource->Back)->Submenu=pMDSourceNext;
                pHP->pMenuData=pMDSourceNext;
                }
            else
                (pMDSource->Back)->Next=pMDSourceNext;
            }
        if((pMDSource->Back==NULL) && (pMDSourceNext!=NULL))
            {                           /* Current element is the first one of the complete
                                           linked list, but is followed by another */
            (pMDSourceNext)->Back=NULL;
            pHP->pMenuData=pMDSourceNext;
            pHP->pPopupMenu=pMDSourceNext;
            }
        if((pMDSource->Back==NULL) && (pMDSourceNext==NULL))
            {                           /* Current element is the first one of the complete
                                           linked list, and isn't followed by another */
            pHP->pMenuData=NULL;
            pHP->pPopupMenu=NULL;
            }
/*                                                                                      *\
 * Now add the deleted Menuitem at the end of the resorted linked list, by updating the *
 * pointer of the last element to point to the deleted one.                             *
\*                                                                                      */
        if(pMDDestination==NULL)
            {                           /* If the resorted linked list is empty, add
                                           deleted element and update pointers */
            pSortedMenuData=pMDSource;
            pMDDestination=pMDSource;
            pMDDestination->Next=NULL;
            pMDDestination->Back=NULL;
            }
        else
            {                           /* If the resorted linked list isn't empty, add
                                           deleted element at the end and update pointers */
            pMDDestination->Next=pMDSource;
            pMDSource->Back=pMDDestination;
            if((pMDSource->Next!=NULL) && (!strcmp(pMDSource->Next->PgmTitle, CTRL_BREAKSEPARATOR)))
                pMDSource->Next->Next=NULL;
            else
                pMDSource->Next=NULL;
            }
        }
        return((MRESULT)FALSE);         /* We don't want to close the dialog by breaking
                                           out of the switch statement */

    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Now replace the current linked list, which is empty as all Menuitems have been re-   *
 * moved, with the resorted linked list.                                                *
\*                                                                                      */
        if(pParentMenuData==NULL)
            {                           /* If the root of the complete linked list has been
                                           resorted, update the root pointers */
            pHP->pPopupMenu=pSortedMenuData;
            pHP->pMenuData=pHP->pPopupMenu;
            }
        else
            {                           /* If the current level has a parent Menuitem, a
                                           Submenu of course, update the current level pointers */
            pHP->pMenuData=pSortedMenuData;
            pSortedMenuData->Back=pParentMenuData;
            pParentMenuData->Submenu=pHP->pMenuData;
            }
                                        /* Dialog terminated with DID_OK */
        WinDismissDlg(hwndDlg, DID_OK);
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        if(bFirstMove==TRUE)            /* If first resort operation was made, don't dismiss
                                           dialog */
            return((MRESULT)TRUE);
        else
                                        /* Dialog terminated with DID_CANCEL */
            WinDismissDlg(hwndDlg, DID_CANCEL);
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


