/* INETLOG.CMD	REXX Program to extract and totalize daily and monthly		*/
/* 			time_ons from the IBM WARP Internet Dialer CONNECT.LOG file	*/

/* 						Jerry Levy,  Marblehead, MA 12 Feb 95	*/
/*		Please pass on comments, suggestions, problems to JLEVY@IBM.NET	*/
/* --------------------------------------------------------------------	*/
/* WHAT IT DOES:										*/
/* Deciphers the IBM WARP Internet Dialer CONNECT.LOG file.				*/
/* It provides daily and monthly time-on totals, providing total minutes per day		*/
/* for each exact time logged for each connect and for ach time rounded-up to the next	*/
/* whole minute.  For the monthly totals, I also included totals of time_ons rounded to	*/
/* to the nearest minute.									*/
 												
/* HOW IT DOES IT:										*/
/* Looks for lines that contain the string "Disconnected after" (open your CONNECT.LOG	*/
/* file with the OS/2 System Editor to see this) and parses this line to extract out	*/
/* month and day of each connection, and does arithmetic on the times.			*/

/* You should be able to adapt this for deciphering other types of .LOG files as well.	*/

/* CUSTOMIZATION:										*/
/* In most cases, the only changes you may need to make are for the two expressions	*/
/* LOG_FILE and OUTPUT_FILE								*/
/*   LOG_FILE is the path to CONNECT.LOG, where the IBM WARP Internet Dialer	*/
/* 	logs its connection data.  This path should be fine as-is unless you installed	*/
/* 	the internet stuff on a drive other than c:	(which I did).				*/
/*   OUTPUT_FILE is where we write the output.  Output is echoed to the screen	*/
/* 	no matter what we choose here, but it scrolls by awfully fast.			*/

/* Copyright Comment:  This program uses IBM's copyrighted VREXX2 ver. 1.0 Visual	*/
/* REXX functions for Presentation Manager, written by Richard Lam (an IBM'er).  Read 	*/
/* LICENSE.TXT for restrictions and usage details.						*/
/*												*/
/* VREXX2.ZIP can be downloaded from the IBM PCC (PC COMPANY) BBS at		*/
/* (919-517-0001) or any of the several OS/2 BBS's or on the internet by anonymous	*/
/* ftp to software.watson.ibm.net, where it can be found in the pub/os2/ews directory.	*/
/* It's quite nice, and free.  VREXX2.ZIP includes a 49-page manual, an on-line help	*/  
/* file, and demo programs.					*/
/*												*/
/* INSTALLATION:										*/
/* 1.  Easy:  Place everything in this package into one folder, drag the folder onto any	*/
/*	one of your hard drives and run this INETLOG.CMD file by double clicking on it	*/
/*	or by double clicking on its shadow which you can put anywhere			*/
/* 2.	(Probably the right way): Copy VREXX.DLL and this INETLOG.CMD to a directory	*/
/*	in your PATH statement, and copy VREXX.DLL and DEVBASE.DLL to a directory	*/
/*	specified in the config.sys LIBPATH, e.g., into c:\os2\dll				*/

/* Customize these two expressions if you need to						*/

log_file = 'c:\tcpip\etc\connect.log'	/* Complete path and filespec for the log file		*/
output_file = 'c:\file.$$$'		/* Wherever and whatever you want to save output to	*/
					/* Don't forget the quotes if you edit this			*/

/* Now we Initialize VREXX	*/
'@echo off'
call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
initcode = VInit()
if initcode = 'ERROR' then signal CLEANUP

signal on failure name CLEANUP
signal on halt name CLEANUP
signal on syntax name CLEANUP
signal on error name CLEANUP

/* Load the REXXUTIL functions						*/

call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call sysloadfuncs

cr = d2c(13)			/* carriage return	*/
lf = d2c(10)			/* linefeed		*/
ff = d2c(12)			/* formfeed		*/

/* Select logfile		*/

do until result <> ''					/* Don't accept a nonexistent filename	*/
   call VDialogPos 30, 50
   button = VFileBox('Select File to Analyze', log_file, filename)
   if button = 'OK' then ConnectLogFilename = filename.vstring
   if button = 'CANCEL' then call CLEANUP

   call stream ConnectLogFilename, 'c', 'query exists'
   if result = '' then
      do
         say ConnectLogFilename 'does not exist, try again!' 
         call beep 1000,100
       end
end

/* choose file for outputting to disk	*/


do until outfile <> ''						/* Have to enter something	*/
   prompt.0 = 2
   prompt.1 = 'Include path and filename.  If file'
   prompt.2 = 'exists it will be overwritten.'
   prompt.vstring = output_file
   button =  VInputBox(Select Output File, prompt, 30, 3)
   if button = 'CANCEL' then call CLEANUP

   outfile = prompt.vstring
   if outfile = '' then call beep 1000,100
end

/* Check if the output file exists.  If it does, we overwrite it.	*/
/* If not, we create it						*/

call SysFileDelete prompt.vstring


intro = 'Start of Analysis of' ConnectLogFileName Date(U) Time()||cr||lf
say intro
call lineout outfile, intro
intro = 'Date (Logons) Minutes (exact) => minutes, each connect rounded up'
say intro||cr||lf
call lineout outfile, intro

					/* Initialize 		*/
	        daycount = 0			/* Accumulate number of connects daily	*/
		monthcount = 0		/* Accumulate number of connects monthly	*/
		TimeOn = 0			/* Minutes on each conect ...			*/
		TimeOnRndUp = 0		/* ...rounded up to next whole minute	*/
		DailyTimeOn = 0		/* Accumulated minutes daily...		*/
		DailyTimeOnRnd = 0		/* ...which we round to nearest whole...	*/
		DailyTimeOnRndUp = 0	/* ...or which we round up to next whole	*/
		MonthlyTimeOn = 0		/* Accumulated minutes monthly...		*/ 
		MonthlyTimeOnRnd = 0	/* ...which we round to nearest whole...	*/
		MonthlyTimeOnRndUp = 0	/* ...or which we round up to next whole	*/
		LastMonth = 0			/* Stores 2-digit month (eg 05 for May...	*/
		LastDay = 0			/* ...and 2-digit day from prvious hit	*/ 

		monthline = ''			/* null strings					*/
		dayline = ''

		string = 'Disconnected after'		/* Word or phrase we search for in each	*/
						/* line of CONNECT.LOG.  Each line	we hit	*/
						/* that has it is parsed to get month, day, 	*/
						/* and connect time parameters		*/
/* Now look for the string	*/

call SysFileSearch string, ConnectLogFileName, 'line.'
do i = 1 to line.0
	month = substr(subword(line.i, 1, 1), 1, 2)
	day = substr(subword(line.i, 1, 1), 4, 2)
	hrs = substr(subword(line.i, 5, 1), 1, 2)
	mins = substr(subword(line.i, 5, 1), 4, 2)
	secs = substr(subword(line.i, 5, 1), 7, 2)
	TimeOn = (60*hrs + mins + (1/60)*secs)

/* TimeOn in minutes is rounded to 2 places.  We round up if that is not an integer */

	if trunc(TimeOn, 0)-Trunc(TimeOn, 2) = 0 then TimeOnRndUp = Trunc(TimeOn, 0)
	   else TimeOnRndUp = 1 + Trunc(TimeOn, 0)

	if LastMonth = 0 then
	   do					/* for very first connection line	*/
	      LastMonth = month
	      LastDay = day
	      daycount = 1
	      monthcount = 1
	      DailyTimeOn = Trunc(TimeOn, 2)
	      DailyTimeOnRnd = Trunc(TimeOn, 0)
	      DailyTimeOnRndUp = Trunc(TimeOnRndUp, 0)
	      MonthlyTimeOn = Trunc(TimeOn, 2)
	      MonthlyTimeOnRnd = Trunc(TimeOn, 0)
	      MonthlyTimeOnRndUp = Trunc(TimeOnRndUp, 0)
	   end
	else NOP
	 
	if LastMonth = month & LastDay = day & LastMonth <> 0 then			
	   do						/* continue to accumulate times if same month and day	*/
	      daycount = daycount + 1
	      monthcount = monthcount + 1
	      DailyTimeOn = DailyTimeOn + Trunc(TimeOn, 2)
	      DailyTimeOnRnd = DailyTimeOnRnd + Trunc(TimeOn, 0)
	      DailyTimeOnRndUp = DailyTimeOnRndUp + Trunc(TimeOnRndUp, 0)
	      MonthlyTimeOn = MonthlyTimeOn + Trunc(TimeOn, 2)
	      MonthlyTimeOnRnd = MonthlyTimeOnRnd + Trunc(TimeOn, 0)
	      MonthlyTimeOnRndUp = MonthlyTimeOnRndUp + Trunc(TimeOnRndUp, 0)
	   end
	else NOP

						
	if LastMonth = month & LastDay <> day then		/* new day of same month	*/
	   do

	      dayline = LastMonth||'/'||LastDay '('||daycount||'X): ' format(DailyTimeOn, 4, 2) 'mins =>' format(DailyTimeOnRndUp, 4, 0)

	      say dayline
              call lineout outfile, dayline

 	      LastDay = day
	      daycount = 1					/* Start counting over again */
	      monthcount = monthcount + 1
	      DailyTimeOn = Trunc(TimeOn, 2)
	      DailyTimeOnRnd = Trunc(TimeOn, 0)
	      DailyTimeOnRndUp = Trunc(TimeOnRndUp, 0)
	      MonthlyTimeOn = MonthlyTimeOn + Trunc(TimeOn, 2)
	      MonthlyTimeOnRnd = MonthlyTimeOnRnd + Trunc(TimeOn, 0)
	      MonthlyTimeOnRndUp = MonthlyTimeOnRndUp + Trunc(TimeOnRndUp, 0)
	   end
        else NOP

 if LastMonth <> month & LastMonth <> 0 then
	   do					/* for a new month, also by definition a new day	*/

              dayline = LastMonth||'/'||LastDay '('||daycount||'X): ' format(DailyTimeOn, 4, 2) 'mins =>' format(DailyTimeOnRndUp, 4, 0)

	      say dayline
              call lineout outfile, dayline

/* Below, we are creating one concatenated string (with its carriage returns and linefeeds) for	*/
/* the monthly accumumulations and will not output this until all of the daily accumulations	*/
/* have been outputted.  That way all of the monthly accumulations will be together at the end	*/
/* of the output											*/

	      monthline = monthline||'Month'||LastMonth '('||monthcount||'x) Mins/MinsRounded/MinsRoundedUp =' MonthlyTimeOn||'/'||MonthlyTimeOnRnd||'/'||MonthlyTimeOnRndUp||cr||lf

	      LastMonth = month
	      LastDay = day
	      daycount = 1
	      monthcount = 1
	      DailyTimeOn = Trunc(TimeOn, 2)
	      DailyTimeOnRnd = Trunc(TimeOn, 0)
	      DailyTimeOnRndUp = Trunc(TimeOnRndUp, 0)
	      MonthlyTimeOn = Trunc(TimeOn, 2)
	      MonthlyTimeOnRnd = Trunc(TimeOn, 0)
	      MonthlyTimeOnRndUp = Trunc(TimeOnRndUp, 0)
	   end
	else NOP

	 
end		/* of going through all possible lines */

/* Next we output the very last daily accumulation line and then all of the monthly lines		*/
/* If the LastMonth and LastDay values are still zeros, then we didn't have a valid log file	*/

if LastMonth = 0 & LastDay = 0 then
      say 'No hits found.  This is probably not a valid connection log file'||cr||lf
   else
      do
         dayline = LastMonth||'/'||LastDay '('||daycount||'X): ' format(DailyTimeOn, 4, 2) 'mins =>' format(DailyTimeOnRndUp, 4, 0)

         say dayline||cr||lf
         call lineout outfile, dayline||cr||lf

         monthline = monthline||'Month'||LastMonth '('||monthcount||'x) Mins/MinsRounded/MinsRoundedUp ='     MonthlyTimeOn||'/'||MonthlyTimeOnRnd||'/'||MonthlyTimeOnRndUp||cr||lf

         say monthline
         call lineout outfile, monthline
      end
 
finished = 'End of analysis of' ConnectLogFilename Date(U) Time()||cr||lf
say finished
call lineout outfile, finished

/*	Terminate VREXX	*/

CLEANUP:
   call VExit


exit
