/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <tcpconn.h>

#include "globals.h"
#include "nntp.h"
#include "changi.h"



/* forward declarations */
void print_header(int s, FILE * fp, char *header, char *artname);

#ifdef XOVER
int over_is_cheap();
int over_find();
void over_print_header();

#endif

/*
 * XHDR header [<messageid>|articlerange]
 *
 * header is a case-insensitive header field, minus any colons.
 *
 * articlerange is one of:
 *	an article number
 *	an article number followed by a dash to indicate all following
 *	an article number followed by a dash followed by another
 *		article number.
 * e.g.,
 * XHDR subject			retrieve subject of current article
 * XHDR subject 5589-6325	retrieve subject of arts 5589 to 6325
 * XHDR subject 5589-		retrieve subject of arts 5589 and up
 * XHDR subject 5589		retrieve subject of art 5589 only
 * XHDR subject <123@ucbvax>	retrieve subject of art <123@ucbvax>
 *
 * This command is an extension, and not included in RFC 977.
 */

void xhdr(PNEWSCLIENT pnc, int argc, char *argv[])
{
    char buf[_MAX_PATH];
    register int artptr;
    long artnum;
    long low, high;
    register FILE *fp;

#ifdef XOVER
    int over_candidate, hdr;

#endif

    if (argc < 2 || argc > 3) {
	so_printf(pnc -> s, "%d Usage: XHDR headerfield [artrange|<message-id>]\r\n",
		  ERR_CMDSYN);
	return;
    }

    if (!pnc -> canread) {
	so_printf(pnc -> s, "%d You only have permission to transfer, sorry.\r\n",
		  ERR_ACCESS);
	return;
    }

    /* Handle message-id requests */

    if (argc == 3 && *argv[2] == '<') {	/* Message ID */
        fp = openartbyid(pnc, argv[2]);
	if (fp == NULL) {
	    so_printf(pnc -> s, "%d No article by message-id %s, sorry.\r\n",
		      ERR_NOART, argv[2]);
	    return;
	}
        if(so_printf(pnc -> s, "%d 0 %s header of article %s.\r\n",
                     OK_HEAD, argv[1], argv[2]) != -1)
            print_header(pnc -> s, fp, argv[1], argv[2]);
	fclose(fp);

        so_puts(pnc -> s, ".\r\n");
	return;
    }

    /*
     * It must be a range of articles, which means that we need to be in a newsgroup already.
     */

    if (!pnc -> ingroup) {
	so_printf(pnc -> s, "%d You are not currently in a newsgroup.\r\n",
		  ERR_NCING);
	return;
    }

    if (argc == 2) {
	if (pnc -> art_ptr < 0 || pnc -> art_ptr >= pnc -> num_arts) {
	    so_printf(pnc -> s, "%d No article is currently selected.\r\n",
		      ERR_NOCRNT);
	    return;
	}
	high = low = pnc -> art_array[pnc -> art_ptr];
	artptr = pnc -> art_ptr;
    }
    else {
	register char *cp = strchr(argv[2], '-');

	if (cp == NULL)
            low = high = atol(argv[2]);
	else {
	    *cp++ = '\0';
            low = atol(argv[2]);
            high = atol(cp);
	    if (high < low)
		if (pnc -> num_arts > 0)
		    high = pnc -> art_array[pnc -> num_arts - 1];
		else
		    high = low;
	}
	artptr = 0;
    }

    so_printf(pnc -> s, "%d %s fields follow\r\n", OK_HEAD, argv[1]);

#ifdef XOVER
    if (over_is_cheap(low, high))
	over_candidate = ((hdr = over_header(argv[1])) > 0);
    else
	over_candidate = 0;
#endif

    for (; artptr < pnc -> num_arts; artptr++) {
	if ((artnum = pnc -> art_array[artptr]) < low)
	    continue;
	if (artnum > high)
	    break;

        sprintf(buf, "%ld", artnum);

#ifdef XOVER
	if (over_candidate) {
	    extern int over_num;

	    if (over_find(artnum)) {
		over_print_header(hdr, buf);
		continue;
	    }
	    else if (over_num == -1)
		over_candidate = 0;
	}
#endif

	fp = fopen(buf, "r");
	if (fp == NULL)
	    continue;
	print_header(pnc -> s, fp, argv[1], buf);
	fclose(fp);
    }

    so_puts(pnc -> s, ".\r\n");
}


void print_header(int s, FILE * fp, char *header, char *artname)
{
    char line[NNTP_STRLEN];
    char buf[NNTP_STRLEN];
    register char *cp;
    char *cp2;

    while (fgets(line, sizeof(line), fp) != NULL) {
        if (*line == '\n' || *line == '\0')
	    break;
	if (!isspace(*line) && (cp = strchr(line, ':')) != NULL) {
	    *cp = '\0';
	    if (!stricmp(header, line)) {
                strcpy(buf, artname);
                strcat(buf, " ");
		cp += 2;
		for (;;) {
		    if ((cp2 = strchr(cp, '\n')) != NULL)
			*cp2 = '\0';
                    strcat(buf, cp);
                    if (!fgets(line, sizeof(line), fp))
			break;
		    cp = line;
                    if (*cp != ' ' && *cp != '\t')
			break;
		    while (isspace(*++cp)) ;
		    *--cp = ' ';
		}
                strcat(buf, "\r\n");
                so_puts(s, buf);
		return;
	    }
	}
    }
    so_printf(s, "%s (none)\r\n", artname);
}
