/*
 * This program was hacked by Harald Kipp using a source of
 * INEWS written by Kai Uwe Rommel.
 *
 * Some parts are
 *
 *       Copyright (c) 1989-1994 by Kendra Electronic Wonderworks.
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 * You may freely copy or redistribute this software. However,
 * this may not apply to any part of it, if otherwise noted.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <lprintf.h>
#include <header.h>
#include <chanlib.h>

#include "config.h"
#include "inews.h"


int spool_news(char *sysname, FILE *article, char *command)
{
    FILE *fp;
    char wkfile[15];
    char idfile[15];
    char rdfile[15];
    char ixfile[15];
    char rxfile[15];
    char pathname[255];
    char localpath[22];
    char *job = job_id(1);
    size_t cpysiz = 2048;
    char *cpybuf;
    size_t cc;

    sprintf(wkfile, "C.%.8s%c%3.3s", sysname, cfg.grade, job);
    sprintf(idfile, "D.%.7s0%sd", cfg.mynode , job);
    sprintf(rdfile, "D.%.7s0%sr", cfg.mynode , job);
    sprintf(ixfile, "D.%.7s0%se", cfg.mynode , job);
    sprintf(rxfile, "X.%.7s0%sr", cfg.mynode , job);

    /*
     * Create remote X.file
     */
    sprintf(pathname, "%s/%s", cfg.spooldir, cfg.uupcmode ?
            uupc_path(cfg.mynode, localpath, ixfile, sysname) : ixfile);
    if((fp = fopen(pathname, "wb")) == NULL) {
        if(!makepath(pathname))
            fp = fopen(pathname, "wb");
        if(fp == NULL) {
            lperror(pathname);
            return(-1);
        }
    }
    fprintf(fp, "R news %s\n", cfg.mydomain);
    fprintf(fp, "U news %s\n", cfg.mynode);
    fprintf(fp, "F %s\n", rdfile);
    fprintf(fp, "I %s\n", rdfile);
    fprintf(fp, "C %s\n", command);
    fclose(fp);

    /*
     * Create D.file
     */
    sprintf(pathname, "%s/%s", cfg.spooldir, cfg.uupcmode ?
            uupc_path(cfg.mynode, localpath, idfile, sysname) : idfile);
    if((fp = fopen(pathname, "wb")) == NULL) {
        if(!makepath(pathname))
            fp = fopen(pathname, "wb");
        if(fp == NULL) {
            lperror(pathname);
            return(-1);
        }
    }
    cpybuf = malloc(cpysiz);
    while((cc = fread(cpybuf, 1, cpysiz, article)) != 0)
        fwrite(cpybuf, 1, cc, fp);
    free(cpybuf);
    fclose(fp);

    /*
     * Create local C.file
     */
    sprintf(pathname, "%s/%s", cfg.spooldir, cfg.uupcmode ?
            uupc_path(cfg.mynode, localpath, wkfile, sysname) : wkfile);
    if((fp = fopen(pathname, "wb")) == NULL) {
        if(!makepath(pathname))
            fp = fopen(pathname, "wb");
        if(fp == NULL) {
            lperror(pathname);
            return(-1);
        }
    }
    fprintf(fp, "S %s %s %s - %s 0666\n", idfile, rdfile, "news", idfile);
    fprintf(fp, "S %s %s %s - %s 0666\n", ixfile, rxfile, "news", ixfile);
    fclose(fp);

    return(0);
}
