#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <lprintf.h>
#include <chanlib.h>

#include "config.h"
#include "chanx.h"

#define DIRBUFSIZ   8192

/************************************************************************/
/*                                                                      */
/************************************************************************/
char **scan_jobs(char *sysname)
{
    HDIR hdir = HDIR_CREATE;
    int sOff = sizeof(FILEFINDBUF) - CCHMAXPATHCOMP + 1;
    PFILEFINDBUF paffb = malloc(DIRBUFSIZ);
    PFILEFINDBUF pffb;
    int cffb = 255;
    int rc;
    int i;
    int num_jobs = 0;
    int num_got = 0;
    char tpl[_MAX_PATH];
    char **artfiles = NULL;
    char *line = malloc(1024);
    char name[80];
    char typ;
    FILE *fp;

    sprintf(tpl, "%s/C.%.8s*", cfg.spooldir, sysname);
    /*
     * First loop will count entries
     */
    if((rc = DosFindFirst2(tpl, &hdir, 0, paffb, DIRBUFSIZ, &cffb, 1, 0L)) == 0) {
        while (!rc && cffb) {
            pffb = paffb;
            for(i = 0; i < cffb; i++) {
                num_jobs++;
                pffb = (PFILEFINDBUF)((char *)pffb + sOff + pffb->cchName);
            }
            cffb = 255;
            rc = DosFindNext(hdir, paffb, DIRBUFSIZ, &cffb);
        }
        DosFindClose(hdir);
        if(num_jobs) {
            artfiles = malloc((num_jobs + 1) * sizeof(char *));
            /*
             * Second loop will build array of article filenames
             */
            cffb = 255;
            hdir = HDIR_CREATE;
            if((rc = DosFindFirst2(tpl, &hdir, 0, paffb, DIRBUFSIZ, &cffb, 1, 0L)) == 0) {
                while (!rc && cffb && num_got < num_jobs) {
                    pffb = paffb;
                    for(i = 0; i < cffb && num_got < num_jobs; i++) {
                        sprintf(tpl, "%s/%s", cfg.spooldir, pffb->achName);
                        printf("Open %s\n", tpl);
                        if((fp = xopen(tpl, "rt")) != NULL) {
                            if(fgets(line, 1024, fp)) {
                                if(sscanf(line, "%c %s\n", &typ, name) == 2 && typ == 'S')
                                    artfiles[num_got++] = strdup(name);
                            }
                            if(fgets(line, 1024, fp)) {
                                if(sscanf(line, "%c %s\n", &typ, name) == 2 && typ == 'S') {
                                    sprintf(line, "%s/%s", cfg.spooldir, name);
                                    if(unlink(line))
                                        lperror(line);
                                }
                            }
                            fclose(fp);
                            if(unlink(tpl))
                                lperror(tpl);
                        }
                        else
                            lperror(tpl);
                        pffb = (PFILEFINDBUF)((char *)pffb + sOff + pffb->cchName);
                    }
                    cffb = 255;
                    rc = DosFindNext(hdir, paffb, DIRBUFSIZ, &cffb);
                }
                DosFindClose(hdir);
            }
            artfiles[num_got] = NULL;
        }
    }
    free(paffb);
    free(line);
    return (artfiles);
}
