/*
 * This program was hacked by Harald Kipp using a source of
 * RNEWS written by Mike Lipsie.
 *
 * Some parts are
 *
 *  Copyright (c) 1989-1994 by Kendra Electronic Wonderworks.
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 * You may freely copy or redistribute this software. However,
 * this may not apply to any part of it, if otherwise noted.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <direct.h>

#include <lprintf.h>
#include <getopt.h>
#include <header.h>
#include <history.h>
#include <active.h>
#include <chanlib.h>
#include <readcfg.h>

#include <fcntl.h>
#include <io.h>


#include "config.h"
#include "rnews.h"

static CFGITEM cfgitm[] = {
    { "active"    , 0, 4, cfg.activefile     },
    { "batchfile" , 0, 4, NULL               },
    { "dupegroup" , 0, 4, cfg.dupegroup      },
    { "gunzip"    , 0, 4, cfg.gunzipcall     },
    { "history"   , 0, 4, cfg.historyfile    },
    { "inews"     , 0, 4, NULL               },
    { "junkgroup" , 0, 4, cfg.junkgroup      },
    { "mydomain"  , 0, 4, cfg.mydomain       },
    { "mynode"    , 0, 4, cfg.mynode         },
    { "newsdir"   , 0, 4, cfg.newsdir        },
    { "newsserver", 0, 4, NULL               },
    { "rnews"     , 0, 4, NULL               },
    { "spooldir"  , 0, 4, NULL               },
    { "uncompress", 0, 4, cfg.uncompresscall }
};

int n_proc = 0;     /* number of articles processed */

static void usage(void);

/************************************************************************/
/*                                                                      */
/*  RNEWS                                                               */
/*                                                                      */
/*  This program receives incoming news articles into a news directory. */
/*  It accepts batched and compressed news directly. The inews program  */
/*  uses this one to post news locally.                                 */
/*                                                                      */
/************************************************************************/
int main(int argc, char **argv)
{
    int result = 0;
    FILE *fp;
    int option;
    time_t t_proc = time(NULL);

    init_cfg();
    initexit();
    lopen(cfg.logfile);
    lprintf("Rnews (%s)", __TIMESTAMP__);

    /*
     * Process command line options
     */
    while((option = getopt(argc, argv,
           "?ha:A:c:d:D:e:f:F:N:o:r:s:S:t:y:")) != EOF) {
        char *cp;
        switch(option) {
        case 'a':
            strcpy(cfg.activefile, optarg);
            break;
        case 'A':
            strcpy(cfg.approved, optarg);
            break;
        case 'c':
            strcpy(cfg.configfile, optarg);
            break;
        case 'd':
            cp = optarg;
            while(*cp) {
                switch(*cp) {
                case 'a':
                    cfg.logflg |= LOG_ACTIVE;
                    break;
                case 'h':
                    cfg.logflg |= LOG_HISTORY;
                    break;
                case 'f':
                    cfg.logflg |= LOG_FLUSH;
                    break;
                case 'r':
                    cfg.logflg |= LOG_READ;
                    break;
                case 'w':
                    cfg.logflg |= LOG_WRITE;
                    break;
                default:
                    lprintf("Unknown option -d%c ignored", *cp);
                    break;
                }
                cp++;
            }
            break;
        case 'D':
            strcpy(cfg.distribution, optarg);
            break;
        case 'e':
            strcpy(cfg.expires, optarg);
            break;
        case 'f':
            strcpy(cfg.newsfile, optarg);
            break;
        case 'F':
            strcpy(cfg.followupto, optarg);
            break;
        case 'h':
            /* accecpt headers, ignored for compatibility */
            break;
        case 'N':
            strcpy(cfg.newsgroups, optarg);
            break;
        case 'o':
            strcpy(cfg.organization, optarg);
            break;
        case 'r':
            strcpy(cfg.replyto, optarg);
            break;
        case 's':
            strcpy(cfg.newsdir, optarg);
            break;
        case 'S':
            strcpy(cfg.signfile, optarg);
            break;
        case 't':
            strcpy(cfg.subject, optarg);
            break;
        case 'y':
            strcpy(cfg.historyfile, optarg);
            break;
        default:
        case '?':
            lprintf("Unknown option -%c", option);
            usage();
            return(1);
        }
    }

    /*
     * All command line options are processed, check if one
     * argument is left to give us an article file name.
     */
    argc -= optind;
    argv += optind;
    if(argc)
        lprintf("Additional parameter %s ignored", argv[0]);

    if(cfg.newsfile[0]) {
        if((fp = freopen(cfg.newsfile, "rb", stdin)) == NULL) {
            lperror(argv[0]);
            lprintf("Rnews returned error %d%c", 3, '\n');
            lclose();
            return(3);
        }
    }
    else {
        fp = stdin;
        setmode(0, O_BINARY);
    }

    if(fp) {
        ReadCfg(cfg.configfile, cfgitm, sizeof(cfgitm) / sizeof(CFGITEM));
        if(validate_cfg()) {
            int ng;

            if((ng = load_active(cfg.activefile)) != 0) {
                if(DOLOG(LOG_ACTIVE))
                    lprintf("%d active groups", ng);
                artfileproc(fp);
                if(DOLOG(LOG_ACTIVE))
                    lprintf("Saving %s", cfg.activefile);
                save_active(cfg.activefile);
            }
            else if(DOLOG(LOG_ACTIVE))
                lprintf("No active groups found in %s", cfg.activefile);
        }
        else
            result = 3;
        fclose(fp);
    }

    if(result)
        lprintf("Rnews returned error %d%c", 3, '\n');
    else {
        t_proc = time(NULL) - t_proc;
        lprintf("Rnews processed %d article(s) in %lu second(s)%c", n_proc, t_proc, '\n');
    }
    lclose();
    return(result);
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
static void usage(void)
{
    puts("usage: rnews [options]\n"
         "options:\n"
         "  -a<filename>     active file     -N<grouplist>    to newsgroups\n"
         "  -A<approved>     approved by     -o<organization> organization\n"
         "  -c<filename>     config file     -r<address>      reply to\n"
         "  -d<log-flags>    logfile flags   -s<directory>    news directory\n"
         "  -D<distribution> distribution    -S<filename>     append signature\n"
         "  -e<date>         expire date     -t<title>        subject\n"
         "  -f<filename>     article file    -y<filename>     history file\n"
         "  -F<followup>     followup\n\n"
         "logfile flags:\n"
         "  a  active file processing\n"
         "  f  flush logfile after each line\n"
         "  h  history file processing\n"
         "  r  article file reading\n"
         "  w  article file writing");
    lprintf("Rnews usage displayed%c", '\n');
    lclose();
}
