/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#define OS2
#include <os2.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <tcpconn.h>

#include "nntp.h"
#include "globals.h"
#include "changi.h"

/*
 * NEXT
 * LAST
 *
 * Retrieve the message-id of the next or last article in the
 * newsgroup.  Position the current article pointer to this
 * article.
 */

void nextlast(PNEWSCLIENT pnc, int argc, char *argv[])
{
    char artbuf[_MAX_PATH], art_id[MAXBUFLEN];
    int oldptr;
    int next;

    if (!pnc -> canread) {
	so_printf(pnc -> s, "%d You only have permission to transfer, sorry.\r\n",
		  ERR_ACCESS);
	return;
    }

    if (!pnc -> ingroup) {
	so_printf(pnc -> s, "%d You are not currently in a newsgroup.\r\n",
		  ERR_NCING);
	return;
    }

    if (argc != 1) {
	so_printf(pnc -> s, "%d NEXT/LAST need no arguments.\r\n", ERR_CMDSYN);
	return;
    }

    next = (argv[0][0] == 'n' || argv[0][0] == 'N');

    if (pnc -> art_ptr < 0 || pnc -> art_ptr >= pnc -> num_arts) {
	so_printf(pnc -> s, "%d No current article selected.\r\n",
		  ERR_NOCRNT);
	return;
    }

    if (next ? (pnc -> art_ptr + 1 >= pnc -> num_arts) : (pnc -> art_ptr - 1 < 0)) {
	so_printf(pnc -> s, "%d No %s article to retrieve.\r\n",
		next ? ERR_NONEXT : ERR_NOPREV, next ? "next" : "previous");
	return;
    }

    oldptr = pnc -> art_ptr;
    sprintf(artbuf, "%ld", pnc -> art_array[next ? ++(pnc -> art_ptr) : --(pnc -> art_ptr)]);

    if (!atol(artbuf)) {
	so_printf(pnc -> s, "%d Invalid article number: %s.\r\n", ERR_NOARTIG,
		  artbuf);
	return;
    }

    while ((pnc -> art_fp = open_valid_art(pnc, artbuf, art_id)) == NULL) {
	if (((next) ? (++(pnc -> art_ptr) >= pnc -> num_arts) : (--(pnc -> art_ptr) < 0))) {
	    so_printf(pnc -> s, "%d No %s article to retrieve.\r\n",
		      next ? ERR_NONEXT : ERR_NOPREV,
		      next ? "next" : "previous");
	    pnc -> art_ptr = oldptr;
	    return;
	}
        sprintf(artbuf, "%ld", pnc -> art_array[pnc -> art_ptr]);
    }

    so_printf(pnc -> s, "%d %s %s Article retrieved; request text separately.\r\n",
	      OK_NOTEXT, artbuf, art_id);

    if (argc > 1)
	pnc -> art_ptr = findart(artbuf, pnc -> art_array, pnc -> num_arts);
}
