/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

/*
 * Routines to deal with network stuff for
 * stand-alone version of server.
 */

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <types.h>
#define _OFF_T_DEFINED

#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>

#include <sys/socket.h>
#include <netinet/in.h>

#ifndef EXCELAN
#include <netdb.h>
#endif

#include <sys/ioctl.h>
#include <signal.h>

#ifdef USG
#include <time.h>
#else
#include <sys/time.h>
#endif

#include "globals.h"
#include "nntp.h"
#include "changi.h"



#ifdef ALONE
/*
 * get_socket -- create a socket bound to the appropriate
 *	port number.
 *
 *	Parameters:	None.
 *
 *	Returns:	Socket bound to correct address.
 *
 *	Side effects:	None.
 *
 *	Errors:		Syslogd, cause abortion.
 */

get_socket()
{
    int s;
    struct sockaddr_in sin;

#ifndef EXCELAN
    struct servent *sp;
    int on = 1;

    sp = getservbyname("nntp", "tcp");
    if (sp == NULL) {

#ifdef SYSLOG
	syslog(LOG_ERR, "get_socket: tcp/nntp, unknown service.");
#endif

	exit(1);
    }
#endif				/* not EXCELAN */

    bzero((char *)&sin, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = htonl(INADDR_ANY);

#ifndef EXCELAN
    sin.sin_port = sp -> s_port;

    s = socket(AF_INET, SOCK_STREAM, 0);
#else				/* EXCELAN */
    sin.sin_port = htons(IPPORT_NNTP);
    s = 3;				/* WTF??? */
    s = socket(SOCK_STREAM, (struct sockproto *) 0, &sin,
	       (SO_KEEPALIVE | SO_ACCEPTCONN));
#endif				/* EXCELAN */

    if (s < 0) {

#ifdef EXCELAN
	sleep(5);
	return (-1);
#else				/* not EXCELAN */

#ifdef SYSLOG
	syslog(LOG_ERR, "get_socket: socket: %m");
#endif				/* SYSLOG */

	exit(1);
#endif				/* not EXCELAN */
    }

#ifndef EXCELAN

#ifdef SO_REUSEADDR
    if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR,
		   (char *)&on, sizeof(on)) < 0)
	perror("setsockopt - SO_REUSEADDR");
#endif				/* SO_REUSEADDR */

    if (bind(s, (struct sockaddr *) & sin, sizeof(sin)) < 0) {

#ifdef SYSLOG
	syslog(LOG_ERR, "get_socket: bind: %m");
#endif

	exit(1);
    }
#endif				/* not EXCELAN */

    return (s);
}

/*
 * make_stdio -- make a given socket be our standard input
 *	and output.
 *
 *	Parameters:	"sockt" is the socket we want to
 *			be file descriptors 0, 1, and 2.
 *
 *	Returns:	Nothing.
 *
 *	Side effects:	None.
 */

make_stdio(sockt)
int sockt;
{
    if (sockt != 0) {
	dup2(sockt, 0);
	close(sockt);
    }
    dup2(0, 1);
    dup2(1, 2);
}

#if 0
/*
 * set_timer -- set up the interval timer so that
 *	the active file is read in every so often.
 *
 *	Parameters:	None.
 *
 *	Returns:	Nothing.
 *
 *	Side effects:	Sets interval timer to READINTVL seconds.
 *			Sets SIGALRM to call read_again.
 */

set_timer()
{

#ifndef USG
    struct itimerval new, old;

#endif				/* not USG */
    extern int read_again();

    signal(SIGALRM, read_again);

#ifdef USG
    alarm(READINTVL);
#else				/* not USG */

    new.it_value.tv_sec = READINTVL;
    new.it_value.tv_usec = 0;
    new.it_interval.tv_sec = READINTVL;
    new.it_interval.tv_usec = 0;
    old.it_value.tv_sec = 0;
    old.it_value.tv_usec = 0;
    old.it_interval.tv_sec = 0;
    old.it_interval.tv_usec = 0;

    if (setitimer(ITIMER_REAL, &new, &old) < 0) {

#ifdef SYSLOG
	syslog(LOG_ERR, "set_timer: setitimer: %m\n");
#endif

	exit(1);
    }
#endif				/* not USG */
}

#endif				/* 0 */


/*
 * reaper -- reap children who are ready to die.
 *	Called by signal.
 *
 *	Parameters:	None.
 *
 *	Returns:	Nothing.
 *
 *	Side effects:	None.
 */

reaper()
{

#ifndef USG
    union wait status;

    while (wait3(&status, WNOHANG, (struct rusage *) 0) > 0) ;
#endif
}

#else				/* !ALONE */

/* Kludge for greenhill's C compiler */

static void netaux_greenkludge()
{
}

#endif				/* not ALONE */
