/************************************************************************/
/*                                                                      */
/*  Create all subdirectories of a given pathname                       */
/*                                                                      */
/*  Bug reports should be sent to                                       */
/*                                                                      */
/*  harald@os2point.ping.de                                             */
/*  harald@haport.sesam.com                                             */
/*  Fido: 2:2448/434                                                    */
/*                                                                      */
/************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>
#include <errno.h>

#include <lprintf.h>
#include <chanlib.h>

/************************************************************************/
/*  makepath                                                            */
/*                                                                      */
/*  Creates a subdirectory and all its intermediate directories too.    */
/*  The 'pathname' parameter must contain slashes, not backslashes,     */
/*  and a trailing slash. An appended filename would do no harm.        */
/*                                                                      */
/************************************************************************/
int makepath(char *pathname)
{
    char *cp = pathname;
    int r = 0;

    if(pathname[1] == ':' || (pathname[0] == '/' && pathname[1] == '/'))
        cp += 3;
    while(!r && (cp = strchr(cp, '/')) != NULL) {
        *cp = '\0';
        if(mkdir(pathname) && errno != EACCES) {
            r = -1;
            lperror(pathname);
        }
        *cp++ = '/';
    }
    return(r);
}
