/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <active.h>
#include <tcpconn.h>


#include "config.h"
#include "globals.h"
#include "nntp.h"
#include "changi.h"

/*
 * LIST
 *
 * List active newsgroups, newsgroup descriptions, distributions
 * and subscriptions.
 *
 */

void list(PNEWSCLIENT pnc, int argc, char *argv[])
{
    char line[NNTP_STRLEN];
    char *grparray[2];
    char *filename;
    char *items;
    char *format;
    int  num_groups;
    register char *cp;
    register FILE *list_fp;

    if (argc == 1 || (argc == 2 && !stricmp(argv[1], "active"))) {
        num_groups = reload_active(cfg.activefile);
	if (num_groups == 0) {		/* can't get a group list */
	    so_printf(pnc -> s, "%d Group update failed. Try later.\r\n",
		      ERR_FAULT);
	    exit(1);
	}
        filename = cfg.activefile;
	items = "active newsgroups";
	format = "Newsgroups in form \"group high low y/n/m\".";
    }
    else if (argc == 2 && !stricmp(argv[1], "distributions")) {
        filename = "distributions"; /* cfg.distributionsfile; */
	items = "newsgroup distributions";
	format = "Distributions in form \"area description\".";
    }
    else if (argc == 2 && !stricmp(argv[1], "newsgroups")) {
        filename = "newsgroups"; /* cfg.newsgroupsfile; */
	items = "newsgroup descriptions";
	format = "Descriptions in form \"group description\".";
    }
    else if (argc == 2 && !stricmp(argv[1], "subscriptions")) {
        filename = "subscriptions"; /* cfg.subscriptionsfile; */
	items = "group subscription list";
	format = "New-user subscription list in form \"group\".";
    }
    else {
	so_printf(pnc -> s, "%d Usage: LIST [ACTIVE|NEWSGROUPS|DISTRIBUTIONS|SUBSCRIPTIONS]\r\n",
		  ERR_CMDSYN);
	return;
    }

    grparray[0] = line;
    grparray[1] = NULL;

    list_fp = fopen(filename, "r");

    if (list_fp == NULL) {
	so_printf(pnc -> s, "%d No list of %s available.\r\n",
		  ERR_FAULT, items);
	return;
    }

    so_printf(pnc -> s, "%d %s\r\n", OK_GROUPS, format);

    while (fgets(line, sizeof(line), list_fp) != NULL) {
	if ((cp = strchr(line, '\n')) != NULL)
	    *cp = '\0';
	if (ngpermcount) {
	    if (ngmatch(s1strneql, 1, ngpermlist, ngpermcount, grparray, 1) == 0)
		continue;
	}
        if(so_printf(pnc -> s, "%s\r\n", line) == -1)
            break;
    }
    fclose(list_fp);

    so_puts(pnc -> s, ".\r\n");
}
