PROJ = inews
PROJFILE = inews.mak
DEBUG = 0

PWBRMAKE  = pwbrmake
NMAKEBSC1  = set
NMAKEBSC2  = nmake
CC  = cl
CFLAGS_G  = /AC /W4 /G2 /Zp /BATCH /B2 C2L
CFLAGS_D  = /qc /Gi$(PROJ).mdt /Zr /Zi /Od
CFLAGS_R  = /Ot /Ol /Og /Oe /Oi /Gs
MAPFILE_D  = NUL
MAPFILE_R  = NUL
LFLAGS_G  =  /NOI /STACK:8192  /BATCH
LFLAGS_D  = /CO /INC /FAR /PACKC /PACKD /PMTYPE:VIO
LFLAGS_R  = /EXE /FAR /PACKC /PACKD /PMTYPE:VIO
LINKER  = link
ILINK  = ilink
LRF  = echo > NUL
LLIBS_R  =  /NOD:CLIBCE CLIBCEP
LLIBS_D  =  /NOD:CLIBCE CLIBCEP

DEF_FILE  = inews.def
OBJS  = inews.obj spool.obj ..\lib\body.obj ..\lib\jobid.obj\
        ..\lib\lprintf.obj ..\lib\header.obj ..\lib\history.obj ..\lib\dbm.obj\
        ..\lib\idx.obj ..\lib\uupcname.obj ..\lib\arbmath.obj config.obj\
        ..\lib\getopt.obj ..\lib\mkpath.obj iheader.obj ..\lib\mktemp.obj\
        ..\lib\active.obj ..\lib\xopen.obj ..\lib\finedir.obj\
        ..\lib\radixpck.obj ..\lib\readcfg.obj exit.obj
SBRS  = inews.sbr spool.sbr ..\lib\body.sbr ..\lib\jobid.sbr\
        ..\lib\lprintf.sbr ..\lib\header.sbr ..\lib\history.sbr ..\lib\dbm.sbr\
        ..\lib\idx.sbr ..\lib\uupcname.sbr ..\lib\arbmath.sbr config.sbr\
        ..\lib\getopt.sbr ..\lib\mkpath.sbr iheader.sbr ..\lib\mktemp.sbr\
        ..\lib\active.sbr ..\lib\xopen.sbr ..\lib\finedir.sbr\
        ..\lib\radixpck.sbr ..\lib\readcfg.sbr exit.sbr

all: $(PROJ).exe

.SUFFIXES:
.SUFFIXES: .obj .sbr .c

inews.obj : inews.c config.h inews.h

inews.sbr : inews.c config.h inews.h

spool.obj : spool.c config.h inews.h

spool.sbr : spool.c config.h inews.h

..\lib\body.obj : ..\lib\body.c

..\lib\body.sbr : ..\lib\body.c

..\lib\jobid.obj : ..\lib\jobid.c

..\lib\jobid.sbr : ..\lib\jobid.c

..\lib\lprintf.obj : ..\lib\lprintf.c

..\lib\lprintf.sbr : ..\lib\lprintf.c

..\lib\header.obj : ..\lib\header.c

..\lib\header.sbr : ..\lib\header.c

..\lib\history.obj : ..\lib\history.c

..\lib\history.sbr : ..\lib\history.c

..\lib\dbm.obj : ..\lib\dbm.c

..\lib\dbm.sbr : ..\lib\dbm.c

..\lib\idx.obj : ..\lib\idx.c

..\lib\idx.sbr : ..\lib\idx.c

..\lib\uupcname.obj : ..\lib\uupcname.c

..\lib\uupcname.sbr : ..\lib\uupcname.c

..\lib\arbmath.obj : ..\lib\arbmath.c

..\lib\arbmath.sbr : ..\lib\arbmath.c

config.obj : config.c config.h

config.sbr : config.c config.h

..\lib\getopt.obj : ..\lib\getopt.c

..\lib\getopt.sbr : ..\lib\getopt.c

..\lib\mkpath.obj : ..\lib\mkpath.c

..\lib\mkpath.sbr : ..\lib\mkpath.c

iheader.obj : iheader.c config.h inews.h

iheader.sbr : iheader.c config.h inews.h

..\lib\mktemp.obj : ..\lib\mktemp.c

..\lib\mktemp.sbr : ..\lib\mktemp.c

..\lib\active.obj : ..\lib\active.c

..\lib\active.sbr : ..\lib\active.c

..\lib\xopen.obj : ..\lib\xopen.c

..\lib\xopen.sbr : ..\lib\xopen.c

..\lib\finedir.obj : ..\lib\finedir.c

..\lib\finedir.sbr : ..\lib\finedir.c

..\lib\radixpck.obj : ..\lib\radixpck.c

..\lib\radixpck.sbr : ..\lib\radixpck.c

..\lib\readcfg.obj : ..\lib\readcfg.c

..\lib\readcfg.sbr : ..\lib\readcfg.c

exit.obj : exit.c config.h

exit.sbr : exit.c config.h


$(PROJ).bsc : $(SBRS)
        $(PWBRMAKE) @<<
$(BRFLAGS) $(SBRS)
<<

$(PROJ).exe : $(DEF_FILE) $(OBJS)
!IF $(DEBUG)
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
!IF $(DEBUG)
        $(ILINK) -a -e "$(LINKER) @$(PROJ).lrf" $@
!ELSE
        $(LINKER) @$(PROJ).lrf
!ENDIF


.c.obj :
!IF $(DEBUG)
        $(CC) /c $(CFLAGS_G) $(CFLAGS_D) /Fo$@ $<
!ELSE
        $(CC) /c $(CFLAGS_G) $(CFLAGS_R) /Fo$@ $<
!ENDIF

.c.sbr :
!IF $(DEBUG)
        $(CC) /Zs $(CFLAGS_G) $(CFLAGS_D) /FR$@ $<
!ELSE
        $(CC) /Zs $(CFLAGS_G) $(CFLAGS_R) /FR$@ $<
!ENDIF


run: $(PROJ).exe
        $(PROJ).exe $(RUNFLAGS)

debug: $(PROJ).exe
        CVP $(CVFLAGS) $(PROJ).exe $(RUNFLAGS)
