#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <lprintf.h>
#include <chanlib.h>
#include <header.h>

#include "config.h"
#include "inews.h"

/************************************************************************/
/*  validate_header                                                     */
/*                                                                      */
/*  Returns true if header is valid or false otherwise.                 */
/*                                                                      */
/************************************************************************/
int validate_header(char *buf, int bufsiz)
{
    int valid = 1;
    char *item = malloc(MAX_ITEMSIZE);
    int i;
    size_t len;

    *item = '\0';
    for(i = 0; valid && i < ID_LASTENTRY; i++) {
        switch(i) {
        /*
         * In any case we need the newsgroups line
         */
        case ID_Newsgroups:
            if(cfg.newsgroups[0])
                header[i].info = cfg.newsgroups;
            if(header[i].info == NULL) {
                lprintf("Newsgroups missing\n");
                valid = 0;
            }
            break;

        /*
         * If the article contains a path line then we
         * put our machine name in front of it.
         * If there is no such line then we'll create one.
         */
        case ID_Path:
            if(header[i].info) {
                char c;
                char *cp = header[i].info;
                while(*cp && strchr(" !:@^%", *cp) == NULL)
                    cp++;
                c = *cp;
                *cp = '\0';
                if(stricmp(header[i].info, cfg.mynode)) {
                    strcpy(item, cfg.mynode);
                    strcat(item, "!");
                }
                *cp = c;
                strcat(item, header[i].info);
            }
            else
                sprintf(item, "%s!%s", cfg.mynode, "not-for-mail");
            break;

        case ID_From:
            if(cfg.sender[0])
                header[i].info = cfg.sender;
            if(header[i].info == NULL)
                sprintf(item, "%s@%s (%s)", "unknown", cfg.mydomain, "Unknown User");
            break;

        case ID_Subject:
            if(cfg.subject[0])
                header[i].info = cfg.subject;
            else if(header[i].info == NULL) {
                strcpy(item, "<none>");
                lprintf("Created missing subject line");
            }
            break;

        case ID_Distribution:
            if(cfg.distribution[0])
                header[i].info = cfg.distribution;
            if(header[i].info == NULL)
                strcpy(item, "world");
            break;

        case ID_Date:
            if(header[i].info == NULL)
                rfc_date(item, MAX_ITEMSIZE);
            break;

        case ID_Message_ID:
            if(header[i].info == NULL) {
                char pck[MAX_PCKSTRING];
                sprintf(item, "<%s$%s@%s>", radixpack(time(NULL), pck),
                        job_id(0), cfg.mydomain);
                if(cfg.printid)
                    puts(item);
            }
            break;

        case ID_Followup_To:
            if(cfg.followup[0])
                header[i].info = cfg.followup;
            break;

        case ID_Approved:
            if(cfg.approved[0])
                header[i].info = cfg.approved;
            break;

        case ID_Organization:
            if(cfg.organization[0])
                header[i].info = cfg.organization;
            break;

        case ID_Expires:
            if(cfg.expire[0])
                header[i].info = cfg.expire;
            break;

        case ID_Reply_To:
            if(cfg.replyto[0])
                header[i].info = cfg.replyto;
            break;

        /*
         * Remove any xref leftovers
         */
        case ID_Xref:
            header[i].info = NULL;
            break;
        }

        if(*item) {
            if((len = strlen(item) + 1) > (size_t)bufsiz) {
                lprintf("Buffer overflow\n");
                valid = 0;
            }
            else {
                strcpy(buf, item);
                header[i].info = buf;
                buf += len;
                bufsiz -= len;
                *item = '\0';
            }
        }
    }

    if(valid)
        lprintf("Spooling news from %s via %s", header[ID_From].info, cfg.newsserver);
    free(item);
    return(valid);
}
