/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <tcpconn.h>

#include "globals.h"
#include "nntp.h"
#include "changi.h"


/*
 * HELP
 *
 * Provide a naive user with a brief help message.
 *
 */

void help(PNEWSCLIENT pnc, int argc, char *argv[])
{
    so_printf(pnc -> s, "%d This server accepts the following commands:\r\n", INF_HELP);
    so_puts(pnc -> s, "ARTICLE     BODY         GROUP\r\n");
    so_puts(pnc -> s, "HEAD        LAST         LIST\r\n");
    so_puts(pnc -> s, "NEXT        POST         QUIT\r\n");
    so_puts(pnc -> s, "STAT        NEWGROUPS    HELP\r\n");
    so_puts(pnc -> s, "IHAVE       NEWNEWS      SLAVE\r\n");
    so_puts(pnc -> s, "DATE\r\n");
    so_puts(pnc -> s, "XHDR        Retrieve a single header line from a range of articles.\r\n");
    so_puts(pnc -> s, "LISTGROUP   Retrieve a list of valid article-numbers.\r\n");

#if defined(XTHREAD) \
 || defined(XOVER) || defined(XINDEX)
    so_puts(pnc -> s, "\r\nAdditionally, the following extension(s) are supported:\r\n\r\n");

#ifdef XOVER
    so_puts(pnc -> s, "XOVER       Return news overview data\r\n");
#endif

#ifdef XINDEX
    so_puts(pnc -> s, "XINDEX      Retrieve a tin style index file.\r\n");
#endif

#ifdef	XTHREAD
    so_puts(pnc -> s, "XTHREAD     Retrieve trn thread file for the current group.\r\n");
#endif

#endif

    so_puts(pnc -> s, "\r\n");
    so_puts(pnc -> s, "Bugs to Harald Kipp (harald@haport.sesam.com)\r\n");
    so_puts(pnc -> s, ".\r\n");

    if (argc && argv) ;
}
