/*
 * This part was written by Harald Kipp
 *
 * Bug reports should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 * This module contains routines to read the configuration file.
 *
 */

#define INCL_DOSPROCESS
#include <os2.h>

#include <stdlib.h>
#include <stdio.h>

#include <lprintf.h>


#include "config.h"

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
static VOID PASCAL FAR ExitRnews(USHORT usTermCode)
{
    switch(usTermCode) {
    case TC_EXIT:
        lprintf("Normal exit%c", '\n');
        break;
    case TC_HARDERROR:
        lprintf("Hard-error, aborting%c", '\n');
        break;
    case TC_TRAP:
        lprintf("System trap, aborting%c", '\n');
        break;
    case TC_KILLPROCESS:
        lprintf("Oh dear, rnews was killed%c", '\n');
        break;
    default:
        lprintf("Unknown exit%c", '\n');
        break;
    }
    unlink(cfg.pidfile);
    DosExitList(EXLST_EXIT, 0);
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
int initexit(void)
{
    USHORT rc = DosExitList(EXLST_ADD, ExitRnews);
    FILE *fp = fopen(cfg.pidfile, "wt");

    if(fp) {
        PIDINFO pidi;

        DosGetPID(&pidi);
        fprintf(fp, "%u\n", pidi.pid);
        fclose(fp);
    }

    return(rc == 0);
}
