/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      nntpxfer
 *
 *      Brian Kantor, UCSD 1986
 *      Stan Barber, November 7, 1989
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#define OS2
#include <os2.h>

#include <types.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <netdb.h>

#undef min
#include <time.h>

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <direct.h>
#include <process.h>

#include <lprintf.h>
#include <history.h>
#include <tcpconn.h>
#include <readcfg.h>
#include <chanlib.h>

#include "config.h"
#include "chanx.h"

/*
 * Globals
 */
char *artlist[MAX_ARTICLES];
char buf[BUFSIZ];

/*
 * Locals
 */
static CFGITEM cfgitm[] = {
    { "active"    , 0, 4, NULL               },
    { "batchfile" , 0, 4, cfg.batchfile      },
    { "dupegroup" , 0, 4, NULL               },
    { "gunzip"    , 0, 4, NULL               },
    { "history"   , 0, 4, cfg.historyfile    },
    { "inews"     , 0, 4, NULL               },
    { "junkgroup" , 0, 4, NULL               },
    { "mydomain"  , 0, 4, NULL               },
    { "mynode"    , 0, 4, NULL               },
    { "newsdir"   , 0, 4, NULL               },
    { "newsserver", 0, 4, NULL               },
    { "rnews"     , 0, 4, cfg.rnewscall      },
    { "spooldir"  , 0, 4, cfg.spooldir       },
    { "uncompress", 0, 4, NULL               }
};


/************************************************************************/
/*                                                                      */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/* OPTIONS
        argv[1] MUST be the host name
        argv[2-4] MAY be "newsgroups YYMMDD HHMMSS"
                argv[5] MAY be distributions
        (otherwise use 2-4/5 from the file
        "%CHANGIWORKDIR%/nntp.hostname")
*/
int main(int argc, char *argv[])
{
    int server;
    FILE *dtfile;                   /* where last xfer date/time stored */
    char dstrb[BUFSIZ];
    char dtname[_MAX_PATH];
    char ngs[BUFSIZ];
    long ldate;
    long ltime;
    int  omitupdate = 0;            /* 1 = don't update datetime */
    long newdate = 0, newtime = 0;
    struct tm *now;
    time_t t_proc = time(NULL);
    int  n_proc;
    char **artfiles;

    /*
     * Check arguments and print usage if invalid
     */
    if (argc != 2 && argc != 5 && argc != 6) {
	printf("Usage: %s host [groups YYMMDD HHMMSS [<dist>]]\n", argv[0]);
	return (1);
    }

    /*
     * Set up timer
     */
    now = gmtime(&t_proc);
    newdate = ((time_t)(now -> tm_year) * 10000) +
              (((time_t)(now -> tm_mon) + 1) * 100) +
              (time_t)(now -> tm_mday);
    newtime = ((time_t)(now -> tm_hour) * 10000) +
              ((time_t)(now -> tm_min) * 100) +
              (time_t)(now -> tm_sec);

    /*
     * Set up initial configuration
     */
    init_cfg();

    /*
     * Initialize exit proc
     */
    initexit();

    /*
     * Open log file
     */
    lopen(cfg.logfile);
    lprintf("Chanx (%s)", __TIMESTAMP__);

    /*
     * Read configuration file
     */
    ReadCfg(cfg.configfile, cfgitm, sizeof(cfgitm) / sizeof(CFGITEM));
    if(!validate_cfg())
        return(3);


    /*
     * Process command line arguments
     */
    if (argc > 2) {
	omitupdate = 1;
        strcpy(ngs, argv[2]);
        ldate = atol(argv[3]);
        ltime = atol(argv[4]);
	if (argc > 5)
            strcpy(dstrb, argv[5]);
        else
            dstrb[0] = '\0';
    }
    else {
        sprintf(dtname, "%s/nntp.%s", cfg.workdir, argv[1]);
	dtfile = fopen(dtname, "rt");
	if (dtfile == NULL) {
            lperror(dtname);
            strcpy(ngs, "*");
            ldate = newdate;
            ltime = 0;
            dstrb[0] = '\0';
	}
        else {
            if (fscanf(dtfile, "%s %ld %ld %s", ngs, &ldate, &ltime, dstrb) < 3) {
                lprintf("%s has invalid format", dtname);
                strcpy(ngs, "*");
                ldate = newdate;
                ltime = 0;
                dstrb[0] = '\0';
	    }
            fclose(dtfile);
	}
    }

    /*
     * Connect to the nntp daemon and get the greeting
     */
    sock_init();

    if ((server = get_tcp_conn(argv[1], "nntp")) < 0) {
        lprintf("Could not connect to %s", argv[1]);
        return (3);
    }
    if(recv_line(server, buf) <= 0) {
        soclose(server);
        return (3);
    }
    if (buf[0] != '2') {
        lprintf("Server error: %s", buf);
	soclose(server);
        return (3);
    }
    puts(buf + 4);


    /*
     * Tell them we're a slave process to get priority
     */
    if(so_printf(server, "SLAVE\r\n") < 0) {
        soclose(server);
        return (3);
    }
    if(recv_line(server, buf) <= 0) {
        soclose(server);
        return (3);
    }
    if (buf[0] != '2')
        lprintf("Server error: %s", buf);

    /*
     * Post articles
     */
    if((artfiles = scan_jobs(argv[1])) != NULL) {
        int i;
        char *txname = malloc(_MAX_PATH);

        printf("Posting...\n");
        for(i = 0; artfiles[i]; i++) {
            sprintf(txname, "%s/%s", cfg.spooldir, artfiles[i]);
            if(post(server, txname) == 1) {
                if(unlink(txname))
                    lperror(txname);
            }
        }
        free(txname);
    }
    else
        printf("Nothing to post\n");

    /*
     * Query articles
     */
    printf("Querying new articles since %06lu %06lu GMT\n", ldate, ltime);
    if((n_proc = query_ids(server, ngs, ldate, ltime, dstrb)) > 0) {
        puts("Retrieving...");
        n_proc = query_arts(server, cfg.batchfile, n_proc);
    }

    /*
     * We're all done, so tell them goodbye
     */
    so_printf(server, "QUIT\r\n");
    soclose(server);
    puts("Connection closed");

    /*
     * Spooling received batch
     */
    if(n_proc > 0) {
        puts("Spooling...");
        sprintf(buf, "%s < %s", cfg.rnewscall, cfg.batchfile);
        if (system(buf))
            lperror(cfg.rnewscall);
        else if(unlink(cfg.batchfile))
            lperror(cfg.batchfile);

        /*
         * Update timestamp file
         */
        if (!omitupdate) {
            sprintf(buf, "%s %06lu %06lu %s\n", ngs, newdate, newtime, dstrb);
            dtfile = fopen(dtname, "wt");
            if (dtfile == NULL) {
                lperror(dtname);
                exit(1);
            }
            fputs(buf, dtfile);
            fclose(dtfile);
        }
    }

    t_proc = time(NULL) - t_proc;
    lprintf("Chanx processed %d article(s) in %lu second(s)%c", n_proc, t_proc, '\n');
    lclose();

    return (0);
}
