/* EMACS CLASS BROWSER FOR C++.
   Copyright (C) 1993 Gerd Moellmann,
   Altenbergstr. 6, D-4000 Duesseldorf 1, Germany

   $Id: lex.h,v 3.1 1995/02/17 18:20:24 mmann Exp $

   This file is part of GNU Emacs.

   GNU Emacs is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.  No author or distributor
   accepts responsibility to anyone for the consequences of using it
   or for whether it serves any particular purpose or works at all,
   unless he says so in writing.  Refer to the GNU Emacs General Public
   License for full details.

   Everyone is granted permission to copy, modify and redistribute
   GNU Emacs, but only under the conditions described in the
   GNU Emacs General Public License.   A copy of this license is
   supposed to have been given to you along with GNU Emacs so you
   can know your rights and responsibilities.  It should be in a
   file named COPYING.  Among other things, the copyright notice
   and this notice must be preserved on all copies. */

#ifndef lex_h_included
#define lex_h_included

#ifdef __BORLANDC__
#define PROTOTYPES
#endif

#ifdef __IBMC__
#define PROTOTYPES
#endif

#ifdef MSDOS
#define CONVERT_BACKSLASH
#endif

#ifdef OS2
#define CONVERT_BACKSLASH
#endif

/* Parameters. */

#ifdef MSDOS
#define INBUFFER_SIZE   64000        /* would you believe that there are
                                        source files larger than this? */
#else
#define INBUFFER_SIZE	200000
#endif

#define MAX_ID_LENGTH   100
#define MAX_REGEXP      50
#define MIN_REGEXP      5
#define DEFAULT_OUTFILE "BROWSE"
#define VERSION         "GeM 3.00"
#define USE_STRUCTS     1           /* Use Lisp structs where possible */
#define USE_ARRAYS      1           /* Use Lisp arrays where possible */
#define SYM_HASH_SIZE   1001        /* Hash table size for classes */
#define MAX_INPUTFILES  50          /* Max no. of -i<file> options */
#define GLOBALS_NAME	"*Globals*" /* Name of pseudo class for globals. */

/* Storage classes, so to say. */

#define SC_UNKNOWN      0
#define SC_MEMBER       1
#define SC_STATIC       2
#define SC_FRIEND       3
#define SC_TYPE         4

/* Visibility */

#define V_PUBLIC        0
#define V_PROTECTED     1
#define V_PRIVATE       2

/* Constants. */

#define CSTRING         256
#define CCHAR           257
#define CINT            258
#define CFLOAT          259

/* Tokens not expressable with multibyte character constants. */

#define ELLIPSIS        260	/* ... */
#define LSHIFTASGN      261	/* <<= */
#define RSHIFTASGN      262	/* >>= */
#define ARROWSTAR       263	/* ->* */
#define IDENT           264	/* identifier */
#define DIVASGN		265	/* /= */
#define INC		266	/* ++ */
#define ADDASGN		267	/* += */
#define DEC		268	/* -- */
#define ARROW		269	/* -> */
#define SUBASGN		270	/* -= */
#define MULASGN		271	/* *= */
#define MODASGN		272	/* %= */
#define LOR		273	/* || */
#define ORASGN		274	/* |= */
#define LAND		275	/* && */
#define ANDASGN		276	/* &= */
#define XORASGN		277	/* ^= */
#define POINTSTAR	278	/* .* */
#define DCOLON		279	/* :: */
#define EQ		280	/* == */
#define NE		281	/* != */
#define LE		282	/* <= */
#define LSHIFT		283	/* << */
#define GE		284	/* >= */
#define RSHIFT		285	/* >> */


/* Keywords in alphabetical order */

#define ASM             286
#define AUTO            287
#define BREAK           288
#define CASE            289
#define CATCH           290
#define CHAR            291
#define CLASS           292
#define CONST           293
#define CONTINUE        294
#define DEFAULT         295
#define DELETE          296
#define DO              297
#define DOUBLE          298
#define ELSE            299
#define ENUM            300
#define EXTERN          301
#define FLOAT           302
#define FOR             303
#define FRIEND          304
#define GOTO            305
#define IF              306
#define INLINE          307
#define INT             308
#define LONG            309
#define NEW             310
#define OPERATOR        311
#define PRIVATE         312
#define PROTECTED       313
#define PUBLIC          314
#define REGISTER        315
#define RETURN          316
#define SHORT           317
#define SIGNED          318
#define SIZEOF          319
#define STATIC          320
#define STRUCT          321
#define SWITCH          322
#define TEMPLATE        323
#define THIS            324
#define THROW           325
#define TRY             326
#define TYPEDEF         327
#define UNION           328
#define UNSIGNED        329
#define VIRTUAL         330
#define VOID            331
#define VOLATILE        332
#define WHILE           333
#define YYEOF           0

/* The following depends on the CL implementation in use, and its
   implementation of `structs'. */

#define TREE_HEADER_STRUCT	"[cl-struct-tree-header "
#define TREE_STRUCT		"[cl-struct-tree "
#define MEMBER_STRUCT		"[cl-struct-member "
#define BROWSE_STRUCT		"[cl-struct-browse "
#define CLASS_STRUCT		"[cl-struct-class "

extern char yytext[];
extern FILE* yyout;
extern int regexp_file;
extern char* filename;
extern char* regexp_filename;
extern unsigned yyline;
extern int f_costly_friends;
extern int f_append;
extern int f_structs;
extern int f_verbose;
extern int f_very_verbose;
extern int f_emacs;
extern int f_regexps;
extern int f_nested_classes;
extern long total_allocated;
extern long long_val;

typedef struct link
{
  struct sym* sym;
  struct link* next;
}
link_t;

typedef struct member
{
  struct member* next;
  long params;                  /* hash value for parameter types */
  unsigned vis : 4;             /* visibility (private, ...) */
  unsigned is_virtual : 1;      /* virtual function? */
  unsigned is_inline : 1;       /* inline function? */
  unsigned is_const : 1;        /* const function? */
  unsigned is_pure : 1;         /* pure virtual function? */
  char* regexp;                 /* matching regular expression */
  char* filename;               /* don't free this shared string */
  unsigned pos;                 /* buffer position of occurrence */
  char* def_regexp;
  char* def_filename;           /* don't free this shared string */
  unsigned def_pos;
  char name[1];
}
member_t;

/* The structure used to describe a class in the symbol
   table. */

typedef struct sym
{
  unsigned is_template : 1;	/* is class a template class? */
  unsigned visited : 1;		/* used to find circles. */
  struct sym* next;             /* hash collision list */
  link_t* subs;                 /* list of subclasses */
  link_t* supers;               /* list of superclasses */
  member_t* vars;               /* list of instance variables */
  member_t* fns;                /* list of instance functions */
  member_t* static_vars;        /* list of static variables */
  member_t* static_fns;         /* list of static functions */
  member_t* friends;            /* list of friend functions */
  member_t* types;              /* list of local types */
  char* regexp;                 /* matching regular expression */
  unsigned pos;                 /* buffer position */
  char* filename;               /* file in which it can be found */
  char* sfilename;              /* file in which members can be found */
  char name[1];                 /* name of the class */
}
sym_t;

#ifdef PROTOTYPES
int yylex (void);
void yyerror (char* format, ...);
int yyparse (void);
void re_init_parse (void);
char* token_string (unsigned tk);
char* line_start (void);
unsigned buffer_pos (void);
void init_sym (void);
sym_t* add_sym (char* name);
sym_t* find_sym (char* name);
void add_link (sym_t* super, sym_t* sub);
void add_member_definition (sym_t* cls, char* name, char* regexp,
                            unsigned pos, long hash, int var,
                            int is_static, int is_inline, int is_const);
void add_member_declaration (sym_t* cls, char* name, char* regexp,
                             unsigned pos, long hash, int var,
                             int is_static, unsigned vis,
                             int is_virtual, int is_inline,
                             int is_const, int is_pure);
void dump_roots (FILE* fp);
char* dupstr (char* s);
void* xmalloc (unsigned sz);
void xfree (void* p);
void add_global_definition (char* name, char* regexp, unsigned pos,
                            long hash, int is_var, int sc, int is_inline,
			    int is_const);
void add_global_declaration (char* name, char* regexp, unsigned pos,
			     long hash, int is_var, int sc, int is_inline,
			     int is_const);
void mark_inherited_virtual (void);
#endif
#endif
