;;; CLASS BROWSER FOR C++
;;; $Id: br-menu.el,v 3.1 1995/02/17 18:19:36 mmann Exp $
;;;
;;; **********************************************************************
;;; Copyright (C) 1993, 1994 Gerd Moellmann. All rights reserved.
;;; Altenbergstr. 6, D-40235 Duesseldorf, Germany
;;; 100025.3303@COMPUSERVE.COM
;;; Suggestions, comments and requests for improvements are welcome.
;;; **********************************************************************
;;;
;;; This version works with both Emacs version 18 and 19, and I want
;;; to keep it that way. It requires the CL-19 Common Lisp compatibility
;;; package for Emacs 18 and 19.
;;;
;;; This file contains a menu definition for Emacs 19. To load the
;;; menu, insert into your .emacs:
;;;
;;; (require 'br-menu "browse/menu")
;;; 

;; This file may be made part of the Emacs distribution at the option
;; of the FSF.

;; This code is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; this code, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


(require 'br-tree)
(require 'br-membe)

(if (and (browse-emacs-19-p)
	 window-system
	 browse-enable-menu-bar)
    (progn
      (define-key tree-mode-map [menu-bar browse]
	(cons "Browse" (make-sparse-keymap "Browse")))

      ;; Expanding and collapsing the tree
      (define-key tree-mode-map [menu-bar browse expand-tree]
	'("Expand branch" . tree-expand-branch))
      (define-key tree-mode-map [menu-bar browse expand-all]
	'("Expand all" . tree-expand-all))
      (define-key tree-mode-map [menu-bar browse collapse-tree]
	'("Collapse branch" . tree-collapse-branch))

      ;; Showing function, attributes etc.
      (define-key tree-mode-map [menu-bar browse show-instance-vars]
	'("Show instance variables" . tree-show-vars))
      (define-key tree-mode-map [menu-bar browse show-static-vars]
	'("Show static variables" . tree-show-svars))
      (define-key tree-mode-map [menu-bar browse show-instance-functions]
	'("Show instance functions" . tree-show-fns))
      (define-key tree-mode-map [menu-bar browse show-static-functions]
	'("Show static functions" . tree-show-sfns))
      (define-key tree-mode-map [menu-bar browse show-friends]
	'("Show friend functions" . tree-show-friends))
      (define-key tree-mode-map [menu-bar browse show-types]
	'("Show types" . tree-show-types))

      ;; Jump to definition
      (define-key tree-mode-map [menu-bar browse view-class]
	'("View class declaration" . tree-view-source))
      (define-key tree-mode-map [menu-bar browse find-class]
	'("Find class declaration" . tree-find-source))

      ;; Move in tree
      (define-key tree-mode-map [menu-bar browse goto-class]
	'("Find class..." . tree-position-on-class))

      ;; Show member buffer
      (define-key tree-mode-map [menu-bar browse pop-to-member-buffer]
	'("Pop to member buffer" . tree-pop-to-members))

      ;; Member buffer...
      (define-key member-mode-map [menu-bar browse]
	(cons "Browse" (make-sparse-keymap "Browse")))

      ;; Viewing and finding
      (define-key member-mode-map [menu-bar browse find-definition]
	'("Find definition" . member-find-definition))
      (define-key member-mode-map [menu-bar browse find-declaration]
	'("Find declaration" . member-find-declaration))
      (define-key member-mode-map [menu-bar browse view-definition]
	'("View definition" . member-view-definition))
      (define-key member-mode-map [menu-bar browse view-declaration]
	'("View declaration" . member-view-declaration))

      ;; Positioniing...
      (define-key member-mode-map [menu-bar browse position-on-all]
	'("Goto member..." . member-position-over-all-members))
      (define-key member-mode-map [menu-bar browse position-on-class]
	'("Goto class..." . member-show-some-class))
      (define-key member-mode-map [menu-bar browse position-on-subclass]
	'("Goto derived class..." . member-show-class-down))
      (define-key member-mode-map [menu-bar browse position-on-base-class]
	'("Goto base class..." . member-show-class-up))
      (define-key member-mode-map [menu-bar browse show-next]
	'("Show next list" . member-view-next))
      (define-key member-mode-map [menu-bar browse show-previous]
	'("Show previous list" . member-view-previous))

      ;; Tree
      (define-key member-mode-map [menu-bar browse show-class-in-tree]
	'("Show class in tree..." . member-show-class-in-tree))
      (define-key member-mode-map [menu-bar browse pop-to-tree]
	'("Pop to class tree" . member-pop-to-tree))
            
      ;; Display filters
      (define-key member-mode-map [menu-bar browse show-attributes]
	'("Show attributes" . member-display-attributes))
      (define-key member-mode-map [menu-bar browse toggle-regexp]
	'("Toggle regular expression display" . member-toggle-regexp))
      (define-key member-mode-map [menu-bar browse toggle-long-short]
	'("Toggle long/short display" . member-toggle-long-short))
      (define-key member-mode-map [menu-bar browse show-inherited]
	'("Toggle inherited members" . member-toggle-superclasses))

      (define-key member-mode-map [menu-bar browse show-pure]
	'("Toggle pure virtual function display" . member-pure))
      (define-key member-mode-map [menu-bar browse show-const]
	'("Toggle const function display" . member-const))
      (define-key member-mode-map [menu-bar browse show-inline]
	'("Toggle inline function display" . member-inline))
      (define-key member-mode-map [menu-bar browse show-virtual]
	'("Toggle virtual function display" . member-virtual))
      (define-key member-mode-map [menu-bar browse show-private]
	'("Toggle privates" . member-private))
      (define-key member-mode-map [menu-bar browse show-protected]
	'("Toggle protected" . member-protected))
      (define-key member-mode-map [menu-bar browse show-public]
	'("Toggle publics" . member-public))
      (define-key member-mode-map [menu-bar browse show-all]
	'("Display all" . member-all-visible))
      ))

(provide 'br-menu)

;;; End of br-menu.el