Phantom of The Console

Don't Leave Your Server Alone Without It !



CIRCUIT MASTERS SOFTWARE, INC.

10014 Kent Town

Sugar Land, Tx 77478

U.S.A.



Sales: (713) 242-9353

Fax: (713) 242-4632



Support: (409) 335-6126

BBS: (409) 335-4786

CIS: 72103,2327


























PRODUCT MANUAL
TO OUR VALUED CUSTOMERS,

     Thank You for making the Phantom choice.  This
powerful product has been specifically developed to allow you to
most efficiently manage and increase productivity in your network
environment.  Once Phantom of The Console has been implemented into
your facility, you will be pleased with the additional amount of
extra time that you will have to spend in other important areas.

     We place a very high value on feedback from our User's.  Any
input, comments or suggestions that you may have to offer could
result  in an improved Product.  Your input will be most
appreciated and certainly considered in our future releases. 
Take a moment and drop us a line.  Our fax number is 713-242-4632
and your comments are welcome. 

Circuit Masters Software, Inc.


















All rights reserved.  No part of this document may be reproduced,
copied, transmitted, transcribed or translated in any form or by
any means without prior written permission of Circuit Masters
Software, Inc..

Circuit Masters Software, Inc. provides this manual "as is",
without warranty of any kind, either expressed or implied,
including to , the limited warranties of merchantability and
fitness for a particular purpose.  Circuit Masters Software, Inc.
may make improvements and/or changes in the products) and/or the
programs described in this manual at any time and without notice. 
Changes are periodically made to the information herein.  These
changes will be incorporated in new editions of this publication. 
Updated 12-09-94. Phantom of The Console is a Trademark of  Circuit
Masters Software, Inc..

(c) Copyright 1993, 94, 95 Circuit Masters Software, Inc.. 

All Rights Reserved.
CHAPTER 1                               PROGRAM OVERVIEW


** Introduction **


Since 1991, Phantom of The Console has been the clear choice
around the world in need of scheduling power for their NetWare
servers.  From Phantom's Original Console SchedulerV1.57
allowing administrators to schedule simple NetWare commands, to
Phantom's V4.13's integrated scripting language, and now Phantom
V5.10's multiprocessing architecture, sophisticated command
language and elegant user interface, there has never been time
to experience the power of Phantom of The Console.  Install the
Phantom, and let it work for you.  We think you'll be surprised
at how much more sleep you will get.


** Copyright/Trademark Aackonwledgements **


Phantom of The Console is a trademark of Circuit Masters
Software, Inc..

Server Sentry is a trademark of Circuit Masters Software, Inc.

Volume Sentry is a trademark of Circuit Masters Software, Inc.

CORA is a trademark of Circuit Masters Software, Inc.

NetWare and NLM are registered trademarks of Novell, Inc..

Windows is a registered trademark of Microsoft Corporation.

All other trademarks are of their respective manufacturer.


** Features **


Sophisticated scripting language

Record & playback keystrokes

Automated database shutdowns

Allows control of NLM's & server screens

MS Windows Management Console

DOS command line job submission

File level actions, copy/move/delete/etc.
page 1
Execute multiple scripts concurrently

Report generator

Centralized password protection

Multi-process architecture

Execute multiple scripts 

Workstation agent support

Execute tasks on idle workstations

Integrate with network monitoring and alert packages

Includes 2 Server Sentry NLM's

Includes 2 Volume Sentry NLM's

Includes CORA NLM's

Includes 20 client workstation agents

Features are based on the type of package


** Program Overview **


Phantom Of The Console is comprised of several software
components that allow the scheduling of command scripts to be
executed on a Novell 3.x or 4.x server, or client workstations
connected to the server.



















page 2
CHAPTER 2                                         INSTALLATION


** Hardware Requirements **


Please refer to your NetWare Installation Guide for hardware
requirements.  Otherwise, Phantom has no additional requirements.


** Software Requirements **


The file server must be running NetWare V3.11 or greater, including
NetWare V4.0+.  If your file server is not running NetWare 3.1X or
greater, please refer to the installation section of your NetWare
User's Manual.

Management Console requires Microsoft Windows version 3.1 or
greater.


** What You Should Know Before Installation ! **


The file server Must be running NetWare v3.1x or higher. With
CLIB.NLM Ver 3.11d or greater and NWSNUT.NLM.

The SYS Volume MUST be mounted. This volume must be mounted so
that the INSTALL program can create the necessary bindery
objects.

To Install, you must be logged in as Supervisor or equivalent
under NetWare v3.1x or ADMIN or equivalent under NetWare v4.x


** Note About NetWare 4.x installations **


Phantom Of The Console uses bindery emulation services on NetWare
4.x, therefore it is important that a bindery context be set on the
file server before running the installation program. The bindery
context can be set using the Set Bindery Context command or using
the SERVMAN.NLM, on the server console.

For more information on setting the bindery context, please see the
NetWare 4.x manuals. You do not need to login to the server using
bindery emulation, the installation will run properly using a 
Directory Services connection.

After the installation is COMPLETE, 


page 3
Run the management console to SETUP USERS AND GROUPS as Phantom
users.

     LOAD the PHANTOM.NLM on the file server. 

This must be done before any jobs can be executed !


** The Difference Between  Phantom's BASIC & GOLD & PLATINUM
Packages **


BASIC PACKAGE

     PHANTOM .NLM   Script Execution Engine (NetWare Loadable
                         Module)

     PHANTOM.NLM    Phantom Management Console (MS-Windows)

     ONCONSLE.EXE   Command Line Job Execution



GOLD PACKAGE

     PWA.EXE        Workstation Control Agents (DOS TSR)

     PAD.NLM        Alert Dispatch Module (NetWare Loadable Module)

     PXCONSLE.NLM   Phantom Extended Console (NetWare Loadable
                         Console)

     WSERVE.NLM     Workstation Server (NetWare Loadable Module)


PLATINUM PACKAGE

     SSENTRY.NLM    Server Sentry (NetWare Loadable Module)

     SSENTRY.EXE    Server Sentry Management Console (MS-DOS)

     SSPAGE.EXE          Server Sentry Pager Notification (MS-DOS)

     VSENTRY.NLM    Volume Sentry (NetWare Loadable Module)

     CORA.NLM       Console Output Recorder (NetWare Loadable    
                    Module)


** Installing Phantom Of The Console **


If you received Phantom of The Console from the CMSI BBS, your
page 4
You have two options at this point:.

Option 1: Unzip each disk file received from the CMSI BBS into its
own directory.  When prompted for a diskette during the install
process, enter the path to where the files can be found.

Option 2: Unzip each disk file received from the CMSI BBS onto a
separate diskette of your own.  When prompted for a diskette during
the install process, enter the appropriate diskette.

Complete the License Form, filling in the Organization and Company
Name fields

If this is an evaluation or demo copy, the license key field will
remain blank.  When all of the License Information is entered, 

     Enter the license key number that was shipped with the Phantom
     of The Console Diskette

=>Note:  If this is a demonstration version, the license key #
should remain with the default blank, or "0"


=>Note:  For Site License Installations, enter the key # during the
first install only. For the remaining intstalls on the Site
License, the key # will automatically appear.

=> CAUTION:  Once the license information has been saved, it cannot
be changed.

To begin the installation procedure, you should be running
Microsoft Windows v3.1 or higher. 

     Insert the disk labeled "Setup" in drive A:

From the Program Manager,

     Select File|Run, then enter A:SETUP and press <ENTER>. 

After the setup program initializes, the file server selection
dialog is displayed, as shown below:

Using this dialog, 

     Select the server where the software should be installed. 

The list contains all file servers that the workstation is
currently logged in to as supervisor or equivalent. When a server
has been selected,

     Click  Ok.

page 5
After the server has been selected, the license information
dialog is displayed, as shown on the next page:


Complete the fields on the license dialog.  To CONTINUE,  

     Click OK 

To ABORT the installation, 

     Click CANCEL

=>  Note:  If you are installing a demonstration version of the
software, leave the license key field blank, otherwise enter the
license key that is shipped with your licensed software.

The installation program continues by creating the PHANTOM
directory on the SYS: volume of the server that was selected and
copying files to the PHANTOM directory and NLM files to the SYSTEM
directory, and creating a program group and icon for the Phantom
Management Console.

After all files have been copied to the file server, the
installation program will display the read.me file that contains
last minute information and updates not included in the manual.
Once the read.me has been displayed, the installation is completed.


** Note About NetWare 4.x installations **


Phantom Of The Console uses bindery emulation services on NetWare
4.x, therefore it is important that a bindery context be set on the
file server before running the installation program. The bindery
context can be set using the Set Bindery Context command or using
the SERVMAN.NLM, on the server console.

For more information on setting the bindery context, please see the
NetWare 4.x manuals. You do not need to login to the server using
bindery emulation, the installation will run properly using a 
Directory Services connection.

After the installation is COMPLETE, 

     Run the management console to SETUP USERS AND GROUPS as      
     Phantom users.

     LOAD the PHANTOM.NLM on the file server. 

This must be done before any jobs can be executed !



page 6
CHAPTER 3                                       PHANTOM'S  NLMS


** The Phantom NLM **


The PHANTOM.NLM is the NetWare Loadable Module responsible for
executing scripts at the specified date and time. This NLM can
process multiple scripts at the same time, which allows for a
more enhanced scripting language. This NLM must be loaded before
any jobs are run on the server, or workstations. 

The PHANTOM.NLM is depended upon two other Novell NLM's, they
are as follows:

     CLIB.NLM V3.11d or greater and 

     NWSNUT.NLM. 

These NLM's are shipped with the NetWare operating system and will
be automatically loaded by the PHANTOM.NLM.  To LOAD the
PHANTOM.NLM, enter the following command at the file server's
system console prompt:

     load Phantom [/nm]

The PHANTOM.NLM accepts one command line parameter, /nm. This
command line parameter instructs the PHANTOM.NLM NOT to create the
Phantom Monitor screen, on the file server console. Specifying the
/nm option saves about 50k of memory on the file server. It is
recommended that the PHANTOM.NLM be loaded without the /nm switch
so that the monitor screen is always created. However, if strict
memory requirements exist, the option still exists to save the
additional memory.

After the PHANTOM.NLM is loaded, a screen similar to the one
shown on the following page will appear:

This screen shown above is the Phantom Monitor Screen. It displays
statistics about the PHANTOM.NLM's operating status. The following
information is displayed:

Phantom UPTIME - The amount of time elapsed since the PHANTOM.NLM
was loaded.

Total Jobs Executed - The total number of jobs successfully
executed.

Total Jobs In Queue - The total number of jobs in the Phantom's
queue.

Peak Work Threads Used - The maximum number of jobs that has been
executed simultaneously since the PHANTOM.NLM was loaded.
page 7
Work Threads In Use - The number of jobs that are currently
executing.

Phantom Server Can Service Jobs - Displays Yes or No, if the
PHANTOM.NLM can service jobs in the queue.

Phantom Users Can Create New Jobs - Displays Yes or No, if
Phantom users can create new jobs for the PHANTOM.NLM to service.

Active Jobs - A list of all jobs that are currently being
executed by the PHANTOM.NLM. Each entry in the list contains the
job description, job submitter, job type, and target execution date
/ time.

The following keys are active on the Phantom Monitor Screen

     [Arrow Keys    ]         Move through the job list
     [Enter         ]         View active job detail
     [Delete        ]         Cancel currently executing job.
     [Escape        ]         Unload The Phantom NLM

To VIEW  details about an active job,

     Highlight the job and press <ENTER>

The screen shown below will appear:

When finished viewing the job detail information, 

     Press  <ESC>  to RETURN to the active job list.

To CANCEL a job that is currently being executed, 

     Highlight the job entry in the list and press  <DEL> 

A confirmation screen similar to the one shown on the next page
will be displayed:

To ABORT the job and reschedule for it's next earliest execution,

     Select YES

To UNLOAD the PHANTOM.NLM, 

     Press <ESC> on the Phantom Monitor Screen or 

From the file server's system console screen,

     Enter the command UNLOAD PHANTOM  

Any jobs that are currently executing will be prematurely
terminated, and the NLM will be unloaded.

page 8
** Phantom's Workstation Control Server, WSERVE.NLM **

* Not available in the Phantom Basic Product


To distribute tasks to idle workstations, the WSERVE.NLM must be
loaded on the file server.  This NLM handles the communications for
all attached workstations that are running the Phantom
Workstation Control Software. The WSERVE.NLM communicates with
workstations via NCP (NetWare Core Protocol ) extensions which are
created when the NLM is loaded. 

The workstations that run PWC software send an NCP request to
the WSERVE.NLM, which in turn returns work for it to perform, in
the form of keystrokes. To LOAD the WSERVE.NLM, enter the following
command at the file server's system console prompt.

     load wserve

After the NLM is loaded, it creates a Phantom Workstation Control
screen on the file server. This screen is similar to the system
console, in that operates with a command line interface. The
following commands are available:

Down - Stop communicating with workstation agents, and unload the
          WSERVE.NLM.

List -  all known agents communicating with the WSERVE.NLM

Trace - Turn on diagnostic communication messages.

Cls - Clear the screen.


** Phantom Alert Dispatch (PAD) **

* Not included in the Phantom Basic Product


The PAD.NLM is used to interface Phantom with network monitoring
and alert packages that broadcast alert messages through the
NetWare 25th line Broadcast Message Facility.

When PAD receives an alert message, it will search Phantom's Job
Queue for a Pro*Active job that is defined to resolve the alert.

Upon finding the job, PAD will then place all other Phantom
job's on hold and execute the actions required to resolve the
problem. Once the problem has been resolved, all held jobs will be
reactivated.

PAD will work with ANY network monitoring/alert package that can
notify users of network failures via NetWare Broadcast messages.
page 9
In order for PAD to interface with alert and monitoring packages,
it must login to the file server as a NetWare user. This user id
requires minimal rights and should be defined using the SYSCON
utility.

PAD will always login to the NetWare server on a connection
number above the number of licensed users, so that it does not
occupy a connection that may be needed for other users.

=> Example:  If the server allows 100 user connections, then PAD
would login on connection 101 or higher. Novell has reserved
100 connections above the licensed user count for NLM logins.

After the user ID has been defined, 

ADD The ID to the list of users that are notified via Broadcast
messages, in the alert/monitoring package.

If unsure about how to add the user to the broadcast list, please
refer to your monitoring software documentation.

To LOAD the PAD NLM, enter the following command at the NetWare
Console prompt:  

     LOAD PAD [USERNAME] [PASSWORD]

A screen similar to below will be displayed:

Phantom Alert Dispatch Status

---------------------------------------------------------------

Uptime Without Incident  0 Days  0 Hours  0 Minutes 15 Seconds

Last Alert Received

Date Received

Action Taken 

---------------------------------------------------------------

This screen will list the last alert received, date and time and
the action that was taken.

All Pro*Active jobs executed may be viewed by using the Report Tool
from the Phantom Management Console's report menu.






page 10
** Phantom Extended Console **

* Not included in the Phantom Base product


The PXCONSLE.NLM, or Phantom Extended console, brings a DOS like 
command line interface to the NetWare server. From the Phantom
Extended Console screen, otherwise referred to as the Extended
Console screen, files may be copied, deleted, flagged, renamed
etc., just as if you were entering the commands from a workstation
connected to the server. The PXCONSLE.NLM also has access to the
DOS partition of the file server.  This access allows operations to
be performed on that drive, even when the server is up.

To LOAD the PXCONSLE.NLM, enter the following command at the file
server's system console prompt.

     load pxconsle /a=script.fil

The PXCONSLE.NLM accepts one parameter on the command line. The
/a= parameter specifies a script file to run automatically after
the PXCONSLE.NLM has loaded. This script will run on connection 0
of the file server, unless the script, calls the attach function to
attach as a given user. If the script finishes execution at
connection 0, PXCONSLE will require that a valid user login before
commands may be entered on the extended console screen.


After the NLM is loaded and a user has logged in, the PXCONSLE
prompt will be displayed. The Phantom Extended Console command line
prompt is identical to the MS-DOS command line interface.  The
command line prompt is defined in the following format:

      [SERVER_NAME/VOLUME:DIRECTORY_PATH]

From the Phantom Extended Console command line, users can enter
any of the valid Phantom Command Language commands, or the name of
a script file.  A script file is a collection of Phantom Command
Language commands, stored in a text file for sequential execution.


** Filespec Rules & PXCONSLE Commands **


The similarities between the Phantom Extended Console and the
MS-DOS  command interpreter are obvious, however there are some
subtle differences as noted below.

When entering file specifications for Extended Console commands, be
sure to include any / or \ characters that may be needed to
indicate the presence of a sub-directory on the command line.
Phantom Extended console will accept the forward slash "/" in place
of a back slash "\", in path specifications.
page 11
For instance, the MS-DOS command interpreter will accept the
following as a valid sub-directory specification \, as shown below:
   ..\data



However, when using the Extended Console, you must include the
trailing back slash character, as shown below:

  ..\data\











































page 12
CHAPTER 4            PHANTOM WORKSTATION CONTROL SOFTWARE

* Not included in the Phantom Basic Product.


The Phantom Workstation Control Agent software is a TSR
(terminate stay resident) program that resides on client PC's
attached to the file server. This program is responsible for
communicating with the Workstation Control Server NLM and
polling for work. 

It is recommended that a group of workstations be designated to
run the PWCA software. Once the group of workstations has been
established, 

Copy the PWA.EXE file from the SYS:PHANTOM directory to the local
drive of the workstation and Modify the workstation's AUTOEXEC.BAT
file to load the PWA.EXE when the machine is booted. 

Doing so, will ensure that the software is always loaded and ready
to handle jobs for execution.

Since PWA and WSERVE.NLM communicate at the NCP layer of the
network, a login to the file server is not required for jobs to be
processed. However, the job that PWA executes may login to the file
server at any time.

Each workstation that has the PWA software running must have a
unique name, referred to as the agent name. If PWA is loaded with
an agent that has already been registered with the WSERVE.NLM, the
later agent will be denied access to communicate with the
WSERVE.NLM. Agent names are limited to 25 bytes in length and may
not contain spaces. Below are some example agent names:

     jobs-ws-1st-floor

     compaq-486dx

     pentium-station

Agent names should be static in nature and not change, due to the
fact that the agent name may be referenced in an existing script.
If agent names are changed, you should ensure that all scripts that
reference the agent for work are updated to select the new agent
name where applicable.

The PWA software uses a memory swapping technique to minimize the
amount of memory required for it's TSR portion by swapping unneeded
code to EMS, XMS or disk. When PWA is loaded, it automatically
selects the best memory swapping technique to use.  However, the
default memory swapping method may be overridden by specifying /x
for XMS, /e for EMS or /d=filename for disk swapping.

page 13
The following command line options are available when loading the
PWA software:

PWA /s=SERVER NAME /a=AGENT NAME /d=path /x /e /p /u

/s=SERVER NAME       = Phantom Task Director Agent Name

/a=AGENT NAME        = Unique Name For This Agent

/p=POLLING           = How often PWA polls for work in seconds

/x                   = Use XMS for memory swapping

/e                   = Use EMS for memory swapping

/d=FILENAME          = Use DISK file for memory swapping

/u                   = Unload PWA From Memory

/list                = Display list of all known agents

=>Example:  PWA /S=FS1 /A=BARNEY /P=30 /E

Loads PWA servicing file server FS1 with an agent name BARNEY
requesting work about every 30 seconds. Uses EMS for the swap area.

Once PWA has been loaded, it sends an NCP request to the WSERVE.NLM
every polling seconds to determine if it has work to do.  If so the
WSERVE.NLM sends the work to the PWA which begins the process of
pushing the keystrokes into the keyboard buffer on the workstation.

PWA may be REMOVED from memory on the workstation by 

     Execute PWA with the /U command, 

This action will cancel out the agent with the WSERVE.NLM and
remove PWA from memory.
















page 14
CHAPTER 5                SUBMITTING JOBS FROM THE COMMAND LINE

The ONCONSLE program is used to send a command, or script fil to
the file server for  immediate execution by the PHANTOM.NLM.
ONCONSLE accepts the following command line parameters.

ONCONSLE (Command || @filename) [/S=Server] [/X=Screen Name] /Q
/F

     /S=  Server To Receive The Command(s)

     * Current File Server Is Used As Default If Omitted

     /X=  Server Screen To Receive The Command(s)

     * Defaults To System Console

     /P=  Phantom Of The Console Password

     /F   Submit The Job Even If No Job Servers Are Available

     /Q   Suppress Program Identification Banner

After ONCONSLE parses the command line, it formats a console job
for the PHANTOM.NLM to service. It then submits the job to the
Phantom queue, and waits for the job to be serviced and completed.
After the job is submitted by ONCONSLE and executed by the
PHANTOM.NLM, it is purged from the Phantom's queue.

ONCONSLE can be very useful for automating routine tasks for
non-technical operations personnel, by including scripts in DOS
batch files, and performing logic based upon it's return codes. 
The following is a list of DOS error levels that ONCONSLE  will
return:

  Error level        Name                         Description    

      (0)      JOB_COMPLETE   Command Executed Successfully
      (1)      SYNTAX         No Command Passed To ONCONSLE
      (2)      NO_SHELL       IPX and/or NETX/VLM is not loaded 
      (3)      NO_QUEUE       PHANTOM Queue Not Found
      (4)      NO_Q_STATUS    Unable To Get Queue Status    
      (5)      NO_Q_SERVER    PHANTOM NLM Not Loaded.  
      (6)      NO_JOB_LIST    Unable To Get PHANTOM Job List
      (8)      JOB_CREAT_FAIL Unable To Create Phantom Job
      (9)      JOB_START_FAIL Unable To Start Phantom Job

In addition to the standard error levels defined above, a script
executed by the PHANTOM.NLM can return any value to the calling
program (ONCONSLE.EXE), including an identifying message.

In the following example, the script determines that the

page 15
MONITOR.NLM is not loaded and it should be reported to the calling
program.

     if notloaded monitor then
     begin
          return 99 "ERROR: Monitor Not Loaded"
     end

ONCONSLE will receive the return code  99, display the message
"ERROR: Monitor Not Loaded", then return errorlevel 99 to DOS for
testing in a batch file.

For more examples on using return codes, please review the sample
script, RETTEST.PCF and  DOS bat file, RETTEST.BAT.







































page 16
CHAPTER 6                               PHANTOM MANAGEMENT CONSOLE


** Using The Phantom Management Console For Windows **


If you use Microsoft Windows, Phantom Of The Console provides an
MS-Windows based management console interface that can be used to
submit, report and modify jobs scheduled for execution. 

To use the windows interface, 

     Double click the Phantom ICON under the Circuit Masters      
     program group A screen, similar to the following will appear:

Phantom Of The Console v5.10 adds enhanced security features that
require login before any job scheduling may be performed. This
login dialog requires that the currently queue password be entered
before any operations may be performed from within the management
console. 

     Enter the password, then click Ok to login to the Phantom
     Management Console.

Take a moment to familiarize yourself the layout of the management
console. Most actions can be accessed via the button toolbar across
the upper portion of the screen. The lower toolbar displays the
current date and time, as well as the currently selected file
server.


** Managing Console Users **


One of the first tasks that should be performed is to specify which
users can submit jobs to the Phantom, or it's clients for service.
If an authorized user attempts to submit a job for service, an
error will be returned and the job will not be submitted.

By default, the user object SUPERVISOR and it's equivalencies are
setup as Phantom Console Users. To ADD or DELETE other users, 

Select Manage|Console Users from the menu, or click the users
button from the tool bar. 

A dialog box similar to the one below will be displayed:

This dialog displays a list of all NetWare Group or User objects
that are authorized to submit and modify Phantom jobs.  If a user
is having difficulty submitting a job for execution, you should
ensure that they have been added to the list of Phantom Console
Users.  Secondly ensure that the Phantom queue status allows users
to submit new jobs. 
page 17
See the section on phantom queue status to determine if users are
allowed to submit new jobs.

To ADD a  new user, 

     Click  Add  

A dialog similar to the one shown below will be displayed:

Using the left mouse button 

     Select the user in the list, then click Ok

After clicking Ok, a confirmation dialog similar to the one shown
below will be displayed:
 
To ADD this user as a Phantom Console user, 

     Click  Yes, otherwise click NO. 

If you elected to make the selected user a Phantom Console user,
the user will be added to the list of available console users. Now
that the user has been defined as a Phantom Console User they can:

     Create Jobs
     Modify Jobs
     Change the queue status
     Generate reports etc.

To DELETE an existing user. 

     Click the desired user in the users dialog box with the left 
     mouse button, then click delete 

A dialog similar to the one shown below will be displayed:

If you want to revoke the Phantom Console privileges for the
selected user 

     Click Yes, otherwise click No 

Once the user's Phantom Console privileges have been revoked, the
user name will be removed from the users dialog box.

When finished managing Phantom Console users,

     Click OK






page 18
** Scheduling A Script For Execution **


To CREATE a NEW job to be serviced by the Phantom, 

     Select File|New from the menu, or click the new icon from the 
     top toolbar

A dialog similar to the one below will be displayed:

This dialog contains all the fields necessary to create a job to be
executed by the Phantom Of The Console. Complete the following
fields:

Job Is Held - If this checkbox is checked, the job will not be
executed until the check is removed. 

Description - This is a text description of  the job you are
creating, for example if you are creating a job that will shutdown
the database NLM, the job description may be Shutdown database for
backup

Job Type - By default new jobs are defined as a daily job. A daily
job is one that is executed at the desired date and time, and then
repeated each day at the same time.

The other available job types are as follows:

Onetime - A one-time job is executed at the specified date and
time and then purged from the Phantom's job queue.

Weekly - the weekly job is executed at the specified date and time,
and then repeats execution on a weekly basis.

Monthly - A monthly job is executed at the specified date and time
and then repeats execution on a monthly basis.

Yearly - A yearly job is executed at the specified date and time
and then repeats execution on a yearly basis.

Hourly - An hourly job is executed at the specified date and time
and then repeats execution on a hourly basis.

ProActive - A ProActive job is run in response to an alert message
received by the PAD.NLM. 

Execution date - The date that the job should be executed.

Execution time - The time that the job should be executed.

If execution is missed,  reschedule job for next interval - Check
this box if you want the script to be rescheduled for the next
execution, if the target execution date and time was missed. If
page 19
this box is not checked, the PHANTOM.NLM, will run the job
immediately to "catch up" to the current time, otherwise the job is
simply rescheduled for the next execution interval.

Exclude Days From execution - For each day of the week that is
checked, the job will not be run on the selected day.
Job Script - The actual script commands to execute. For more
information on Phantom Script commands, please review the Phantom
Command Language section.

Script Assistant - By clicking the script assistant button, a-list
of all available Phantom script commands will be displayed, as
shown below:

To ADD a command to the script, 

     Select a command in the list and click Ok 

The command will be added to the script at the current cursor
location within the script.

Import Script - By clicking the import script button, the following
dialog will be displayed:

Use this dialog to import a script into the job script field. You
may find it more convenient to use your own text editor and then
import the script to the job script field. After a file has been
selected for import, the contents of the file will be inserted in
the job script field at the current cursor position.

Export Script - Allows you to save a copy of the script to a text
file, for backup purposes, or for submitting it via another Phantom
utility.

Editor - By clicking the editor button, Phantom will invoke the
text editor as defined in the PHANTOM.INI file. The default text
editor is notepad.exe, which is shipped with Microsoft Windows.

After all fields have been entered, 

     Click Ok to SAVE the job. 

The following dialog will be displayed:

To SAVE the job information to the queue so that it will be
executed at the specified date and time,

     Click Yes

If the No button is clicked, the job information will be discarded
and the changes will not be saved.


page 20
** Viewing The Scheduled List **


To VIEW a list of jobs that are scheduled for execution,

     Select File|Open, or click Open from the top toolbar,

A dialog similar to the one below will be displayed:

This dialog displays a list of all jobs that are scheduled for
execution by the PHANTOM.NLM. The following information is
displayed in the list; Job description, execution date, execution
time, job type, job status, and queue job number. 

By default this list is updated every 15 seconds, this value can be
adjusted by changing the update=nn parameter in the PHANTOM.INI
file, located in the SYS:\PHANTOM directory. The value of nn is
specified in seconds.

Displayed along the top of this dialog are eight buttons, they are
defined as follows:  

Add - Clicking this button will perform the same action as
selecting File|New  from the menu, allowing the creation of a new
job.

Modify - By clicking the modify button, the job currently selected
in the list will be displayed for modification. Use this button to
change a job's execution date/time, job type, script commands etc..

Delete - By clicking the delete button, the job currently selected
in the list will be removed from the queue. Before the deletion is
performed, confirmation will be required to delete the job.

Run - By clicking the run button, the job currently selected in the
list will be executed immediately by the PHANTOM.NLM. Before the
job is executed, confirmation will be required.

NetWare Console - Clicking the NetWare console button, executes
RCONSOLE.EXE, the Novell server's remote console program.

Copy Job - Clicking the copy job button, causes the management
console to copy the currently selected job to the specified file
server. Confirmation is required before the copy is performed. 

Help - Provides on-line help for using this dialog.

Ok - When finished modifying queue entries click the OK button to
close this dialog.




page 21
** Producing Reports **


To verify that a particular job executed, or to see a list of
scheduled jobs for a particular day or days, reports can be
produced that will list the details of each job. To PRODUCE a
REPORT, 

     Select the Report option from the menu bar

The following menu will be displayed.

The following reports may be produced:

Scheduled Job List - Lists all jobs that will be executed for a
given date range.

Completed Job List - Lists all jobs that were executed during a
given date range.

To SELECT a REPORT from the menu,

     Click the left mouse button. 

After the report type has been selected, the report may be further
enhanced by choosing a filter to filter out any unwanted
information on the report. 

The report filter dialog will be displayed as shown below:

The following fields are included on the report filter dialog:

Beginning Date - Used to specify the execution date of the first
job to include in the report. 

Ending Date - Used to specify the execution date of the last job
to include in the report.

Job Type - Used to specify a job type to include in the report,
or to include all job types.

When finished with the report filter, 

     Click OK to generate the report. 

While the report is generated, a status dialog will be displayed,
similar to the one shown below:

When the report is generated, it will be displayed in a browse
window similar to the one shown below:

Use the  scroll bars to scroll through the document. To PRINT the
report, 
page 22
     Select File|Print from the report browse menu bar, 

The report will be sent the printer.


** Managing Phantom's Queue Status **


From time to time it may be necessary to halt the execution of
jobs, or prevent clients from submitting jobs to the queue for
maintenance purposes etc. To HALT the execution of a job, 

     Click the Q Status icon, or select Manage|Queue Status from  
     the menu bar

A dialog similar to the one shown below will be displayed:

The following information is contained on the Queue Status dialog:

Jobs In Queue - Displays the total number of jobs currently in
Phantom's job queue.

Queue Servers Attached - Displays the number of queue servers
attached to Phantom's job queue. If the PHANTOM.NLM is presently
loaded on the file server, this number should be greater than 0,
if the PHANTOM.NLM is not loaded on the file server this number
should be 0.

Phantom Can Service Queue Jobs - If this box is checked, the
PHANTOM.NLM can service jobs currently waiting execution in the
queue. If this box is not checked, the PHANTOM.NLM will not be able
to service any queue jobs, therefore placing all jobs in the queue
on hold.

Users Can Add New Jobs To Phantom's Queue - If this box is checked,
new jobs can be created and added to Phantom's queue. If this box
is not checked, any job that is attempted to be added to the queue
will return an error.

When finished, 

     Click OK  to SAVE changes or 

CANCEL to ABORT changes.


** Changing Phantom's Queue Password **


Access to the management console, and for submitting jobs via
the ONCONSLE utility is restricted by a global password to the
Phantom job queue. The default password for the job queue is
PHANTOM. It is recommended that this password be changed after
page 23
the installation procedure, and then changed periodically to
prevent un-authorized access to the Phantom job queue.

To CHANGE the Phantom job queue PASSWORD 

     Select Manage|Change Job Queue Password, 

The following dialog will be displayed:

The following fields are displayed on the dialog;

Current Password - Enter the password currently used when logging
into the management console. For new installations the default is
PHANTOM.

New Password - Enter the new password to be used when logging into
the management console.

Re-Enter New Password  Enter the new password , exactly as entered
above to verify spelling.

To CHANGE the PASSWORD,

     Click OK 

To ABORT the change,

     Click Cancel

A confirmation will be displayed after the password has been
changed.


** Managing A Phantom Job Queue On A Remote File Server **


If Phantom Of The Console is installed on multiple servers in your
site, you can manage all of  the servers from a central location.
The currently managed file server is displayed in the bottom status
bar's right hand corner. To change the currently managed file
server 

     Select File|Change Console Server, or click the Server icon on
     the management console's toolbar. 

A list of all servers that you are currently attached to is
displayed:

To SELECT a SERVER from the list,

     Click the left mouse button, then click OK

After the new server has been selected, the newly managed server
page 24
name will be displayed in the status bar of the management console.

=> Note: If you are not attached to the server that you wish to
manage, use the NetWare windows tools to login to the desired
file server, before attempting to change the currently managed
server.















































page 25
CHAPTER 7                              PHANTOM COMMAND LANGUAGE


** Phantom Command Language Structure **


This section describes the workings of  the Phantom Command
Language flow control statements, such as if then else while repeat
continue break etc. Each of these statements are also  covered in
the Phantom Command Language reference.

If statements select from alternative courses of action by testing
certain values. If statements may be nested to any level. Care
should be taken to ensure that each if statement contains a begin
and end statement. The if statement has the following pattern:

     IF <conditional function>  THEN 
     BEGIN
          // statements to execute when true
     END
   <ELSE>
     BEGIN
          // statements to execute when false
     END

=> Example:   // This is a simple IF/THEN Construct

               IF LOADED MONITOR THEN
                         BEGIN
                    keyin "SEND Monitor NLM is Loaded<ENTER>"
             END
                     IF EXIST SYS:/SYSTEM/FILE1.DOC THEN
                  BEGIN
                     IF EXIST SYS:/SYSTEM/FILE2.DOC THEN
                       BEGIN
                           IF EXIST SYS:/SYSTEM/FILE3.DOC THEN
                             BEGIN
                                cp "All Files Have Arrived."
                              END
                        END
                      END

Iteration statements, let you loop a set of statements. There
are two forms of iteration in the Phantom Command Language, they
are while, and repeat.

While statements - The general format for a while statement is:

     while cond
          // commands to execute while true
     wend

The cond is tested first. If this value is true, the commands are
page 26
executed; if no jump statements that exit from the loop are
encountered, cond is evaluated again. This cycle repeats until cond
is false.

Repeat Statements - The general format for a repeat statement is:

     repeat nn
          // commands to executed
     next

An internal counter is initialized to a value of one. All
statements are executed up to the nearest next, at which time the
counter is incremented by one and the cycle repeats again, until
the counter is equal to the value of nn.

Jump Statements - A jump statement, when executed, transfers
control unconditionally. There are four such statements in the
Phantom Command Language: break,   continue, goto and return.

Break statements - A break statement can be used only inside an
integration (while, repeat loops). It terminates the iteration
statement. Because iteration statements can be mixed and nested to
any level, you must ensure that the break exits from the correct
loop. Three rule is that a break terminates the nearest enclosing
iteration statement.

Continue statements - A continue statement can be used only inside
an iteration statement; it transfers control to the test condition
for while loops and to the increment expression in a repeat loop.
With nested iteration loops, a continue statement is taken as
belonging to the nearest enclosing iteration.

Goto statements - The goto statement transfers control to the
statement labeled label, which must be in the same script.

Return statements - The execution of a script terminates if a
return statements is encountered; if no return is met, execution
continues, ending at the final line of the script.


** Phantom Command Language Reference **


This section lists all commands that are available in the Phantom
Command Language. Each command is listed with a definition, syntax,
example and availability that specifies which NLM supports the
command.

*  #  or // *

Function - Denote a comment in a script file.


page 27
Syntax         # Comment Text


Availability   PHANTOM.NLM, PXCONSLE.NLM     
Remarks   The pound sign or double slash can be used as a comment
marker, for commenting lines of  a script. For large or
complicated scripts it is a good idea to use comments, to easily
describe what the script's purpose is.

Example   # This is a comment line.

          // This is also a comment line.



*  $Debug  *

Function  Include or exclude debug information from a script.

Syntax         $debug [on|off]

Availability   PXCONSLE.NLM, PHANTOM.NLM

Remarks   The debug command, instructs the script interpreter to
include debug information for the script at run-time. This
command is used with the $Trace command to enable single step
debugging.

Example   $DEBUG ON



*  $Include  *

Function  Include a file at runtime.

Syntax         $include [file_name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   This directive allows commands to be located in a
separate script file a and called at runtime when the job is
executed. The script commands located in the file specified by
the include command are executed before the script command that
follows the $include directive. The file name specified by the
$include directive must include the fully qualified path of the
file. The current logged user, or script submitter must have
sufficient rights to access the file to be included.

Example   $include sys:\system\startup.pcf



page 28
*  $Step  *

Function  Start / Stop single step execution.

Syntax         $step [on | off]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The $step command instructs the phantom debugger to
begin single step operation within a script file. Single step
operation, executes the script one line at a time so that the
user can see the script lines execute in order, at their own
pace. In order for the $step command to be effective, the $debug
command must be used first, to ensure that the debug information
is included for the script file.

Example   $step on




*  (1)  *

Function  Always return true.

Syntax         (1)

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The (1) function always evaluates to TRUE and can be
used with the while loop to create an endless loop.

Example   while (1) then
          begin
               cp "looping"
          wend



*  Attach  *

Function  Attach to a remote NetWare server.  

Syntax         attach server/user

Availability   PXCONSLE.NLM

Remarks   attach accepts the user-name and server name of a remote
NetWare file server to attach to. If a password is required for
the user, PXCONSLE will respond with "Enter password" to obtain
the password. If the user/server information is not passed on
the command line, attach will prompt for all required
information.
page 29
Example      attach mkting/bdavis
              attach   
              Enter server name : mkting
              Enter user name : bdavis
              Enter password : Confidential




*  Break  *

Function  Exit the current iteration.

Syntax         break 

Availability   PHANTOM.NLM

Remarks   The break  command can be used only inside an iteration
(while, repeat, or goto loops. It terminates the iteration loop.
Because iteration loops can be intermixed and nested to any
depth, you must ensure that you break exits from the correct
loop. The rule is that a break terminates the nearest enclosing
iteration.

Example   while (1)
          break
          wend



*  Ccp  *

Function  Display text on current screen.

Syntax         ccp "message"

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The ccp command is used to display text on the currently
selected screen. To set the current screen, you must use the
setscreen command. This command  should be used with care, due
to the fact that it will write to any screen on the server, and
may cause confusion if written to a screen such as Monitor, or
other standard NLM utilities.

Example   ccp "This is a test message from my phantom script"



*  Clearnli  *

Function  Clear NOT-LOGGED-IN connections.

page 30
Syntax         clearnli

Availability   PHANTOM.NLM

Remarks   The clearnli command scans through the file server's
connection list looking for connections that are not logged in.
If a connection is found, it will release the connection for
other workstations to use. 

Example   clearnli
*  Clearusr  *

Function  Log the specified user, or object out of the file
server.

Syntax         clearusr [object name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Louser scans the file servers connection list to locate
the specified object. If the object is found in the connection
list, louser closes any open files, rolls back any pending
transactions, and clears the object's connection. If the user,
or object is logged in on multiple connections, all of the
objects connections will be logged out.

Example   clearusr guest



*  Close  *

Function  Close a log file

Syntax         close

Availability   PHANTOM.NLM

Remarks   Close, will close the currently active log file that was
assigned using the open command. Only one log file can be open
at a time. Log files are used to record information to regarding
file level actions such as a copy, move or purge operation.
Custom log messages can also be written to the log file using
the write command.

Example   open sys:/system/log.fil

          write "hello world"

          close



page 31
*  Cmddelay  *

Function  Set delay between commands

Syntax         cmddelay [milliseconds]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   This command specifies the amount of time to wait before
processing the next line of the script. This command has a
direct effect on the file server's CPU utilization when a script
is executed. The default setting for cmddelay is 1000 ms, which
has been specifically fine tuned to provide fast script
execution without over burdening the CPU. This command is
relative to each script execution and is always defaulted to
1000ms. If you require that a script execute faster, then lower
the cmddelay time. 

Example   cmddelay 500



*  Connections  *

Function  Return the number of active connections.

Syntax         connections

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The connections function returns the number of active
connections on the file server for the purpose of evaluation, in
IF statements or WHILE iteration loops. 

Example   while connections < 10 then
          begin

               ..

          wend





*  CONSOLE or !  *

Function  Execute a NetWare console command.

Syntax         console [command string]

Availability   PXCONSLE.NLM

page 32
Remarks   The Console command is used to send a specific command
string to the server's system console screen from within the
extended console environment. This command can be used without
performing a setscreen, and will not effect the current screen
context.

Example   console load phantom
          ! Load Phantom




*  Continue  *

Function  Transfer control to the test condition

Syntax         continue

Availability   PHANTOM.NLM

Remarks   A continue command can be used only inside an iteration
loop; it transfers control to the test condition for while and
repeat loops. With nested iteration loops, a continue command is
taken as belonging to the nearest enclosing iteration.

Example   repeat 10

               if connections < 10 then
                begin
                    continue
                end
               cp "connections have peeked"
          next



*  Copy  *

Function  Copies one or more files to the specified location.

Syntax         copy source [ [+ source] [ +...]] [destination]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Use the copy command to copy files from a source
location to a destination.  The copy command accepts  wild card
specifiers.  The source and target specification can contain a 
partial or fully  qualified path including server volume and
directory path. You may also use the copy command to combine one
or more files. Note The copy command available via the
PHANTOM.NLM does not have access to remote servers, i.e. you
cannot copy between servers. 

page 33
Examples  To copy  the file named AUTOEXEC.NCF from the current
directory to an existing directory named BACKUP located on
volume SYS1, type the following command:

               copy AUTOEXEC.NCF  sys1:\backup\

          To copy several files into one file, list any number of
files as source parameters on the COPY command line. Separate
filenames with a plus sign (+) and a space,. Specify a filename for
the resulting combined file, as the following example shows:

               copy svr1.log + svr2.log + svr3.log allsvrs.log

You can also combine several files into one by using wild cards, as
the following example shows:

               copy *.log large.log

     To copy files to a remote server, specify the server name as
part of the destination path, as the following example shows:

               copy *.log remote/sys:\backup

*  CP  *

Function  Display A Message On The System Console.

Syntax         cp "text string"

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Use the cp "Console Print" command to send text messages
to the system console for monitoring the progress of script
execution, or displaying information required for console
operators. The CP command accepts a text string up to 250
characters in length to be sent to the console, followed by a
CR\LF.

Example   cp "Hello World"



*  Date  *

Function  Display the current date.

Syntax         date

Availability   PXCONSLE.NLM

Remarks   Use the date command to determine what the file server's
current date and time are.

page 34
Example   date 

          Thursday April 15, 1993  10:31:34



*  Del  *

Function  Delete File(s).  

Syntax         del [file_spec] /c

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The del command will erase files specified by file_spec
from the file server's disk.. File_spec may be any specified
directory path, or file name that is accessible to the currently
logged in user. When deleting all files in a directory the del
command will require confirmation. If the /C parameter is passed
on the command line,  when deleting all files, i.e. *.* ,
confirmation will not be required.

Example         del *.*
              del *.* /c
              del server-1/vol1:\data\*.bak
              del sys:/data/file.one



*  Delay  *

Function  Delay script execution.

Syntax         delay [seconds]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Delay will temporarily pause the execution of commands
until the specified number of seconds has expired.  

Example   delay 10



*  Detach  *

Function  Logout from a previously attached remote server.  

Syntax         detach [server name]
Availability   PXCONSLE.NLM

Remarks   Detach will logout from the specified remote file server
and maintain all other server connections.  If you detach from
page 35
the local file server,  it will be considered a logout. When the
PXCONSLE.NLM is unloaded, all server connections, both local and
remote are automatically terminated for you.

Example   detach server-2





*  Dir  *

Function  Directory Listing.  

Syntax         dir [file_path] /p /w
Availability   PXCONSLE.NLM

Remarks   DIR will display directory information for the specified
file path on the PXCONSLE screen.  Information displayed on
screen is filename, extension,  and the last updated date and
time.  After all files have been listed, the total number of
files is displayed, with a total byte count. If the /p switch is
included on the command line, DIR will display one page of files
at a time. If the /w switch is included on the command line, DIR
will display only file names in wide column format. The
file_spec parameter may be any fully qualified file name,
including server, volume path,  file name and extension, or a
partial file name including wild card characters. The dir
command can only access directories in which the currently
logged in user has read and file scan rights. Attempt to access
any other directory will return a message indicating that the
directory does not exist.

Example         dir *.bat
              dir vol1:/data/*.dat
              dir server-2/sys:/system/*.* /p /w



*  Dow - Notdow  *

Function  Compare day name to current day.

Syntax         dow [day name] or notdow [day name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The dow function returns  TRUE or FALSE based on the
comparison of the current day of the week, to the supplied day
name. If the current day  as determined by the file server's
clock is the same as the day name parameter, TRUE is returned,
otherwise FALSE is returned. Conversely if  the notdow function
is used,  and the current day is the same as the day name, FALSE
page 36
is returned. Day names are the actual text  name of the day.

i.e. Sunday-Saturday. The day name parameter is not case
sensitive. This function is used for comparison in IF
statements, or a WHILE iteration loop.

Example   if dow Sunday then

          begin
               cp "today is Sunday"
          end

          if notdow sunday then
          begin
               cp "today is NOT sunday"
          end




*  Dspace  *

Function  Display Disk Space Information.  

Syntax         dspace

Availability   PXCONSLE.NLM

Remarks   The DSPACE command will  display  volume/directory
information about the current  volume.  The following
information is returned; Logical Drive #

Sectors Per Block, Block Size, Total Disk Space (MB), Available
Disk  Space (MB), Total Directory slots, Available Directory
Slots, Maximum Directory Slots.

Example   dspace



*  Edit  *

Function  Edit a file. 

Syntax         edit [file_path]

Availability   PXCONSLE.NLM

Remarks   The edit command calls the NetWare EDIT.NLM with the
specified file name to edit. Upon issuing this command , no
other commands can be entered on the extended console screen,
until the EDIT.NLM has been exited.

page 37
Example   edit sys:/system/autoexec.ncf



*  Echo  *

Function  Enable/disable the display of script commands.

Syntax         echo on|off

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Use the ECHO command to turn the display of script
commands executed ,on or off. By default, echo is on for the
PXCONSLE.NLM and off for the PHANTOM.NLM. 

Example        echo on
               echo off



*  Exist - Not Exist  *

Function  Determine if a file exists.

Syntax         exist [file spec] or notexist [file spec]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The exist function determines if the given file name
exists on the NetWare volume. If the file exists, TRUE is
returned. If the file does not exist FALSE is returned. However,
if the "not" form of the function is used, i.e. notexist, TRUE
is returned if the file does not exist and FALSE is returned if
the file does exist.

Example   if exist sys:\system\autoexec.ncf 
          if notexists sys:\system\autoexec.ncf



*  Flag  *

Function  Set or remove file attributes

Syntax         FLAG [path  [+|-] attribute(s)]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The flag command set or removes file attributes from
files located on a NetWare partition. In order for the flag
command to be effective, the current logged user, or job
submitter must have the appropriate trustee rights to change the
page 38
specified file. The path parameter may be any fully qualified or
partial path, including server, volume, directory and file
names. Wild card identifiers may also be used.

Example   FLAG *.exe +s +r +o
          FLAG sys1:/user/bob/*.* +s +r +o




*  Goto  *

Function  Jump to a specified execution label in a script.

Syntax         goto [labelname]:

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Label names are limited to 25 characters including the
colon.

Before each goto call there is an implied delay which will allow
other process on the file server to run. This is done so that
the script file execution does not HOG the file server's CPU. 
Use the goto command to perform a simple looping type construct
within a script file, such as waiting for a file to be uploaded
or a user to login.

Example    Wait for a file to be uploaded, then import using
sql*loader.

          setscreen system console
          // Create a label named restart
          restart: 
          // Check the existence of the incoming file
          if exist sys:/oracle6/dbs/import.dat then
          begin
               // file is here, now run sqlloader
               load sqlload [parameters]
               // set the screen context to the sql loader
               setscreen oracle sql*loader
               // press the enter key to close the screen
               <ENTER>
               // set our screen context back to the system console
               setscreen system console
               // wait for sqlloader to finish it's job.
               waitfor sqlload
          end   
          // wait one minute
          delay 60
          // check for the file again.
          goto restart

page 39
*  Gotoxy  *

Function  Move the output cursor to coordinate x,y

Syntax         gotoxy [col] [row]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The gotoxy command is used for setting the position of
the output cursor. The output cursor will be moved to the x and
y coordinates given on the command line. The next time output is
performed to the screen, the output will begin from coordinates
x and y. This command effects the screen pointed to by the
current screen context. 

Example   gotoxy 10 10

          cp "Hello World"



*  Help  *

Function  Display the help screen, for PXCONSLE.  
Syntax         help

Availability   PXCONSLE.NLM

Remarks   Use the HELP command when you are unsure about the use
of an extended console command. Help will display all available
command names, and syntax with a brief description of it's
function.

Example   help



*  Jlist  *

Function  Display a list of scheduled jobs.

Syntax         jlist

Availability   PXCONSLE.NLM

Remarks   Jlist, displays a list of all jobs, currently scheduled
for execution by the PHANTOM.NLM. The following information is
displayed in the job listing. The job description, execution
date, execution time, job type, and the queue sequence number.

Example   jlist      


page 40
*  Keydelay  *

Function  Specify the delay between keystrokes

Syntax         keydelay [milliseconds]


Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The keydelay command specifies the amount of time that
the keyin command should wait before pushing the next key onto
the keyboard. The keydelay value is defaulted to 10 ms which has
been fine tuned for smooth script execution and performance.

Example   keydelay 20



*  Keyin  *

Function  Stuff  keys into keyboard buffer.

Syntax         keyin "key strokes"

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The keyin command is used to play keystrokes to the
current screen context. Current screen context is determined by
issuing the setscreen command. By default all scripts begin with
a current screen context set to the System Console. The keyin
command can push any keys on the keyboard to simulate the
presence of an operator typing on the keyboard. To have keyin
simulate keys such as any of the function keys or special keys,
enclose the function key with <> characters. In previous
versions of the Phantom, all text in a script file that was not
a reserved command, or comment was interpreted as keystrokes to
be sent to the server screen. This has been changed to
facilitate the expansion of the script language. Keyin will play
the keystrokes to the current screen context without pressing
the ENTER key afterwards. If an enter key, or other special key
is required, use the keyboard macro for the desired key.

Example   keyin "load monitor <ENTER>"
          keyin "<F1>"



*  Kill  *

Function  Clear a specified connection number.

Syntax         kill [connection number]

page 41
Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The kill command is used to clear a specified connection
number on the file server. If an object is currently logged in
on the connection, all files will be closed and any pending
transactions will be rolled back, to prevent data corruption. 


Example   kill 10

          kill 23 




*  Loaded - NotLoaded  *

Function  Determine if a given module is loaded.

Syntax         loaded [module name] or notloaded [module name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The loaded function will return TRUE if the given module
name is loaded, or FALSE if the module is not loaded. If the
"not" form of  the function is used, TRUE is returned if the
module is not loaded, or FALSE is returned if the module is
loaded.
Example   if loaded MONITOR.NLM then
               begin
                    cp "monitor is loaded"
               end
               if notloaded MONITOR.NLM then
               begin
                    cp "monitor is NOT loaded"
               end



*  Loggedin - NotLoggedIn  *

Function  Determine if a given user is logged in.

Syntax         loggedin [object name] or notloggedin [object name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks  The loggedin function checks to see if the given object
is logged in to the file server. If the object is logged in,
TRUE is returned, otherwise FALSE is returned. If the "not" form
of the function is used, TRUE is returned if the object is not
logged in and FALSE is returned if the object is logged in. The
object name parameter may be any valid NetWare object name, or
page 42
one of the following. 

     ANY_USERS - Return true if any users are logged in.

     NO_USERS    - Return true if there are no users logged in.

Example   if loggedin guest then
               begin
                    keyin "send please logout to guest"
                    cp "guest is logged in, message sent"
               end

               if notloggedin ANY_USERS then
               begin

                    cp "No users logged in, begin backup"
                    keyin "load sbackup <ENTER>"
                    waitfor sbackup
                    setscreen sbackup screen
                    keyin "supervisor <ENTER>"
               end



*  Login  *

Function  Login to a file server.  

Syntax         login server/user.

Availability   PXCONSLE.NLM.

Remarks   The LOGIN command is used to login to a local or remote
file server on the LAN. Login will first logout of any currently
logged servers and then attempt to login to the specified file
server. If  a server name is not given on the command line, it
is assumed that the specified user wants to login to the current
file server. If any information required is not passed on the
command line, login will prompt for the needed information i.e.,
user id or password.

Example   login

          login server-1/guest




*  LoginDisabled  *

Function  Determine if login is disabled

Syntax         logindisabled
page 43
Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Logindisabled returns TRUE if the file server's login
status has been disabled, i.e. no users can login to the file
server. 

Example   while logindisabled 
          begin
               cp "login is disabled"
          wend



*  LoginEnabled  *

Function  Determine if login is enabled

Syntax         loginenabled

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Loginenabled returns TRUE if the file server's login
status is enabled, i.e. users can login to the file server. 

Example   while loginenabled
          begin
               cp "login is enabled"
          wend
*  Logout  *

Function  Logout from all servers.  

Syntax         logout

Availability   PXCONSLE.NLM

Remarks   The logout command will logout all objects from all
connections on all local and remote file servers. All open files
are closed, any pending transactions are rolled back, and all
connections are released.

Example   logout



*  Logroup  *

Function  Logout all members of a group from the file server.

Syntax         logroup [group name]

Availability   PHANTOM.NLM, PXCONSLE.NLM
Remarks   This command first scans the list of connections on the
page 44
file server, then check's each object logged in to see if it is
a member of the specified group. If the object is a member of
the group, the object is logged out from the file server,
closing any open files and rolling back any pending transactions.

Example   LOGROUP FINANCE


*  Louser  *

Function  Log the specified user, or object out of the file
server.

Syntax         louser [object name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Louser scans the file servers connection list to locate
the specified 

object. If the object is found in the connection list, louser
closes any open files, rolls back any pending transactions, and
clears the object's connection. If the user, or object is logged
in on multiple connections, all of the objects connections will
be logged out.

Example   louser guest




*  Md  *

Function  Make a directory.

Syntax         md [volume:] path

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The MD command is used for creating a new directory. In
order to create a new directory, the current logged in user, or
the job submitter must have sufficient rights to the volume or
directory in which the new directory will be created.

Example         md test



*  Mounted - NotMounted  *

Function  Determine if a given volume is mounted

Syntax         mounted [volume] or notmounted [volume]
page 45
Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The mounted function returns TRUE if the specified
volume is mounted or FALSE if the volume is not mounted. If the
"not" form of the function is used, TRUE is returned if the
volume is not mounted or FALSE is returned if the volume is
mounted.


Example   if mounted vol1 then
          begin
               cp "vol1 is mounted"
          end
          if notmounted vol1 then
          begin
               cp "vol1 is not mounted"
          end



*  Move  *

Function  Move File(s) From Source To Destination.

Syntax         move [source] [dest]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The move command  copies the source file specification
to the dest file specification. If all files were copied
successfully, the source file specification is deleted. Although
the files are deleted they are not purged from the NetWare
volume. The current logged in user, or job submitter must have
sufficient rights to the source and destination directories for
the move command to work successfully. The source and dest
parameters may contain a fully qualified path, wild card
characters, or a relative path.

Example   move *.* sys:/test/

          move server-1:data/*.dat server-2/sys:/data/



*  Onscreen - NotOnscreen  *

Function  Determine if specified text is on a screen.

Syntax         onscreen ["text"] or notonscreen ["text"]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The onscreen function returns TRUE if the specified text
page 46
is displayed on the current screen context, or FALSE if it is
not. If the "not" form of
 the function is used, TRUE is returned if the text does not
appear on the screen, or FALSE is returned if the text is
displayed on the screen.

Example   if onscreen "hello world" then ...

          if notonscreen "hello world" then ...



*  Open  *

Function  Open a log file.

Syntax         open filepath

Availability   PHANTOM.NLM

Remarks   Open, creates the specified log file for the purpose of
recording activity that takes place during a file level
operation such as copy, move, purge etc., or user defined
messages written using the Write command. Open, overwrites any
existing log file without warning. When the log file is created,
a header similar to the one below is written to the log file.

Log file created Friday Dec 12, 1994 8:12:34 pm

Phantom Job - Move database files.

Example   open sys:\phantom\thisjob.log




*  Pause  *

Function  Pause Script File Execution

Syntax         pause "message"

Availability   PXCONSLE.NLM

Remarks   Use the PAUSE command to pause the execution of a script
file that is executed by the PXCONSLE.NLM.  Pause, displays the
message on the screen at the current x, y location, and waits
for a key to be pressed. After the key is pressed, script file
execution continues.

Example   pause "Hit Any Key"


page 47
*  Picture  *

Function  Record a server screen

Syntax         picture [file name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Picture will record the contents of the current screen
to the specified file name. The current screen is set by issuing
a setscreen command. Picture will not overwrite an existing
file, but append the new output to the end.

Example   setscreen system console
          picture sys:\system\console.log



*  Print  *

Function  Print a file to a NetWare queue.

Syntax         print [filename] [queue name]

Availability   PXCONSLE.NLM

Remarks   The print command will print the specified file to the
named print queue. The current logged in user must be a QUEUE
USER of the specified print queue, for the print to be
successful.

Example   print sys:/system/autoexec.ncf  hp_laserjet



*  Purge  *

Function  Purge deleted files from a NetWare volume.

Syntax         purge [file spec]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Purge scans the specified file path for matching deleted
files. If deleted files are found they are purged from the
volume. Once a file has been purged is no longer available for
recovery using the salvage utility. Purge can remove specified
files, or a group of matching files using wild card matching
characters. The current logged in user or job submitter must
have sufficient rights to the directory in which a purge is
performed.


page 48
Example   purge *.*
          purge sys:/data/*.dat     
          purge server-1/sys:/data/*.dat



*  Rd  *

Function  Remove a directory

Syntax         rd [directory name]

Availability   PHANTOM.NLM, PXCONSLE.NLM


Remarks   The RD command can be used to remove a directory from
the file server's drive.  The directory that is being removed
must be empty. The current logged in user, or job submitter must
have sufficient rights to the directory for it to be removed.

Example   rd test

          rd vol1:/test/data

          rd server-2/vol1:/database



*  Ready - NotReady  *

Function  Determine if a given device is ready

Syntax         ready [device name] or notready [device name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The ready command returns TRUE if the specified device
is ready to accept jobs, or FALSE if it is not. If the "not" form
of the command is used, TRUE is returned if the device is not ready
to accept jobs, and FALSE is returned if the device is ready to
accept jobs.

Example   if ready bobs-ws then ...
          if notready server-2.phantom then ....



*  Ren  *

Function  Rename File(s). 

Syntax         ren [old file] [new file]

page 49
Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The REN command is used to rename a given file or group
of files from an existing name, to a new name. File names may
contain wild card characters to match a group of files for
rename. The current logged in user or job submitter, must have
sufficient rights to the specified files for rename to be
successful.

Example   ren test.dat test.old
          ren test.* *.new
          ren sys:system/test.nlm test.old




*  Repeat  *

Function  Repeat commands "count" times

Syntax         repeat [count] .. next

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Repeat will execute the enclosed block of script
commands, a specified number of times. Similar to a while loop,
but uses an internal counter to determine when it should finish
looping. A repeat loop can be exited prematurely by using the
break, or return command.

Example   repeat 10

               cp "I am looping"

          next



*  Return  *

Function  Return an status and message to script caller.

Syntax         return [status] "message"

Availability   PHANTOM.NLM

Remarks   Return will return the specified status number and
message to a console that submitted a script via the ONCONSLE
utility. ONCONSLE will display the message on the screen, and
return status as a DOS ERRORLEVEL for use in batch files. Using
the return command, more intelligent scripts can be designed for
notifying operations personnel about the status of the job that
they are running.
page 50
Example   return 10 "Monitor NLM Is Not Loaded !"




*  Send2grp  *

Function  Send a broadcast message to a group

Syntax         send2grp [group name] ["message"]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The send2grp command scans the file server's connection
list to determine which currently logged in users are a member
of the specified group. As group members are found, the
specified message is sent to them, via the NetWare broadcast
message facility.

Example   send2grp everyone "Logout Immediately"




*  Setdevice  *

Function  Select a remote device for execution.

Syntax         setdevice [device name]

Availability   PHANTOM.NLM

Remarks   The setdevice command is used to redirect script
execution to a workstation running the Phantom Workstation
Control software, or to a remote server, running the
PHANTOM.NLM. Once a setdevice command has been issued, all
commands from that point will be sent to the selected device
until the next set device command has been issued. To return to
the local server, after a previous call to setdevice, use the
device name "Server". This device is always available and
references the local server. The WSERVE.NLM must be loaded for
workstations running the Phantom Workstation Control Software.
Workstations that run the control software, currently only
interpret keystrokes, and do not have and special logic or
functions available to them. Upon the issuance of the next
setdevice command, the script will wait until the device
acknowledges that it has performed the commands as requested. To
access the PHANTOM.NLM on a remote server, use the device name
SERVER.PHANTOM. Using this device name will cause all subsequent
script commands to be executed by the PHANTOM.NLM located on the
named file server.


page 51
Example   // go to john's machine and kick off the backup
          setdevice johns-ws
          f:
          login server-1/nightly
          backup
          logout
          // now hop over to server-2 and load the monitor nlm
          setdevice server-2.phantom
          load monitor
          // now jump back to our original home server.
          setdevice server





*  Setscreen  *

Function  Set current screen context

Syntax         setscreen [screen name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The setscreen command, selects the specified screen on
which operations will be performed, i.e.. the keyin command
sends keystrokes to the current screen context, which is set by
issuing the setscreen command. All onscreen command operations
also require that screen context be set properly as well. When a
script is executed, it has a default screen context of System
Console. The screen name parameter is the title of the screen.
To determine a screen name, go to the file server console and
use the ALT-TAB keys to switch between screens. When the desired
screen is displayed, press and hold down the ALT key. The title
bar shown at the top of the screen contains the screen name. Use
the name shown in the title bar, exactly as it is displayed for
the screen name parameter. The screen name parameter is not case
sensitive.

Example   // set the screen to the NetWare console
          SETSCREEN SYSTEM CONSOLE
          // execute the statement on the NetWare console
          keyin "disable login"



*  Showscreen  *

Function  Display a screen

Syntax         showscreen [screen name]

Availability   PHANTOM.NLM, PXCONSLE.NLM
page 52
Remarks   The showscreen command is used to display the specified
screen on the file server's monitor. Since a NetWare server can
have many different screens, only one can be displayed at a
time. This command simulates the key sequence of ALT-TABing to
the specified screen. After the screen is displayed, it is made
the current screen context.

Example   showscreen monitor screen



*  Slist  *

Function  Display a server list

Syntax         slist [match pattern]

Availability   PXCONSLE.NLM

Remarks   Use the SLIST command to display a list of all known
NetWare file servers . If no match pattern is given, slist will
display all known file servers. A match pattern is any sequence
of characters, including wild card characters. 

Example   slist

          slist fs*

          slist cms??



*  Time  *

Function  Display the current time

Syntax         time

Availability   PXCONSLE.NLM

Remarks   The time command, displays the file server's current
date and time on the extended console screen.

Example   time
          Thursday April 15, 1993  10:31:34
*  Type  *

Function  Display file contents

Syntax         type [file name]

Availability   PXCONSLE.NLM

page 53
Remarks   The TYPE command is used to display the contents of the
specified file on the extended console screen. The current
logged in user must have sufficient rights to view the specified
file. The file name can include a full path specification
including server , volume and directory path. No pagination is
performed on the file output.

Example   type read.me
          type sys1:/data/read.me
          type server-2/sys:/data/read.me



*  Userlist  *

Function  List logged in users.

Syntax         userlist

Availability   PXCONSLE.NLM

Remarks   Userlist displays a list of objects that are currently
logged in to the local file server. The following information is
returned by userlist. Connection number, user name, network
number, node address, and login time.

Example   userlist



*  Ver  *

Function  Display version information

Syntax         ver

Availability   PXCONSLE.NLM

Remarks   The ver command, displays the PXCONSLE NLM's current
version and copyright information.

Example   ver




*  Waitdismount  *

Function  Wait for volume to dismount

Syntax         waitdismount [volume name]

Availability   PHANTOM.NLM, PXCONSLE.NLM
page 54
Remarks   Waitdismount scans the volume table for the specified
volume name and determines if it is mounted. If the volume is
mounted, it will wait until it has been dismounted. There is no
time limit on the amount of time that the waitdismount command
will wait for the volume to dismount. The script does not
continue execution until the volume has been dismounted.

Example   waitdismount vol1



*  Waitfor  *

Function  Wait for module to unload

Syntax         waitfor [module name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The watifor command scans the NLM loaded list to
determine if the specified NLM is loaded. If the module is
loaded, the script does not continue execution until the module
has been unloaded. The module name parameter is the file name of
the NLM. If no extension is given, waitfor assumes the default
NLM extension of .NLM. Other NLM extensions may be DSK, LAN, HAM
etc.

Example   waitfor monitor.nlm





*  Waitforscr  *

Function  Wait for screen to be destroyed

Syntax         waitforscr [screen name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Waitforscr scans the active screen list to determine if
the specified screen is available. The script execution is
paused until the screen is destroyed. There is no limit on the
amount of time that may pass before the screen is destroyed. The
screen name parameter is the title of the screen, as displayed
on the file server console. For more information on determining
the screen name, see the setscreen command.

Example   waitforscr monitor screen



page 55
*  Waitmount  *

Function  Wait for a volume to mount

Syntax         waitfor [volume name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Waitmount scans the volume table to determine if the
specified volume is mounted. If the volume is not mounted,
waitmount pauses script execution until the volume is mounted.
Waitmount will wait up to five minutes for the volume to mount.

Example   waitmount vol1



*  Waitoffscr  *

Function  Wait for text to be removed from screen

Syntax         waitoffscr ["text string"]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The waitoffscr command scans the current screen context
for the specified text string. If the text string is found on
the screen, script execution is paused until the string is
removed from the screen, or the screen is closed. For more
information on how to set the current screen context, see the
setscreen command. There is no limit on the amount of time that
waitoffscr will wait for the string to be removed.

Example   waitoffscr "Hello World"



*  Waitonscr  *

Function  Wait for text to be appear on screen

Syntax         waitonscr ["text string"]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The waitonscr command scans the current screen context
for the specified text string. If the text string is not found
on the screen, script execution is paused until the string is
displayed on the screen, or the screen is closed. For more
information on how to set the current screen context, see the
setscreen command. There is no limit on the amount of time that
waitoffscr will wait for the string to be displayed.

page 56
Example   waitonscr "Hello World"



*  Waittil  *

Function  Wait for module to load
Syntax         waittil [module name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The waittil command scans the NLM loaded list to
determine if the 

specified NLM is loaded. If the module is not loaded, waittil
pauses script execution until the module has been loaded. The
module name parameter is the file name of the NLM. If no
extension is given, waitfor assumes the default NLM extension of
.NLM. Other NLM extensions may be DSK, LAN, HAM etc. There is no
limit to the amount of time that waittil will wait for the
module to load

Example   waittil monitor.nlm



*  Waittilscr  *

Function  Wait for screen to be created.

Syntax         waittilscr [screen name]

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   Waittilscr scans the active screen list to determine if
the specified screen is available. The script execution is
paused until the screen becomes available. Waittilscr will wait
up to five minutes for the screen to be created. The screen name
parameter is the title of the screen, as displayed on the file
server console. For more information on determining the screen
name, see the setscreen command.

Example   waittilscr monitor screen





*  Walktree  *

Function  Scan directory tree executing command

Syntax         walktree [command] [parameters]
page 57
Availability   PXCONSLE.NLM

Remarks   The walktree command begins exection of [command] from
the current working directory. For each directory below the
current directory, the command is executed with the specified
parameters. The following commands are supported by the walktree
command, DIR, DEL, REN, PURGE. The current logged in user must
have sufficient rights to the directory structure in which the
walktree command will be used. 
Example   walktree purge *.*

          walktree del *.bak



*  While  *

Function  Perform iteration loop.

Syntax         while (cond-exp) st.. wend

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The loop statements are executed continuously until the
conditional expression compares equal to zero (false). The
cond-exp is evaluated and tested first. If the return value is
not zero (true),  st.. is executed; if no break statements that
exit from the loop are encountered, cond-exp is evaluated again.
This cycle repeats until cond-exp is zero (False).

Example   while connections < 10 then

          begin
               cp "connections ok"
          wend



*  Whoami  *

Function  Display current login information

Syntax         whoami

Availability   PXCONSLE.NLM

Remarks   The whoami command displays information about all
connections the current logged in user has with all file
servers. The following information is returned by the whoami
command. Object name, file server connected to, connection number
and login date, time.

Example   whoami
page 58
*  Write  *

Function  Write message to a log file.

Syntax         write ["message"]

Availability   PHANTOM.NLM, PXCONSLE.NLM
Remarks   The write command writes the specified message to the
current log file. Log files are created using the Open command. 

Example   write " script execution is beginning"



*  Xcopy  *

Function  Copy specified files and sub-directories

Syntax         xcopy [source] [destination] /a

Availability   PHANTOM.NLM, PXCONSLE.NLM

Remarks   The xcopy command copies directories, their
sub-directories and files to the specified destination. The
current logged in user or job submitter must have sufficient
rights to both source and destination directories for the copy
to be successful. The source specification may be and NetWare
path, or DOS partition path on the file server. Destination must
be a NetWare path. The source and destination specification may
contain partial or fully qualified paths, including wild card
characters. If the /a parameter is included on the command line,
xcopy will maintain the file attributes from source to
destination when copying. 

Example   xcopy sys: *.* sys1:
          xcopy sys: *.dat sys1:  /a
          xcopy c:\*.* sys:\cdrive\*.*
















page 59
CHAPTER 8                                           MISCELLANEOUS


** Customer Support **


Server Sentry is backed by a customer support system designed to
offer you prompt and courteous service. If you have exhausted
all other HELP avenues and need a friendly voice to help you
with your problem, follow these steps:

Try to duplicate the problem, keystroke by keystroke, to see
exactly what was done. Document each move.

Be at your computer when you call Customer Support. Have your
manual and license number handy.

If possible, fax us any details or pertinent information ahead
of time which you feel may help us understand and resolve your
problem.

Call Circuit Masters Software, Inc. on our direct technical
support line at  (409) 335-6126.

Circuit Masters Software, Inc. offers a 24 hour BBS.  This
service contains fully functional demo packages, update
documentation, product literature, etc..  Our BBS number is
409-335-4786.


** Product Updates **


If any changes have been incorporated into the software that are
presently not reflected in the manual/documentation, a READ.ME
file will be located on the original Server Sentry Installation
Diskette and in the directory specified during the installation
process.

If applicable, you will have the opportunity to view this file
upon the initial installation. The READ ME file will also be
copied into the Server Sentry directory.

     Print this file and attach it to your User's Manual.

To receive notices concerning product updates and new product
releases,  please fill out and mail back the User Registration
Card.  Mailing back this Card is the only method which will
ensure that you are added to our mailing list.




page 60
** Our Products Include **

     Phantom of The Console Order #PC5000.  The Original Console
Scheduler.  This powerful scheduler NLM automatically monitors
and executes any valid NetWare command, NCF file or Phantom
Command File.  Simple scripting language adds workstation
capabilities to the server using If...Then, while & repeat
loops, macros and user defined variables.  Utilize commands in
scripts like: attach, break, console, copy, date delete, delay,
dir dspace, edit, echo, goto, help, killuser, login, walktree,
xcopy (supports the DOS partition) and many more.  Use a Phantom
Command file to automate most any situation.

Includes DOS & Windows Interface.  Access job lists, server
console or execute a job to run immediately.  Fully automate
back-up procedures (including back-up of the DOS partition) by
automatically starting & stopping NLM's.  Send keystrokes
directly to NLM screens, automating SBACKUP and other menu
driven NLM's.  Run multiple processes simultaneously.  Increased
security includes password protection, encrypted batch files and
control of volumes when not in use. Reporting utility documents
date, time, description of the job, commands executed and job
results.  Automatically logoff users.  Perform automatic file
transfers routinely or based on pre-defined criteria.  Move
print jobs between queues.  Send broadcast messages and much
more.

     Phantom of The Console GOLD Order # PG5000.  Includes all of
the features of the Basic package and much more.  Avoid
potentially catastrophic network scenarios by automatically
responding to NetWare O/S alerts, database messages & other
network monitoring packages.  Avoid down time or loss of data on
the network.  Automatically resolve network problems as they
occur using pre-defined solutions.  The Gold offers file
operations such as copy, move, delete, rename, flag, etc.  on
remote servers, as well as local servers. 

Harness the power of idle workstations.  Execute jobs requiring
DOS platforms like: database consolidation, produce reports, run
client based applications, manipulate large database files,
etc.. Distribute an unlimited number of interactive tasks from a
server to client workstations and control these tasks from the
server.  Schedule jobs on the workstation and the server. 
Includes 5 client agents.

     Phantom of The Console PLATINUM Order # PP5000.  The ultimate
network automation solution, including all of the features of
the Gold and more.  Includes 2 Server Sentry NLM's, 2 Volume
Sentry NLM's, 2 CORA NLM's, 2 server agents with all of the
features of the Gold, and 20 client agents.

     Upgrade Express Order #UE4000. The right stuff in "Electronic
Software Distribution" on both the LAN and the WAN, at the price
page 61
you have been waiting for.  Upgrade Express offers complete
enterprise control from a central location.  Features include: 
hierarchical distribution schema, DOS & Windows interface,
progress/status reporting features, user notification
capabilities, keyboard/mouse record playback, copy/move/delete
files, push/pull technology, hardware/software inventory, true
"rollback" UNDO feature, powerful scheduling capabilities,
Windows INI & text file editing, set file attributes, Windows
program manager control, supports all major networks & more.  

     Volume Sentry Order # VS4000.  Automate the volume repair
process on NetWare file servers.   When a volume cannot mount or
is dismounted due to errors, Volume Sentry takes over and runs
VREPAIR to repair and mount the defective volume.  Volume Sentry
will retry until the volume is mounted or until a user 
specified number of retries has been reached.  All actions are
recorded  into a log file.

     StayUp Order # SU4000.  Automatically reboot NetWare services
24 hours a day.  No more running from machine to machine trying
to re-establish connections with the file server.  StayUp is a
TSR utility program which automatically reboots and
re-establishes the network connection for :  dedicated print
servers, tape back-ups, fax servers, network bridges, mail
gateways, E-Mail servers, dial-up gateways, CD-ROM servers,
network gateways, unattended workstations, mainframe
connections, BBS's, etc..  Runs on all versions of NetWare. 
Takes less than 2K of RAM.

     Z-Menu Order # ZM4000.  The last word in menu systems. 
Features include:  shadow menus, custom help screens, 39
programmable function keys, password support, desktop background
configurable, customizable menu borders-single & double, mouse
support, moveable menu windows, customizable menu header,
converts Novell & Saber formats, compiled menus for added
security, hotkey access utilities anywhere within menu, desktop
accessories & more.  Runs on NetWare 286 V2.XX, NetWare V3,XX &
V4.XX.  0K RAM overhead on item execution.

     CORA Order # CO4000.  Console Output Recording Agent for
Novell File Servers.  This NetWare Loadable Module will record any
screen output on the file  server to a log file. This
information can then be reviewed later when  network personnel
are available. Useful for documenting boot sequences, error
recording etc. Runs on NetWare V3.X & 4.x.

SERVER SENTRY  (SS5000)  V5.10.  Continuously monitor the server
for ABENDs to occur. When an ABEND occurs Server Sentry will record
every active screen on the server, and the internal O/S registers
to a living history log. After the information is recorded, Server
Sentry will reboot and restore to service the NetWare server. If
the server continues to ABEND a user specified number of times, the
ABEND pager alert will notify network managers of the event via 
page 62
dialing specified pager numbers.  Generate detailed downtime cost
ananysis reports including: the cause of the ABEND, total downtime,
estimated downtime, cost of downtime.




















































page 63





DO YOU KNOW ?




WHAT ARE THE TOP FIVE PRIORITIES FOR NETWORK MANAGERS ?



Increase productivity 

Reduce down time 

Reduce computing/communications costs 

Fine-tune network performance 

Plan for a growing computing infrastructure







WHEN ASKED ABOUT THE COST OF NETWORK DownTime PER HOUR:



19% said between $ 5,000.00 and $ 10,000.00 per hour 

24% said between $ 10,000.00 and $ $ 50,000.00 per hour 

14% said between $ 50,000.00 and $ 100,000.00 per hour





WHAT ARE YOUR COSTS ?




Circuit Masters Software, Inc.'s products offer you instant
benefits, including an immediate return on your investment !
