@ECHO OFF
REM If you are running DOS 3.2 or below, change the above line to ECHO OFF
REM .
REM .
REM I-Queue Server 3.10
REM (c) Copyright 1992 by Bill Carter & Infinite Technologies
REM .
REM This is the batch file that is used to load the I-Queue! Server print
REM server.  For best results, it is recommended that you load I-Queue!
REM Server into memory on the workstations acting as print servers before
REM they log into the network.
REM .
REM This batch file executes the GETNODE.EXE program (included with I-Queue!
REM Server) to set two environmental variables with the network address
REM of the current workstation.  Conditional statements are then issued
REM to load I-Queue! Server on selected workstations with the appropriate
REM parameters.
REM .
REM An easy way to accomplish this is to place this batch file and the
REM GETNODE.EXE program in your SYS:LOGIN directory.  Rename LOGIN.EXE
REM to LOGON.EXE, and rename this batch file to LOGIN.BAT, so that
REM workstations will execute it first instead of LOGIN.EXE.
REM Include LOGON as the last statement of this batch file to execute
REM the standard Novell LOGIN procedure.
REM .
REM There are two separate versions of the I-Queue! Server program.
REM IQS.EXE uses unencrypted passwords, and can be used under NetWare 2.x
REM or NetWare 3.x when you have issued the statement SET ALLOW UNENCRYPTED
REM PASSWORDS = ON at the file server console.
REM IQSE.EXE uses encrypted passwords, and can be used in either the
REM NetWare 2.x or 3.x environment without restriction.
REM However, IQSE.EXE requires approximately 3-1/2KB of additional
REM memory to provide the encrypted password support, so NetWare 3.x
REM users may wish to enable unencrypted passwords and use IQS.EXE instead.
REM .
REM Command line options for IQS.EXE and IQSE.EXE.
REM .
REM     /U              to un-install.
REM .
REM     /Q<queuename>   primary queue to service.
REM     /Q2<queuename>  2nd queue name.
REM                     (NOTE:  To specify a queue on another file server
REM                     use the syntax /Qserver\queue)
REM .
REM     /x              x is Printer (1-3 for LPT1-LPT3 / 1-4 for COM1-COM4).
REM                       LPT1 is DEFAULT
REM .
REM     /S              Serial version (use COMx instead of LPTx)
REM                     (NOTE:  When using the serial option, you must
REM                     initialize the port's baud rate and parameters
REM                     using the DOS MODE command before loading IQS.)
REM .
REM     /Cx             x is 1-9 for copy to load.
REM                     (NOTE:  You can load up to 9 copies of IQS per
REM                     workstation, simply specify a different copy #
REM                     each time.)
REM .
REM     /P              Use Direct Port I/O to print. (DEFAULT)
REM     /B              Use BIOS to print.
REM                     (NOTE:  The BIOS option is slower, but will be
REM                     compatible with more "unusual" devices.)
REM .
REM     /Dxxx           Delay between jobs for xxx seconds.
REM                     (NOTE:  This option is useful for printers that
REM                     auto-switch between PCL and PostScript.)
REM .
REM     /Rxxxx          Printer Reset String...
REM                     (NOTE:  This is an ASCII string that will be
REM                     sent to the printer after each print job.
REM                     Use {xx} to include non-printable ASCII characters.
REM                     For example, <Escape>-E, which is the reset code
REM                     on HP LaserJets would be denoted /R{27}E)
REM .
REM     /Oxxx           Optimization. X is 128-1024 (256 Default).
REM                     (NOTE:  This # can be increased for better
REM                     performance on workstations being used as
REM                     dedicated print servers.)
REM .
REM     /Fx             Form Servicing Mode, where:
REM                       0 - Ignore forms changes. (DEFAULT)
REM                       1 - Minimize form changes.
REM                       2 - Change forms as needed.
REM                     (NOTE:  The default mode 0 means that I-Queue!
REM                     Server will ignore form specifications in print jobs.
REM                     Modes 1 & 2 will cause IQS to request form
REM                     changes.)
REM .
REM     /L              Local notification of printer errors/form changes (DEFAULT)
REM     /N              No local notification of printer errors/form changes
REM                     (NOTE:  By default or with the /L parameter, IQS will
REM                     send NetWare broadcast messages to the workstation
REM                     it is running on with printer error or form change
REM                     notifications.
REM .
REM     /I              Show status Information.
REM .
REM .
REM Run the GETNODE program, which will set two environmental variables.
REM NET will be set to the current workstation's network address.
REM NODE will be set to the curren workstation's node address.
REM Combined, these will uniquely identify each of your workstations.
GETNODE
REM Sample statements showing IQS parameters:
REM .
REM Bill's PC...Print Queue LASER1 to LPT2 with no local notification of errors.
IF %NET%$==00000001$ IF %NODE%$==000000000046$ IQS /QLASER1 /2 /N
REM Joe's PC...Print Queue LASER7 to COM1 with a reset code of <Escape>E
IF %NET%$==D0DAD0DA$ IF %NODE%$==02608CBADBAD$ MODE COM1:9600,n,8,1
IF %NET%$==D0DAD0DA$ IF %NODE%$==02608CBADBAD$ IQS /QLASER7 /S /1 /R{27}E
REM Print Server Workstation with multiple printers
REM First example is servicing 2 print queues.
REM Second example shows 1 print queue being serviced by 2 printers.
IF %NET%$==00000001$ IF %NODE%$==00000000006F$ IQS /C1 /QEPSON /Q2FS2\EPSON /1
IF %NET%$==00000001$ IF %NODE%$==00000000006F$ IQS /C2 /QLASER2 /2
IF %NET%$==00000001$ IF %NODE%$==00000000006F$ MODE COM1:9600,n,8,1
IF %NET%$==00000001$ IF %NODE%$==00000000006F$ IQS /C3 /QLASER2 /1 /S
REM .
REM To reclaim the environment space used by the NET and NODE variables,
REM we clear them out below.  This is optional.
SET NET=
SET NODE=
