.f3                              - # -              Appendix C - Examples & Tips
.rm70
.tc
.tc C. EXAMPLES & TIPS ....................................#
APPENDIX C   EXAMPLES & TIPS

.irTIPS;   see also Appendix C
This appendix consists of examples of various Word Fugue features.
They are in addition to the examples distributed throughout the
manual, and in the tutorial. The examples are intended to give you
ideas for using Word Fugue in your own work or to help you with a
particular application. Because Word Fugue users often have questions
relating to merge printing, many of these examples are related to
merge printing applications.

.tc    Changing Page Length and Line Height ...............#
Changing Page Length and Line Height

Suppose you are printing a document for readers with visual
impairment. You plan to use double width characters on paper that is
14 inches long. You also plan to increase the line height in order to
increase the separation between lines.

By default, Word Fugue assumes that you are using American standard
8-by-11-inch paper with 6 lines of text to the inch. This example
shows you how to set up a document for paper 14 lines long, with 4
lines per inch.

First, you must tell Word fugue of the new page length. At the default
of 6 lines per inch, 14 inch paper is 6 * 14 = 84 lines. So in order
to tell Word Fugue that you are using 14 inch paper, use the .PL
command to set the page length to 84.

        .PL 84

Now, use the .LH command to set the appropriate line height, and Word
Fugue will calculate the correct number of lines per page at this
height. You must have set the page length first, or Word Fugue will
assume that you are using 66 line paper. The default line step is
measured in 1/48ths of an inch - if your printer does not use this,
then you must determine the appropriate step and number. At 4 lines
per inch, you need 12/48ths of an inch per line:

        .LH 12    
        .LH 18/72            if your printer uses 1/72nds of an inch
        .LH 54/216           if your printer uses 1/216ths of an inch

Word Fugue will calculate the new number of lines that will fit on a
page - 84/12*8 = 56 lines. (Or 14*4 = 56!). Subtract of the margins
from the new page length to determine how many lines in the text body:
56-5-4=47. Thus there will be 47 text lines to the page. (Please note
that this is not a figure for the .PL command.)

If you are using double width characters, you should change the right
margin to 33 to fit on the line (.RM33) and you should change the page
offset to 5 (.PO5) since these are measured in characters.

.CP10
.tc    Double Spaced Text .................................#
Double Spaced Text
.ixDouble;Double Spaced Text (.LH)

If you need to print text double spaced, you actually want to print 3
lines per inch instead of the normal 6. You do this by changing the
line height. At 6 lines per inch, the line height was 8/48 inches. To
print 3 lines per inch, you need to double the line spacing to 16/48
inches:

        .LH 16

Again, you should place this command at the top of your text.

.CP6
.tc    Selective Printing of Page Numbers .................#
Selective Printing of Page Numbers

If you are printing a manual such as this, you probably do not want
page numbers on the title page, you want to use lower case roman
numerals for the table of contents, and ordinary numbers starting from
one at the first page of the first chapter. The following example
shows you how to do this.


   Ŀ
               .po10                                                
               .rm70                                                
               .mt5                                                 
               .mb4                                                 
               .pl66                                                
                                                                    
                    Word Fugue                                      
                                                                    
                    User's Guide                                    
                                                                    
               .pa                                                  
               --------------------- (page break) ---------------   
               .H1        WORD FUGUE USERS GUIDE                    
               .H2        TABLE OF CONTENTS                         
               .h3    
               .PA                                                  
               .f1                                                  
               .f2    
               .f3               - # -                              
    A .pn1                                                 
    B .pt r                                                
    C .fiwf.toc  contains the text for table of contents   
               .pa                                                  
               --------------------- (page break) ---------------   
               .H1        WORD FUGUE USERS GUIDE                    
               .h2    
    D .H3                                                  
    E .pn1                                                 
    F .pt n                                                
                                                                    
                           [Text]                                   
                                                                    
   



For the sample book on the previous page, printing starts without page
numbers on the title page. (This is the default, so the .OP command is
not needed). The .PA command starts a new page for the table of
contents. The footing with the # will cause page numbers to be printed
from then on. However, the first page of the table of contents is
physically the second page of the document, and Word Fugue will have
set the page number to 2. Thus the line labelled A (.PN1) resets the
page number to 1 for the table of contents.

We want lowercase roman Numerals for the contents, so line B (.PT r)
will set page numbers to be printed in lower case roman numerals. The
table of contents is held in a separate file WF.TOC and so is copied
in using the .FI file include command at line C.

At the end of the table of contents we take a new page and change the
heading. Line D blanks heading line 3. Line E resets the page number
back to 1 again for the first chapter. Line F changes the page number
type back to ordinary numbers.

.tc    Printing the First Page on Letterhead ..............#
Printing the First Page of a Document on Letterhead

This is the format for the first page of an organisation's formal
correspondence on preprinted letterhead.


      Ŀ
                                                                  
       ..STATIONARY FORMAT                                        
       ..FIRST PAGE                                               
       .RRL    !        !       !       !                   R     
       .MT10                                                      
       .MB5                                                       
       .PO14                                                      
                                                 {.@D8}           
      

The large top margin of 10 accommodates the preprinted letterhead. The
{.@D8} causes the current date to be printed in the format dd month
yyyy.

The letter should should be printed with Manual Paper Feed turned on
to cause the print to pause between pages so you can swap paper for
the following pages (unless you have a sheet feeder for your printer)
The example below shows how to print the rest of the letter.


      Ŀ
                                                                  
       ..FOLLOWING PAGES                                          
       .MT5                                                       
       .MB4                                                       
       .PG                                                        
       .PC 1                                                      
                                                                  
      


.CP6
The .PG command turns on printing of page numbers in the default
column at the foot of the page. The .PC 1 places the page number in
column 1.

    TIP You could set up this format (or your own variation) as a
    separate document, and whenever you want to print such a letter,
    use the file read command (Ctrl K R) to insert the document into
    the letter.

.cp10
.tc    Printing a Standard Business Envelope ..............#
Printing a Standard Business Envelope

Assuming your printer can handle envelopes, then to print one you need
only consider it as a document with a short page length and special
margins.

The format shown below is suitable for a standard 9-by-4-inch
business envelope, printing 10 characters per inch.


       Ŀ
                                                                  
        .PA             {begin envelope on new page}              
        .PL24           {standard size @ 6 lines per inch}        
        .MT12           {start printing 12 lines from top}        
        .MB0            {eliminate bottom margin}                 
        .PO40           {begin printing 40 spaces from left edge} 
                                                                  
       

If you use different size envelopes, change the dot commands
accordingly.

    TIP You could set up this format (or your own variation) as a
    separate document, and whenever you want to print an envelope,
    use the file read command (Ctrl K R) to insert the format into
    the document.

.tc    A Typical Master Document for Merge Printing .......#
A Typical Master Document for Merge Printing

The following is a sample master document for a form letter that
includes variable names and merge print dot commands:

.CP21
     Ŀ
       .df names.dat                                           
       .rv name,greeting,address1,address2                     
       ..make sure that there is enough room for letterhead    
       .mt 20                                                  
                                                               
       {.D8}                                                   
                                                               
       &name&                                                  
       &address1&                                              
       &address2&                                              
                                                               
       Dear &greeting&,                                        
                                                               
       thank you for your recent enquiry. ........             
                                                               
       yours sincerely                                         
                                                               
       fred Nurk                                               
       .pa                                                     
     

The four variables in the form letter are surrounded by ampersands (&).
The date in NAMES.DAT might look like this:


.ixData Files;   examples
     Ŀ
       Joe Bloggs,Mr. Bloggs,43 Oak drive,Acorn city  SA 5871   
       Jane Smith,Ms Smith,7 Main St,The Village   TAS 7766     
       Cecil Cedric,Cecil,9 Rose ave, Melbourne   VIC   3021    
     


.tc    Merge Printing Envelopes for a Mass Mailing ........#
Merge Printing Envelopes for a Mass Mailing

You can use the same data file from the letters to print the
envelopes. However, you will need to create a different master
document. Below is an example of such a document:


    Ŀ
    .df names.dat                                                 
    .rv name,greeting,address1,address2                           
    .av "Put an envelope in the printer. Press enter when ready",X
    .pl24                                                         
    .mt12                                                         
    .mb0                                                          
    .po40                                                         
    &name&                                                        
    &address1&                                                    
    &address2&                                                    
    .pa                                                           
    


The dot commands select the data file, read the data, and interrupt
printing so you can put in a new envelope. They also set up the format
for a standard envelope as above.

The .AV tells word Fugue to pause during the merge printing and
display the message in quotes. The X variable in the .AV command is
used only because the .AV command requires a variable for the keyboard
input. Using the .AV is really only a trick to display a message and
pause until you press Enter.

The next 4 dot commands set up the format for the envelope - the page
length, top and bottom margins, and offset.

The address variables print the name and address from the data file.
The .PA starts a new envelope.

.cp40
.tc    Merge Printing Sticky Labels Three Across ..........#
Merge Printing Sticky Labels Three Across
{.}
Example 1{.}
.tc       Example 1 .......................................#

This first example shows you how to set up a format for merge printing
names and addresses on stick labels. The dot commands here assume
standard 3-inch by 1-inch labels, printed at 10 characters per inch
and 6 lines per inch. Each label can therefore fit 35 characters.


    Ŀ
     .po 2                                                        
     .PL 9                                                        
     .mt 1                                                        
     .mb 1                                                        
     .df label.dat                                                
     .rv name1,address1,city1,state1,pc1                          
     .rv name2,address2,city2,state2,pc2                          
     .rv name3,address3,city3,state3,pc3                          
     .sv name1/L30=&name1&                                        
     .sv name2/L30=&name2&                                        
     .sv name3/L30=&name3&                                        
     .sv address1/L30=&address1&                                  
     .sv address2/L30=&address2&                                  
     .sv address3/L30=&address3&                                  
     .sv cityline1/L30=&city1&, &state1&, &pc1&                   
     .sv cityline2/L30=&city2&, &state2&, &pc2&                   
     .sv cityline3/L30=&city3&, &state3&, &pc3&                   
     &name1&     &name2&     &name3&                              
     &address1&     &address2&     &address3&                     
     &cityline1&     &cityline2&     &cityline3&                  
     .pa                                                          
    


Each row of labels is treated as a page, so the page length is set to
9 lines (6 lines per inch => 1" = 9 lines). The data for each label
is read in, and then formatted.

The .SV lines format each variable to a length of 30 characters, left
justified. We could have defined formats for the variables City, State
and PC, so that their combined length totalled 30 characters, but the
method shown here of creating another variable is easier to work with.

.CP6
There are 6 spaces between each variable reference in the print
section. During merge printing, each variable is replaced with a
field 30 characters wide. The five spaces between them add up to a
combined width of 36 characters, which is the label width plus the gap
between the labels. The point of the .PO2 command is to ensure that
the text does not start right on the edge of the label (which would
look unsightly).

The .PL9 command also tells the printer the page length, so it does
not matter whether you have form feeds on or not. However, if your
printer does not have a control sequence for setting page length, you
should turn off form feeds before printing (otherwise the printer will
spit out 66 lines for each label!).
{.}
{.}
Example 2{.}
.tc       Example 2 .......................................#

This second example shows you how to achieve the same ends but by
using snaking columns of text. You can either print down one column,
and then down the second and finally down the third (suitable if you
have a page printer - see example 3 below) or you can print across the
paper 3 abreast. This is more suitable for a dot matrix or similar
with continuous stationery.{.}

This example is probably easier than the first, since you do not need
to pad variables out to a fixed size, nor do you need to position the
variables for label 2 and 3 across the page from label 1.
                                                        {.}

    Ŀ
     .po 2                                                        
     .PL 9                                                        
     .mt 1                                                        
     .mb 1                                                        
     .co 3,1 / 35,35,35                                           
     .df label.dat                                                
     .rv name1,address1,city1,state1,pc1                          
     .rv name2,address2,city2,state2,pc2                          
     .rv name3,address3,city3,state3,pc3                          
     &name1&                                                      
     &address1&                                                   
     &city1&   &state1&  &pc1&                                    
     .cb                                                          
     &name2&                                                      
     &address2&                                                   
     &city2&   &state2&  &pc2&                                    
     .cb                                                          
     &name3&                                                      
     &address3&                                                   
     &city3&   &state3&  &pc3&                                    
     .pa                                                          
    


Each row of labels is treated as a page, so the page length is set to
9 lines (6 lines per inch => 1" = 9 lines). The data for each label
is read in. No additional formatting is done.{.}
{.}
The .CO line defines the printing to occur in 3 columns, with a gutter
of 1 character between each column. Each column is defined to be 35
characters wide. These add up to 36 characters, which allows for the
gap between the labels. (Normally only 1 character).

The .CB commands after the first 2 labels issue a Column Break and
cause the text following to be printed in the next column. The third
label is followed by a page break (.PA) so that the 3 labels will
print, and then the printer will advance to the top of the next page
(the next label group).{.}
{.}
.cp10{.}
Example 3{.}
.tc       Example 3 .......................................#
{.}
When working with page printers, you should define the page to be the
real page length, with margins to ensure that the printable area
includes only the sticky label area. Instead of defining a single row
of labels, you will need to define additional rows for the entire
page, preferably using method 2. You would insert a column break at
the last label in each of columns 1 and 2, with a page break after the
labels in column 3. If you have 7 labels down a column, then you will
need to define 3x7 = 21 labels in your page layout. If you don't do
this, but try to define the labels with a page length of 9, you
printer will probably spit out a page of labels with only the first
row printed.{.}
{.}
After each label, you will need to insert sufficient blank lines to
bring the next label down to where it will line up correctly. For
example, if you are printing 3 lines on a label, you will need 6 blank
lines to bring the format down to the next label (the length is 9
lines remember?)  You can either insert column breaks after each
label, so the printing will run across the page, or you can simply let
them run down the column, and let Word Fugue continue in the next
column when the first is full. {.}
{.}

.CP29
    Ŀ
     .po 2                                                        
     .PL 66                                                       
     .mt 1                                                        
     .mb 2                                                        
     .co 3,1 / 35,35,35                                           
     .df label.dat                                                
     .rv name1,address1,city1,state1,pc1                          
     .rv name2,address2,city2,state2,pc2                          
           {this continues for 21 labels}                         
     .rv name21,address21,city21,state21,pc21                     
     &name1&                                                      
     &address1&                                                   
     &city1&   &state1&  &pc1&                                    
                                                                  
                                                                  
                              {6 blank lines to fill out label}   
                                                                  
                                                                  
     &name2&                                                      
                              {repeats for 21 labels}             
                                                                  
                                                                  
     &name21&                                                     
     &address21&                                                  
     &city21&   &state21&  &pc21&                                 
     .pa                   {prints the page and starts a new one} 
    
{.}

.CP10
Missing Data in Some Records
.tc       Missing Data in Some Records ....................#

It may well be that in a row of labels, some may be missing the first
line of the address. This is still a valid address, but can look
unsightly. This is easily fixed by use of conditional dot commands.
This example assumes that the mailing list consists of name, street
address and city line, and that the street address is missing.

After Word Fugue has read all variables from the data file for a row
of labels, it can check to see if any street addresses are missing.
The method we will use is to place the name into the street line, and
blank out the name:


    Ŀ
        .IF &ADDRESS1&=                                 
        .SV ADDRESS1=&NAME1&                            
        .SV NAME1/L30=                                  
        .EI                                             
        .IF &ADDRESS2&=                                 
        .SV ADDRESS2=&NAME2&                            
        .SV NAME2/L30=                                  
        .EI                                             
        .IF &ADDRESS3&=                                 
        .SV ADDRESS3=&NAME3&                            
        .SV NAME3/L30=                                  
        .EI                                             
    


You  can modify this basic procedure to cater for other situations
where data could be missing.

.tc    Merging and Centering a Variable in a Page .........#
Merging and Centring a Variable in a Page

To centre a variable in a document page, simply use the .SV command,
and specify the format as /C for centred, with the width the same as
the ruler line.

        .RV name
        .SV name/C70=&name&

will define name as 70 characters wide (the same as the ruler line),
and centre the value read. Simply place the variable at the left
margin of your document, and the text will be centred on the page.

.tc    Maths, Formatting and Conditionals in Merging ......#
Maths, Formatting and Conditionals in Merging

The example on the next page shows how to set up a more complicated
document, which is only printed if the customer spent a total of more
than $40 during the last month, on at least 4 different items. A
special discount is offered, 5% for those who spent less than $400,
and 10% for those who spent more.

.pa
        .df names.dat
        .rv first,last,street,city,state,postcode
        .rv item1,price1,item2,price2,item3,price3,item4,price4
A       .ma total$=&price1&+&price2&+&price3&+&price4&
B       .sv total/R10=&total&
C  .sv item1/L25=&item1&
       .sv item2/L25=&item2&
       .sv item3/L25=&item3&
       .sv item4/L25=&item4&
D  .sv price1/R17=&price1&
       .sv price2/R17=&price2&
       .sv price3/R17=&price3&
       .sv price4/R17=&price4&
E   .if &total& >= 40.00
F ĳ                {.@D8}
       Nurk's Special Supplies
       Erehwon
   
       &First& &Last&
G ĳ .if &street&
      &street&
     .ei
       &city& &state& &postcode&
   
       Dear &First&
   
       Our records show that you have bought four or more items from
       us in the last month.......
       ... we are offering you the following discount on your next
       purchase:
   
H ĳ .if &total& < 400.00
                      five percent
      .el
                      ten percent
     .ei
   
I ĳ .if &item2&
      Here list a list of your last purchases
      .el
      Here is your last purchase
     .ei
   
J ĳ         &item1&&price1&
              &item2&&price2&
              &item3&&price3&
              &item4&&price4&
   
               Total                           &total&
   
       sincerely
   
       Fred Nurk
       .pa
    .ei

.CP5
  Explanation

  At A, the total is calculated from the four prices read in, and is
  formatted as 2 decimal places (the $ at the end of total does this).

  Line B formats the total to be 10 characters wide, right justified.

  Lines C format the item descriptions to be 25 characters wide, left
  justified.

  Lines D format the prices to be 17 characters wide, right justified.

  Line E checks that the total expenditure is greater than or equal to
  40. If it is less, the entire letter is skipped down to the matching
  .EI, which means that nothing prints.

  Line F inserts todays date in the format dd month yyyy.

  Lines marked G test if the variable street contains a value, and
  prints it if it does. If the variable is blank, the line is omitted.

  The lines labelled H print the words five percent if the total is
  less than 400, and print the words ten percent otherwise.

  The lines marked with I test if there is a second item, and print
  the words here is a list of your last purchases if there is a second
  item, but print the words Here is your last purchase if there is
  not a second item.

  The lines J print a list of items, they have already been
  formatted, so there is no need for spaces between the variable
  names, the formatting takes care of that. The first ampersand (&) of
  the total is in the column so that it will line up with the other
  prices when they print.

  NOTE if you need to omit variables from your data file, place a blank
       and follow it by a comma (,). Each .RV command only reads
       variables from one line of the file

.tc    Advanced Mathematics in Merge Printing .............#
Advanced Mathematics in Merge Printing

All of the functions of Word Fugue's pop up calculator are available
for the .MA command. You can do complicated trigonometric functions and
so on. For example to calculate loan payments from the amount
borrowed, interest rate and term of loan is:

       P = A * i * (i + 1)n/((i+1)n-1)

where P is the amount of each payment
      A is the amount borrowed
      i is the interest rate per payment interval. If the payment
        interval is monthly, divide i by 12. i must be converted from
        a percentage to a decimal fraction - 12% = 0.12, and on
        monthly payments = 0.01
      n is the total number of payments. For example monthly payments
        over 4 years total 48 payments

.CP5
This equation can be expressed in a .MA commands below. The actual
equation is on one line only - since Word Fugue's maximum line length
is 999 characters, you should be able to express the most complicated
equation on one line. If you cannot, break it up into parts, calculate
intermediate values, and then combine the intermediate values.

      Ŀ
       .. calculate monthly interest as decimal   
       .MA i=&interest&/1200                      
       .. calculate payment P                     
       .MA P$=&A&*&i&*(&i&+1)^&n&/((&i&+1)^&n&-1) 
      

The hat sign (^) is used for raising the first number to the power of
the second, thus 2 squared (22) is 2^2, and 2 cubed (23) is 2^3. The
variable interest is read in as a percentage and then divided by 1200
to convert it to a decimal rate per month. It is more efficient to
calculate i once and refer to it in the second equation than to
calculate it each time it is referenced (3 times), and probably less
confusing too. The payment figure is truncated to 2 decimal places for
printing as a Dollar amount. Without this, Word Fugue might print the
payment figure as a 14 digit decimal number, depending on just how
many decimal places the exponentiation (raising to the nth power)
produced.

.tc    Creating a Lookup Table for Merge Printing .........#
Creating a Lookup Table for Merge Printing

There can be times when, for example, you want to print different
messages for different categories of people. Either you do not want to
type the same message in over and over again, or you want to use a
standard mailing list several times for several different sets of
messages.

You could read in the customer type, and use conditionals (.IF .EL
.EI) to determine the message to be printed, but there is another
method, using what is known as recursion:

In your sample data file there are 3 records:

       Ŀ
       Fred Nurk,&prize1&                 
       Susan Soo,&prize2&                 
       Sally Zed,&Prize2&                 
       

.CP16
The form letter looks like this:

       Ŀ
       .sv prize1=A new car                          
       .sv prize2=A trip to New Zealand for 2        
       .df data.dat                                  
       .rv name,prize                                
       Dear &name&                                   
                                                     
       Your prize is &prize&                         
                                                     
       sincerely yours                               
       prize coordinator                             
       .pa                                           
                                                     
       

When the variable prize is read from the data file, it will contain
either "&prize1&" or "&prize2&". When it is printed, it will be
replaced with the characters it contains, and since they have been
defined as variables themselves, they in turn will be replaced with "A
new car" and "A trip to New Zealand for 2" respectively.

.tc    Proof Reading Your Printouts Before Merge Printing .#
Proof Reading Your Printouts Before Merge Printing

Keep in mind that when merging documents with data files, everything
has to be correct. Take your time to spell check your documents, proof
read them carefully. In addition, you should try out the different
combinations (especially if you are using conditionals) by using a
sample data file before the real thing.

You can either run this to paper, or print it to disk and review the
output using Word Fugue. If your document is large, you could make an
exact copy of it, and working on the copy, delete most of the text,
leaving just enough to identify the various conditions and so on. Run
this with your sample data file to see how things work.

This approach is ideal for developing a merge print document - work
out the commands you need to use, and test them with a sample data
file, then when you have fixed any errors in the commands, flesh out
the document with the real text, and print it again with the sample
data file. Be sure to try each of the different combination so that
you know you won't have funny merged documents in some situations.
Only when you are sure that everything is right should you run the
real print.

.cp15
.tc    Working with Books and Chapters ....................#
Working with Books and Chapters
.tc       The Master Document .............................#
{.}
The Master Document{.}

For convenience, you should break a long document such as a book or a
research paper down into sections or chapters. Each chapter should be
set up as a separate file. To simplify printing, generation of table
of contents and indexes, you should create a Master Document that
includes each chapter using a .FI command. With the master document
loaded into Word Fugue, you can easily open a chapter by placing the
cursor on the appropriate .FI line and pressing Ctrl F to load the
chapter into a separate window.

If you inspect the compressed document file that came with your copy
of Word Fugue, you will find that it contains a version of the manual
you are reading. The master document is WF.DOC, and all the chapters
are WF.nnn, where nnn is a number or letter. The table of contents is
WF.TOC, while the index is WF.IDX. They are generated by specifying
WF.DOC as the file to process, and each chapter is included as needed
by the .FI command.

Below is a section of the master document:
{.}

         Ŀ
A ĳ.po O 12                                              
       ĳ.po E 8                                               
                                                               
                        Word Fugue                             
                                                               
                        User's Guide                           
                                                               
         .pa                                                   
B ĳ.f1                                                   
       ĳ.f2 ĳ
       ĳ.f3                                 - # -             
C ĳ.pn1                                                  
       ĳ.pt r                                                 
D ĳ.fiwf.toc                                             
       ĳ.pa                                                   
E ĳ.H1                      WORD FUGUE USERS GUIDE       
       ĳ.h2 ĳ
       ĳ.H3                                                   
F ĳ.pn1                                                  
       ĳ.pt n                                                 
G ĳ.fiwf.001                                             
H ĳĳ.pbo                                                  
      ĳ.fiwf.002                                             
    ĳĳ.pbo                                                  
      ĳ.fiwf.003                                             
    ĳĳ.pbo                                                  
      ĳ.fiwf.004                                             
    ĳ.pbo                                                  
         

.cp7

A - The page offset for even numbered pages is set to 8 characters,
    while that for odd numbered pages is set to 12 characters. This is
    to allow for the binding, since the book will eventually be
    printed double sided, with the left hand pages bearing even
    numbers, and the right hand pages bearing odd numbers.

B   A three line footer is created, with the page number as the lowest
    line.

C   The page number is reset to 1 via the .PN 1 line, while the type
    of the page number is set to lower case roman numerals via the
    .PTr command.

D   The table of contents is included.

E   A new page is started, and a heading is set up for the entire
    document.

F   The page number is reset to 1, and the number type is changed to
    ordinary numbers via the .PT n command. Failure to reset the page
    number to 1 will result in the first page being numbered 4 or 5 as
    it follows the table of contents.

G   These lines include the first 4 chapters of the manual.

H   These lines ensure that each new chapter starts on an ODD numbered
    page. If the next page is even numbered, a blank page will be
    printed to force the text onto an odd numbered page.

There are many more commands in the real master document, and it is
suggested that you inspect the sample documents to see how everything
is done.

Headings in your Table of Contents
.tc       Headings in your Table of Contents ..............#

Since the table of contents is generated each time, and headings etc
need to be placed into the table of contents when it is generated.
This can be accomplished by prefixing the dot commands by .TC, since
the text that follows the dot command is copied literally into the
table of contents file.

For example, the following commands in a document:


       Ŀ
       .TC.HE   TABLE OF CONTENTS             
       .TC.FO       - # -                     
       .TC.PT r                               
       .TC CHAPTER 1 ...................#     
       .tc    sub heading 1 ............#     
       .tc    sub heading 2 ............#     
       .tc                                    
       .tc CHAPTER 2 ...................#     
       

.cp17
will produce a table of contents file (.TOC) containing:


       Ŀ
       .HE   TABLE OF CONTENTS                
       .FO       - # -                        
       .PT r                                  
        CHAPTER 1 ...................1        
           sub heading 1 ............1        
           sub heading 2 ............2        
                                              
        CHAPTER 2 ...................4        
       


A blank line can be produced by typing a .TC command with no text
following.
{.}
Headings and Columns in your Index
.tc       Headings and Columns in your Index ..............#

Since the index is generated each time, and headings etc need to be
placed into the table of contents when it is generated. This can be
accomplished by prefixing the dot commands by .IR, since the text that
follows the dot command is copied literally into the table of contents
file. For commands to come at the start of the index, you would use a
prefix of .IR ; (the major sort key is a space to sort to the front).
For dot commands to appear at the end, you would use .IR; (the major
sort key is  which can be keyed in by holding down the ALT key and
pressing 254 on the numeric key pad. This character will sort last).
For dot commands to appear at a particular point (or headings), you
would use the prefix .IRabcde; where abcde is what ever sequence of
characters that will cause that line to sort into the appropriate
place.{.}

For example, the following commands in a document:{.}


       Ŀ{.}
#1 ĳ.IR ;.HE       INDEX                   {.}
      .IR ;.FO       - # -                   {.}
      .IR ;.PT r                             {.}
     ĳ.IR ;.PN 1                             {.}
#2 ĳ.IR!;.CO 2,5                           {.}
#3 ĳ.IR;.CO 1                             {.}
#4 ĳ.IRA;  ^O                              {.}
      .irA;  -A-                             {.}
     ĳ.IRA;  {.|}                               {.}
       .IRB;  ^O                              {.}
       .irB;  -B-                             {.}
       .IRB;  {.|}                               {.}
       .IMAardvarks                           {.}
       .ix   Eating Habits                    {.}
       .ix   Habitat                          {.}
       .ix   As pets                          {.}
       .IMBirds                               {.}
       .ix   As pets                          {.}
       {.}

.cp17

will produce an index file (.IDX) containing:


       Ŀ{.}
       .FO       - # -                        {.}
       .HE       INDEX                        {.}
       .PN 1                                  {.}
       .PT r                                  {.}
       .CO 2,5                                {.}
                                              {.}
         -A-                                  {.}
                                              {.}
       Aardvarks                              {.}
          As pets        1                    {.}
          Eating Habits  5-9                  {.}
          Habitat        3-5                  {.}
                                              {.}
         -B-                                  {.}
                                              {.}
       Birds                                  {.}
          As pets                             {.}
       .CO 1                                  {.}
       {.}


A blank line can be produced by typing a .IR command with no text
following.{.}
{.}
This will print the index in 2 columns, with 5 spaces between the
columns. The major sort key specified for the lines numbered #1 is a
space (any characters following a .IR or .IX and preceded by a ;
(semicolon) are the sort key for that line. If none is specified, the
the previous .IM text is used) and so the 4 lines will sort together.
The text on each line will also be sorted, so the .FO will come before
the .HE line.

The major sort key specified for the line numbered #2 is an
exclamation mark (!) which will sort immediately after a space. This
is so the .CO 2,5 (snaking column of text) will be sorted to the front
of the file, but after the header and footer commands. The key for
line #3 is  and so the .CO 1 line (end snaking columns) will sort to
the end of the file. You should be aware that since you have used a
space and exclamation mark as major sort keys, all the major sort keys
for you index entries CANNOT have a preceding space, but must start
hard up against the .IM command (eg .IMAardvarks). If you do not
follow this rule, then those entries will sort among the header lines,
which you do not want to happen. Its not an unmitigated disaster, but
your index will not print the way you want.{.}
{.}
The three lines numbered #4 all have a major sort key of A, so they
will all sort together, and the text after the (;) will appear in
sorted order. The first line contains the text ^O - this is actually a
non breaking space, and is entered by pressing Ctrl P O. It will sort
before a space, but will always print as a space. (You could also use
this as the sort key for head & footer lines if you want your major
index entries to have leading spaces). The letter A by itself will
always sort before any combination of letters starting with A.

The last of the three lines contains a ({.|}) character, which is
actually a pad character. It will sort after all letters, numbers and
special characters, but before (). You enter it by holding down the
ALT key and typing 250 on the numeric key pad. This ensures that the
space line will sort after the -A- line. (If you used ^O again, the 2
space lines would sort before the -A- line). {.}
{.}
.RRL    w  !       !       !       !       !       !       !       !    R
NOTE The ^O and the ({.|}) character MUST either physically line up with
     the first non space character on the intervening lines or must be
     in an earlier column IF you want them to sort in the right order.
     If you were to set them in (say) 3 characters, then the first 3
     characters would be spaces. If the heading had only 2 spaces
     preceding it (-A-) then it would sort AFTER the other 2 lines,
     because the third character (-) will come alphabetically after a
     space.

.RRL       !       !       !       !       !       !       !       !    R

