VERSION 2.00
Begin Form EdtLevel 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Levels"
   ClientHeight    =   4875
   ClientLeft      =   645
   ClientTop       =   1530
   ClientWidth     =   8085
   ClipControls    =   0   'False
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "Courier"
   FontSize        =   9.75
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   5250
   HelpContextID   =   100
   Icon            =   EDTLEVEL.FRX:0000
   Left            =   600
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4875
   ScaleWidth      =   8085
   Top             =   1200
   Width           =   8175
   Begin CommandButton Cmd 
      Caption         =   "Examine"
      Height          =   375
      Index           =   2
      Left            =   2100
      TabIndex        =   7
      Top             =   3840
      Width           =   1035
   End
   Begin CommandButton CmdSave 
      BackColor       =   &H00808080&
      Caption         =   "Save"
      Height          =   315
      Left            =   420
      TabIndex        =   8
      Top             =   540
      Width           =   1155
   End
   Begin SSFrame FrameCvt 
      Caption         =   "Convert"
      Enabled         =   0   'False
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   1695
      Left            =   6300
      TabIndex        =   18
      Top             =   3000
      Width           =   1635
      Begin Label Label1 
         Alignment       =   2  'Center
         Caption         =   "Not Yet Implemented"
         ForeColor       =   &H00808080&
         Height          =   435
         Left            =   240
         TabIndex        =   25
         Top             =   660
         Width           =   1155
      End
   End
   Begin SSFrame FrameNod 
      Caption         =   "Nodes+Reject"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   1935
      Left            =   6300
      TabIndex        =   14
      Top             =   960
      Width           =   1635
      Begin CommandButton CmdReject 
         Caption         =   "Build Reject"
         Height          =   375
         Left            =   120
         TabIndex        =   17
         Top             =   960
         Width           =   1395
      End
      Begin CommandButton CmdEff 
         Caption         =   "Efficiency"
         Enabled         =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   16
         Top             =   1440
         Width           =   1395
      End
      Begin CommandButton CmdNodes 
         Caption         =   "Build Nodes"
         Height          =   375
         Left            =   120
         TabIndex        =   15
         Top             =   360
         Width           =   1395
      End
   End
   Begin CommandButton CmdDoom 
      Caption         =   "Doom/Heretic"
      Height          =   375
      Left            =   6420
      TabIndex        =   13
      Top             =   480
      Width           =   1395
   End
   Begin CommandButton Cmd 
      Caption         =   "Rename"
      Height          =   375
      Index           =   1
      Left            =   4560
      TabIndex        =   10
      Top             =   3840
      Width           =   1035
   End
   Begin ComboBox Ident 
      Height          =   300
      Left            =   2100
      TabIndex        =   9
      Text            =   "HELP "
      Top             =   4380
      Width           =   4035
   End
   Begin SSFrame FrameLev 
      Caption         =   "Level Edition"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   2955
      Left            =   120
      TabIndex        =   6
      Top             =   1260
      Width           =   1755
      Begin CommandButton CmdEdit 
         Caption         =   "DCK"
         Height          =   375
         Index           =   4
         Left            =   180
         TabIndex        =   23
         Top             =   720
         Width           =   1395
      End
      Begin CommandButton CmdEdit 
         Caption         =   "EdMap"
         Height          =   375
         Index           =   5
         Left            =   180
         TabIndex        =   22
         Top             =   1140
         Width           =   1395
      End
      Begin CommandButton CmdEdit 
         Caption         =   "WadEd"
         Height          =   375
         Index           =   3
         Left            =   180
         TabIndex        =   21
         Top             =   1560
         Width           =   1395
      End
      Begin CommandButton CmdEdit 
         Caption         =   "DoomCAD"
         Height          =   375
         Index           =   2
         Left            =   180
         TabIndex        =   20
         Top             =   1980
         Width           =   1395
      End
      Begin CommandButton CmdEdit 
         Caption         =   "WinDEU"
         Height          =   375
         Index           =   1
         Left            =   180
         TabIndex        =   19
         Top             =   300
         Width           =   1395
      End
      Begin CommandButton CmdEdit 
         Caption         =   "Custom Editor"
         Height          =   375
         Index           =   0
         Left            =   180
         TabIndex        =   5
         Top             =   2460
         Width           =   1395
      End
   End
   Begin CommandButton Cmd 
      Caption         =   "Add Level"
      Height          =   375
      Index           =   0
      Left            =   3240
      TabIndex        =   3
      Top             =   3840
      Width           =   1215
   End
   Begin ListBox LevelLst 
      Height          =   3150
      Left            =   2100
      TabIndex        =   4
      Top             =   480
      Width           =   4035
   End
   Begin CommandButton Exit 
      BackColor       =   &H00808080&
      Caption         =   "Quit"
      Height          =   315
      Left            =   420
      TabIndex        =   0
      Top             =   120
      Width           =   1155
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   4
      X1              =   2640
      X2              =   2640
      Y1              =   3240
      Y2              =   4020
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Level editing "
      ForeColor       =   &H00800000&
      Height          =   195
      Index           =   2
      Left            =   180
      TabIndex        =   11
      Top             =   960
      Width           =   1695
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Help on custom textures and flats"
      ForeColor       =   &H00800000&
      Height          =   435
      Index           =   1
      Left            =   240
      TabIndex        =   24
      Top             =   4320
      Width           =   1635
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   1
      X1              =   6060
      X2              =   7380
      Y1              =   660
      Y2              =   660
   End
   Begin Label Info 
      BackStyle       =   0  'Transparent
      Caption         =   "List of single level WADs"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   0
      Left            =   2760
      TabIndex        =   12
      Top             =   120
      Width           =   2955
   End
   Begin Image CmdForget 
      Height          =   480
      Left            =   5640
      Picture         =   EDTLEVEL.FRX:0302
      Top             =   3780
      Width           =   480
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   3
      X1              =   5880
      X2              =   5880
      Y1              =   3240
      Y2              =   4080
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   2
      X1              =   5100
      X2              =   5100
      Y1              =   4500
      Y2              =   3300
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   0
      X1              =   3840
      X2              =   3840
      Y1              =   3300
      Y2              =   4500
   End
   Begin Label WadInfo 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "wadinfo.txt"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   6840
      TabIndex        =   2
      Top             =   120
      Visible         =   0   'False
      Width           =   1035
   End
   Begin Label WorkDirec 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "work dir"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   5700
      TabIndex        =   1
      Top             =   120
      Visible         =   0   'False
      Width           =   975
   End
End
Option Explicit

Dim ListDirty As Integer

Sub Cmd_Click (Index As Integer)
   Dim file As String
   Dim entry$, nam$
   Dim X%, Y%, repeat%
   Select Case Index
     Case 0 'new level
       If Not Tutor("add a new level to the list. The entry name is taken from the drop box.") Then Exit Sub
       ' get entry name
       entry = HelpGetName(Ident, True)
       If Len(entry) <= 0 Then Exit Sub
       file = ChooseFile(".", "*.wad", True, "Select a file containing a level (.WAD)")
       If Not DIRexistFile(file) Then Exit Sub
       nam = FileName(file)
       Dim file2 As String
       file2 = MakeFileName(WorkDirec.Caption, nam)
       Call EditCopyFile(file, file2)
       'remove .wad
       Dim i As Integer
       i = InStr(nam, ".")
       If i > 1 Then nam = Left$(nam, i - 1)
       'declare entry
       nam = EntryMake(entry, INVALID, INVALID, nam, False)
       If Len(nam) <= 0 Then Exit Sub
       LevelLst.ListIndex = ListInsert(LevelLst, nam$)
       ListDirty = True
     Case 1 'rename
       If Not Tutor("rename a level using a name taken from the drop box.") Then Exit Sub
       entry = HelpGetName(Ident, True)
       If Len(entry) <= 0 Then Exit Sub
       If LevelLst.ListIndex < 0 Then Exit Sub
       file = EntryGet(X, Y, nam, repeat, LevelLst.Text)
       LevelLst.List(LevelLst.ListIndex) = EntryMake(entry, INVALID, INVALID, nam, False)
       ListDirty = True
     Case 2 'examine
       If Not Tutor("display contents of a single level WAD.") Then Exit Sub
       If LevelLst.ListIndex < 0 Then Exit Sub
       entry = EntryGet(X, Y, nam, repeat, LevelLst.Text)
       file = MakeFileName(WorkDirec.Caption, nam & ".wad")
       Load ListDir
       ListDir.WadFile.Caption = file
       ListDir.Show 1
    End Select
End Sub

Sub CmdDoom_Click ()
  If Not Tutor("Call DOOM or HERETIC on your single level file (plus custom textures and flats)") Then Exit Sub
  If Not QueryCancel("Exit windows and try to call DOOM or HERETIC? (the game may lock up. another windows bug?)") Then Exit Sub
  Dim wad As String
  Dim level As String
  wad = CurrentWad(level)
  If Len(wad) <= 0 Then Exit Sub
  Call CallDoom(wad)
End Sub

Sub CmdEdit_Click (Index As Integer)
  Dim wad As String
  Dim level As String
  wad = CurrentWad(level)
  If Len(wad) <= 0 Then
    Call Infos("No WAD selected.")
  End If
  Select Case Index
    Case 0 'custom editor
      Call EditLevel(wad, level)
    Case 1 'WinDEU
      Call CallWinDeu(wad, level)
    Case 2 'Doomcad
      Call CallDoomcad(wad, level)
    Case 3 'WadEd
      Call CallWadEd(wad, level)
    Case 4 'DCK
      Call CallDCK(wad, level)
    Case 5 'EdMap
      Call CallEdmap(wad, level)
  End Select
End Sub

Sub CmdEff_Click ()
  Call Infos("Not implemented yet")
End Sub

Sub CmdForget_Click ()
  Call EntryDelete(LevelLst, WorkDirec.Caption, ".WAD")
  ListDirty = True
End Sub

Sub CmdNodes_Click ()
  If Not Tutor("Build the nodes and blockmap in your select level WAD. This is needed before you can play the WAD, if your level editor can't do it correctly.") Then Exit Sub
  Dim wad As String
  Dim level As String
  wad = CurrentWad(level)
  If Len(wad) <= 0 Then Exit Sub
  Call EditNodes(wad, level)
End Sub

Sub CmdReject_Click ()
  If Not Tutor("Build the reject data in your select level WAD. This is not required, but improves game speed.") Then Exit Sub
  Dim wad As String
  Dim level As String
  wad = CurrentWad(level)
  If Len(wad) <= 0 Then Exit Sub
  Call EditReject(wad, level)
End Sub

Sub CmdSave_Click ()
  If Not Tutor("save the modifications") Then Exit Sub
  If Not ListDirty Then Exit Sub
  Call SectionWrite(LevelLst, WadInfo.Caption, "LEVELS")
  ListDirty = False
End Sub

Function CurrentWad (level As String) As String
 'get file name of current wad
  CurrentWad = ""
  If LevelLst.ListIndex < 0 Then Exit Function
   Dim entry$, nam$
   Dim X%, Y%, repeat%
  entry = EntryGet(X, Y, nam, repeat, LevelLst.Text)
  level = entry
  CurrentWad = MakeFileName(WorkDirec.Caption, nam & ".wad")
End Function

Sub Exit_Click ()
  Unload Me
End Sub

Sub Form_Load ()
 ListDirty = False
 'Init Level selection
End Sub

Sub Form_Unload (Cancel As Integer)
  If Not ListDirty Then Exit Sub
  If QueryOk("Save file " & WadInfo.Caption & " ?") Then Call CmdSave_Click
End Sub

Sub FrameCvt_DblClick ()
   Select Case typeIWAD()
    Case 10, 11'doom
      Call Infos("Convert your levels to DOOM")
    Case 12 'doom2
      Call Infos("Convert your levels to DOOM2")
    Case 20, 21, 22'heretic
      Call Infos("Convert your levels to HERETIC")
   End Select
End Sub

Sub FrameLev_DblClick ()
  Call Infos("Use an editor to build your level (sectors, linedefs)")
End Sub

Sub FrameNod_DblClick ()
   Call Infos("Before you play your level, you need to build the nodes, blockmap and reject. Use the tools in this panel, unless your editor already does the job.")
End Sub

Sub Ident_Change ()
  Call HelpCheckSelect(Ident)
End Sub

Sub Ident_KeyDown (KeyCode As Integer, Shift As Integer)
   If KeyCode = KEY_DELETE Then KeyCode = 0
End Sub

Sub Ident_KeyPress (KeyAscii As Integer)
  KeyAscii = HelpKeyPress(Ident, KeyAscii)
End Sub

Sub Info_Click (Index As Integer)
   Select Case Index
     Case 0
        Call Infos("The WADs in that list shall contain only one level (and nothing else).")
     Case 1
        Call Infos("Build a custom Texture and Flat PWAD. Then when you will edit a level, that WAD will be shown to your level editor, if it can support external Texture and Flats. (Otherwise, first merge this WAD in your main WAD.)")
     Case 2
        Call Infos("Select a WAD containing a single level, then click on your favourite editor")
   End Select
End Sub

Sub LevelLst_Click ()
   If LevelLst.ListIndex < 0 Then Exit Sub
   Dim entry$, nam$
   Dim X%, Y%, repeat%
   entry = EntryGet(X, Y, nam, repeat, LevelLst.Text)
   Call HelpMatch(Ident, entry)
End Sub

Sub LevelLst_KeyDown (KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case KEY_DELETE
      Call EntryDelete(LevelLst, WorkDirec.Caption, ".WAD")
      ListDirty = True
  End Select
End Sub

Sub WadInfo_Change ()
  Dim i%
  Select Case typeIWAD()
   Case 10, 11 'doom
     For i = 1 To 9
      HelpD Ident, "E1M" & i, "Episod 1 level " & i
     Next i
     For i = 1 To 9
       HelpD Ident, "E2M" & i, "Episod 2 level " & i
     Next i
     For i = 1 To 9
      HelpD Ident, "E3M" & i, "Episod 3 level " & i
     Next i
     HelpD Ident, "????", "Any level"
   Case 12 'doom2
    For i = 1 To 9
    HelpD Ident, "MAP0" & i, "level " & i
    Next i
    For i = 10 To 30
    HelpD Ident, "MAP" & i, "level " & i
    Next i
    HelpD Ident, "MAP31", "Wolf level"
    HelpD Ident, "MAP32", "Keen level"
    HelpD Ident, "E?M?", "Convert this level to DOOM2"
    HelpD Ident, "MAP??", "Any level"
   Case 22 'heretic2
    For i = 1 To 9
    HelpD Ident, "MAP0" & i, "level " & i
    Next i
    For i = 10 To 30
    HelpD Ident, "MAP" & i, "level " & i
    Next i
    HelpD Ident, "E?M?", "Convert this level to HERETIC2"
    HelpD Ident, "MAP??", "Any level"
   Case 20, 21'heretic
     For i = 1 To 9
      HelpD Ident, "E1M" & i, "Episod 1 level " & i
     Next i
     For i = 1 To 9
       HelpD Ident, "E2M" & i, "Episod 2 level " & i
     Next i
     For i = 1 To 9
      HelpD Ident, "E3M" & i, "Episod 3 level " & i
     Next i
     HelpD Ident, "E4M1", "Super Secret Level"
     HelpD Ident, "MAP??", "Convert this level to HERETIC"
     HelpD Ident, "E?M?", "Any level"
  End Select
   Ident.Text = Ident.List(0)
   'Init Level List   5 = no X Y offset, repeat
   Call SectionRead(LevelLst, WadInfo.Caption, "LEVELS", 5)
End Sub

