#define FIXFLOAT_H

// ### should the rnd variables be declared
//     to be reached from c-code ??

void gen_fixfloat_tables();
long fftoa(long ff, char *buf);
long fftoah(long ff, char *buf);

long rand32();
long randpowint(long po2int,long interval);
long randinter(long interval);


long ffsmul(long,long);
long ffmul(long,long);
long ffsdiv(long,long);
long ffdiv(long,long);

long ffsin(long val);
long ffcos(long val);
long ffasin(long val);
long ffacos(long val);

long fftan(long val);
long ffatan(long val);
long ff_vec_to_ang(long x_vect, long y_vect);

long fflog2(long val);
long ffexp2(long val);
long ffpow(long base, long expo);
long ffsqrt(long val);
long ffhyp(long a, long b);
long fftrihyp(long a, long b, long c);

long ffmuldiv(long a, long b, long c, long d);
long ffmmd(long a, long b, long c);

long ffortproj(long a, long b, long c, long d);
// returns (a*b+c*d)/(a*a+c*c)

long ffortproj1(long a, long b, long c, long d);
// returns (a*b+c*d)/sqrt(a*a+c*c)

long ffdot_through_hyps(long a, long b, long c, long d);
//returns (a*b+c*d)/(sqrt(a*a+c*c)*sqrt(b*b+d*d))

long ff_solve_2nd_poly(long p, long q, long *conj_ptr, long *pre_ptr);
// solves 2nd degree equation by std formula.
// nonzero return indicates error

long ffalmosthyp(long a, long b);
// returns approximation to sqrt( a*a + b*b)

long isqrt(long a); 
// returns the integer!! root of a. NOT A FIXFLOAT ROUTINE !!

long ff_double_div(long denom_lo, long denom_hi, long nom, long *dec_part);
long ff_double_shift(long *lo_ptr, long *hi_ptr, long aritm_flag, long steps);



long iffsmul(long, long);
#pragma aux iffsmul = \
         "imul   edx"\
         "shrd   eax,edx,16"\
         parm [eax] [edx]\
         modify [edx];


long iffmul(long, long);
#pragma aux iffmul = \
         "mul    edx"\
         "shrd   eax,edx,16"\
         parm [eax] [edx]\
         modify [edx];


long iffsdiv(long,long);
#pragma aux iffsdiv = \
         "cdq    "\
         "shld   edx,eax,16"\
         "shl    eax,16"\
         "idiv   ecx"\
         parm [eax] [ecx]\
         modify [edx];

long iffdiv(long,long);
#pragma aux iffdiv = \
         "mov    edx,eax"\
         "shl    eax,16"\
         "shr    edx,16"\
         "div   ecx"\
         parm [eax] [ecx]\
         modify [edx];





